/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.datetime;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;

public interface DateTimeInput
extends IsWidget,
HasValue<Date> {
    default public void setValue(Date value, boolean fireEvents) {
        this.setValue(value);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public static enum Accuracy {
        MINUTES("60", "yyyy-MM-dd'T'HH:mm", "HH:mm"),
        SECONDS("1", "yyyy-MM-dd'T'HH:mm:ss", "HH:mm:ss"),
        MILLISECONDS("0.001", "yyyy-MM-dd'T'HH:mm:ss.SSS", "HH:mm:ss.SSS");

        private static final DateTimeFormat DATE_FORMAT;
        private final DateTimeFormat datetimeFormat;
        private final DateTimeFormat timeFormat;
        private final String step;

        static {
            DATE_FORMAT = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
        }

        private Accuracy(String step, String datetimeFormat, String timeFormat) {
            this.step = step;
            this.datetimeFormat = DateTimeFormat.getFormat((String)datetimeFormat);
            this.timeFormat = DateTimeFormat.getFormat((String)timeFormat);
        }

        public static DateTimeFormat getDateFormat() {
            return DATE_FORMAT;
        }

        public DateTimeFormat getTimeFormat() {
            return this.timeFormat;
        }

        public DateTimeFormat getDatetimeFormat() {
            return this.datetimeFormat;
        }

        public String getStep() {
            return this.step;
        }
    }
}

