/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.async;

import com.google.gwt.debug.client.DebugInfo;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.gwt.client.async.PendingAjaxCallMarker;
import java.util.logging.Logger;

public final class MarkedAsyncCallback<T>
implements AsyncCallback<T> {
    private static final Logger logger = Logger.getLogger(MarkedAsyncCallback.class.getName());
    public static final String CATEGORY_GLOBAL = "";
    private String category;
    private AsyncCallback<T> callback;

    public MarkedAsyncCallback(AsyncCallback<T> callback) {
        this(callback, CATEGORY_GLOBAL);
    }

    public MarkedAsyncCallback(AsyncCallback<T> callback, String category) {
        this.callback = callback;
        this.category = category;
        try {
            if (DebugInfo.isDebugIdEnabled()) {
                PendingAjaxCallMarker.incrementPendingAjaxCalls(this.category);
            }
        }
        catch (Throwable e) {
            if (e.getClass().getSimpleName().equals("ExceptionInInitializerError") || e.getClass().getSimpleName().equals("NoClassDefFoundError")) {
                logger.info("If this occurs outside of tests, please be alarmed!");
            }
            throw e;
        }
    }

    public final void onFailure(Throwable cause) {
        try {
            this.callback.onFailure(cause);
        }
        finally {
            try {
                if (DebugInfo.isDebugIdEnabled()) {
                    PendingAjaxCallMarker.decrementPendingAjaxCalls(this.category);
                }
            }
            catch (Throwable e) {
                if (e.getClass().getSimpleName().equals("ExceptionInInitializerError") || e.getClass().getSimpleName().equals("NoClassDefFoundError")) {
                    logger.info("If this occurs outside of tests, please be alarmed!");
                }
                throw e;
            }
        }
    }

    public final void onSuccess(T result) {
        try {
            this.callback.onSuccess(result);
        }
        finally {
            try {
                if (DebugInfo.isDebugIdEnabled()) {
                    PendingAjaxCallMarker.decrementPendingAjaxCalls(this.category);
                }
            }
            catch (Throwable e) {
                if (e.getClass().getSimpleName().equals("ExceptionInInitializerError") || e.getClass().getSimpleName().equals("NoClassDefFoundError")) {
                    logger.info("If this occurs outside of tests, please be alarmed!");
                }
                throw e;
            }
        }
    }
}

