/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.StringMessages;

public class DefaultErrorReporter<S extends StringMessages>
implements ErrorReporter {
    private DialogBox errorDialogBox;
    private HTML serverResponseLabel;
    private Button dialogCloseButton;
    private S stringMessages;
    protected Label persistentAlertLabel;

    public DefaultErrorReporter(S stringMessages) {
        this(stringMessages, false);
    }

    public DefaultErrorReporter(S stringMessages, boolean showCommunicationErrorText) {
        this.stringMessages = stringMessages;
        this.errorDialogBox = this.createErrorDialog(showCommunicationErrorText);
        this.persistentAlertLabel = new Label("");
        this.persistentAlertLabel.setStyleName("global-alert-message");
    }

    @Override
    public void reportError(String title, String message) {
        this.errorDialogBox.setText(title);
        this.serverResponseLabel.addStyleName("serverResponseLabelError");
        this.serverResponseLabel.setHTML(String.valueOf(SafeHtmlUtils.fromString((String)message).asString()) + "<br><br>");
        this.errorDialogBox.center();
        this.dialogCloseButton.setFocus(true);
    }

    public static <S extends StringMessages> void reportMasterTemporarilyUnavailable(S stringMessages) {
        DefaultErrorReporter<S> errorReporter = new DefaultErrorReporter<S>(stringMessages, false);
        errorReporter.reportError(stringMessages.error(), stringMessages.temporarilyUnavailable());
    }

    @Override
    public void reportError(String message) {
        this.errorDialogBox.setText(this.stringMessages.serverError());
        this.serverResponseLabel.addStyleName("serverResponseLabelError");
        this.serverResponseLabel.setHTML(SafeHtmlUtils.fromString((String)message));
        this.errorDialogBox.center();
        this.dialogCloseButton.setFocus(true);
    }

    @Override
    public void reportError(String message, boolean silentMode) {
        if (silentMode) {
            Notification.notify(message, Notification.NotificationType.WARNING);
        } else {
            this.reportError(message);
        }
    }

    @Override
    public void reportPersistentInformation(String message) {
        this.persistentAlertLabel.setText(message);
    }

    @Override
    public Widget getPersistentInformationWidget() {
        return this.persistentAlertLabel;
    }

    private DialogBox createErrorDialog(boolean showCommunicationErrorText) {
        final DialogBox myErrorDialogBox = new DialogBox();
        myErrorDialogBox.getElement().setAttribute("selenium-id", "ErrorDialog");
        myErrorDialogBox.setText(this.stringMessages.remoteProcedureCall());
        myErrorDialogBox.getCaption().asWidget().getElement().setAttribute("selenium-id", "ErrorDialogTitle");
        myErrorDialogBox.setAnimationEnabled(true);
        this.dialogCloseButton = new Button(this.stringMessages.close());
        this.dialogCloseButton.getElement().setId("closeButton");
        this.dialogCloseButton.getElement().setAttribute("selenium-id", "ErrorDialogCloseButton");
        Label textToServerLabel = new Label();
        this.serverResponseLabel = new HTML();
        this.serverResponseLabel.getElement().setAttribute("selenium-id", "ErrorDialogServerResponse");
        VerticalPanel dialogVPanel = new VerticalPanel();
        if (showCommunicationErrorText) {
            dialogVPanel.add((Widget)new HTML("<b>" + this.stringMessages.errorCommunicatingWithServer() + "</b>"));
            dialogVPanel.add((Widget)textToServerLabel);
            dialogVPanel.add((Widget)new HTML("<br><b>" + this.stringMessages.serverReplies() + "</b>"));
        }
        dialogVPanel.add((Widget)this.serverResponseLabel);
        dialogVPanel.setHorizontalAlignment(VerticalPanel.ALIGN_RIGHT);
        dialogVPanel.add((Widget)this.dialogCloseButton);
        myErrorDialogBox.setWidget((Widget)dialogVPanel);
        this.dialogCloseButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                myErrorDialogBox.hide();
            }
        });
        return myErrorDialogBox;
    }
}

