/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information for a single version of a managed rule set.
 * </p>
 * <note>
 * <p>
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
 * Services Marketplace sellers.
 * </p>
 * <p>
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
 * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
 * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedRuleSetVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedRuleSetVersion.Builder, ManagedRuleSetVersion> {
    private static final SdkField<String> ASSOCIATED_RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedRuleGroupArn").getter(getter(ManagedRuleSetVersion::associatedRuleGroupArn))
            .setter(setter(Builder::associatedRuleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRuleGroupArn").build())
            .build();

    private static final SdkField<Long> CAPACITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Capacity")
            .getter(getter(ManagedRuleSetVersion::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<Integer> FORECASTED_LIFETIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ForecastedLifetime").getter(getter(ManagedRuleSetVersion::forecastedLifetime))
            .setter(setter(Builder::forecastedLifetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastedLifetime").build())
            .build();

    private static final SdkField<Instant> PUBLISH_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PublishTimestamp").getter(getter(ManagedRuleSetVersion::publishTimestamp))
            .setter(setter(Builder::publishTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTimestamp").getter(getter(ManagedRuleSetVersion::lastUpdateTimestamp))
            .setter(setter(Builder::lastUpdateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build())
            .build();

    private static final SdkField<Instant> EXPIRY_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiryTimestamp").getter(getter(ManagedRuleSetVersion::expiryTimestamp))
            .setter(setter(Builder::expiryTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATED_RULE_GROUP_ARN_FIELD, CAPACITY_FIELD, FORECASTED_LIFETIME_FIELD, PUBLISH_TIMESTAMP_FIELD,
            LAST_UPDATE_TIMESTAMP_FIELD, EXPIRY_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associatedRuleGroupArn;

    private final Long capacity;

    private final Integer forecastedLifetime;

    private final Instant publishTimestamp;

    private final Instant lastUpdateTimestamp;

    private final Instant expiryTimestamp;

    private ManagedRuleSetVersion(BuilderImpl builder) {
        this.associatedRuleGroupArn = builder.associatedRuleGroupArn;
        this.capacity = builder.capacity;
        this.forecastedLifetime = builder.forecastedLifetime;
        this.publishTimestamp = builder.publishTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.expiryTimestamp = builder.expiryTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vendor rule group that's used to define the published version of your
     * managed rule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vendor rule group that's used to define the published version of
     *         your managed rule group.
     */
    public final String associatedRuleGroupArn() {
        return associatedRuleGroupArn;
    }

    /**
     * <p>
     * The web ACL capacity units (WCUs) required for this rule group.
     * </p>
     * <p>
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and
     * web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule.
     * Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule
     * group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity
     * units (WCU)</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * 
     * @return The web ACL capacity units (WCUs) required for this rule group.</p>
     *         <p>
     *         WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule
     *         groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative
     *         cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use
     *         more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU
     *         usage when they use a rule group. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL
     *         capacity units (WCU)</a> in the <i>WAF Developer Guide</i>.
     */
    public final Long capacity() {
        return capacity;
    }

    /**
     * <p>
     * The amount of time you expect this version of your managed rule group to last, in days.
     * </p>
     * 
     * @return The amount of time you expect this version of your managed rule group to last, in days.
     */
    public final Integer forecastedLifetime() {
        return forecastedLifetime;
    }

    /**
     * <p>
     * The time that you first published this version.
     * </p>
     * <p>
     * Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example,
     * "2016-09-27T14:50Z".
     * </p>
     * 
     * @return The time that you first published this version. </p>
     *         <p>
     *         Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
     *         example, "2016-09-27T14:50Z".
     */
    public final Instant publishTimestamp() {
        return publishTimestamp;
    }

    /**
     * <p>
     * The last time that you updated this version.
     * </p>
     * <p>
     * Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example,
     * "2016-09-27T14:50Z".
     * </p>
     * 
     * @return The last time that you updated this version. </p>
     *         <p>
     *         Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
     *         example, "2016-09-27T14:50Z".
     */
    public final Instant lastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    /**
     * <p>
     * The time that this version is set to expire.
     * </p>
     * <p>
     * Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example,
     * "2016-09-27T14:50Z".
     * </p>
     * 
     * @return The time that this version is set to expire.</p>
     *         <p>
     *         Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
     *         example, "2016-09-27T14:50Z".
     */
    public final Instant expiryTimestamp() {
        return expiryTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatedRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(forecastedLifetime());
        hashCode = 31 * hashCode + Objects.hashCode(publishTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRuleSetVersion)) {
            return false;
        }
        ManagedRuleSetVersion other = (ManagedRuleSetVersion) obj;
        return Objects.equals(associatedRuleGroupArn(), other.associatedRuleGroupArn())
                && Objects.equals(capacity(), other.capacity())
                && Objects.equals(forecastedLifetime(), other.forecastedLifetime())
                && Objects.equals(publishTimestamp(), other.publishTimestamp())
                && Objects.equals(lastUpdateTimestamp(), other.lastUpdateTimestamp())
                && Objects.equals(expiryTimestamp(), other.expiryTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedRuleSetVersion").add("AssociatedRuleGroupArn", associatedRuleGroupArn())
                .add("Capacity", capacity()).add("ForecastedLifetime", forecastedLifetime())
                .add("PublishTimestamp", publishTimestamp()).add("LastUpdateTimestamp", lastUpdateTimestamp())
                .add("ExpiryTimestamp", expiryTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedRuleGroupArn":
            return Optional.ofNullable(clazz.cast(associatedRuleGroupArn()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "ForecastedLifetime":
            return Optional.ofNullable(clazz.cast(forecastedLifetime()));
        case "PublishTimestamp":
            return Optional.ofNullable(clazz.cast(publishTimestamp()));
        case "LastUpdateTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimestamp()));
        case "ExpiryTimestamp":
            return Optional.ofNullable(clazz.cast(expiryTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociatedRuleGroupArn", ASSOCIATED_RULE_GROUP_ARN_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("ForecastedLifetime", FORECASTED_LIFETIME_FIELD);
        map.put("PublishTimestamp", PUBLISH_TIMESTAMP_FIELD);
        map.put("LastUpdateTimestamp", LAST_UPDATE_TIMESTAMP_FIELD);
        map.put("ExpiryTimestamp", EXPIRY_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedRuleSetVersion, T> g) {
        return obj -> g.apply((ManagedRuleSetVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedRuleSetVersion> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vendor rule group that's used to define the published version of your
         * managed rule group.
         * </p>
         * 
         * @param associatedRuleGroupArn
         *        The Amazon Resource Name (ARN) of the vendor rule group that's used to define the published version of
         *        your managed rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRuleGroupArn(String associatedRuleGroupArn);

        /**
         * <p>
         * The web ACL capacity units (WCUs) required for this rule group.
         * </p>
         * <p>
         * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups,
         * and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each
         * rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing
         * power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use
         * a rule group. For more information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity
         * units (WCU)</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param capacity
         *        The web ACL capacity units (WCUs) required for this rule group.</p>
         *        <p>
         *        WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule
         *        groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative
         *        cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that
         *        use more processing power. Rule group capacity is fixed at creation, which helps users plan their web
         *        ACL WCU usage when they use a rule group. For more information, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL
         *        capacity units (WCU)</a> in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Long capacity);

        /**
         * <p>
         * The amount of time you expect this version of your managed rule group to last, in days.
         * </p>
         * 
         * @param forecastedLifetime
         *        The amount of time you expect this version of your managed rule group to last, in days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastedLifetime(Integer forecastedLifetime);

        /**
         * <p>
         * The time that you first published this version.
         * </p>
         * <p>
         * Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
         * example, "2016-09-27T14:50Z".
         * </p>
         * 
         * @param publishTimestamp
         *        The time that you first published this version. </p>
         *        <p>
         *        Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z.
         *        For example, "2016-09-27T14:50Z".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishTimestamp(Instant publishTimestamp);

        /**
         * <p>
         * The last time that you updated this version.
         * </p>
         * <p>
         * Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
         * example, "2016-09-27T14:50Z".
         * </p>
         * 
         * @param lastUpdateTimestamp
         *        The last time that you updated this version. </p>
         *        <p>
         *        Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z.
         *        For example, "2016-09-27T14:50Z".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimestamp(Instant lastUpdateTimestamp);

        /**
         * <p>
         * The time that this version is set to expire.
         * </p>
         * <p>
         * Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
         * example, "2016-09-27T14:50Z".
         * </p>
         * 
         * @param expiryTimestamp
         *        The time that this version is set to expire.</p>
         *        <p>
         *        Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z.
         *        For example, "2016-09-27T14:50Z".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTimestamp(Instant expiryTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String associatedRuleGroupArn;

        private Long capacity;

        private Integer forecastedLifetime;

        private Instant publishTimestamp;

        private Instant lastUpdateTimestamp;

        private Instant expiryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedRuleSetVersion model) {
            associatedRuleGroupArn(model.associatedRuleGroupArn);
            capacity(model.capacity);
            forecastedLifetime(model.forecastedLifetime);
            publishTimestamp(model.publishTimestamp);
            lastUpdateTimestamp(model.lastUpdateTimestamp);
            expiryTimestamp(model.expiryTimestamp);
        }

        public final String getAssociatedRuleGroupArn() {
            return associatedRuleGroupArn;
        }

        public final void setAssociatedRuleGroupArn(String associatedRuleGroupArn) {
            this.associatedRuleGroupArn = associatedRuleGroupArn;
        }

        @Override
        public final Builder associatedRuleGroupArn(String associatedRuleGroupArn) {
            this.associatedRuleGroupArn = associatedRuleGroupArn;
            return this;
        }

        public final Long getCapacity() {
            return capacity;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final Integer getForecastedLifetime() {
            return forecastedLifetime;
        }

        public final void setForecastedLifetime(Integer forecastedLifetime) {
            this.forecastedLifetime = forecastedLifetime;
        }

        @Override
        public final Builder forecastedLifetime(Integer forecastedLifetime) {
            this.forecastedLifetime = forecastedLifetime;
            return this;
        }

        public final Instant getPublishTimestamp() {
            return publishTimestamp;
        }

        public final void setPublishTimestamp(Instant publishTimestamp) {
            this.publishTimestamp = publishTimestamp;
        }

        @Override
        public final Builder publishTimestamp(Instant publishTimestamp) {
            this.publishTimestamp = publishTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final Instant getExpiryTimestamp() {
            return expiryTimestamp;
        }

        public final void setExpiryTimestamp(Instant expiryTimestamp) {
            this.expiryTimestamp = expiryTimestamp;
        }

        @Override
        public final Builder expiryTimestamp(Instant expiryTimestamp) {
            this.expiryTimestamp = expiryTimestamp;
            return this;
        }

        @Override
        public ManagedRuleSetVersion build() {
            return new ManagedRuleSetVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
