/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filtering that specifies which web requests are kept in the logs and which are dropped, defined for a web ACL's
 * <a>LoggingConfiguration</a>.
 * </p>
 * <p>
 * You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL
 * evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingFilter implements SdkPojo, Serializable, ToCopyableBuilder<LoggingFilter.Builder, LoggingFilter> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(LoggingFilter::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultBehavior").getter(getter(LoggingFilter::defaultBehaviorAsString))
            .setter(setter(Builder::defaultBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            DEFAULT_BEHAVIOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Filter> filters;

    private final String defaultBehavior;

    private LoggingFilter(BuilderImpl builder) {
        this.filters = builder.filters;
        this.defaultBehavior = builder.defaultBehavior;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters that you want to apply to the logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters that you want to apply to the logs.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Default handling for logs that don't match any of the specified filtering conditions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultBehavior}
     * will return {@link FilterBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #defaultBehaviorAsString}.
     * </p>
     * 
     * @return Default handling for logs that don't match any of the specified filtering conditions.
     * @see FilterBehavior
     */
    public final FilterBehavior defaultBehavior() {
        return FilterBehavior.fromValue(defaultBehavior);
    }

    /**
     * <p>
     * Default handling for logs that don't match any of the specified filtering conditions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultBehavior}
     * will return {@link FilterBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #defaultBehaviorAsString}.
     * </p>
     * 
     * @return Default handling for logs that don't match any of the specified filtering conditions.
     * @see FilterBehavior
     */
    public final String defaultBehaviorAsString() {
        return defaultBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingFilter)) {
            return false;
        }
        LoggingFilter other = (LoggingFilter) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(defaultBehaviorAsString(), other.defaultBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingFilter").add("Filters", hasFilters() ? filters() : null)
                .add("DefaultBehavior", defaultBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "DefaultBehavior":
            return Optional.ofNullable(clazz.cast(defaultBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filters", FILTERS_FIELD);
        map.put("DefaultBehavior", DEFAULT_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingFilter, T> g) {
        return obj -> g.apply((LoggingFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingFilter> {
        /**
         * <p>
         * The filters that you want to apply to the logs.
         * </p>
         * 
         * @param filters
         *        The filters that you want to apply to the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters that you want to apply to the logs.
         * </p>
         * 
         * @param filters
         *        The filters that you want to apply to the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters that you want to apply to the logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.Filter.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.wafv2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.Filter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Default handling for logs that don't match any of the specified filtering conditions.
         * </p>
         * 
         * @param defaultBehavior
         *        Default handling for logs that don't match any of the specified filtering conditions.
         * @see FilterBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterBehavior
         */
        Builder defaultBehavior(String defaultBehavior);

        /**
         * <p>
         * Default handling for logs that don't match any of the specified filtering conditions.
         * </p>
         * 
         * @param defaultBehavior
         *        Default handling for logs that don't match any of the specified filtering conditions.
         * @see FilterBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterBehavior
         */
        Builder defaultBehavior(FilterBehavior defaultBehavior);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String defaultBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingFilter model) {
            filters(model.filters);
            defaultBehavior(model.defaultBehavior);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultBehavior() {
            return defaultBehavior;
        }

        public final void setDefaultBehavior(String defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
        }

        @Override
        public final Builder defaultBehavior(String defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
            return this;
        }

        @Override
        public final Builder defaultBehavior(FilterBehavior defaultBehavior) {
            this.defaultBehavior(defaultBehavior == null ? null : defaultBehavior.toString());
            return this;
        }

        @Override
        public LoggingFilter build() {
            return new LoggingFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
