/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstancesOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstancesOffering.Builder, ReservedInstancesOffering> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(ReservedInstancesOffering::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceTenancy")
            .getter(getter(ReservedInstancesOffering::instanceTenancyAsString))
            .setter(setter(Builder::instanceTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy")
                    .unmarshallLocationName("instanceTenancy").build()).build();

    private static final SdkField<Boolean> MARKETPLACE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Marketplace")
            .getter(getter(ReservedInstancesOffering::marketplace))
            .setter(setter(Builder::marketplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketplace")
                    .unmarshallLocationName("marketplace").build()).build();

    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OfferingClass")
            .getter(getter(ReservedInstancesOffering::offeringClassAsString))
            .setter(setter(Builder::offeringClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass")
                    .unmarshallLocationName("offeringClass").build()).build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OfferingType")
            .getter(getter(ReservedInstancesOffering::offeringTypeAsString))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType")
                    .unmarshallLocationName("offeringType").build()).build();

    private static final SdkField<List<PricingDetail>> PRICING_DETAILS_FIELD = SdkField
            .<List<PricingDetail>> builder(MarshallingType.LIST)
            .memberName("PricingDetails")
            .getter(getter(ReservedInstancesOffering::pricingDetails))
            .setter(setter(Builder::pricingDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingDetailsSet")
                    .unmarshallLocationName("pricingDetailsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PricingDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PricingDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .memberName("RecurringCharges")
            .getter(getter(ReservedInstancesOffering::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges")
                    .unmarshallLocationName("recurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Scope")
            .getter(getter(ReservedInstancesOffering::scopeAsString))
            .setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope")
                    .unmarshallLocationName("scope").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(ReservedInstancesOffering::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesOfferingId")
            .getter(getter(ReservedInstancesOffering::reservedInstancesOfferingId))
            .setter(setter(Builder::reservedInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesOfferingId")
                    .unmarshallLocationName("reservedInstancesOfferingId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ReservedInstancesOffering::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(ReservedInstancesOffering::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("Duration")
            .getter(getter(ReservedInstancesOffering::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration")
                    .unmarshallLocationName("duration").build()).build();

    private static final SdkField<Float> USAGE_PRICE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("UsagePrice")
            .getter(getter(ReservedInstancesOffering::usagePrice))
            .setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice")
                    .unmarshallLocationName("usagePrice").build()).build();

    private static final SdkField<Float> FIXED_PRICE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("FixedPrice")
            .getter(getter(ReservedInstancesOffering::fixedPrice))
            .setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice")
                    .unmarshallLocationName("fixedPrice").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription")
            .getter(getter(ReservedInstancesOffering::productDescriptionAsString))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription")
                    .unmarshallLocationName("productDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            INSTANCE_TENANCY_FIELD, MARKETPLACE_FIELD, OFFERING_CLASS_FIELD, OFFERING_TYPE_FIELD, PRICING_DETAILS_FIELD,
            RECURRING_CHARGES_FIELD, SCOPE_FIELD, AVAILABILITY_ZONE_ID_FIELD, RESERVED_INSTANCES_OFFERING_ID_FIELD,
            INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, DURATION_FIELD, USAGE_PRICE_FIELD, FIXED_PRICE_FIELD,
            PRODUCT_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final String instanceTenancy;

    private final Boolean marketplace;

    private final String offeringClass;

    private final String offeringType;

    private final List<PricingDetail> pricingDetails;

    private final List<RecurringCharge> recurringCharges;

    private final String scope;

    private final String availabilityZoneId;

    private final String reservedInstancesOfferingId;

    private final String instanceType;

    private final String availabilityZone;

    private final Long duration;

    private final Float usagePrice;

    private final Float fixedPrice;

    private final String productDescription;

    private ReservedInstancesOffering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.marketplace = builder.marketplace;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.pricingDetails = builder.pricingDetails;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.usagePrice = builder.usagePrice;
        this.fixedPrice = builder.fixedPrice;
        this.productDescription = builder.productDescription;
    }

    /**
     * <p>
     * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     * currency codes. At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     *         currency codes. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     * currency codes. At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     *         currency codes. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public final String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public final String instanceTenancyAsString() {
        return instanceTenancy;
    }

    /**
     * <p>
     * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or Amazon Web
     * Services. If it's a Reserved Instance Marketplace offering, this is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or Amazon
     *         Web Services. If it's a Reserved Instance Marketplace offering, this is <code>true</code>.
     */
    public final Boolean marketplace() {
        return marketplace;
    }

    /**
     * <p>
     * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with
     * different configurations. If <code>standard</code>, it is not possible to perform an exchange.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassAsString}.
     * </p>
     * 
     * @return If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
     *         value, with different configurations. If <code>standard</code>, it is not possible to perform an
     *         exchange.
     * @see OfferingClassType
     */
    public final OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(offeringClass);
    }

    /**
     * <p>
     * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with
     * different configurations. If <code>standard</code>, it is not possible to perform an exchange.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassAsString}.
     * </p>
     * 
     * @return If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
     *         value, with different configurations. If <code>standard</code>, it is not possible to perform an
     *         exchange.
     * @see OfferingClassType
     */
    public final String offeringClassAsString() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public final OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(offeringType);
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public final String offeringTypeAsString() {
        return offeringType;
    }

    /**
     * For responses, this returns true if the service returned a value for the PricingDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPricingDetails() {
        return pricingDetails != null && !(pricingDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The pricing details of the Reserved Instance offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPricingDetails} method.
     * </p>
     * 
     * @return The pricing details of the Reserved Instance offering.
     */
    public final List<PricingDetail> pricingDetails() {
        return pricingDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecurringCharges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recurring charge tag assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecurringCharges} method.
     * </p>
     * 
     * @return The recurring charge tag assigned to the resource.
     */
    public final List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The ID of the Availability Zone.
     * </p>
     * 
     * @return The ID of the Availability Zone.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering. This is the offering ID used in
     * <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering. This is the offering ID used in
     *         <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
     */
    public final String reservedInstancesOfferingId() {
        return reservedInstancesOfferingId;
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The duration of the Reserved Instance, in seconds.
     * </p>
     * 
     * @return The duration of the Reserved Instance, in seconds.
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * The usage price of the Reserved Instance, per hour.
     * </p>
     * 
     * @return The usage price of the Reserved Instance, per hour.
     */
    public final Float usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The purchase price of the Reserved Instance.
     * </p>
     * 
     * @return The purchase price of the Reserved Instance.
     */
    public final Float fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionAsString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public final RIProductDescription productDescription() {
        return RIProductDescription.fromValue(productDescription);
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionAsString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public final String productDescriptionAsString() {
        return productDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marketplace());
        hashCode = 31 * hashCode + Objects.hashCode(offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPricingDetails() ? pricingDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRecurringCharges() ? recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(productDescriptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesOffering)) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering) obj;
        return Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(instanceTenancyAsString(), other.instanceTenancyAsString())
                && Objects.equals(marketplace(), other.marketplace())
                && Objects.equals(offeringClassAsString(), other.offeringClassAsString())
                && Objects.equals(offeringTypeAsString(), other.offeringTypeAsString())
                && hasPricingDetails() == other.hasPricingDetails() && Objects.equals(pricingDetails(), other.pricingDetails())
                && hasRecurringCharges() == other.hasRecurringCharges()
                && Objects.equals(recurringCharges(), other.recurringCharges())
                && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(reservedInstancesOfferingId(), other.reservedInstancesOfferingId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(duration(), other.duration())
                && Objects.equals(usagePrice(), other.usagePrice()) && Objects.equals(fixedPrice(), other.fixedPrice())
                && Objects.equals(productDescriptionAsString(), other.productDescriptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedInstancesOffering").add("CurrencyCode", currencyCodeAsString())
                .add("InstanceTenancy", instanceTenancyAsString()).add("Marketplace", marketplace())
                .add("OfferingClass", offeringClassAsString()).add("OfferingType", offeringTypeAsString())
                .add("PricingDetails", hasPricingDetails() ? pricingDetails() : null)
                .add("RecurringCharges", hasRecurringCharges() ? recurringCharges() : null).add("Scope", scopeAsString())
                .add("AvailabilityZoneId", availabilityZoneId())
                .add("ReservedInstancesOfferingId", reservedInstancesOfferingId()).add("InstanceType", instanceTypeAsString())
                .add("AvailabilityZone", availabilityZone()).add("Duration", duration()).add("UsagePrice", usagePrice())
                .add("FixedPrice", fixedPrice()).add("ProductDescription", productDescriptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "InstanceTenancy":
            return Optional.ofNullable(clazz.cast(instanceTenancyAsString()));
        case "Marketplace":
            return Optional.ofNullable(clazz.cast(marketplace()));
        case "OfferingClass":
            return Optional.ofNullable(clazz.cast(offeringClassAsString()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringTypeAsString()));
        case "PricingDetails":
            return Optional.ofNullable(clazz.cast(pricingDetails()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "ReservedInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedInstancesOfferingId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescriptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("InstanceTenancy", INSTANCE_TENANCY_FIELD);
        map.put("Marketplace", MARKETPLACE_FIELD);
        map.put("OfferingClass", OFFERING_CLASS_FIELD);
        map.put("OfferingType", OFFERING_TYPE_FIELD);
        map.put("PricingDetailsSet", PRICING_DETAILS_FIELD);
        map.put("RecurringCharges", RECURRING_CHARGES_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("ReservedInstancesOfferingId", RESERVED_INSTANCES_OFFERING_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("UsagePrice", USAGE_PRICE_FIELD);
        map.put("FixedPrice", FIXED_PRICE_FIELD);
        map.put("ProductDescription", PRODUCT_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesOffering, T> g) {
        return obj -> g.apply((ReservedInstancesOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstancesOffering> {
        /**
         * <p>
         * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
         * currency codes. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217
         *        standard currency codes. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
         * currency codes. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217
         *        standard currency codes. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or Amazon Web
         * Services. If it's a Reserved Instance Marketplace offering, this is <code>true</code>.
         * </p>
         * 
         * @param marketplace
         *        Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or
         *        Amazon Web Services. If it's a Reserved Instance Marketplace offering, this is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplace(Boolean marketplace);

        /**
         * <p>
         * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value,
         * with different configurations. If <code>standard</code>, it is not possible to perform an exchange.
         * </p>
         * 
         * @param offeringClass
         *        If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
         *        value, with different configurations. If <code>standard</code>, it is not possible to perform an
         *        exchange.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value,
         * with different configurations. If <code>standard</code>, it is not possible to perform an exchange.
         * </p>
         * 
         * @param offeringClass
         *        If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
         *        value, with different configurations. If <code>standard</code>, it is not possible to perform an
         *        exchange.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * 
         * @param pricingDetails
         *        The pricing details of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingDetails(Collection<PricingDetail> pricingDetails);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * 
         * @param pricingDetails
         *        The pricing details of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingDetails(PricingDetail... pricingDetails);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.PricingDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.PricingDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.PricingDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #pricingDetails(List<PricingDetail>)}.
         * 
         * @param pricingDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.PricingDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pricingDetails(java.util.Collection<PricingDetail>)
         */
        Builder pricingDetails(Consumer<PricingDetail.Builder>... pricingDetails);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RecurringCharge.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RecurringCharge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RecurringCharge.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RecurringCharge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(java.util.Collection<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * The ID of the Availability Zone.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The ID of the Reserved Instance offering. This is the offering ID used in
         * <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
         * </p>
         * 
         * @param reservedInstancesOfferingId
         *        The ID of the Reserved Instance offering. This is the offering ID used in
         *        <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingId(String reservedInstancesOfferingId);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The duration of the Reserved Instance, in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the Reserved Instance, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The usage price of the Reserved Instance, per hour.
         * </p>
         * 
         * @param usagePrice
         *        The usage price of the Reserved Instance, per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Float usagePrice);

        /**
         * <p>
         * The purchase price of the Reserved Instance.
         * </p>
         * 
         * @param fixedPrice
         *        The purchase price of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Float fixedPrice);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private String instanceTenancy;

        private Boolean marketplace;

        private String offeringClass;

        private String offeringType;

        private List<PricingDetail> pricingDetails = DefaultSdkAutoConstructList.getInstance();

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private String scope;

        private String availabilityZoneId;

        private String reservedInstancesOfferingId;

        private String instanceType;

        private String availabilityZone;

        private Long duration;

        private Float usagePrice;

        private Float fixedPrice;

        private String productDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesOffering model) {
            currencyCode(model.currencyCode);
            instanceTenancy(model.instanceTenancy);
            marketplace(model.marketplace);
            offeringClass(model.offeringClass);
            offeringType(model.offeringType);
            pricingDetails(model.pricingDetails);
            recurringCharges(model.recurringCharges);
            scope(model.scope);
            availabilityZoneId(model.availabilityZoneId);
            reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            instanceType(model.instanceType);
            availabilityZone(model.availabilityZone);
            duration(model.duration);
            usagePrice(model.usagePrice);
            fixedPrice(model.fixedPrice);
            productDescription(model.productDescription);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final Boolean getMarketplace() {
            return marketplace;
        }

        public final void setMarketplace(Boolean marketplace) {
            this.marketplace = marketplace;
        }

        @Override
        public final Builder marketplace(Boolean marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass == null ? null : offeringClass.toString());
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final List<PricingDetail.Builder> getPricingDetails() {
            List<PricingDetail.Builder> result = PricingDetailsListCopier.copyToBuilder(this.pricingDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPricingDetails(Collection<PricingDetail.BuilderImpl> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copyFromBuilder(pricingDetails);
        }

        @Override
        public final Builder pricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(PricingDetail... pricingDetails) {
            pricingDetails(Arrays.asList(pricingDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(Consumer<PricingDetail.Builder>... pricingDetails) {
            pricingDetails(Stream.of(pricingDetails).map(c -> PricingDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargesListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getReservedInstancesOfferingId() {
            return reservedInstancesOfferingId;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Float getUsagePrice() {
            return usagePrice;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final Float getFixedPrice() {
            return fixedPrice;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription == null ? null : productDescription.toString());
            return this;
        }

        @Override
        public ReservedInstancesOffering build() {
            return new ReservedInstancesOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
