/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Public hostname type options. For more information, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">EC2 instance hostnames, DNS
 * names, and domains</a> in the <i>Amazon EC2 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicIpDnsNameOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicIpDnsNameOptions.Builder, PublicIpDnsNameOptions> {
    private static final SdkField<String> DNS_HOSTNAME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DnsHostnameType")
            .getter(getter(PublicIpDnsNameOptions::dnsHostnameType))
            .setter(setter(Builder::dnsHostnameType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsHostnameType")
                    .unmarshallLocationName("dnsHostnameType").build()).build();

    private static final SdkField<String> PUBLIC_IPV4_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIpv4DnsName")
            .getter(getter(PublicIpDnsNameOptions::publicIpv4DnsName))
            .setter(setter(Builder::publicIpv4DnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4DnsName")
                    .unmarshallLocationName("publicIpv4DnsName").build()).build();

    private static final SdkField<String> PUBLIC_IPV6_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIpv6DnsName")
            .getter(getter(PublicIpDnsNameOptions::publicIpv6DnsName))
            .setter(setter(Builder::publicIpv6DnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv6DnsName")
                    .unmarshallLocationName("publicIpv6DnsName").build()).build();

    private static final SdkField<String> PUBLIC_DUAL_STACK_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicDualStackDnsName")
            .getter(getter(PublicIpDnsNameOptions::publicDualStackDnsName))
            .setter(setter(Builder::publicDualStackDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicDualStackDnsName")
                    .unmarshallLocationName("publicDualStackDnsName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_HOSTNAME_TYPE_FIELD,
            PUBLIC_IPV4_DNS_NAME_FIELD, PUBLIC_IPV6_DNS_NAME_FIELD, PUBLIC_DUAL_STACK_DNS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dnsHostnameType;

    private final String publicIpv4DnsName;

    private final String publicIpv6DnsName;

    private final String publicDualStackDnsName;

    private PublicIpDnsNameOptions(BuilderImpl builder) {
        this.dnsHostnameType = builder.dnsHostnameType;
        this.publicIpv4DnsName = builder.publicIpv4DnsName;
        this.publicIpv6DnsName = builder.publicIpv6DnsName;
        this.publicDualStackDnsName = builder.publicDualStackDnsName;
    }

    /**
     * <p>
     * The public hostname type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">EC2 instance hostnames, DNS
     * names, and domains</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The public hostname type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">EC2 instance
     *         hostnames, DNS names, and domains</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String dnsHostnameType() {
        return dnsHostnameType;
    }

    /**
     * <p>
     * An IPv4-enabled public hostname for a network interface. Requests from within the VPC resolve to the private
     * primary IPv4 address of the network interface. Requests from the internet resolve to the public IPv4 address of
     * the network interface.
     * </p>
     * 
     * @return An IPv4-enabled public hostname for a network interface. Requests from within the VPC resolve to the
     *         private primary IPv4 address of the network interface. Requests from the internet resolve to the public
     *         IPv4 address of the network interface.
     */
    public final String publicIpv4DnsName() {
        return publicIpv4DnsName;
    }

    /**
     * <p>
     * An IPv6-enabled public hostname for a network interface. Requests from within the VPC or from the internet
     * resolve to the IPv6 GUA of the network interface.
     * </p>
     * 
     * @return An IPv6-enabled public hostname for a network interface. Requests from within the VPC or from the
     *         internet resolve to the IPv6 GUA of the network interface.
     */
    public final String publicIpv6DnsName() {
        return publicIpv6DnsName;
    }

    /**
     * <p>
     * A dual-stack public hostname for a network interface. Requests from within the VPC resolve to both the private
     * IPv4 address and the IPv6 Global Unicast Address of the network interface. Requests from the internet resolve to
     * both the public IPv4 and the IPv6 GUA address of the network interface.
     * </p>
     * 
     * @return A dual-stack public hostname for a network interface. Requests from within the VPC resolve to both the
     *         private IPv4 address and the IPv6 Global Unicast Address of the network interface. Requests from the
     *         internet resolve to both the public IPv4 and the IPv6 GUA address of the network interface.
     */
    public final String publicDualStackDnsName() {
        return publicDualStackDnsName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsHostnameType());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpv4DnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpv6DnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicDualStackDnsName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicIpDnsNameOptions)) {
            return false;
        }
        PublicIpDnsNameOptions other = (PublicIpDnsNameOptions) obj;
        return Objects.equals(dnsHostnameType(), other.dnsHostnameType())
                && Objects.equals(publicIpv4DnsName(), other.publicIpv4DnsName())
                && Objects.equals(publicIpv6DnsName(), other.publicIpv6DnsName())
                && Objects.equals(publicDualStackDnsName(), other.publicDualStackDnsName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicIpDnsNameOptions").add("DnsHostnameType", dnsHostnameType())
                .add("PublicIpv4DnsName", publicIpv4DnsName()).add("PublicIpv6DnsName", publicIpv6DnsName())
                .add("PublicDualStackDnsName", publicDualStackDnsName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsHostnameType":
            return Optional.ofNullable(clazz.cast(dnsHostnameType()));
        case "PublicIpv4DnsName":
            return Optional.ofNullable(clazz.cast(publicIpv4DnsName()));
        case "PublicIpv6DnsName":
            return Optional.ofNullable(clazz.cast(publicIpv6DnsName()));
        case "PublicDualStackDnsName":
            return Optional.ofNullable(clazz.cast(publicDualStackDnsName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DnsHostnameType", DNS_HOSTNAME_TYPE_FIELD);
        map.put("PublicIpv4DnsName", PUBLIC_IPV4_DNS_NAME_FIELD);
        map.put("PublicIpv6DnsName", PUBLIC_IPV6_DNS_NAME_FIELD);
        map.put("PublicDualStackDnsName", PUBLIC_DUAL_STACK_DNS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublicIpDnsNameOptions, T> g) {
        return obj -> g.apply((PublicIpDnsNameOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicIpDnsNameOptions> {
        /**
         * <p>
         * The public hostname type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">EC2 instance hostnames,
         * DNS names, and domains</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param dnsHostnameType
         *        The public hostname type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">EC2 instance
         *        hostnames, DNS names, and domains</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsHostnameType(String dnsHostnameType);

        /**
         * <p>
         * An IPv4-enabled public hostname for a network interface. Requests from within the VPC resolve to the private
         * primary IPv4 address of the network interface. Requests from the internet resolve to the public IPv4 address
         * of the network interface.
         * </p>
         * 
         * @param publicIpv4DnsName
         *        An IPv4-enabled public hostname for a network interface. Requests from within the VPC resolve to the
         *        private primary IPv4 address of the network interface. Requests from the internet resolve to the
         *        public IPv4 address of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4DnsName(String publicIpv4DnsName);

        /**
         * <p>
         * An IPv6-enabled public hostname for a network interface. Requests from within the VPC or from the internet
         * resolve to the IPv6 GUA of the network interface.
         * </p>
         * 
         * @param publicIpv6DnsName
         *        An IPv6-enabled public hostname for a network interface. Requests from within the VPC or from the
         *        internet resolve to the IPv6 GUA of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv6DnsName(String publicIpv6DnsName);

        /**
         * <p>
         * A dual-stack public hostname for a network interface. Requests from within the VPC resolve to both the
         * private IPv4 address and the IPv6 Global Unicast Address of the network interface. Requests from the internet
         * resolve to both the public IPv4 and the IPv6 GUA address of the network interface.
         * </p>
         * 
         * @param publicDualStackDnsName
         *        A dual-stack public hostname for a network interface. Requests from within the VPC resolve to both the
         *        private IPv4 address and the IPv6 Global Unicast Address of the network interface. Requests from the
         *        internet resolve to both the public IPv4 and the IPv6 GUA address of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDualStackDnsName(String publicDualStackDnsName);
    }

    static final class BuilderImpl implements Builder {
        private String dnsHostnameType;

        private String publicIpv4DnsName;

        private String publicIpv6DnsName;

        private String publicDualStackDnsName;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicIpDnsNameOptions model) {
            dnsHostnameType(model.dnsHostnameType);
            publicIpv4DnsName(model.publicIpv4DnsName);
            publicIpv6DnsName(model.publicIpv6DnsName);
            publicDualStackDnsName(model.publicDualStackDnsName);
        }

        public final String getDnsHostnameType() {
            return dnsHostnameType;
        }

        public final void setDnsHostnameType(String dnsHostnameType) {
            this.dnsHostnameType = dnsHostnameType;
        }

        @Override
        public final Builder dnsHostnameType(String dnsHostnameType) {
            this.dnsHostnameType = dnsHostnameType;
            return this;
        }

        public final String getPublicIpv4DnsName() {
            return publicIpv4DnsName;
        }

        public final void setPublicIpv4DnsName(String publicIpv4DnsName) {
            this.publicIpv4DnsName = publicIpv4DnsName;
        }

        @Override
        public final Builder publicIpv4DnsName(String publicIpv4DnsName) {
            this.publicIpv4DnsName = publicIpv4DnsName;
            return this;
        }

        public final String getPublicIpv6DnsName() {
            return publicIpv6DnsName;
        }

        public final void setPublicIpv6DnsName(String publicIpv6DnsName) {
            this.publicIpv6DnsName = publicIpv6DnsName;
        }

        @Override
        public final Builder publicIpv6DnsName(String publicIpv6DnsName) {
            this.publicIpv6DnsName = publicIpv6DnsName;
            return this;
        }

        public final String getPublicDualStackDnsName() {
            return publicDualStackDnsName;
        }

        public final void setPublicDualStackDnsName(String publicDualStackDnsName) {
            this.publicDualStackDnsName = publicDualStackDnsName;
        }

        @Override
        public final Builder publicDualStackDnsName(String publicDualStackDnsName) {
            this.publicDualStackDnsName = publicDualStackDnsName;
            return this;
        }

        @Override
        public PublicIpDnsNameOptions build() {
            return new PublicIpDnsNameOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
