/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a <code>DataQuery</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataResponse implements SdkPojo, Serializable, ToCopyableBuilder<DataResponse.Builder, DataResponse> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(DataResponse::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("id")
                    .build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Source")
            .getter(getter(DataResponse::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source")
                    .unmarshallLocationName("source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Destination")
            .getter(getter(DataResponse::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination")
                    .unmarshallLocationName("destination").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Metric")
            .getter(getter(DataResponse::metricAsString))
            .setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric")
                    .unmarshallLocationName("metric").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Statistic")
            .getter(getter(DataResponse::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic")
                    .unmarshallLocationName("statistic").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Period")
            .getter(getter(DataResponse::periodAsString))
            .setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period")
                    .unmarshallLocationName("period").build()).build();

    private static final SdkField<List<MetricPoint>> METRIC_POINTS_FIELD = SdkField
            .<List<MetricPoint>> builder(MarshallingType.LIST)
            .memberName("MetricPoints")
            .getter(getter(DataResponse::metricPoints))
            .setter(setter(Builder::metricPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPointSet")
                    .unmarshallLocationName("metricPointSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<MetricPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SOURCE_FIELD,
            DESTINATION_FIELD, METRIC_FIELD, STATISTIC_FIELD, PERIOD_FIELD, METRIC_POINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String source;

    private final String destination;

    private final String metric;

    private final String statistic;

    private final String period;

    private final List<MetricPoint> metricPoints;

    private DataResponse(BuilderImpl builder) {
        this.id = builder.id;
        this.source = builder.source;
        this.destination = builder.destination;
        this.metric = builder.metric;
        this.statistic = builder.statistic;
        this.period = builder.period;
        this.metricPoints = builder.metricPoints;
    }

    /**
     * <p>
     * The ID passed in the <code>DataQuery</code>.
     * </p>
     * 
     * @return The ID passed in the <code>DataQuery</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Region or Availability Zone that's the source for the data query. For example, <code>us-east-1</code>.
     * </p>
     * 
     * @return The Region or Availability Zone that's the source for the data query. For example, <code>us-east-1</code>
     *         .
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The Region or Availability Zone that's the destination for the data query. For example, <code>eu-west-1</code>.
     * </p>
     * 
     * @return The Region or Availability Zone that's the destination for the data query. For example,
     *         <code>eu-west-1</code>.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The metric used for the network performance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return The metric used for the network performance request.
     * @see MetricType
     */
    public final MetricType metric() {
        return MetricType.fromValue(metric);
    }

    /**
     * <p>
     * The metric used for the network performance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return The metric used for the network performance request.
     * @see MetricType
     */
    public final String metricAsString() {
        return metric;
    }

    /**
     * <p>
     * The statistic used for the network performance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link StatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic used for the network performance request.
     * @see StatisticType
     */
    public final StatisticType statistic() {
        return StatisticType.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic used for the network performance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link StatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic used for the network performance request.
     * @see StatisticType
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * The period used for the network performance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link PeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The period used for the network performance request.
     * @see PeriodType
     */
    public final PeriodType period() {
        return PeriodType.fromValue(period);
    }

    /**
     * <p>
     * The period used for the network performance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link PeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The period used for the network performance request.
     * @see PeriodType
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricPoints() {
        return metricPoints != null && !(metricPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>MetricPoint</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricPoints} method.
     * </p>
     * 
     * @return A list of <code>MetricPoint</code> objects.
     */
    public final List<MetricPoint> metricPoints() {
        return metricPoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricPoints() ? metricPoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataResponse)) {
            return false;
        }
        DataResponse other = (DataResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(source(), other.source())
                && Objects.equals(destination(), other.destination()) && Objects.equals(metricAsString(), other.metricAsString())
                && Objects.equals(statisticAsString(), other.statisticAsString())
                && Objects.equals(periodAsString(), other.periodAsString()) && hasMetricPoints() == other.hasMetricPoints()
                && Objects.equals(metricPoints(), other.metricPoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataResponse").add("Id", id()).add("Source", source()).add("Destination", destination())
                .add("Metric", metricAsString()).add("Statistic", statisticAsString()).add("Period", periodAsString())
                .add("MetricPoints", hasMetricPoints() ? metricPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metricAsString()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "Period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "MetricPoints":
            return Optional.ofNullable(clazz.cast(metricPoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Metric", METRIC_FIELD);
        map.put("Statistic", STATISTIC_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("MetricPointSet", METRIC_POINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataResponse, T> g) {
        return obj -> g.apply((DataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataResponse> {
        /**
         * <p>
         * The ID passed in the <code>DataQuery</code>.
         * </p>
         * 
         * @param id
         *        The ID passed in the <code>DataQuery</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Region or Availability Zone that's the source for the data query. For example, <code>us-east-1</code>.
         * </p>
         * 
         * @param source
         *        The Region or Availability Zone that's the source for the data query. For example,
         *        <code>us-east-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The Region or Availability Zone that's the destination for the data query. For example,
         * <code>eu-west-1</code>.
         * </p>
         * 
         * @param destination
         *        The Region or Availability Zone that's the destination for the data query. For example,
         *        <code>eu-west-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The metric used for the network performance request.
         * </p>
         * 
         * @param metric
         *        The metric used for the network performance request.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metric(String metric);

        /**
         * <p>
         * The metric used for the network performance request.
         * </p>
         * 
         * @param metric
         *        The metric used for the network performance request.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metric(MetricType metric);

        /**
         * <p>
         * The statistic used for the network performance request.
         * </p>
         * 
         * @param statistic
         *        The statistic used for the network performance request.
         * @see StatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticType
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic used for the network performance request.
         * </p>
         * 
         * @param statistic
         *        The statistic used for the network performance request.
         * @see StatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticType
         */
        Builder statistic(StatisticType statistic);

        /**
         * <p>
         * The period used for the network performance request.
         * </p>
         * 
         * @param period
         *        The period used for the network performance request.
         * @see PeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodType
         */
        Builder period(String period);

        /**
         * <p>
         * The period used for the network performance request.
         * </p>
         * 
         * @param period
         *        The period used for the network performance request.
         * @see PeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodType
         */
        Builder period(PeriodType period);

        /**
         * <p>
         * A list of <code>MetricPoint</code> objects.
         * </p>
         * 
         * @param metricPoints
         *        A list of <code>MetricPoint</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricPoints(Collection<MetricPoint> metricPoints);

        /**
         * <p>
         * A list of <code>MetricPoint</code> objects.
         * </p>
         * 
         * @param metricPoints
         *        A list of <code>MetricPoint</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricPoints(MetricPoint... metricPoints);

        /**
         * <p>
         * A list of <code>MetricPoint</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.MetricPoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.MetricPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.MetricPoint.Builder#build()} is called immediately and its
         * result is passed to {@link #metricPoints(List<MetricPoint>)}.
         * 
         * @param metricPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.MetricPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricPoints(java.util.Collection<MetricPoint>)
         */
        Builder metricPoints(Consumer<MetricPoint.Builder>... metricPoints);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String source;

        private String destination;

        private String metric;

        private String statistic;

        private String period;

        private List<MetricPoint> metricPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataResponse model) {
            id(model.id);
            source(model.source);
            destination(model.destination);
            metric(model.metric);
            statistic(model.statistic);
            period(model.period);
            metricPoints(model.metricPoints);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(MetricType metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(StatisticType statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(PeriodType period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final List<MetricPoint.Builder> getMetricPoints() {
            List<MetricPoint.Builder> result = MetricPointsCopier.copyToBuilder(this.metricPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricPoints(Collection<MetricPoint.BuilderImpl> metricPoints) {
            this.metricPoints = MetricPointsCopier.copyFromBuilder(metricPoints);
        }

        @Override
        public final Builder metricPoints(Collection<MetricPoint> metricPoints) {
            this.metricPoints = MetricPointsCopier.copy(metricPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricPoints(MetricPoint... metricPoints) {
            metricPoints(Arrays.asList(metricPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricPoints(Consumer<MetricPoint.Builder>... metricPoints) {
            metricPoints(Stream.of(metricPoints).map(c -> MetricPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataResponse build() {
            return new DataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
