/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.oauth.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.EntryPointHelper;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserChangeEventHandler;
import com.sap.sse.security.ui.client.UserManagementService;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.UserManagementWriteService;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.shared.oauthlogin.OAuthLogin;
import com.sap.sse.security.ui.oauth.client.util.ClientUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class OAuthLoginEntryPoint
implements EntryPoint,
UserChangeEventHandler {
    private final StringMessages stringMessages = (StringMessages)GWT.create(StringMessages.class);
    private OAuthLogin loginScreen;
    private UserService userService;
    private FlowPanel content = new FlowPanel();

    public void onModuleLoad() {
        UserManagementServiceAsync userManagementService = (UserManagementServiceAsync)GWT.create(UserManagementService.class);
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)userManagementService), (String)"service/usermanagement", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA});
        UserManagementWriteServiceAsync userManagementWriteService = (UserManagementWriteServiceAsync)GWT.create(UserManagementWriteService.class);
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)userManagementWriteService), (String)"service/usermanagement", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER});
        this.userService = new UserService(userManagementService, userManagementWriteService);
        this.loginScreen = new OAuthLogin(userManagementWriteService);
        RootPanel.get().add((Widget)this.content);
        this.setContentMessage(this.stringMessages.loading());
        try {
            this.handleRedirect();
        }
        catch (Exception e) {
            this.log(e.getMessage());
        }
    }

    private void handleRedirect() throws Exception {
        if (ClientUtils.redirected()) {
            if (!ClientUtils.alreadyLoggedIn()) {
                this.setContentMessage(this.stringMessages.tryingToVerifyUser());
                this.userService.verifySocialUser((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.updateUserContent();
            }
        } else {
            this.updateUserContent();
        }
    }

    private void updateUserContent() {
        UserDTO result = this.userService.getCurrentUser();
        if (result == null) {
            this.setContent((Widget)this.loginScreen);
        } else {
            this.setLoggedInContent(result);
            OAuthLoginEntryPoint.closeWindow();
        }
    }

    public void onUserChange(UserDTO result) {
        if (result == null) {
            this.setContent((Widget)this.loginScreen);
        } else {
            String name = result.getName();
            this.log("User '" + name + "' is verified!\n");
            ClientUtils.saveUsername((String)name);
            this.setLoggedInContent(result);
            OAuthLoginEntryPoint.closeWindow();
        }
    }

    public void log(String msg) {
        GWT.log((String)msg);
    }

    private void setContentMessage(String msg) {
        this.content.clear();
        this.content.add((Widget)new Label(msg));
    }

    private void setContent(Widget w) {
        this.content.clear();
        this.content.add(w);
    }

    private void setLoggedInContent(UserDTO user) {
        this.content.clear();
        this.content.add((Widget)new Label(this.stringMessages.signedInAs(user.getName())));
        this.content.add((Widget)new Button(this.stringMessages.close(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
    }

    public static native void closeWindow();
}

