/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.usermanagement;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DecoratorPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.AccountDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.dto.WildcardPermissionWithSecurityDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.oauth.client.SocialUserDTO;
import com.sap.sse.security.ui.shared.UsernamePasswordAccountDTO;
import java.util.ArrayList;
import java.util.Map;

public class UserEditDialog
extends DataEntryDialog<UserDTO> {
    private final UserDTO userToEdit;
    private final TextBox username;
    private final TextBox fullName;
    private final TextBox company;
    private final TextBox email;
    private final VerticalPanel accountPanels;
    private final UserService userService;
    private static final StringMessages stringMessages = StringMessages.INSTANCE;

    public UserEditDialog(UserDTO userToEdit, DataEntryDialog.DialogCallback<UserDTO> callback, UserService userService, ErrorReporter errorReporter) {
        super(stringMessages.editUser(), null, stringMessages.ok(), stringMessages.cancel(), null, true, callback);
        this.ensureDebugId("UserEditDialog");
        this.userService = userService;
        this.userToEdit = userToEdit;
        this.username = this.createTextBox(userToEdit.getName(), 70);
        this.username.ensureDebugId("UsernameTextBox");
        this.username.setEnabled(false);
        this.email = this.createTextBox(userToEdit.getEmail(), 70);
        this.fullName = this.createTextBox(userToEdit.getFullName(), 70);
        this.company = this.createTextBox(userToEdit.getCompany(), 70);
        this.accountPanels = new VerticalPanel();
        for (AccountDTO a : userToEdit.getAccounts()) {
            DecoratorPanel accountPanelDecorator = new DecoratorPanel();
            FlowPanel accountPanelContent = new FlowPanel();
            accountPanelDecorator.setWidget((Widget)accountPanelContent);
            accountPanelContent.add((Widget)new Label(stringMessages.account(a.getAccountType())));
            if (a instanceof UsernamePasswordAccountDTO) {
                Button changePasswordButton = new Button(stringMessages.changePassword());
                changePasswordButton.ensureDebugId("ChangePasswordButton");
                accountPanelContent.add((Widget)changePasswordButton);
                changePasswordButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            } else if (a instanceof SocialUserDTO) {
                SocialUserDTO sua = (SocialUserDTO)a;
                FlexTable table = new FlexTable();
                int i = 0;
                for (Map.Entry e : sua.getProperties().entrySet()) {
                    if (e.getValue() == null) continue;
                    table.setText(i, 0, ((String)e.getKey()).toLowerCase().replace('_', ' '));
                    table.setText(i, 1, (String)e.getValue());
                    ++i;
                }
                accountPanelContent.add((Widget)table);
            }
            this.accountPanels.add((Widget)accountPanelDecorator);
        }
    }

    private UserManagementWriteServiceAsync getUserManagementWriteService() {
        return this.userService.getUserManagementWriteService();
    }

    protected Focusable getInitialFocusWidget() {
        return this.email;
    }

    protected UserDTO getResult() {
        ArrayList<WildcardPermissionWithSecurityDTO> permissions = new ArrayList<WildcardPermissionWithSecurityDTO>();
        for (WildcardPermission permission : this.userToEdit.getPermissions()) {
            if (!(permission instanceof WildcardPermissionWithSecurityDTO)) continue;
            permissions.add((WildcardPermissionWithSecurityDTO)permission);
        }
        UserDTO user = new UserDTO(this.userToEdit.getName(), this.email.getText(), this.fullName.getText(), this.company.getText(), this.userToEdit.getLocale(), this.userToEdit.isEmailValidated(), this.userToEdit.getAccounts(), this.userToEdit.getRoles(), this.userToEdit.getDefaultTenant(), permissions, (Iterable)this.userToEdit.getUserGroups(), this.userToEdit.getLockedUntil());
        return user;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(5, 2);
        result.setWidget(0, 0, (Widget)new Label(stringMessages.username()));
        result.setWidget(0, 1, (Widget)this.username);
        result.setWidget(1, 0, (Widget)new Label(stringMessages.name()));
        result.setWidget(1, 1, (Widget)this.fullName);
        result.setWidget(2, 0, (Widget)new Label(stringMessages.email()));
        result.setWidget(2, 1, (Widget)this.email);
        result.setWidget(3, 0, (Widget)new Label(stringMessages.company()));
        result.setWidget(3, 1, (Widget)this.company);
        result.setWidget(4, 0, (Widget)this.accountPanels);
        return result;
    }

    static /* synthetic */ StringMessages access$1() {
        return stringMessages;
    }

    static /* synthetic */ UserManagementWriteServiceAsync access$2(UserEditDialog userEditDialog) {
        return userEditDialog.getUserManagementWriteService();
    }
}

