/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ImageResourceRenderer;
import com.google.gwt.user.client.ui.IntegerBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.AbstractEntryPoint;
import com.sap.sse.security.ui.client.IconResources;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.HashMap;
import java.util.Map;

public class SettingsPanel
extends LayoutPanel {
    private UserManagementServiceAsync userManagementService;
    private UserManagementWriteServiceAsync userManagementWriteService;
    private Map<String, String> settings = null;
    private Map<String, String> settingTypes = null;
    private Map<String, FlexTable> savedTabs = new HashMap();
    private final StringMessages stringMessages;

    public SettingsPanel(UserManagementServiceAsync userManagementService, UserManagementWriteServiceAsync userManagementWriteService, StringMessages stringMessages) {
        this.setHeight("600px");
        this.stringMessages = stringMessages;
        this.userManagementService = userManagementService;
        this.userManagementWriteService = userManagementWriteService;
        this.initComponents();
    }

    private void initComponents() {
        this.clear();
        this.userManagementService.getSettingTypes((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.userManagementService.getSettings((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateSettings() {
        if (this.settings == null || this.settingTypes == null) {
            return;
        }
        TabLayoutPanel tabPanel = new TabLayoutPanel(30.0, Style.Unit.PX);
        tabPanel.setHeight("95%");
        AbstractEntryPoint.setTabPanelSize((ResizeComposite)tabPanel, (String)"100%", (String)"95%");
        HashMap<String, Integer> numberOfSettings = new HashMap<String, Integer>();
        for (Map.Entry e : this.settingTypes.entrySet()) {
            String[] split = ((String)e.getKey()).split("_");
            FlexTable flexTable = (FlexTable)this.savedTabs.get(split[0]);
            Integer row = (Integer)numberOfSettings.get(split[0]);
            if (row == null) {
                row = 0;
            }
            if (flexTable == null) {
                flexTable = new FlexTable();
                this.savedTabs.put(split[0], flexTable);
                ScrollPanel scrollPanel = new ScrollPanel((Widget)flexTable);
                scrollPanel.setHeight("100%");
                scrollPanel.addStyleName("settingsPanel-grid");
                tabPanel.add((Widget)scrollPanel, split[0]);
            }
            if (split[0].equals("URLS")) {
                if (!split[1].equals("AUTH")) {
                    this.createUrlRowEntry((String)e.getKey(), (String)e.getValue(), flexTable, row.intValue());
                }
            } else {
                this.createSettingRowEntry((String)e.getKey(), (String)e.getValue(), flexTable, row);
            }
            row = row + 1;
            numberOfSettings.put(split[0], row);
        }
        if (this.savedTabs.get("URLS") != null) {
            FlexTable table = (FlexTable)this.savedTabs.get("URLS");
            int newline = table.getRowCount() + 1;
            TextBox key = new TextBox();
            TextBox url = new TextBox();
            TextBox filter = new TextBox();
            table.setWidget(newline, 0, (Widget)key);
            table.setWidget(newline, 1, (Widget)url);
            table.setWidget(newline, 2, (Widget)filter);
            Button add = new Button(this.stringMessages.addURLFilter(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            table.setWidget(newline + 1, 0, (Widget)add);
        }
        this.clear();
        this.add((Widget)tabPanel);
    }

    private void createSettingRowEntry(String key, String sValue, FlexTable flexTable, Integer row) {
        Label keyLabel = new Label(key.substring(key.indexOf(95) + 1));
        flexTable.setWidget(row.intValue(), 0, (Widget)keyLabel);
        ImageResourceRenderer renderer = new ImageResourceRenderer();
        ImageResource statusRedImageResource = IconResources.INSTANCE.statusRed();
        HTML statusRed = new HTML(renderer.render(statusRedImageResource));
        statusRed.setTitle("Could not safe property!");
        ImageResource statusGreenImageResource = IconResources.INSTANCE.statusGreen();
        HTML statusGreen = new HTML(renderer.render(statusGreenImageResource));
        statusGreen.setTitle("Saved property!");
        ImageResource statusYellowImageResource = IconResources.INSTANCE.statusYellow();
        HTML statusYellow = new HTML(renderer.render(statusYellowImageResource));
        statusYellow.setTitle("Trying to safe property...");
        flexTable.setWidget(row.intValue(), 2, (Widget)statusGreen);
        ImageResource deleteImageResource = com.sap.sse.gwt.client.IconResources.INSTANCE.removeIcon();
        HTML delete = new HTML(renderer.render(deleteImageResource));
        delete.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        flexTable.setWidget(row.intValue(), 3, (Widget)delete);
        if (sValue.equals(Boolean.class.getName())) {
            CheckBox value = new CheckBox();
            value.setValue(Boolean.valueOf(Boolean.parseBoolean((String)this.settings.get(key))));
            value.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            flexTable.setWidget(row.intValue(), 1, (Widget)value);
        } else if (sValue.equals(Integer.class.getName())) {
            IntegerBox value = new IntegerBox();
            value.setValue((Object)Integer.parseInt((String)this.settings.get(key)));
            value.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            flexTable.setWidget(row.intValue(), 1, (Widget)value);
        } else {
            TextBox value = new TextBox();
            value.setText((String)this.settings.get(key));
            value.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            flexTable.setWidget(row.intValue(), 1, (Widget)value);
        }
    }

    private void createUrlRowEntry(String key, String sValue, FlexTable flexTable, int row) {
        String labelKey = key.substring(key.indexOf(95) + 1);
        Label keyLabel = new Label(labelKey);
        flexTable.setWidget(row, 0, (Widget)keyLabel);
        ImageResourceRenderer renderer = new ImageResourceRenderer();
        ImageResource statusRedImageResource = IconResources.INSTANCE.statusRed();
        HTML statusRed = new HTML(renderer.render(statusRedImageResource));
        statusRed.setTitle("Could not safe property!");
        ImageResource statusGreenImageResource = IconResources.INSTANCE.statusGreen();
        HTML statusGreen = new HTML(renderer.render(statusGreenImageResource));
        statusGreen.setTitle("Saved property!");
        ImageResource statusYellowImageResource = IconResources.INSTANCE.statusYellow();
        HTML statusYellow = new HTML(renderer.render(statusYellowImageResource));
        statusYellow.setTitle("Trying to safe property...");
        flexTable.setWidget(row, 3, (Widget)statusGreen);
        ImageResource deleteImageResource = com.sap.sse.gwt.client.IconResources.INSTANCE.removeIcon();
        HTML delete = new HTML(renderer.render(deleteImageResource));
        delete.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        flexTable.setWidget(row, 4, (Widget)delete);
        TextBox value1 = new TextBox();
        value1.setText((String)this.settings.get(key));
        value1.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        flexTable.setWidget(row, 1, (Widget)value1);
        TextBox value2 = new TextBox();
        value2.setText((String)this.settings.get("URLS_AUTH_" + labelKey));
        value2.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        flexTable.setWidget(row, 2, (Widget)value2);
    }

    static /* synthetic */ void access$0(SettingsPanel settingsPanel, Map map) {
        settingsPanel.settingTypes = map;
    }

    static /* synthetic */ void access$1(SettingsPanel settingsPanel) {
        settingsPanel.updateSettings();
    }

    static /* synthetic */ void access$2(SettingsPanel settingsPanel, Map map) {
        settingsPanel.settings = map;
    }

    static /* synthetic */ UserManagementWriteServiceAsync access$3(SettingsPanel settingsPanel) {
        return settingsPanel.userManagementWriteService;
    }
}

