/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.authentication.signin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.common.CommonSharedResources;
import com.sap.sse.security.ui.authentication.UserManagementResources;
import com.sap.sse.security.ui.authentication.signin.SignInView;
import com.sap.sse.security.ui.authentication.signin.SignInViewImpl;

public class SignInViewImpl
extends Composite
implements SignInView {
    private static SignInViewImplUiBinder uiBinder = (SignInViewImplUiBinder)GWT.create(SignInViewImplUiBinder.class);
    @UiField
    TextBox loginNameUi;
    @UiField
    PasswordTextBox passwordUi;
    @UiField
    Anchor forgotPasswordUi;
    @UiField
    Button createAccountUi;
    @UiField
    Button signInUi;
    @UiField
    Anchor loginFacebookUi;
    @UiField
    Anchor loginGoogleUi;
    @UiField
    CheckBox reallyUseLeadingOrTrailingSpacesInUsernameUi;
    @UiField
    DivElement formErrorUi;
    @UiField
    DivElement socialLoginUi;
    @UiField(provided=true)
    final CommonSharedResources res;
    private SignInView.Presenter presenter;

    public SignInViewImpl(CommonSharedResources resources) {
        this.res = resources;
        UserManagementResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.ensureDebugIds();
        this.socialLoginUi.removeFromParent();
        this.loginNameUi.addKeyUpHandler(e -> this.validate());
        this.reallyUseLeadingOrTrailingSpacesInUsernameUi.addValueChangeHandler(e -> this.validate());
    }

    private void validate() {
        String username = this.loginNameUi.getValue();
        boolean usernameStartsOrEndsWithSpace = username.startsWith(" ") || username.endsWith(" ");
        this.reallyUseLeadingOrTrailingSpacesInUsernameUi.setVisible(usernameStartsOrEndsWithSpace);
        this.signInUi.setEnabled(!usernameStartsOrEndsWithSpace || this.reallyUseLeadingOrTrailingSpacesInUsernameUi.getValue() != false);
    }

    public void setPresenter(SignInView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setErrorMessage(String errorMessage) {
        this.formErrorUi.setInnerText(errorMessage);
        this.selectAll((TextBox)(this.passwordUi.getValue().isEmpty() ? this.loginNameUi : this.passwordUi));
    }

    protected void onLoad() {
        this.selectAll(this.loginNameUi);
    }

    @UiHandler(value={"forgotPasswordUi"})
    void onForgotPasswordUiControlClicked(ClickEvent event) {
        this.presenter.forgotPassword();
    }

    @UiHandler(value={"createAccountUi"})
    void onCreateAccountUiControlClicked(ClickEvent event) {
        this.presenter.createAccount();
    }

    @UiHandler(value={"signInUi"})
    void onSignInControlUiClicked(ClickEvent event) {
        this.triggerLogin();
    }

    @UiHandler(value={"loginNameUi", "passwordUi"})
    void onSignInKeyPressed(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.triggerLogin();
        }
    }

    @UiHandler(value={"loginFacebookUi"})
    void onLoginFacebookUiClicked(ClickEvent event) {
        this.presenter.loginWithFacebook();
    }

    @UiHandler(value={"loginGoogleUi"})
    void onLoginGoogleUiClicked(ClickEvent event) {
        this.presenter.loginWithGoogle();
    }

    private void triggerLogin() {
        this.presenter.login(this.loginNameUi.getValue(), this.passwordUi.getValue());
    }

    private void selectAll(TextBox textBox) {
        textBox.setFocus(true);
        textBox.selectAll();
    }

    private void ensureDebugIds() {
        this.ensureDebugId("signInForm");
        this.loginNameUi.ensureDebugId("loginTextField");
        this.passwordUi.ensureDebugId("passwordTextField");
        this.signInUi.ensureDebugId("signInAnchor");
        this.createAccountUi.ensureDebugId("signUpAnchor");
        this.forgotPasswordUi.ensureDebugId("forgotPasswordAnchor");
    }
}

