/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.integration;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.tracking.CompleteManeuverCurve;
import com.sap.sailing.windestimation.data.transformer.ConvertableToManeuverForEstimation;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;

public class ConvertableManeuverForEstimationAdapterForCompleteManeuverCurve
implements ConvertableToManeuverForEstimation {
    private final CompleteManeuverCurve maneuver;
    private final Position maneuverPosition;
    private final boolean hasMarkPassingData;
    private final Duration intervalBetweenFirstFixOfCurveAndPreviousFix;
    private final Duration intervalBetweenLastFixOfCurveAndNextFix;
    private final Duration longestIntervalBetweenTwoFixes;
    private final Double courseChangeInDegreesWithinTurningSectionOfPreviousManeuver;
    private final Double courseChangeInDegreesWithinTurningSectionOfNextManeuver;
    private final Duration durationFromPreviousManeuverEndToManeuverStart;
    private final Duration durationFromManeuverEndToNextManeuverStart;
    private final Double targetTackAngleInDegrees;
    private final Double targetJibeAngleInDegrees;

    public ConvertableManeuverForEstimationAdapterForCompleteManeuverCurve(CompleteManeuverCurve maneuver, Position maneuverPosition, boolean hasMarkPassingData, Duration longestIntervalBetweenTwoFixes, Double courseChangeInDegreesWithinTurningSectionOfPreviousManeuver, Double courseChangeInDegreesWithinTurningSectionOfNextManeuver, Duration intervalBetweenFirstFixOfCurveAndPreviousFix, Duration intervalBetweenLastFixOfCurveAndNextFix, Duration durationFromPreviousManeuverEndToManeuverStart, Duration durationFromManeuverEndToNextManeuverStart, Double targetTackAngleInDegrees, Double targetJibeAngleInDegrees) {
        this.maneuver = maneuver;
        this.maneuverPosition = maneuverPosition;
        this.hasMarkPassingData = hasMarkPassingData;
        this.longestIntervalBetweenTwoFixes = longestIntervalBetweenTwoFixes;
        this.courseChangeInDegreesWithinTurningSectionOfPreviousManeuver = courseChangeInDegreesWithinTurningSectionOfPreviousManeuver;
        this.courseChangeInDegreesWithinTurningSectionOfNextManeuver = courseChangeInDegreesWithinTurningSectionOfNextManeuver;
        this.intervalBetweenFirstFixOfCurveAndPreviousFix = intervalBetweenFirstFixOfCurveAndPreviousFix;
        this.intervalBetweenLastFixOfCurveAndNextFix = intervalBetweenLastFixOfCurveAndNextFix;
        this.durationFromPreviousManeuverEndToManeuverStart = durationFromPreviousManeuverEndToManeuverStart;
        this.durationFromManeuverEndToNextManeuverStart = durationFromManeuverEndToNextManeuverStart;
        this.targetTackAngleInDegrees = targetTackAngleInDegrees;
        this.targetJibeAngleInDegrees = targetJibeAngleInDegrees;
    }

    @Override
    public double getCourseChangeInDegreesWithinTurningSection() {
        return this.maneuver.getMainCurveBoundaries().getDirectionChangeInDegrees();
    }

    @Override
    public double getCourseChangeInDegrees() {
        return this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getDirectionChangeInDegrees();
    }

    @Override
    public Double getCourseChangeInDegreesWithinTurningSectionOfPreviousManeuver() {
        return this.courseChangeInDegreesWithinTurningSectionOfPreviousManeuver;
    }

    @Override
    public Double getCourseChangeInDegreesWithinTurningSectionOfNextManeuver() {
        return this.courseChangeInDegreesWithinTurningSectionOfNextManeuver;
    }

    @Override
    public boolean isMarkPassing() {
        return this.maneuver.isMarkPassing();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingBefore() {
        return this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingBefore();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingAfter() {
        return this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingAfter();
    }

    @Override
    public Duration getLongestIntervalBetweenTwoFixes() {
        return this.longestIntervalBetweenTwoFixes;
    }

    @Override
    public Duration getIntervalBetweenFirstFixOfCurveAndPreviousFix() {
        return this.intervalBetweenFirstFixOfCurveAndPreviousFix;
    }

    @Override
    public Duration getIntervalBetweenLastFixOfCurveAndNextFix() {
        return this.intervalBetweenLastFixOfCurveAndNextFix;
    }

    @Override
    public Duration getDurationFromPreviousManeuverEndToManeuverStart() {
        return this.durationFromPreviousManeuverEndToManeuverStart;
    }

    @Override
    public Duration getDurationFromManeuverEndToNextManeuverStart() {
        return this.durationFromManeuverEndToNextManeuverStart;
    }

    @Override
    public Speed getLowestSpeed() {
        return this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getLowestSpeed();
    }

    @Override
    public Speed getHighestSpeedWithinTurningSection() {
        return this.maneuver.getMainCurveBoundaries().getHighestSpeed();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingBeforeWithinTurningSection() {
        return this.maneuver.getMainCurveBoundaries().getSpeedWithBearingBefore();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingAfterWithinTurningSection() {
        return this.maneuver.getMainCurveBoundaries().getSpeedWithBearingAfter();
    }

    @Override
    public Double getTargetTackAngleInDegrees() {
        return this.targetTackAngleInDegrees;
    }

    @Override
    public Double getTargetJibeAngleInDegrees() {
        return this.targetJibeAngleInDegrees;
    }

    @Override
    public boolean hasMarkPassingData() {
        return this.hasMarkPassingData;
    }

    @Override
    public double getMaxTurningRateInDegreesPerSecond() {
        return this.maneuver.getMainCurveBoundaries().getMaxTurningRateInDegreesPerSecond();
    }

    @Override
    public Bearing getMiddleCourse() {
        return this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getMiddleCourse();
    }

    @Override
    public Position getPosition() {
        return this.maneuverPosition;
    }

    @Override
    public TimePoint getTimePoint() {
        return this.maneuver.getMainCurveBoundaries().getTimePoint();
    }
}

