/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.windestimation.aggregator.hmm.WindCourseRange;

public class IntersectedWindRange
extends WindCourseRange {
    private final double violationRange;

    public IntersectedWindRange(double fromPortside, double angleTowardStarboard, double violationRange) {
        super(fromPortside, angleTowardStarboard);
        this.violationRange = violationRange;
    }

    public double getViolationRange() {
        return this.violationRange;
    }

    public boolean isViolation() {
        return this.violationRange > 0.0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.violationRange);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntersectedWindRange other = (IntersectedWindRange)obj;
        return Double.doubleToLongBits(this.violationRange) == Double.doubleToLongBits(other.violationRange);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString());
        if (this.isViolation()) {
            result.append(" (");
            result.append(this.getViolationRange());
            result.append("\ufffd violation)");
        }
        return result.toString();
    }
}

