/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.windestimation.aggregator.graph.ElementWithQuality;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevelBase;
import com.sap.sailing.windestimation.aggregator.hmm.WindCourseRange;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;

public class GraphNode<GL extends GraphLevelBase<GL>>
implements ElementWithQuality {
    private final GL graphLevel;
    private final WindCourseRange validWindRange;
    private double confidence;
    private final int indexInLevel;
    private final ManeuverTypeForClassification maneuverType;
    private final Tack tackAfter;

    public GraphNode(ManeuverTypeForClassification maneuverType, Tack tackAfter, WindCourseRange validWindRange, double confidence, int indexInLevel, GL graphLevel) {
        this.maneuverType = maneuverType;
        this.tackAfter = tackAfter;
        this.validWindRange = validWindRange;
        this.confidence = confidence;
        this.indexInLevel = indexInLevel;
        this.graphLevel = graphLevel;
    }

    public ManeuverTypeForClassification getManeuverType() {
        return this.maneuverType;
    }

    public WindCourseRange getValidWindRange() {
        return this.validWindRange;
    }

    public GL getGraphLevel() {
        return this.graphLevel;
    }

    public double getConfidence() {
        return this.confidence;
    }

    @Override
    public double getQuality() {
        return this.getConfidence();
    }

    public int getIndexInLevel() {
        return this.indexInLevel;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public Tack getTackAfter() {
        return this.tackAfter;
    }

    public String toString() {
        return (Object)((Object)this.maneuverType) + " onto " + this.tackAfter + " tack, confidence=" + this.confidence + ", estimated " + this.validWindRange;
    }
}

