/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.mongodb.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.RotatingFileBasedLog;
import com.sap.sse.landscape.mongodb.MongoMetrics;
import com.sap.sse.landscape.mongodb.MongoProcess;
import com.sap.sse.landscape.mongodb.impl.MongoEndpointImpl;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MongoProcessImpl
extends MongoEndpointImpl
implements MongoProcess {
    private static final String LOCAL_DB_NAME = "local";
    private static final Logger logger = Logger.getLogger(MongoProcessImpl.class.getName());
    private final int port;
    private final Host host;

    public MongoProcessImpl(Host host) {
        this(host, 27017);
    }

    public MongoProcessImpl(Host host, int port) {
        this.port = port;
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public RotatingFileBasedLog getLog() {
        return null;
    }

    @Override
    public MongoMetrics getMetrics() {
        return null;
    }

    @Override
    public boolean isReady(Optional<Duration> optionalTimeout) {
        try {
            return Util.contains((Iterable)this.getClient().listDatabaseNames(), (Object)LOCAL_DB_NAME);
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Internal error constructing MongoDB client URI", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MongoProcessImpl other = (MongoProcessImpl)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }
}

