/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.VHWSentence;

class VHWParser
extends SentenceParser
implements VHWSentence {
    private static final int TRUE_HEADING = 0;
    private static final int TRUE_INDICATOR = 1;
    private static final int MAGNETIC_HEADING = 2;
    private static final int MAGNETIC_INDICATOR = 3;
    private static final int SPEED_KNOTS = 4;
    private static final int KNOTS_INDICATOR = 5;
    private static final int SPEED_KMH = 6;
    private static final int KMH_INDICATOR = 7;

    public VHWParser(String nmea) {
        super(nmea);
    }

    public VHWParser(TalkerId talker) {
        super(talker, SentenceId.VHW, 8);
        this.setCharValue(1, 'T');
        this.setCharValue(3, 'M');
        this.setCharValue(5, 'N');
        this.setCharValue(7, 'K');
    }

    @Override
    public double getHeading() {
        return this.getDoubleValue(0);
    }

    @Override
    public double getMagneticHeading() {
        return this.getDoubleValue(2);
    }

    @Override
    public double getSpeedKmh() {
        return this.getDoubleValue(6);
    }

    @Override
    public double getSpeedKnots() {
        return this.getDoubleValue(4);
    }

    @Override
    public boolean isTrue() {
        return true;
    }

    @Override
    public void setHeading(double hdg) {
        this.setDegreesValue(0, hdg);
    }

    @Override
    public void setMagneticHeading(double hdg) {
        this.setDegreesValue(2, hdg);
    }

    @Override
    public void setSpeedKmh(double kmh) {
        this.setDoubleValue(6, kmh, 1, 1);
    }

    @Override
    public void setSpeedKnots(double knots) {
        this.setDoubleValue(4, knots, 1, 1);
    }
}

