/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.gwt.ui.shared.CompetitorRaceDataDTO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CompetitorsRaceDataDTO
implements IsSerializable {
    private DetailType detailType;
    private HashMap<CompetitorDTO, CompetitorRaceDataDTO> competitorsData;
    private Date requestedFromTime;
    private Date requestedToTime;

    CompetitorsRaceDataDTO() {
    }

    public CompetitorsRaceDataDTO(DetailType detailType, Date requestedFromTime, Date requestedToTime) {
        this(detailType, requestedFromTime, requestedToTime, new HashMap());
    }

    public CompetitorsRaceDataDTO(DetailType detailType, Date requestedFromTime, Date requestedToTime, Map<CompetitorDTO, CompetitorRaceDataDTO> raceData) {
        this.detailType = detailType;
        this.requestedFromTime = requestedFromTime;
        this.requestedToTime = requestedToTime;
        this.competitorsData = new HashMap<CompetitorDTO, CompetitorRaceDataDTO>(raceData);
    }

    public Set<CompetitorDTO> getCompetitors() {
        return this.competitorsData.keySet();
    }

    public CompetitorRaceDataDTO getCompetitorData(CompetitorDTO competitor) {
        return (CompetitorRaceDataDTO)this.competitorsData.get(competitor);
    }

    public void setCompetitorData(CompetitorDTO competitor, CompetitorRaceDataDTO competitorData) {
        if (competitorData != null && this.detailType == competitorData.getDetailType()) {
            this.competitorsData.put(competitor, competitorData);
        }
    }

    public void setCompetitorMarkPassingsData(CompetitorRaceDataDTO competitorData) {
        if (this.detailType == competitorData.getDetailType() && this.competitorsData.containsKey(competitorData.getCompetitor())) {
            ((CompetitorRaceDataDTO)this.competitorsData.get(competitorData.getCompetitor())).setMarkPassingsData(competitorData.getMarkPassingsData());
        }
    }

    public void addCompetitorRaceData(CompetitorRaceDataDTO competitorDataToAdd) {
        if (this.detailType == competitorDataToAdd.getDetailType() && this.competitorsData.containsKey(competitorDataToAdd.getCompetitor())) {
            ((CompetitorRaceDataDTO)this.competitorsData.get(competitorDataToAdd.getCompetitor())).addAllRaceData((Collection)competitorDataToAdd.getRaceData());
        }
    }

    public Collection<CompetitorRaceDataDTO> getAllRaceData() {
        return this.competitorsData.values();
    }

    public DetailType getDetailType() {
        return this.detailType;
    }

    public Date getDateOfNewestData() {
        Date dateOfNewestData = null;
        for (CompetitorRaceDataDTO competitorRaceData : this.competitorsData.values()) {
            Date raceDateOfNewestData = competitorRaceData.getDateOfNewestData();
            if (dateOfNewestData == null) {
                dateOfNewestData = raceDateOfNewestData;
                continue;
            }
            Date date = dateOfNewestData = dateOfNewestData.after(raceDateOfNewestData) || raceDateOfNewestData == null ? dateOfNewestData : raceDateOfNewestData;
        }
        return dateOfNewestData;
    }

    public Date getOldestDateOfNewestData() {
        Date dateOfNewestData = null;
        for (CompetitorRaceDataDTO competitorRaceData : this.competitorsData.values()) {
            Date raceDateOfNewestData = competitorRaceData.getDateOfNewestData();
            if (dateOfNewestData == null) {
                dateOfNewestData = raceDateOfNewestData;
                continue;
            }
            Date date = dateOfNewestData = dateOfNewestData.before(raceDateOfNewestData) || raceDateOfNewestData == null ? dateOfNewestData : raceDateOfNewestData;
        }
        return dateOfNewestData;
    }

    public boolean isEmpty() {
        for (CompetitorRaceDataDTO competitorRaceData : this.competitorsData.values()) {
            if (competitorRaceData.getRaceData().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(CompetitorWithBoatDTO competitor) {
        return this.competitorsData.containsKey(competitor);
    }

    public Date getRequestedFromTime() {
        return this.requestedFromTime;
    }

    public Date getRequestedToTime() {
        return this.requestedToTime;
    }
}

