/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.shared.CompetitorRaceDataDTO;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CompetitorRaceDataDTO
implements IsSerializable {
    private CompetitorDTO competitor;
    private DetailType detailType;
    private List<Util.Triple<String, Date, Double>> markPassingsData;
    private List<Util.Pair<Date, Double>> raceData;

    CompetitorRaceDataDTO() {
    }

    public CompetitorRaceDataDTO(CompetitorDTO competitor, DetailType detailType, Collection<Util.Triple<String, Date, Double>> markPassingsData, Collection<Util.Pair<Date, Double>> raceData) {
        this.competitor = competitor;
        this.detailType = detailType;
        this.markPassingsData = new ArrayList();
        this.raceData = new ArrayList();
        this.addAllMarkPassingsData(markPassingsData);
        this.addAllRaceData(raceData);
    }

    public CompetitorDTO getCompetitor() {
        return this.competitor;
    }

    public DetailType getDetailType() {
        return this.detailType;
    }

    public Date getDateOfNewestData() {
        return !this.raceData.isEmpty() ? (Date)((Util.Pair)this.raceData.get(this.raceData.size() - 1)).getA() : null;
    }

    public void setMarkPassingsData(List<Util.Triple<String, Date, Double>> markPassingsData) {
        this.markPassingsData = new ArrayList();
        this.addAllMarkPassingsData(markPassingsData);
    }

    public List<Util.Triple<String, Date, Double>> getMarkPassingsData() {
        return Collections.unmodifiableList(this.markPassingsData);
    }

    public void addAllMarkPassingsData(Collection<Util.Triple<String, Date, Double>> markPassingsDataToAdd) {
        for (Util.Triple<String, Date, Double> data : markPassingsDataToAdd) {
            this.addMarkPassingsData(data);
        }
    }

    public void addMarkPassingsData(Util.Triple<String, Date, Double> markPassingsDataToAdd) {
        int index = Collections.binarySearch(this.markPassingsData, markPassingsDataToAdd, new MarkPassingsByTime(this));
        if (index < 0) {
            this.markPassingsData.add(-1 * index - 1, markPassingsDataToAdd);
        }
    }

    public List<Util.Pair<Date, Double>> getRaceData() {
        return Collections.unmodifiableList(this.raceData);
    }

    public void addAllRaceData(Collection<Util.Pair<Date, Double>> raceDataToAdd) {
        for (Util.Pair<Date, Double> data : raceDataToAdd) {
            this.addRaceData(data);
        }
    }

    public void addRaceData(Util.Pair<Date, Double> raceDataToAdd) {
        int index = Collections.binarySearch(this.raceData, raceDataToAdd, new RaceDataByTime(this));
        if (index < 0) {
            this.raceData.add(-1 * index - 1, raceDataToAdd);
        }
    }

    public void addAllData(CompetitorRaceDataDTO dataToAdd) {
        if (this.detailType == dataToAdd.getDetailType()) {
            this.addAllMarkPassingsData((Collection)dataToAdd.getMarkPassingsData());
            this.addAllRaceData((Collection)dataToAdd.getRaceData());
        }
    }

    public List<Util.Pair<Date, Double>> getRaceDataAfterDate(Date after) {
        int from = Collections.binarySearch(this.raceData, new Util.Pair((Object)after, (Object)0.0), new RaceDataByTime(this));
        return Collections.unmodifiableList(this.raceData.subList(from + 1, this.raceData.size()));
    }
}

