/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.shared.CompactBoatPositionsDTO;
import com.sap.sailing.gwt.ui.shared.CompactQuickRankDTO;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegTypeIterable;
import com.sap.sailing.gwt.ui.shared.QuickRankDTO;
import com.sap.sailing.gwt.ui.shared.QuickRanksDTO;
import com.sap.sailing.gwt.ui.shared.RaceMapDataDTO;
import com.sap.sailing.gwt.ui.shared.SidelineDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CompactRaceMapDataDTO
implements IsSerializable {
    private CompactBoatPositionsDTO boatPositionsByCompetitorIdAsString;
    private CoursePositionsDTO coursePositions;
    private List<SidelineDTO> courseSidelines;
    private List<CompactQuickRankDTO> quickRanks;
    private long simulationResultVersion;
    private HashSet<String> raceCompetitorIdsAsStrings;
    private Duration estimatedDuration;

    CompactRaceMapDataDTO() {
    }

    public CompactRaceMapDataDTO(Map<CompetitorDTO, GPSFixDTOWithSpeedWindTackAndLegTypeIterable> boatPositions, CoursePositionsDTO coursePositions, List<SidelineDTO> courseSidelines, QuickRanksDTO quickRanks, long simulationResultVersion, HashSet<String> raceCompetitorIdsAsStrings, Duration estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
        this.boatPositionsByCompetitorIdAsString = new CompactBoatPositionsDTO(boatPositions);
        this.raceCompetitorIdsAsStrings = raceCompetitorIdsAsStrings;
        this.quickRanks = new ArrayList(quickRanks == null ? 0 : Util.size((Iterable)quickRanks.getQuickRanks()));
        HashMap<String, Integer> competitorIdAsStringToOneBasedLegNumber = new HashMap<String, Integer>();
        if (quickRanks != null) {
            for (QuickRankDTO quickRank : quickRanks.getQuickRanks()) {
                this.quickRanks.add(new CompactQuickRankDTO(quickRank.competitor.getIdAsString(), quickRank.oneBasedRank, quickRank.legNumberOneBased));
                competitorIdAsStringToOneBasedLegNumber.put(quickRank.competitor.getIdAsString(), quickRank.legNumberOneBased);
            }
        }
        this.courseSidelines = courseSidelines;
        this.coursePositions = coursePositions;
        this.simulationResultVersion = simulationResultVersion;
    }

    public RaceMapDataDTO getRaceMapDataDTO(Map<String, CompetitorDTO> competitorsByIdAsString) {
        RaceMapDataDTO result = new RaceMapDataDTO();
        result.quickRanks = new LinkedHashMap(this.quickRanks.size());
        for (CompactQuickRankDTO compactQuickRank : this.quickRanks) {
            CompetitorDTO competitorDTO = competitorsByIdAsString.get(compactQuickRank.getCompetitorIdAsString());
            if (competitorDTO == null) continue;
            result.quickRanks.put(compactQuickRank.getCompetitorIdAsString(), new QuickRankDTO(competitorDTO, compactQuickRank.getOneBasedRank(), compactQuickRank.getLegNumber()));
        }
        result.courseSidelines = this.courseSidelines;
        result.coursePositions = this.coursePositions;
        result.boatPositions = this.boatPositionsByCompetitorIdAsString.getBoatPositionsForCompetitors(competitorsByIdAsString);
        result.simulationResultVersion = this.simulationResultVersion;
        result.raceCompetitorIdsAsStrings = this.raceCompetitorIdsAsStrings;
        result.estimatedDuration = this.estimatedDuration;
        return result;
    }
}

