/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.aiagent.interfaces.AIAgent;
import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.orc.BaseORCCertificateAssignmentAnalyzer;
import com.sap.sailing.domain.abstractlog.orc.ORCCertificateAssignmentEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataAnalyzer;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataEventFinder;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCScratchBoatAnalyzer;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCScratchBoatFinder;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCCertificateAssignmentEventImpl;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCImpliedWindSourceEventImpl;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCLegDataEventImpl;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCScratchBoatEventImpl;
import com.sap.sailing.domain.abstractlog.orc.impl.RegattaLogORCCertificateAssignmentEventImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEndOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.RaceLogFixedMarkPassingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartOfTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogSuppressedMarkPassingsEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishedTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishingTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinderResult;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.TrackingTimesEventFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.TrackingTimesFinder;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogCourseDesignChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogEndOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogExcludeWindSourcesEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFixedMarkPassingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogSuppressedMarkPassingsEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogWindFixEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogDenoteForTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogStartTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceBoatMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceMarkMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMappingFinder;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMarkMappingFinder;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogOpenEndedDeviceMappingCloser;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SailingServerConfiguration;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.configuration.impl.DeviceConfigurationImpl;
import com.sap.sailing.domain.base.impl.BoatImpl;
import com.sap.sailing.domain.base.impl.CompetitorImpl;
import com.sap.sailing.domain.base.impl.CompetitorWithBoatImpl;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.base.impl.CourseImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.EventBaseImpl;
import com.sap.sailing.domain.base.impl.PersonImpl;
import com.sap.sailing.domain.base.impl.SailingServerConfigurationImpl;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.MailInvitationType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.NotFoundException;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaFetcher;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.ServiceException;
import com.sap.sailing.domain.common.UnableToCloseDeviceMappingException;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLog;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.PairingListDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceColumnInSeriesDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.dto.RegattaCreationParametersDTO;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.orc.ImpliedWindSource;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveLegImpl;
import com.sap.sailing.domain.common.racelog.tracking.CompetitorRegistrationOnRaceLogDisabledException;
import com.sap.sailing.domain.common.racelog.tracking.DoesNotHaveRegattaLogException;
import com.sap.sailing.domain.common.racelog.tracking.MarkAlreadyUsedInRaceException;
import com.sap.sailing.domain.common.racelog.tracking.NotDenotableForRaceLogTrackingException;
import com.sap.sailing.domain.common.racelog.tracking.NotDenotedForRaceLogTrackingException;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.tagging.RaceLogNotFoundException;
import com.sap.sailing.domain.common.tagging.ServiceNotFoundException;
import com.sap.sailing.domain.common.tagging.TagAlreadyExistsException;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.coursetemplate.CommonMarkProperties;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkRolePair;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotServer;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotStandardCommand;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardGroupImpl;
import com.sap.sailing.domain.leaderboard.meta.LeaderboardGroupMetaLeaderboard;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.racelogtracking.DeviceMapping;
import com.sap.sailing.domain.regattalike.HasRegattaLike;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.regattalike.LeaderboardThatHasRegattaLike;
import com.sap.sailing.domain.resultimport.ResultUrlProvider;
import com.sap.sailing.domain.shared.tracking.Track;
import com.sap.sailing.domain.swisstimingadapter.StartList;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingArchiveConfiguration;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingConfiguration;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.DoubleVectorFixImporter;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackerManager;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.DynamicGPSFixTrackImpl;
import com.sap.sailing.domain.tractracadapter.RaceRecord;
import com.sap.sailing.domain.tractracadapter.TracTracConfiguration;
import com.sap.sailing.domain.tractracadapter.TracTracConnectionConstants;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickConfiguration;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapter;
import com.sap.sailing.expeditionconnector.ExpeditionDeviceConfiguration;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogSetTrackingTimesDTO;
import com.sap.sailing.gwt.ui.client.SailingServiceWrite;
import com.sap.sailing.gwt.ui.client.shared.charts.MarkPositionService;
import com.sap.sailing.gwt.ui.server.LogEventTimeRangeWithFallbackFilter;
import com.sap.sailing.gwt.ui.server.SailingServiceImpl;
import com.sap.sailing.gwt.ui.server.SailingServiceWriteImpl;
import com.sap.sailing.gwt.ui.shared.BulkScoreCorrectionDTO;
import com.sap.sailing.gwt.ui.shared.ControlPointDTO;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.DeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.DeviceMappingDTO;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.GPSFixDTO;
import com.sap.sailing.gwt.ui.shared.IgtimiDataAccessWindowWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.IgtimiDeviceWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.MigrateGroupOwnerForHierarchyDTO;
import com.sap.sailing.gwt.ui.shared.RaceLogSetFinishingAndFinishTimeDTO;
import com.sap.sailing.gwt.ui.shared.RaceLogSetStartTimeAndProcedureDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.RemoteSailingServerReferenceDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sailing.gwt.ui.shared.ServerConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingArchiveConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingRaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.TracTracConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.TracTracRaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.TrackFileImportDeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.TypedDeviceMappingDTO;
import com.sap.sailing.gwt.ui.shared.UrlDTO;
import com.sap.sailing.gwt.ui.shared.VenueDTO;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.YellowBrickConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.YellowBrickRaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.CourseTemplateDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkPropertiesDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkRoleDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkTemplateDTO;
import com.sap.sailing.server.hierarchy.SailingHierarchyOwnershipUpdater;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.AddColumnToLeaderboard;
import com.sap.sailing.server.operationaltransformation.AddColumnToSeries;
import com.sap.sailing.server.operationaltransformation.AddCourseAreas;
import com.sap.sailing.server.operationaltransformation.AddOrReplaceExpeditionDeviceConfiguration;
import com.sap.sailing.server.operationaltransformation.AddRemoteSailingServerReference;
import com.sap.sailing.server.operationaltransformation.AllowBoatResetToDefaults;
import com.sap.sailing.server.operationaltransformation.AllowCompetitorResetToDefaults;
import com.sap.sailing.server.operationaltransformation.ConnectTrackedRaceToLeaderboardColumn;
import com.sap.sailing.server.operationaltransformation.CreateLeaderboardGroup;
import com.sap.sailing.server.operationaltransformation.DisconnectLeaderboardColumnFromTrackedRace;
import com.sap.sailing.server.operationaltransformation.MoveLeaderboardColumnDown;
import com.sap.sailing.server.operationaltransformation.MoveLeaderboardColumnUp;
import com.sap.sailing.server.operationaltransformation.RemoveAndUntrackRace;
import com.sap.sailing.server.operationaltransformation.RemoveColumnFromSeries;
import com.sap.sailing.server.operationaltransformation.RemoveCourseAreas;
import com.sap.sailing.server.operationaltransformation.RemoveLeaderboardColumn;
import com.sap.sailing.server.operationaltransformation.RemoveRegatta;
import com.sap.sailing.server.operationaltransformation.RemoveRemoteSailingServerReference;
import com.sap.sailing.server.operationaltransformation.RemoveSeries;
import com.sap.sailing.server.operationaltransformation.RenameEvent;
import com.sap.sailing.server.operationaltransformation.RenameLeaderboardColumn;
import com.sap.sailing.server.operationaltransformation.SetRaceIsKnownToStartUpwind;
import com.sap.sailing.server.operationaltransformation.SetSuppressedFlagForCompetitorInLeaderboard;
import com.sap.sailing.server.operationaltransformation.StopTrackingRace;
import com.sap.sailing.server.operationaltransformation.UpdateBoat;
import com.sap.sailing.server.operationaltransformation.UpdateCompetitor;
import com.sap.sailing.server.operationaltransformation.UpdateCompetitorDisplayNameInLeaderboard;
import com.sap.sailing.server.operationaltransformation.UpdateEliminatedCompetitorsInLeaderboard;
import com.sap.sailing.server.operationaltransformation.UpdateEvent;
import com.sap.sailing.server.operationaltransformation.UpdateIsMedalRace;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboard;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardCarryValue;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardColumnFactor;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardGroup;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardIncrementalScoreCorrection;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardMaxPointsReason;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardScoreCorrection;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardScoreCorrectionMetadata;
import com.sap.sailing.server.operationaltransformation.UpdateRaceDelayToLive;
import com.sap.sailing.server.operationaltransformation.UpdateSailingServerReference;
import com.sap.sailing.server.operationaltransformation.UpdateSeries;
import com.sap.sailing.server.operationaltransformation.UpdateServerConfiguration;
import com.sap.sailing.server.operationaltransformation.UpdateSpecificRegatta;
import com.sap.sailing.server.security.SailingViewerRole;
import com.sap.sailing.server.util.WaitForTrackedRaceUtil;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sse.ServerInfo;
import com.sap.sse.aicore.Credentials;
import com.sap.sse.aicore.CredentialsParser;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.common.mail.MailException;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.filestorage.FileStorageManagementService;
import com.sap.sse.filestorage.FileStorageService;
import com.sap.sse.filestorage.InvalidPropertiesException;
import com.sap.sse.filestorage.OperationFailedException;
import com.sap.sse.gwt.client.media.AbstractMediaDTO;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.ImageResizingTaskDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import com.sap.sse.gwt.server.filestorage.FileStorageServiceDTOUtils;
import com.sap.sse.gwt.shared.filestorage.FileStorageServiceDTO;
import com.sap.sse.gwt.shared.filestorage.FileStorageServicePropertyErrorsDTO;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.security.Action;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.ui.server.SecurityDTOUtil;
import com.sap.sse.security.ui.shared.SuccessInfo;
import com.sap.sse.shared.util.impl.UUIDHelper;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.ImageConverter;
import com.sap.sse.util.ThreadPoolUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.imageio.metadata.IIOMetadata;
import javax.management.InvalidAttributeValueException;
import org.apache.http.client.ClientProtocolException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.json.simple.parser.ParseException;

public class SailingServiceWriteImpl
extends SailingServiceImpl
implements SailingServiceWrite {
    private static final long serialVersionUID = -992637440342246674L;

    public MarkRoleDTO createMarkRole(MarkRoleDTO markRole) {
        MarkRole existingMarkRole = this.getSharedSailingData().getMarkRoleById(markRole.getUuid());
        if (existingMarkRole != null) {
            throw new IllegalArgumentException("Mark role with ID " + markRole.getUuid() + " already exists");
        }
        MarkRoleDTO result = this.convertToMarkRoleDTO(this.getSharedSailingData().createMarkRole(markRole.getName(), markRole.getShortName()));
        return result;
    }

    public void removeMarkProperties(Collection<UUID> markPropertiesUuids) {
        for (UUID uuid : markPropertiesUuids) {
            this.getSharedSailingData().deleteMarkProperties(this.getSharedSailingData().getMarkPropertiesById(uuid));
        }
    }

    public CourseTemplateDTO createOrUpdateCourseTemplate(CourseTemplateDTO courseTemplate) {
        CourseTemplateDTO result;
        CourseTemplate existingCourseTemplate = this.getSharedSailingData().getCourseTemplateById(courseTemplate.getUuid());
        URL optionalImageURL = null;
        try {
            optionalImageURL = courseTemplate.getOptionalImageUrl().isPresent() ? new URL((String)courseTemplate.getOptionalImageUrl().get()) : null;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Invalid URL: %s", courseTemplate.getOptionalImageUrl().get()));
        }
        if (existingCourseTemplate != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)existingCourseTemplate);
            result = this.convertToCourseTemplateDTO(this.getSharedSailingData().updateCourseTemplate(courseTemplate.getUuid(), courseTemplate.getName(), courseTemplate.getShortName(), optionalImageURL, courseTemplate.getTags(), courseTemplate.getDefaultNumberOfLaps()));
        } else {
            List marks = courseTemplate.getMarkTemplates().stream().map(t -> this.getSharedSailingData().getMarkTemplateById(t.getUuid())).collect(Collectors.toList());
            MarkRolePair.MarkRolePairFactory markPairTemplateFactory = new MarkRolePair.MarkRolePairFactory();
            List waypoints = courseTemplate.getWaypointTemplates().stream().map(wp -> this.convertToWaypointTemplate(wp, markPairTemplateFactory)).collect(Collectors.toList());
            Map<MarkTemplate, MarkRole> defaultMarkRolesForMarkTemplates = courseTemplate.getDefaultMarkRolesForMarkTemplates().entrySet().stream().collect(Collectors.toMap(entry -> this.getSharedSailingData().getMarkTemplateById(((MarkTemplateDTO)entry.getKey()).getUuid()), entry -> this.getSharedSailingData().getMarkRoleById(((MarkRoleDTO)entry.getValue()).getUuid())));
            Map<MarkRole, MarkTemplate> defaultMarkTemplatesForMarkRoles = courseTemplate.getDefaultMarkTemplatesForMarkRoles().entrySet().stream().collect(Collectors.toMap(entry -> this.getSharedSailingData().getMarkRoleById(((MarkRoleDTO)entry.getKey()).getUuid()), entry -> this.getSharedSailingData().getMarkTemplateById(((MarkTemplateDTO)entry.getValue()).getUuid())));
            RepeatablePart optionalRepeatablePart = courseTemplate.getRepeatablePart() != null ? this.convertToRepeatablePart(courseTemplate.getRepeatablePart()) : null;
            result = this.convertToCourseTemplateDTO(this.getSharedSailingData().createCourseTemplate(courseTemplate.getName(), courseTemplate.getShortName(), marks, waypoints, defaultMarkRolesForMarkTemplates, defaultMarkTemplatesForMarkRoles, optionalRepeatablePart, (Iterable)courseTemplate.getTags(), optionalImageURL, courseTemplate.getDefaultNumberOfLaps()));
        }
        return result;
    }

    public void removeCourseTemplates(Collection<UUID> courseTemplateUuids) {
        for (UUID uuid : courseTemplateUuids) {
            this.getSharedSailingData().deleteCourseTemplate(this.getSharedSailingData().getCourseTemplateById(uuid));
        }
    }

    public MarkPropertiesDTO updateMarkPropertiesPositioning(UUID markPropertiesId, DeviceIdentifierDTO deviceIdentifier, Position fixedPosition) throws NoCorrespondingServiceRegisteredException, TransformationException {
        MarkProperties markProperties = this.getSharedSailingData().getMarkPropertiesById(markPropertiesId);
        if (deviceIdentifier != null) {
            this.getSharedSailingData().setTrackingDeviceIdentifierForMarkProperties(markProperties, this.convertDtoToDeviceIdentifier(deviceIdentifier));
        } else if (fixedPosition != null) {
            this.getSharedSailingData().setFixedPositionForMarkProperties(markProperties, fixedPosition);
        } else {
            this.getSharedSailingData().clearPositioningForMarkProperties(markProperties);
        }
        return this.convertToMarkPropertiesDTO(this.getSharedSailingData().updateMarkProperties(markProperties.getId(), (CommonMarkProperties)markProperties, markProperties.getTags()));
    }

    public MarkPropertiesDTO addOrUpdateMarkProperties(MarkPropertiesDTO markProperties) {
        MarkProperties createdOrUpdatedMarkProperties = this.getSharedSailingData().getMarkPropertiesById(markProperties.getUuid());
        if (createdOrUpdatedMarkProperties != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)createdOrUpdatedMarkProperties);
            this.getSharedSailingData().updateMarkProperties(markProperties.getUuid(), this.convertDtoToCommonMarkProperties(markProperties.getCommonMarkProperties()), markProperties.getTags());
            createdOrUpdatedMarkProperties = this.getSharedSailingData().getMarkPropertiesById(createdOrUpdatedMarkProperties.getId());
        } else {
            createdOrUpdatedMarkProperties = (MarkProperties)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.MARK_PROPERTIES, MarkTemplate.getTypeRelativeObjectIdentifier((UUID)UUID.randomUUID()), markProperties.getName(), () -> this.getSharedSailingData().createMarkProperties(this.convertDtoToCommonMarkProperties(markProperties.getCommonMarkProperties()), markProperties.getTags(), Optional.empty()));
        }
        return this.convertToMarkPropertiesDTO(createdOrUpdatedMarkProperties);
    }

    public void trackWithTracTrac(RegattaIdentifier regattaToAddTo, List<TracTracRaceRecordDTO> rrs, String liveURIFromConfiguration, String storedURIFromConfiguration, String updateURI, boolean trackWind, boolean correctWindByDeclination, Duration offsetToStartTimeOfSimulatedRace, boolean useInternalMarkPassingAlgorithm, boolean useOfficialEventsToUpdateRaceLog, String jsonUrlAsKey) throws Exception {
        logger.info("tracWithTracTrac for regatta " + regattaToAddTo + " for race records " + rrs + " with liveURI " + liveURIFromConfiguration + " and storedURI " + storedURIFromConfiguration);
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CREATE_OBJECT);
        TracTracConfiguration config = this.tractracDomainObjectFactory.getTracTracConfiguration(jsonUrlAsKey);
        String tracTracApiToken = config == null ? null : config.getTracTracApiToken();
        for (TracTracRaceRecordDTO rr : rrs) {
            try {
                RaceRecord record = this.getTracTracAdapter().getSingleTracTracRaceRecord(new URL(rr.jsonURL), rr.id, true, tracTracApiToken);
                logger.info("Loaded race " + record.getName() + " in " + record.getEventName() + " start:" + record.getRaceStartTime() + " trackingStart:" + record.getTrackingStartTime() + " trackingEnd:" + record.getTrackingEndTime());
                URI effectiveLiveURI = !record.getRaceStatus().equals(TracTracConnectionConstants.REPLAY_STATUS) ? (liveURIFromConfiguration == null || liveURIFromConfiguration.trim().length() == 0 ? record.getLiveURI() : new URI(liveURIFromConfiguration)) : null;
                URI effectiveStoredURI = storedURIFromConfiguration == null || storedURIFromConfiguration.trim().length() == 0 ? record.getStoredURI() : new URI(storedURIFromConfiguration);
                URI effectiveUpdateURI = updateURI == null || updateURI.trim().length() == 0 ? record.getDefaultUpdateURI() : new URI(updateURI);
                this.getTracTracAdapter().addTracTracRace((TrackerManager)this.getService(), regattaToAddTo, record.getParamURL(), effectiveLiveURI, effectiveStoredURI, effectiveUpdateURI, (TimePoint)new MillisecondsTimePoint(record.getTrackingStartTime().asMillis()), (TimePoint)new MillisecondsTimePoint(record.getTrackingEndTime().asMillis()), this.getRaceLogStore(), this.getRegattaLogStore(), 60000L, offsetToStartTimeOfSimulatedRace, useInternalMarkPassingAlgorithm, tracTracApiToken, record.getRaceStatus(), record.getRaceVisibility(), trackWind, correctWindByDeclination, useOfficialEventsToUpdateRaceLog, liveURIFromConfiguration == null || liveURIFromConfiguration.trim().length() == 0 ? null : new URI(liveURIFromConfiguration), storedURIFromConfiguration == null || storedURIFromConfiguration.trim().length() == 0 ? null : new URI(storedURIFromConfiguration));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error trying to load race " + rrs + ". Continuing with remaining races...", e);
            }
        }
    }

    public void trackWithYellowBrick(RegattaIdentifier regattaToAddTo, List<YellowBrickRaceRecordDTO> rrs, boolean trackWind, boolean correctWindByDeclination, String creatorUsername, String raceUrl) throws Exception {
        logger.info("trackWithYellowBrick for regatta " + regattaToAddTo + " for race records " + rrs);
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CREATE_OBJECT);
        for (YellowBrickRaceRecordDTO rr : rrs) {
            try {
                this.getYellowBrickTrackingAdapter().addYellowBrickRace(this.getService(), regattaToAddTo, rr.getRaceUrl(), this.getRaceLogStore(), this.getRegattaLogStore(), creatorUsername, raceUrl, trackWind, correctWindByDeclination);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error trying to load race " + rrs + ". Continuing with remaining races...", e);
            }
        }
    }

    public void createYellowBrickConfiguration(String name, String yellowBrickRaceUrl, String yellowBrickUsername, String yellowBrickPassword) {
        if (this.existsYellowBrickConfigurationForCurrentUser(yellowBrickRaceUrl)) {
            throw new RuntimeException("A configuration for the current user with this race URL already exists.");
        }
        String currentUserName = this.getSecurityService().getCurrentUser().getName();
        TypeRelativeObjectIdentifier identifier = YellowBrickConfiguration.getTypeRelativeObjectIdentifier((String)yellowBrickRaceUrl, (String)currentUserName);
        YellowBrickTrackingAdapter yellowBrickTrackingAdapter = this.getYellowBrickTrackingAdapter();
        this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.YELLOWBRICK_ACCOUNT, identifier, name, () -> yellowBrickTrackingAdapter.createYellowBrickConfiguration(name, yellowBrickRaceUrl, yellowBrickUsername, yellowBrickPassword, currentUserName));
    }

    public void createTracTracConfiguration(String name, String jsonURL, String liveDataURI, String storedDataURI, String courseDesignUpdateURI, String tracTracApiToken) throws Exception {
        if (this.existsTracTracConfigurationForCurrentUser(jsonURL)) {
            throw new RuntimeException("A configuration for the current user with this json URL already exists.");
        }
        String currentUserName = this.getSecurityService().getCurrentUser().getName();
        TypeRelativeObjectIdentifier identifier = TracTracConfiguration.getTypeRelativeObjectIdentifier((String)jsonURL, (String)currentUserName);
        this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.TRACTRAC_ACCOUNT, identifier, name, () -> this.tractracMongoObjectFactory.createTracTracConfiguration(this.getTracTracAdapter().createTracTracConfiguration(currentUserName, name, jsonURL, liveDataURI, storedDataURI, courseDesignUpdateURI, tracTracApiToken)));
    }

    public void deleteTracTracConfigurations(Collection<TracTracConfigurationWithSecurityDTO> tracTracConfigurations) {
        for (TracTracConfigurationWithSecurityDTO tracTracConfiguration : tracTracConfigurations) {
            this.getSecurityService().checkCurrentUserDeletePermission((WithQualifiedObjectIdentifier)tracTracConfiguration);
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)tracTracConfiguration, () -> this.tractracMongoObjectFactory.deleteTracTracConfiguration(tracTracConfiguration.getCreatorName(), tracTracConfiguration.getJsonUrl()));
        }
    }

    public void updateTracTracConfiguration(TracTracConfigurationWithSecurityDTO tracTracConfiguration) throws Exception {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)tracTracConfiguration);
        this.tractracMongoObjectFactory.updateTracTracConfiguration(this.getTracTracAdapter().createTracTracConfiguration(tracTracConfiguration.getCreatorName(), tracTracConfiguration.getName(), tracTracConfiguration.getJsonUrl(), tracTracConfiguration.getLiveDataURI(), tracTracConfiguration.getStoredDataURI(), tracTracConfiguration.getUpdateURI(), tracTracConfiguration.getTracTracApiToken()), tracTracConfiguration.isTracTracApiTokenAvailable());
    }

    public void stopTrackingRaces(List<RegattaAndRaceIdentifier> regattaAndRaceIdentifiers) throws Exception {
        for (RegattaAndRaceIdentifier regattaAndRaceIdentifier : regattaAndRaceIdentifiers) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regattaAndRaceIdentifier);
            this.getService().apply((OperationWithResult)new StopTrackingRace(regattaAndRaceIdentifier));
        }
    }

    public void removeAndUntrackRaces(List<RegattaAndRaceIdentifier> regattaAndRaceIdentifiers) {
        for (RegattaAndRaceIdentifier regattaAndRaceIdentifier : regattaAndRaceIdentifiers) {
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)regattaAndRaceIdentifier, () -> this.getService().apply((OperationWithResult)new RemoveAndUntrackRace(regattaAndRaceIdentifier)));
        }
    }

    public void setWind(RegattaAndRaceIdentifier raceIdentifier, WindDTO windDTO) {
        DynamicTrackedRace trackedRace = (DynamicTrackedRace)this.getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)trackedRace);
            Position p = null;
            if (windDTO.position != null) {
                p = windDTO.position;
            }
            MillisecondsTimePoint at = null;
            if (windDTO.measureTimepoint != null) {
                at = new MillisecondsTimePoint(windDTO.measureTimepoint.longValue());
            }
            KnotSpeedWithBearingImpl speedWithBearing = null;
            KnotSpeedImpl speed = null;
            if (windDTO.trueWindSpeedInKnots != null) {
                speed = new KnotSpeedImpl(windDTO.trueWindSpeedInKnots.doubleValue());
            } else if (windDTO.trueWindSpeedInMetersPerSecond != null) {
                speed = new KilometersPerHourSpeedImpl(windDTO.trueWindSpeedInMetersPerSecond * 3600.0 / 1000.0);
            } else if (windDTO.dampenedTrueWindSpeedInKnots != null) {
                speed = new KnotSpeedImpl(windDTO.dampenedTrueWindSpeedInKnots.doubleValue());
            } else if (windDTO.dampenedTrueWindSpeedInMetersPerSecond != null) {
                speed = new KilometersPerHourSpeedImpl(windDTO.dampenedTrueWindSpeedInMetersPerSecond * 3600.0 / 1000.0);
            }
            if (speed != null) {
                if (windDTO.trueWindBearingDeg != null) {
                    speedWithBearing = new KnotSpeedWithBearingImpl(speed.getKnots(), (Bearing)new DegreeBearingImpl(windDTO.trueWindBearingDeg.doubleValue()));
                } else if (windDTO.trueWindFromDeg != null) {
                    speedWithBearing = new KnotSpeedWithBearingImpl(speed.getKnots(), new DegreeBearingImpl(windDTO.trueWindFromDeg.doubleValue()).reverse());
                }
            }
            WindImpl wind = new WindImpl(p, (TimePoint)at, speedWithBearing);
            Set webWindSources = trackedRace.getWindSources(WindSourceType.WEB);
            if (Util.size((Iterable)webWindSources) == 0) {
                trackedRace.recordWind((Wind)wind, (WindSource)new WindSourceImpl(WindSourceType.WEB));
            } else {
                trackedRace.recordWind((Wind)wind, (WindSource)webWindSources.iterator().next());
            }
        }
    }

    public void updateRaceCourse(RegattaAndRaceIdentifier raceIdentifier, List<Util.Pair<ControlPointDTO, PassingInstruction>> courseDTO) {
        TrackedRace trackedRace = this.getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)trackedRace);
            Course course = trackedRace.getRace().getCourse();
            ArrayList<Util.Pair> controlPoints = new ArrayList<Util.Pair>();
            for (Util.Pair<ControlPointDTO, PassingInstruction> waypointDTO : courseDTO) {
                controlPoints.add(new Util.Pair((Object)this.getOrCreateControlPoint((ControlPointDTO)waypointDTO.getA()), (Object)((PassingInstruction)waypointDTO.getB())));
            }
            try {
                course.update(controlPoints, course.getAssociatedRoles(), course.getOriginatingCourseTemplateIdOrNull(), this.baseDomainFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void removeSailingServers(Set<String> namesOfSailingServersToRemove) throws Exception {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
        for (String serverName : namesOfSailingServersToRemove) {
            this.getService().apply((OperationWithResult)new RemoveRemoteSailingServerReference(serverName));
        }
    }

    public RemoteSailingServerReferenceDTO addRemoteSailingServerReference(RemoteSailingServerReferenceDTO sailingServer) throws MalformedURLException {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
        String expandedURL = sailingServer.getUrl().contains("//") ? sailingServer.getUrl() : "https://" + sailingServer.getUrl();
        URL serverURL = new URL(expandedURL);
        RemoteSailingServerReference serverRef = (RemoteSailingServerReference)this.getService().apply((OperationWithResult)new AddRemoteSailingServerReference(sailingServer.getName(), serverURL, sailingServer.isInclude()));
        Util.Pair eventsOrException = this.getService().updateRemoteServerEventCacheSynchronously(serverRef, false);
        return this.createRemoteSailingServerReferenceDTO(serverRef, eventsOrException);
    }

    public RemoteSailingServerReferenceDTO updateRemoteSailingServerReference(RemoteSailingServerReferenceDTO sailingServer) throws MalformedURLException {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
        RemoteSailingServerReference serverRef = (RemoteSailingServerReference)this.getService().apply((OperationWithResult)new UpdateSailingServerReference(sailingServer.getName(), sailingServer.isInclude(), sailingServer.getSelectedEvents().stream().map(element -> element).collect(Collectors.toSet())));
        Util.Pair eventsOrException = this.getService().updateRemoteServerEventCacheSynchronously(serverRef, true);
        return this.createRemoteSailingServerReferenceDTO(serverRef, eventsOrException);
    }

    public RemoteSailingServerReferenceDTO getCompleteRemoteServerReference(String sailingServerName) throws MalformedURLException {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
        RemoteSailingServerReference serverRef = this.getService().getRemoteServerReferenceByName(sailingServerName);
        Util.Pair eventsOrException = this.getService().getCompleteRemoteServerReference(serverRef);
        return this.createRemoteSailingServerReferenceDTO(serverRef, eventsOrException);
    }

    public void setRaceIsKnownToStartUpwind(RegattaAndRaceIdentifier raceIdentifier, boolean raceIsKnownToStartUpwind) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)raceIdentifier);
        this.getService().apply((OperationWithResult)new SetRaceIsKnownToStartUpwind(raceIdentifier, raceIsKnownToStartUpwind));
    }

    public void setWindSourcesToExclude(RegattaAndRaceIdentifier raceIdentifier, List<WindSource> windSourcesToExclude) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)raceIdentifier);
        DynamicTrackedRace trackedRace = (DynamicTrackedRace)this.getExistingTrackedRace(raceIdentifier);
        if (trackedRace == null) {
            logger.info("Couldn't set wind sources to exclude for tracked race " + raceIdentifier + " because the race was not found");
        } else {
            Iterable raceLogs = trackedRace.getAttachedRaceLogs();
            if (raceLogs != null && !Util.isEmpty((Iterable)raceLogs)) {
                RaceLog defaultRaceLog = (RaceLog)raceLogs.iterator().next();
                logger.info("Set wind sources to exclude for tracked race " + raceIdentifier + " to " + windSourcesToExclude);
                defaultRaceLog.add((AbstractLogEvent)new RaceLogExcludeWindSourcesEventImpl(TimePoint.now(), this.getService().getServerAuthor(), defaultRaceLog.getCurrentPassId(), windSourcesToExclude));
            } else {
                logger.info("Couldn't set wind sources to exclude for tracked race " + raceIdentifier + " because no race log seems attached");
            }
        }
    }

    public void removeWind(RegattaAndRaceIdentifier raceIdentifier, WindDTO windDTO) {
        DynamicTrackedRace trackedRace = (DynamicTrackedRace)this.getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)trackedRace);
            Position p = null;
            if (windDTO.position != null) {
                p = windDTO.position;
            }
            MillisecondsTimePoint at = null;
            if (windDTO.measureTimepoint != null) {
                at = new MillisecondsTimePoint(windDTO.measureTimepoint.longValue());
            }
            KnotSpeedWithBearingImpl speedWithBearing = null;
            KnotSpeedImpl speed = null;
            if (windDTO.trueWindSpeedInKnots != null) {
                speed = new KnotSpeedImpl(windDTO.trueWindSpeedInKnots.doubleValue());
            } else if (windDTO.trueWindSpeedInMetersPerSecond != null) {
                speed = new KilometersPerHourSpeedImpl(windDTO.trueWindSpeedInMetersPerSecond * 3600.0 / 1000.0);
            } else if (windDTO.dampenedTrueWindSpeedInKnots != null) {
                speed = new KnotSpeedImpl(windDTO.dampenedTrueWindSpeedInKnots.doubleValue());
            } else if (windDTO.dampenedTrueWindSpeedInMetersPerSecond != null) {
                speed = new KilometersPerHourSpeedImpl(windDTO.dampenedTrueWindSpeedInMetersPerSecond * 3600.0 / 1000.0);
            }
            if (speed != null) {
                if (windDTO.trueWindBearingDeg != null) {
                    speedWithBearing = new KnotSpeedWithBearingImpl(speed.getKnots(), (Bearing)new DegreeBearingImpl(windDTO.trueWindBearingDeg.doubleValue()));
                } else if (windDTO.trueWindFromDeg != null) {
                    speedWithBearing = new KnotSpeedWithBearingImpl(speed.getKnots(), new DegreeBearingImpl(windDTO.trueWindFromDeg.doubleValue()).reverse());
                }
            }
            WindImpl wind = new WindImpl(p, (TimePoint)at, speedWithBearing);
            trackedRace.removeWind((Wind)wind, (WindSource)trackedRace.getWindSources(WindSourceType.WEB).iterator().next());
        }
    }

    public void createRegattaStructure(List<RegattaDTO> regattas, EventDTO newEvent) throws MalformedURLException {
        ArrayList<String> leaderboardNames = new ArrayList<String>();
        for (RegattaDTO regatta : regattas) {
            this.createRegattaFromRegattaDTO(regatta);
            this.addRaceColumnsToRegattaSeries(regatta);
            if (this.getLeaderboard(regatta.getName()) != null) continue;
            leaderboardNames.add(regatta.getName());
            this.createRegattaLeaderboard(new RegattaName(regatta.getName()), regatta.boatClass.toString(), new int[0]);
        }
        this.createAndAddLeaderboardGroup(newEvent, leaderboardNames);
    }

    public void createSwissTimingArchiveConfiguration(String jsonURL) throws Exception {
        if (this.existsSwissTimingArchiveConfigurationForCurrentUser(jsonURL)) {
            throw new RuntimeException("A configuration for the current user with this json URL already exists.");
        }
        String currentUserName = this.getSecurityService().getCurrentUser().getName();
        TypeRelativeObjectIdentifier identifier = SwissTimingArchiveConfiguration.getTypeRelativeObjectIdentifier((String)jsonURL, (String)currentUserName);
        this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.SWISS_TIMING_ARCHIVE_ACCOUNT, identifier, identifier.toString(), () -> this.swissTimingAdapterPersistence.createSwissTimingArchiveConfiguration(this.swissTimingFactory.createSwissTimingArchiveConfiguration(jsonURL, currentUserName)));
    }

    public void updateSwissTimingArchiveConfiguration(SwissTimingArchiveConfigurationWithSecurityDTO dto) throws Exception {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)dto);
        this.swissTimingAdapterPersistence.updateSwissTimingArchiveConfiguration(this.swissTimingFactory.createSwissTimingArchiveConfiguration(dto.getJsonUrl(), dto.getCreatorName()));
    }

    public void deleteSwissTimingArchiveConfigurations(Collection<SwissTimingArchiveConfigurationWithSecurityDTO> dtos) throws Exception {
        for (SwissTimingArchiveConfigurationWithSecurityDTO dto : dtos) {
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval(dto.getIdentifier(), () -> this.swissTimingAdapterPersistence.deleteSwissTimingArchiveConfiguration(this.swissTimingFactory.createSwissTimingArchiveConfiguration(dto.getJsonUrl(), dto.getCreatorName())));
        }
    }

    public void removeResultImportURLs(String resultProviderName, Set<UrlDTO> toRemove) throws Exception {
        RacingEventService racingEventService = this.getService();
        Set urlsToRemove = toRemove.stream().map(urlDto -> {
            try {
                return new URL(urlDto.getUrl());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(url -> url != null).collect(Collectors.toSet());
        racingEventService.removeResultImportURLs(resultProviderName, urlsToRemove);
    }

    public void addResultImportUrl(String resultProviderName, UrlDTO urlDTO) throws Exception {
        RacingEventService racingEventService = this.getService();
        ResultUrlProvider resultUrlProvider = (ResultUrlProvider)racingEventService.getUrlBasedScoreCorrectionProvider(resultProviderName).orElseThrow(() -> new IllegalStateException("ResultUrlProvider not found: " + resultProviderName));
        URL url = resultUrlProvider.resolveUrl(urlDTO.getUrl());
        racingEventService.addResultImportUrl(resultProviderName, url);
    }

    public StrippedLeaderboardDTO createFlexibleLeaderboard(String leaderboardName, String leaderboardDisplayName, int[] discardThresholds, ScoringSchemeType scoringSchemeType, List<UUID> courseAreaIds) {
        return (StrippedLeaderboardDTO)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName), leaderboardDisplayName, (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public StrippedLeaderboardDTO createRegattaLeaderboard(RegattaName regattaIdentifier, String leaderboardDisplayName, int[] discardThresholds) {
        return (StrippedLeaderboardDTO)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, Leaderboard.getTypeRelativeObjectIdentifier((RegattaName)regattaIdentifier), leaderboardDisplayName, (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public StrippedLeaderboardDTO createRegattaLeaderboardWithEliminations(String name, String displayName, String fullRegattaLeaderboardName) {
        return (StrippedLeaderboardDTO)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, Leaderboard.getTypeRelativeObjectIdentifier((String)name), displayName, (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public StrippedLeaderboardDTO createRegattaLeaderboardWithOtherTieBreakingLeaderboard(RegattaName regattaIdentifier, String leaderboardDisplayName, int[] discardThresholds, String otherTieBreakingLeaderboardName) {
        return (StrippedLeaderboardDTO)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, Leaderboard.getTypeRelativeObjectIdentifier((RegattaName)regattaIdentifier), leaderboardDisplayName, (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public StrippedLeaderboardDTO updateLeaderboard(String leaderboardName, String newLeaderboardDisplayName, int[] newDiscardingThresholds, List<UUID> newCourseAreaIds) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        Leaderboard updatedLeaderboard = (Leaderboard)this.getService().apply((OperationWithResult)new UpdateLeaderboard(leaderboardName, newLeaderboardDisplayName, newDiscardingThresholds, newCourseAreaIds));
        return this.createStrippedLeaderboardDTO(updatedLeaderboard, false, false);
    }

    public void removeLeaderboards(Collection<String> leaderboardNames) {
        for (String leaderboardName : leaderboardNames) {
            this.removeLeaderboard(leaderboardName);
        }
    }

    public void removeLeaderboard(String leaderboardName) {
        Leaderboard leaderBoard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderBoard != null) {
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)leaderBoard, (Action)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void addColumnToLeaderboard(String columnName, String leaderboardName, boolean medalRace) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new AddColumnToLeaderboard(columnName, leaderboardName, medalRace));
    }

    public void removeLeaderboardGroups(Set<UUID> groupIds) {
        for (UUID groupId : groupIds) {
            this.removeLeaderboardGroup(groupId);
        }
    }

    private void removeLeaderboardGroup(UUID groupId) {
        LeaderboardGroup group = this.getService().getLeaderboardGroupByID(groupId);
        if (group != null) {
            if (group.getOverallLeaderboard() != null) {
                this.removeLeaderboard(group.getOverallLeaderboard().getName());
            }
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)group, (Action)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void addColumnsToLeaderboard(String leaderboardName, List<Util.Pair<String, Boolean>> columnsToAdd) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        for (Util.Pair<String, Boolean> columnToAdd : columnsToAdd) {
            this.getService().apply((OperationWithResult)new AddColumnToLeaderboard((String)columnToAdd.getA(), leaderboardName, ((Boolean)columnToAdd.getB()).booleanValue()));
        }
    }

    public void removeLeaderboardColumn(String leaderboardName, String columnName) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new RemoveLeaderboardColumn(columnName, leaderboardName));
    }

    public void renameLeaderboardColumn(String leaderboardName, String oldColumnName, String newColumnName) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new RenameLeaderboardColumn(leaderboardName, oldColumnName, newColumnName));
    }

    public void updateLeaderboardColumnFactor(String leaderboardName, String columnName, Double newFactor) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new UpdateLeaderboardColumnFactor(leaderboardName, columnName, newFactor));
    }

    public void suppressCompetitorInLeaderboard(String leaderboardName, String competitorIdAsString, boolean suppressed) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new SetSuppressedFlagForCompetitorInLeaderboard(leaderboardName, competitorIdAsString, suppressed));
    }

    public boolean connectTrackedRaceToLeaderboardColumn(String leaderboardName, String raceColumnName, String fleetName, RegattaAndRaceIdentifier raceIdentifier) {
        Subject subject = SecurityUtils.getSubject();
        subject.checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        Object principal = subject.getPrincipal();
        if (principal != null) {
            logger.info(String.format("%s linked race column %s %s (%s) with tracked race %s.", principal.toString(), leaderboardName, raceColumnName, fleetName, raceIdentifier.getRaceName()));
        } else {
            logger.info(String.format("Linked race column %s %s (%s) with tracked race %s.", leaderboardName, raceColumnName, fleetName, raceIdentifier.getRaceName()));
        }
        return (Boolean)this.getService().apply((OperationWithResult)new ConnectTrackedRaceToLeaderboardColumn(leaderboardName, raceColumnName, fleetName, raceIdentifier));
    }

    public void disconnectLeaderboardColumnFromTrackedRace(String leaderboardName, String raceColumnName, String fleetName) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new DisconnectLeaderboardColumnFromTrackedRace(leaderboardName, raceColumnName, fleetName));
    }

    public void updateLeaderboardCarryValue(String leaderboardName, String competitorIdAsString, Double carriedPoints) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new UpdateLeaderboardCarryValue(leaderboardName, competitorIdAsString, carriedPoints));
    }

    public Util.Triple<Double, Double, Boolean> updateLeaderboardMaxPointsReason(String leaderboardName, String competitorIdAsString, String raceColumnName, MaxPointsReason maxPointsReason, Date date) throws NoWindException {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        return (Util.Triple)this.getService().apply((OperationWithResult)new UpdateLeaderboardMaxPointsReason(leaderboardName, raceColumnName, competitorIdAsString, maxPointsReason, (TimePoint)new MillisecondsTimePoint(date)));
    }

    public Util.Triple<Double, Double, Boolean> updateLeaderboardScoreCorrection(String leaderboardName, String competitorIdAsString, String columnName, Double correctedScore, Date date) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        return (Util.Triple)this.getService().apply((OperationWithResult)new UpdateLeaderboardScoreCorrection(leaderboardName, columnName, competitorIdAsString, correctedScore, (TimePoint)new MillisecondsTimePoint(date)));
    }

    public Util.Triple<Double, Double, Boolean> updateLeaderboardIncrementalScoreCorrection(String leaderboardName, String competitorIdAsString, String columnName, Double scoringOffsetInPoints, Date date) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        return (Util.Triple)this.getService().apply((OperationWithResult)new UpdateLeaderboardIncrementalScoreCorrection(leaderboardName, columnName, competitorIdAsString, scoringOffsetInPoints, (TimePoint)new MillisecondsTimePoint(date)));
    }

    public void updateLeaderboardScoreCorrectionMetadata(String leaderboardName, Date timePointOfLastCorrectionValidity, String comment) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new UpdateLeaderboardScoreCorrectionMetadata(leaderboardName, (TimePoint)(timePointOfLastCorrectionValidity == null ? null : new MillisecondsTimePoint(timePointOfLastCorrectionValidity)), comment));
    }

    public void updateLeaderboardScoreCorrectionsAndMaxPointsReasons(BulkScoreCorrectionDTO updates) throws NoWindException {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)updates.getLeaderboardName())));
        Date dateForResults = new Date();
        for (Map.Entry e : updates.getScoreUpdatesForRaceColumnByCompetitorIdAsString().entrySet()) {
            for (Map.Entry raceColumnNameAndCorrectedScore : ((Map)e.getValue()).entrySet()) {
                this.updateLeaderboardScoreCorrection(updates.getLeaderboardName(), (String)e.getKey(), (String)raceColumnNameAndCorrectedScore.getKey(), (Double)raceColumnNameAndCorrectedScore.getValue(), dateForResults);
            }
        }
        for (Map.Entry e : updates.getMaxPointsUpdatesForRaceColumnByCompetitorIdAsString().entrySet()) {
            for (Map.Entry raceColumnNameAndNewMaxPointsReason : ((Map)e.getValue()).entrySet()) {
                this.updateLeaderboardMaxPointsReason(updates.getLeaderboardName(), (String)e.getKey(), (String)raceColumnNameAndNewMaxPointsReason.getKey(), (MaxPointsReason)raceColumnNameAndNewMaxPointsReason.getValue(), dateForResults);
            }
        }
    }

    public void updateCompetitorDisplayNameInLeaderboard(String leaderboardName, String competitorIdAsString, String displayName) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new UpdateCompetitorDisplayNameInLeaderboard(leaderboardName, competitorIdAsString, displayName));
    }

    public void moveLeaderboardColumnUp(String leaderboardName, String columnName) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new MoveLeaderboardColumnUp(leaderboardName, columnName));
    }

    public void moveLeaderboardColumnDown(String leaderboardName, String columnName) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new MoveLeaderboardColumnDown(leaderboardName, columnName));
    }

    public void updateIsMedalRace(String leaderboardName, String columnName, boolean isMedalRace) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        this.getService().apply((OperationWithResult)new UpdateIsMedalRace(leaderboardName, columnName, isMedalRace));
    }

    public void updateRacesDelayToLive(List<RegattaAndRaceIdentifier> regattaAndRaceIdentifiers, long delayToLiveInMs) {
        for (RegattaAndRaceIdentifier regattaAndRaceIdentifier : regattaAndRaceIdentifiers) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regattaAndRaceIdentifier);
            this.getService().apply((OperationWithResult)new UpdateRaceDelayToLive(regattaAndRaceIdentifier, delayToLiveInMs));
        }
    }

    public void createSwissTimingConfiguration(String configName, String jsonURL, String hostname, Integer port, String updateURL, String apiToken) throws Exception {
        if (!jsonURL.equalsIgnoreCase("test")) {
            if (this.existsSwissTimingConfigurationForCurrentUser(jsonURL)) {
                throw new RuntimeException("A Configuration for the current user with this json URL already exists.");
            }
            String currentUserName = this.getSecurityService().getCurrentUser().getName();
            TypeRelativeObjectIdentifier identifier = SwissTimingConfiguration.getTypeRelativeObjectIdentifier((String)jsonURL, (String)currentUserName);
            this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.SWISS_TIMING_ACCOUNT, identifier, configName, () -> this.swissTimingAdapterPersistence.createSwissTimingConfiguration(this.swissTimingFactory.createSwissTimingConfiguration(configName, jsonURL, hostname, port, updateURL, apiToken, currentUserName)));
        }
    }

    public void deleteSwissTimingConfigurations(Collection<SwissTimingConfigurationWithSecurityDTO> configurations) {
        for (SwissTimingConfigurationWithSecurityDTO dto : configurations) {
            this.getSecurityService().checkCurrentUserDeletePermission((WithQualifiedObjectIdentifier)dto);
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)dto, () -> this.swissTimingAdapterPersistence.deleteSwissTimingConfiguration(dto.getCreatorName(), dto.getJsonUrl()));
        }
    }

    public void updateSwissTimingConfiguration(SwissTimingConfigurationWithSecurityDTO configuration) throws Exception {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)configuration);
        this.swissTimingAdapterPersistence.updateSwissTimingConfiguration(this.swissTimingFactory.createSwissTimingConfiguration(configuration.getName(), configuration.getJsonUrl(), configuration.getHostname(), configuration.getPort(), configuration.getUpdateURL(), configuration.getApiToken(), configuration.getCreatorName()), configuration.isApiTokenAvailable());
    }

    public void trackWithSwissTiming(RegattaIdentifier regattaToAddTo, List<SwissTimingRaceRecordDTO> rrs, String hostname, int port, boolean trackWind, boolean correctWindByDeclination, boolean useInternalMarkPassingAlgorithm, String updateURL, String apiToken, String eventName, String manage2SailEventUrl) throws InterruptedException, java.text.ParseException, Exception {
        logger.info("tracWithSwissTiming for regatta " + regattaToAddTo + " for race records " + rrs + " with hostname " + hostname + " and port " + port);
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CREATE_OBJECT);
        HashMap<String, RegattaResults> cachedRegattaEntriesLists = new HashMap<String, RegattaResults>();
        for (SwissTimingRaceRecordDTO rr : rrs) {
            BoatClass boatClass = this.getBaseDomainFactory().getOrCreateBoatClass(rr.boatClass);
            String raceDescription = rr.regattaName != null ? rr.regattaName : "";
            raceDescription = String.valueOf(raceDescription) + (rr.seriesName != null ? "/" + rr.seriesName : "");
            raceDescription = String.valueOf(raceDescription) + (raceDescription.length() > 0 ? "/" + rr.getName() : rr.getName());
            RegattaResults regattaResults = (RegattaResults)cachedRegattaEntriesLists.get(rr.xrrEntriesUrl);
            if (regattaResults == null && rr.xrrEntriesUrl != null && (regattaResults = this.getSwissTimingAdapter().readRegattaEntryListFromXrrUrl(rr.xrrEntriesUrl)) != null) {
                cachedRegattaEntriesLists.put(rr.xrrEntriesUrl, regattaResults);
            }
            StartList startList = null;
            if (regattaResults != null) {
                startList = this.getSwissTimingAdapter().readStartListForRace(rr.raceId, regattaResults);
            }
            this.getSwissTimingAdapter().addSwissTimingRace((TrackerManager)this.getService(), regattaToAddTo, rr.raceId, rr.getName(), raceDescription, boatClass, hostname, port, startList, this.getRaceLogStore(), this.getRegattaLogStore(), 60000L, useInternalMarkPassingAlgorithm, trackWind, correctWindByDeclination, updateURL, apiToken, eventName, manage2SailEventUrl);
        }
    }

    public LeaderboardGroupDTO createLeaderboardGroup(String groupName, String description, String displayName, boolean displayGroupsInReverseOrder, int[] overallLeaderboardDiscardThresholds, ScoringSchemeType overallLeaderboardScoringSchemeType) {
        ArrayList leaderboards = new ArrayList();
        return this.doCreateLeaderboardGroup(groupName, description, displayName, displayGroupsInReverseOrder, overallLeaderboardDiscardThresholds, overallLeaderboardScoringSchemeType, leaderboards);
    }

    private LeaderboardGroupDTO doCreateLeaderboardGroup(String groupName, String description, String displayName, boolean displayGroupsInReverseOrder, int[] overallLeaderboardDiscardThresholds, ScoringSchemeType overallLeaderboardScoringSchemeType, List<String> leaderBoards) {
        LeaderboardGroupDTO result;
        UUID newLeaderboardGroupId = UUID.randomUUID();
        Callable<LeaderboardGroupDTO> createLeaderboardGroup = () -> (LeaderboardGroupDTO)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD_GROUP, LeaderboardGroupImpl.getTypeRelativeObjectIdentifier((UUID)newLeaderboardGroupId), displayName, () -> {
            CreateLeaderboardGroup createLeaderboardGroupOp = new CreateLeaderboardGroup(newLeaderboardGroupId, groupName, description, displayName, displayGroupsInReverseOrder, leaderBoards, overallLeaderboardDiscardThresholds, overallLeaderboardScoringSchemeType);
            return this.convertToLeaderboardGroupDTO((LeaderboardGroup)this.getService().apply((OperationWithResult)createLeaderboardGroupOp), false, false);
        });
        if (overallLeaderboardScoringSchemeType != null) {
            String overallLeaderboardName = LeaderboardGroupMetaLeaderboard.getOverallLeaderboardName((String)groupName);
            result = (LeaderboardGroupDTO)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, new TypeRelativeObjectIdentifier(new String[]{overallLeaderboardName}), overallLeaderboardName, createLeaderboardGroup);
        } else {
            try {
                result = createLeaderboardGroup.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public void updateLeaderboardGroup(UUID leaderboardGroupId, String oldName, String newName, String newDescription, String newDisplayName, List<String> leaderboardNames, int[] overallLeaderboardDiscardThresholds, ScoringSchemeType overallLeaderboardScoringSchemeType) {
        LeaderboardGroup leaderboardGroup = this.getService().getLeaderboardGroupByID(leaderboardGroupId);
        if (leaderboardGroup == null) {
            throw new IllegalArgumentException("Leadearboard group with ID " + leaderboardGroupId + " not found.");
        }
        Action updateLeaderboardGroup = () -> {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD_GROUP.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, LeaderboardGroupImpl.getTypeRelativeObjectIdentifier((UUID)leaderboardGroupId)));
            this.getService().apply((OperationWithResult)new UpdateLeaderboardGroup(leaderboardGroupId, newName, newDescription, newDisplayName, leaderboardNames, overallLeaderboardDiscardThresholds, overallLeaderboardScoringSchemeType));
        };
        if (leaderboardGroup.getOverallLeaderboard() == null && overallLeaderboardScoringSchemeType != null) {
            String overallLeaderboardName = LeaderboardGroupMetaLeaderboard.getOverallLeaderboardName((String)newName);
            this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, new TypeRelativeObjectIdentifier(new String[]{overallLeaderboardName}), overallLeaderboardName, updateLeaderboardGroup);
        } else if (leaderboardGroup.getOverallLeaderboard() != null && overallLeaderboardScoringSchemeType == null) {
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)leaderboardGroup.getOverallLeaderboard(), updateLeaderboardGroup);
        } else {
            if (leaderboardGroup.getOverallLeaderboard() != null) {
                SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, new TypeRelativeObjectIdentifier(new String[]{leaderboardGroup.getOverallLeaderboard().getName()})));
            }
            try {
                updateLeaderboardGroup.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void createAndAddLeaderboardGroup(EventDTO newEvent, List<String> leaderboardNames) throws MalformedURLException {
        LeaderboardGroupDTO leaderboardGroupDTO = null;
        String description = "";
        if (newEvent.getDescription() != null) {
            description = newEvent.getDescription();
        }
        String eventName = newEvent.getName();
        ArrayList<UUID> eventLeaderboardGroupUUIDs = new ArrayList<UUID>();
        LeaderboardGroup leaderboardGroup = this.getService().getLeaderboardGroupByName(eventName);
        if (leaderboardGroup == null) {
            leaderboardGroupDTO = this.doCreateLeaderboardGroup(eventName, description, eventName, false, null, null, leaderboardNames);
            eventLeaderboardGroupUUIDs.add(leaderboardGroupDTO.getId());
        } else {
            this.updateLeaderboardGroup(leaderboardGroup.getId(), eventName, eventName, newEvent.getDescription(), eventName, leaderboardNames, null, null);
            leaderboardGroupDTO = this.getLeaderboardGroupByName(eventName, false);
        }
        for (LeaderboardGroupDTO lg : newEvent.getLeaderboardGroups()) {
            eventLeaderboardGroupUUIDs.add(lg.getId());
        }
        this.updateEvent(newEvent.id, newEvent.getName(), description, newEvent.startDate, newEvent.endDate, newEvent.getVenue(), newEvent.isPublic, eventLeaderboardGroupUUIDs, newEvent.getOfficialWebsiteURL(), newEvent.getBaseURL(), newEvent.getSailorsInfoWebsiteURLs(), newEvent.getImages(), newEvent.getVideos(), newEvent.getWindFinderReviewedSpotsCollectionIds());
    }

    public EventDTO updateEvent(EventDTO eventDTO) throws MalformedURLException, UnauthorizedException {
        UUID eventId = eventDTO.id;
        String eventName = eventDTO.getName();
        String eventDescription = eventDTO.getDescription();
        Date startDate = eventDTO.startDate;
        Date endDate = eventDTO.endDate;
        VenueDTO venue = eventDTO.getVenue();
        boolean isPublic = eventDTO.isPublic;
        List leaderboardGroupIds = eventDTO.getLeaderboardGroupIds();
        String officialWebsiteURLString = eventDTO.getOfficialWebsiteURL();
        String baseURLAsString = eventDTO.getBaseURL();
        Map sailorsInfoWebsiteURLsByLocaleName = eventDTO.getSailorsInfoWebsiteURLs();
        List images = eventDTO.getImages();
        List videos = eventDTO.getVideos();
        List windFinderReviewedSpotCollectionIds = eventDTO.getWindFinderReviewedSpotsCollectionIds();
        return this.updateEvent(eventId, eventName, eventDescription, startDate, endDate, venue, isPublic, leaderboardGroupIds, officialWebsiteURLString, baseURLAsString, sailorsInfoWebsiteURLsByLocaleName, images, videos, windFinderReviewedSpotCollectionIds);
    }

    public EventDTO updateEvent(UUID eventId, String eventName, String eventDescription, Date startDate, Date endDate, VenueDTO venue, boolean isPublic, List<UUID> leaderboardGroupIds, String officialWebsiteURLString, String baseURLAsString, Map<String, String> sailorsInfoWebsiteURLsByLocaleName, List<? extends ImageDTO> images, List<? extends VideoDTO> videos, List<String> windFinderReviewedSpotCollectionIds) throws MalformedURLException, UnauthorizedException {
        MillisecondsTimePoint startTimePoint = startDate != null ? new MillisecondsTimePoint(startDate) : null;
        MillisecondsTimePoint endTimePoint = endDate != null ? new MillisecondsTimePoint(endDate) : null;
        URL officialWebsiteURL = officialWebsiteURLString != null ? new URL(officialWebsiteURLString) : null;
        URL baseURL = baseURLAsString != null ? new URL(baseURLAsString) : null;
        Map sailorsInfoWebsiteURLs = this.convertToLocalesAndUrls(sailorsInfoWebsiteURLsByLocaleName);
        List eventImages = this.convertToImages(images);
        List eventVideos = this.convertToVideos(videos);
        TypeRelativeObjectIdentifier typeRelativeObjectIdentifier = EventBaseImpl.getTypeRelativeObjectIdentifier((UUID)eventId);
        if (!SecurityUtils.getSubject().isPermitted(SecuredDomainType.EVENT.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, typeRelativeObjectIdentifier))) {
            if (SecurityUtils.getSubject().isPermitted(SecuredDomainType.EVENT.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredDomainType.EventActions.UPLOAD_MEDIA, typeRelativeObjectIdentifier))) {
                EventDTO currentEventState = this.getEventById(eventId, false);
                if (!(Util.equalsWithNull((Object)startTimePoint, (Object)TimePoint.of((Date)currentEventState.startDate)) && Util.equalsWithNull((Object)endTimePoint, (Object)TimePoint.of((Date)currentEventState.endDate)) && Util.equalsWithNull((Object)officialWebsiteURLString, (Object)currentEventState.getOfficialWebsiteURL()) && Util.equalsWithNull((Object)baseURLAsString, (Object)currentEventState.getBaseURL()) && Util.equalsWithNull(sailorsInfoWebsiteURLsByLocaleName, (Object)currentEventState.getSailorsInfoWebsiteURLs()) && Util.equalsWithNull((Object)venue.getName(), (Object)currentEventState.getVenue().getName()) && Util.equalsWithNull((Object)eventName, (Object)currentEventState.getName()) && Util.equalsWithNull(windFinderReviewedSpotCollectionIds, (Object)currentEventState.getWindFinderReviewedSpotsCollectionIds()) && Util.equalsWithNull(leaderboardGroupIds, (Object)currentEventState.getLeaderboardGroupIds()) && Util.equalsWithNull((Object)isPublic, (Object)currentEventState.isPublic) && Util.isOnlyAdding(images, (Iterable)currentEventState.getImages(), (a, b) -> a.compareTo((AbstractMediaDTO)b) == 0) && Util.isOnlyAdding(videos, (Iterable)currentEventState.getVideos(), (a, b) -> a.compareTo((AbstractMediaDTO)b) == 0))) {
                    throw new UnauthorizedException("You are not permitted to edit event " + eventId + " other than by adding images and videos");
                }
                HashSet sourceRefsOfImagesAdded = new HashSet();
                Util.addAll((Iterable)Util.map(images, AbstractMediaDTO::getSourceRef), sourceRefsOfImagesAdded);
                Util.removeAll((Iterable)Util.map((Iterable)currentEventState.getImages(), AbstractMediaDTO::getSourceRef), sourceRefsOfImagesAdded);
                HashSet sourceRefsOfVideosAdded = new HashSet();
                Util.addAll((Iterable)Util.map(videos, AbstractMediaDTO::getSourceRef), sourceRefsOfVideosAdded);
                Util.removeAll((Iterable)Util.map((Iterable)currentEventState.getVideos(), AbstractMediaDTO::getSourceRef), sourceRefsOfVideosAdded);
                logger.info("User " + SecurityUtils.getSubject().getPrincipal() + " is adding the following media to event " + currentEventState.getName() + " with ID " + currentEventState.getId() + ": images: " + sourceRefsOfImagesAdded + ", videos: " + sourceRefsOfVideosAdded);
            } else {
                throw new UnauthorizedException("You are not permitted to edit event " + eventId);
            }
        }
        this.getService().apply((OperationWithResult)new UpdateEvent(eventId, eventName, eventDescription, (TimePoint)startTimePoint, (TimePoint)endTimePoint, venue.getName(), isPublic, leaderboardGroupIds, officialWebsiteURL, baseURL, sailorsInfoWebsiteURLs, (Iterable)eventImages, (Iterable)eventVideos, windFinderReviewedSpotCollectionIds));
        return this.getEventById(eventId, false);
    }

    public EventDTO createEvent(String eventName, String eventDescription, Date startDate, Date endDate, String venue, boolean isPublic, List<CourseAreaDTO> courseAreas, String officialWebsiteURLAsString, String baseURLAsString, Map<String, String> sailorsInfoWebsiteURLsByLocaleName, List<ImageDTO> images, List<VideoDTO> videos, List<UUID> leaderboardGroupIds) throws UnauthorizedException {
        UUID eventUuid = UUID.randomUUID();
        return (EventDTO)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.EVENT, EventBaseImpl.getTypeRelativeObjectIdentifier((UUID)eventUuid), eventName, (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void createCourseAreas(UUID eventId, List<CourseAreaDTO> courseAreas) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getService().getEvent((Serializable)eventId));
        this.getService().apply((OperationWithResult)new AddCourseAreas(eventId, (String[])Util.toArray((Iterable)Util.map(courseAreas, NamedDTO::getName), (Object[])new String[courseAreas.size()]), (UUID[])Util.toArray((Iterable)Util.map(courseAreas, CourseAreaDTO::getId), (Object[])new UUID[courseAreas.size()]), (Position[])Util.toArray((Iterable)Util.map(courseAreas, CourseAreaDTO::getCenterPosition), (Object[])new Position[courseAreas.size()]), (Distance[])Util.toArray((Iterable)Util.map(courseAreas, CourseAreaDTO::getRadius), (Object[])new Distance[courseAreas.size()])));
    }

    public void removeCourseAreas(UUID eventId, UUID[] courseAreaIds) {
        this.getSecurityService().checkCurrentUserDeletePermission((WithQualifiedObjectIdentifier)this.getService().getEvent((Serializable)eventId));
        this.getService().apply((OperationWithResult)new RemoveCourseAreas(eventId, courseAreaIds));
    }

    public void removeEvents(Collection<UUID> eventIds) throws UnauthorizedException {
        for (UUID eventId : eventIds) {
            this.removeEvent(eventId);
        }
    }

    public void removeEvent(UUID eventId) throws UnauthorizedException {
        Event event = this.getService().getEvent((Serializable)eventId);
        if (event != null) {
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)event, (Action)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void renameEvent(UUID eventId, String newName) throws UnauthorizedException {
        if (!SecurityUtils.getSubject().isPermitted(SecuredDomainType.EVENT.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, EventBaseImpl.getTypeRelativeObjectIdentifier((UUID)eventId)))) {
            throw new UnauthorizedException("You are not permitted to edit event " + eventId);
        }
        this.getService().apply((OperationWithResult)new RenameEvent(eventId, newName));
    }

    public void removeRegattas(Collection<RegattaIdentifier> selectedRegattas) {
        for (RegattaIdentifier regatta : selectedRegattas) {
            this.removeRegatta(regatta);
        }
    }

    public void removeRegatta(RegattaIdentifier regattaIdentifier) {
        Regatta regatta = this.getService().getRegatta(regattaIdentifier);
        if (regatta != null) {
            HashSet<QualifiedObjectIdentifier> objectsThatWillBeImplicitlyCleanedByRemoveRegatta = new HashSet<QualifiedObjectIdentifier>();
            objectsThatWillBeImplicitlyCleanedByRemoveRegatta.add(regatta.getIdentifier());
            for (RaceDefinition race : regatta.getAllRaces()) {
                TypeRelativeObjectIdentifier typeRelativeObjectIdentifier = RegattaNameAndRaceName.getTypeRelativeObjectIdentifier((String)regatta.getName(), (String)race.getName());
                QualifiedObjectIdentifier identifier = SecuredDomainType.TRACKED_RACE.getQualifiedObjectIdentifier(typeRelativeObjectIdentifier);
                objectsThatWillBeImplicitlyCleanedByRemoveRegatta.add(identifier);
            }
            for (Leaderboard leaderboard : this.getService().getLeaderboards().values()) {
                RegattaLeaderboard regattaLeaderboard;
                if (!(leaderboard instanceof RegattaLeaderboard) || (regattaLeaderboard = (RegattaLeaderboard)leaderboard).getRegatta() != regatta) continue;
                objectsThatWillBeImplicitlyCleanedByRemoveRegatta.add(regattaLeaderboard.getIdentifier());
            }
            for (QualifiedObjectIdentifier toRemovePermissionObjects : objectsThatWillBeImplicitlyCleanedByRemoveRegatta) {
                this.getSecurityService().checkCurrentUserDeletePermission(toRemovePermissionObjects);
            }
            this.getService().apply((OperationWithResult)new RemoveRegatta(regattaIdentifier));
            for (QualifiedObjectIdentifier toRemovePermissionObjects : objectsThatWillBeImplicitlyCleanedByRemoveRegatta) {
                this.getSecurityService().deleteAllDataForRemovedObject(toRemovePermissionObjects);
            }
        }
    }

    public void removeSeries(RegattaIdentifier identifier, String seriesName) {
        Regatta regatta = this.getService().getRegatta(identifier);
        if (regatta != null) {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)regatta));
        }
        this.getService().apply((OperationWithResult)new RemoveSeries(identifier, seriesName));
    }

    public void updateRegatta(RegattaIdentifier regattaName, Date startDate, Date endDate, List<UUID> courseAreaUuids, DeviceConfigurationDTO.RegattaConfigurationDTO configurationDTO, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, String registrationLinkSecret, CompetitorRegistrationType registrationType) {
        Regatta regatta = this.getService().getRegatta(regattaName);
        if (regatta != null) {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)regatta));
        }
        MillisecondsTimePoint startTimePoint = startDate != null ? new MillisecondsTimePoint(startDate) : null;
        MillisecondsTimePoint endTimePoint = endDate != null ? new MillisecondsTimePoint(endDate) : null;
        this.getService().apply((OperationWithResult)new UpdateSpecificRegatta(regattaName, (TimePoint)startTimePoint, (TimePoint)endTimePoint, courseAreaUuids, this.convertToRegattaConfiguration(configurationDTO), buoyZoneRadiusInHullLengths, useStartTimeInference, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, registrationLinkSecret, registrationType));
    }

    public List<RaceColumnInSeriesDTO> addRaceColumnsToSeries(RegattaIdentifier regattaIdentifier, String seriesName, List<Util.Pair<String, Integer>> columnNamesWithInsertIndex) {
        Regatta regatta = this.getService().getRegatta(regattaIdentifier);
        if (regatta != null) {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)regatta));
        }
        ArrayList<RaceColumnInSeriesDTO> result = new ArrayList<RaceColumnInSeriesDTO>();
        for (Util.Pair<String, Integer> columnNameAndInsertIndex : columnNamesWithInsertIndex) {
            RaceColumnInSeries raceColumnInSeries = (RaceColumnInSeries)this.getService().apply((OperationWithResult)new AddColumnToSeries(((Integer)columnNameAndInsertIndex.getB()).intValue(), regattaIdentifier, seriesName, (String)columnNameAndInsertIndex.getA()));
            if (raceColumnInSeries == null) continue;
            result.add(this.convertToRaceColumnInSeriesDTO(raceColumnInSeries));
        }
        return result;
    }

    public void updateSeries(RegattaIdentifier regattaIdentifier, String seriesName, String newSeriesName, boolean isMedal, boolean isFleetsCanRunInParallel, int[] resultDiscardingThresholds, boolean startsWithZeroScore, boolean firstColumnIsNonDiscardableCarryForward, boolean hasSplitFleetContiguousScoring, boolean hasCrossFleetMergedRanking, Integer maximumNumberOfDiscards, boolean oneAlwaysStaysOne, List<FleetDTO> fleets) {
        Regatta regatta = this.getService().getRegatta(regattaIdentifier);
        if (regatta != null) {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)regatta));
        }
        this.getService().apply((OperationWithResult)new UpdateSeries(regattaIdentifier, seriesName, newSeriesName, isMedal, isFleetsCanRunInParallel, resultDiscardingThresholds, startsWithZeroScore, firstColumnIsNonDiscardableCarryForward, hasSplitFleetContiguousScoring, hasCrossFleetMergedRanking, maximumNumberOfDiscards, oneAlwaysStaysOne, fleets));
    }

    public void removeRaceColumnsFromSeries(RegattaIdentifier regattaIdentifier, String seriesName, List<String> columnNames) {
        Regatta regatta = this.getService().getRegatta(regattaIdentifier);
        if (regatta != null) {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)regatta));
        }
        for (String columnName : columnNames) {
            this.getService().apply((OperationWithResult)new RemoveColumnFromSeries(regattaIdentifier, seriesName, columnName));
        }
    }

    public RegattaDTO createRegatta(String regattaName, String boatClassName, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, String registrationLinkSecret, Date startDate, Date endDate, RegattaCreationParametersDTO seriesNamesWithFleetNamesAndFleetOrderingAndMedal, boolean persistent, ScoringSchemeType scoringSchemeType, List<UUID> courseAreaIds, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetrics rankingMetricType) {
        logger.info("User " + SecurityUtils.getSubject().getPrincipal() + " is trying to create regatta " + regattaName);
        return (RegattaDTO)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.REGATTA, Regatta.getTypeRelativeObjectIdentifier((String)regattaName), regattaName, (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createRegattaFromRegattaDTO(RegattaDTO regatta) {
        this.createRegatta(regatta.getName(), regatta.boatClass.getName(), regatta.canBoatsOfCompetitorsChangePerRace, regatta.competitorRegistrationType, regatta.registrationLinkSecret, regatta.startDate, regatta.endDate, new RegattaCreationParametersDTO(this.getSeriesCreationParameters(regatta)), true, regatta.scoringScheme, (List)Util.mapToArrayList((Iterable)regatta.courseAreas, CourseAreaDTO::getId), regatta.buoyZoneRadiusInHullLengths, regatta.useStartTimeInference, regatta.controlTrackingFromStartAndFinishTimes, regatta.autoRestartTrackingUponCompetitorSetChange, regatta.rankingMetricType);
    }

    protected void addRaceColumnsToRegattaSeries(RegattaDTO regatta) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Regatta.getTypeRelativeObjectIdentifier((String)regatta.getName())));
        for (SeriesDTO series : regatta.series) {
            ArrayList<Util.Pair> raceNamesAndInsertIndex = new ArrayList<Util.Pair>();
            int insertIndex = 0;
            for (RaceColumnDTO raceColumnInSeries : series.getRaceColumns()) {
                raceNamesAndInsertIndex.add(new Util.Pair((Object)raceColumnInSeries.getName(), (Object)insertIndex));
                ++insertIndex;
            }
            this.addRaceColumnsToSeries(regatta.getRegattaIdentifier(), series.getName(), raceNamesAndInsertIndex);
        }
    }

    protected RaceColumnInSeriesDTO convertToRaceColumnInSeriesDTO(RaceColumnInSeries raceColumnInSeries) {
        RaceColumnInSeriesDTO raceColumnInSeriesDTO = new RaceColumnInSeriesDTO(raceColumnInSeries.getName(), raceColumnInSeries.getSeries().getName(), raceColumnInSeries.getRegatta().getName(), raceColumnInSeries.isOneAlwaysStaysOne());
        this.fillRaceColumnDTO((RaceColumn)raceColumnInSeries, (RaceColumnDTO)raceColumnInSeriesDTO);
        return raceColumnInSeriesDTO;
    }

    public UUID importMasterData(String urlAsString, UUID[] leaderboardGroupIds, boolean override, boolean compress, boolean exportWind, boolean exportDeviceConfigurations, String targetServerUsername, String targetServerPassword, boolean exportTrackedRacesAndStartTracking) {
        UUID importOperationId = UUID.randomUUID();
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CAN_IMPORT_MASTERDATA);
        String targetServerBearerToken = !Util.hasLength((String)targetServerUsername) || !Util.hasLength((String)targetServerPassword) ? this.getSecurityService().getOrCreateAccessToken(this.getSecurityService().getCurrentUser().getName()) : null;
        10 masterDataImportTask = new /* Unavailable Anonymous Inner Class!! */;
        this.executor.execute(ThreadPoolUtil.INSTANCE.associateWithSubjectIfAny((Runnable)masterDataImportTask));
        return importOperationId;
    }

    public List<CompetitorDTO> addOrUpdateCompetitors(List<CompetitorDTO> competitors) throws URISyntaxException {
        ArrayList<CompetitorDTO> result = new ArrayList<CompetitorDTO>();
        for (CompetitorDTO competitor : competitors) {
            if (competitor.hasBoat()) {
                CompetitorWithBoatDTO competitorWithBoat = this.addOrUpdateCompetitorWithBoat((CompetitorWithBoatDTO)competitor);
                SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)competitorWithBoat);
                result.add((CompetitorDTO)competitorWithBoat);
                continue;
            }
            CompetitorDTO competitorWithoutBoat = this.addOrUpdateCompetitorWithoutBoat(competitor);
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)competitorWithoutBoat);
            result.add(competitorWithoutBoat);
        }
        return result;
    }

    private CompetitorWithBoat addOrUpdateCompetitorWithBoatInternal(CompetitorWithBoatDTO competitor) throws URISyntaxException {
        CompetitorWithBoat result;
        Nationality nationality;
        CompetitorWithBoat existingCompetitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorWithBoatByIdAsString(competitor.getIdAsString());
        Nationality nationality2 = nationality = competitor.getThreeLetterIocCountryCode() == null || competitor.getThreeLetterIocCountryCode().isEmpty() ? null : this.getBaseDomainFactory().getOrCreateNationality(competitor.getThreeLetterIocCountryCode());
        if (competitor.getIdAsString() == null || competitor.getIdAsString().isEmpty() || existingCompetitor == null) {
            UUID competitorUUID = UUID.randomUUID();
            PersonImpl sailor = new PersonImpl(competitor.getName(), nationality, null, null);
            TeamImpl team = new TeamImpl(String.valueOf(competitor.getName()) + " team", Collections.singleton(sailor), null);
            DynamicBoat boat = (DynamicBoat)this.addOrUpdateBoatInternal(competitor.getBoat());
            result = (CompetitorWithBoat)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.COMPETITOR, CompetitorImpl.getTypeRelativeObjectIdentifier((Serializable)competitorUUID), competitor.getName(), () -> this.lambda$33(competitorUUID, competitor, (DynamicTeam)team, boat));
        } else {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.COMPETITOR.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, CompetitorImpl.getTypeRelativeObjectIdentifier((Serializable)competitor.getId())));
            Competitor updatedCompetitor = (Competitor)this.getService().apply((OperationWithResult)new UpdateCompetitor(competitor.getIdAsString(), competitor.getName(), competitor.getShortName(), competitor.getColor(), competitor.getEmail(), nationality, competitor.getImageURL() == null ? null : new URI(competitor.getImageURL()), competitor.getFlagImageURL() == null ? null : new URI(competitor.getFlagImageURL()), competitor.getTimeOnTimeFactor(), competitor.getTimeOnDistanceAllowancePerNauticalMile(), competitor.getSearchTag()));
            DynamicBoat updatedBoat = (DynamicBoat)this.addOrUpdateBoatInternal(competitor.getBoat());
            result = new CompetitorWithBoatImpl(updatedCompetitor, updatedBoat);
        }
        return result;
    }

    private Competitor addOrUpdateCompetitorWithoutBoatInternal(CompetitorDTO competitor) throws URISyntaxException {
        Competitor result;
        Nationality nationality;
        DynamicCompetitor existingCompetitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitor.getIdAsString());
        Nationality nationality2 = nationality = competitor.getThreeLetterIocCountryCode() == null || competitor.getThreeLetterIocCountryCode().isEmpty() ? null : this.getBaseDomainFactory().getOrCreateNationality(competitor.getThreeLetterIocCountryCode());
        if (competitor.getIdAsString() == null || competitor.getIdAsString().isEmpty() || existingCompetitor == null) {
            UUID competitorUUID = UUID.randomUUID();
            PersonImpl sailor = new PersonImpl(competitor.getName(), nationality, null, null);
            TeamImpl team = new TeamImpl(String.valueOf(competitor.getName()) + " team", Collections.singleton(sailor), null);
            result = (Competitor)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.COMPETITOR, CompetitorImpl.getTypeRelativeObjectIdentifier((Serializable)competitorUUID), competitor.getName(), () -> this.lambda$34(competitorUUID, competitor, (DynamicTeam)team));
        } else {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.COMPETITOR.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, CompetitorImpl.getTypeRelativeObjectIdentifier((Serializable)competitor.getId())));
            result = (Competitor)this.getService().apply((OperationWithResult)new UpdateCompetitor(competitor.getIdAsString(), competitor.getName(), competitor.getShortName(), competitor.getColor(), competitor.getEmail(), nationality, competitor.getImageURL() == null ? null : new URI(competitor.getImageURL()), competitor.getFlagImageURL() == null ? null : new URI(competitor.getFlagImageURL()), competitor.getTimeOnTimeFactor(), competitor.getTimeOnDistanceAllowancePerNauticalMile(), competitor.getSearchTag()));
        }
        return result;
    }

    public CompetitorDTO addOrUpdateCompetitorWithoutBoat(CompetitorDTO competitorDTO) throws URISyntaxException {
        Competitor competitor = this.addOrUpdateCompetitorWithoutBoatInternal(competitorDTO);
        return this.convertToCompetitorDTO(competitor);
    }

    public CompetitorWithBoatDTO addOrUpdateCompetitorWithBoat(CompetitorWithBoatDTO competitorDTO) throws URISyntaxException {
        CompetitorWithBoat competitor = this.addOrUpdateCompetitorWithBoatInternal(competitorDTO);
        return this.convertToCompetitorWithBoatDTO(competitor);
    }

    public List<CompetitorWithBoatDTO> addCompetitors(List<CompetitorDescriptor> competitorDescriptors, String searchTag) throws URISyntaxException {
        ArrayList competitorsForSaving = new ArrayList();
        for (CompetitorDescriptor competitorDescriptor : competitorDescriptors) {
            Action action = () -> {
                boolean bl = competitorsForSaving.add(this.getService().convertCompetitorDescriptorToCompetitorWithBoat(competitorDescriptor, searchTag));
            };
            DynamicBoat existingBoat = this.getService().getCompetitorAndBoatStore().getExistingBoatById(competitorDescriptor.getBoatId());
            Action actionIncludingBoatSecurityCheck = existingBoat == null ? () -> this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.BOAT, BoatImpl.getTypeRelativeObjectIdentifier((Serializable)competitorDescriptor.getBoatId()), competitorDescriptor.getBoatName(), action) : action;
            Competitor existingCompetitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorById(competitorDescriptor.getCompetitorId());
            Action actionIncludingCompetitorAndBoatSecurityCheck = existingCompetitor == null ? () -> this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.COMPETITOR, CompetitorImpl.getTypeRelativeObjectIdentifier((Serializable)competitorDescriptor.getCompetitorId()), competitorDescriptor.getName(), actionIncludingBoatSecurityCheck) : actionIncludingBoatSecurityCheck;
            try {
                actionIncludingCompetitorAndBoatSecurityCheck.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.getBaseDomainFactory().getCompetitorAndBoatStore().addNewCompetitorsWithBoat(competitorsForSaving);
        return this.convertToCompetitorWithBoatDTOs(competitorsForSaving);
    }

    public void allowCompetitorResetToDefaults(List<CompetitorDTO> competitors) {
        ArrayList<String> competitorIdsAsStrings = new ArrayList<String>();
        for (CompetitorDTO competitor : competitors) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)competitor);
            competitorIdsAsStrings.add(competitor.getIdAsString());
        }
        this.getService().apply((OperationWithResult)new AllowCompetitorResetToDefaults(competitorIdsAsStrings));
    }

    public BoatDTO addOrUpdateBoat(BoatDTO boat) {
        return this.convertToBoatDTO(this.addOrUpdateBoatInternal(boat));
    }

    private Boat addOrUpdateBoatInternal(BoatDTO boat) {
        Boat result;
        DynamicBoat existingBoat = this.getService().getCompetitorAndBoatStore().getExistingBoatByIdAsString(boat.getIdAsString());
        if (boat.getIdAsString() == null || boat.getIdAsString().isEmpty() || existingBoat == null) {
            UUID boatUUID = UUID.randomUUID();
            BoatClass boatClass = this.getBaseDomainFactory().getOrCreateBoatClass(boat.getBoatClass().getName());
            result = (Boat)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.BOAT, BoatImpl.getTypeRelativeObjectIdentifier((Serializable)boatUUID), boat.getName(), () -> this.getBaseDomainFactory().getOrCreateBoat((Serializable)boatUUID, boat.getName(), boatClass, boat.getSailId(), boat.getColor(), true));
        } else {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.BOAT.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, BoatImpl.getTypeRelativeObjectIdentifier((Serializable)boat.getId())));
            result = (Boat)this.getService().apply((OperationWithResult)new UpdateBoat(boat.getIdAsString(), boat.getName(), boat.getColor(), boat.getSailId()));
        }
        return result;
    }

    public void allowBoatResetToDefaults(List<BoatDTO> boats) {
        ArrayList<String> boatIdsAsStrings = new ArrayList<String>();
        for (BoatDTO boat : boats) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)boat);
            boatIdsAsStrings.add(boat.getIdAsString());
        }
        this.getService().apply((OperationWithResult)new AllowBoatResetToDefaults(boatIdsAsStrings));
    }

    public DataImportProgress getImportOperationProgress(UUID id) {
        return this.getService().getDataImportLock().getProgress(id);
    }

    public boolean removeDeviceConfiguration(UUID deviceConfigurationId) {
        DeviceConfiguration configuration = this.getService().getDeviceConfigurationById(deviceConfigurationId);
        this.getSecurityService().checkCurrentUserDeletePermission((WithQualifiedObjectIdentifier)configuration);
        this.getService().removeDeviceConfiguration(deviceConfigurationId);
        return true;
    }

    public void setTrackingTimes(RaceLogSetTrackingTimesDTO dto) throws NotFoundException {
        Util.Pair trackingTimesEvents;
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(dto.leaderboardName));
        RaceLog raceLog = this.getRaceLog(dto.leaderboardName, dto.raceColumnName, dto.fleetName);
        LogEventAuthorImpl author = new LogEventAuthorImpl(dto.authorName, dto.authorPriority.intValue());
        if (!Util.equalsWithNull((Object)dto.newStartOfTracking, (Object)dto.currentStartOfTracking)) {
            if (dto.newStartOfTracking != null) {
                raceLog.add((AbstractLogEvent)new RaceLogStartOfTrackingEventImpl(dto.newStartOfTracking.getTimePoint(), (AbstractLogEventAuthor)author, raceLog.getCurrentPassId()));
            } else {
                trackingTimesEvents = (Util.Pair)new TrackingTimesEventFinder(raceLog).analyze();
                if (trackingTimesEvents == null || trackingTimesEvents.getA() == null || !Util.equalsWithNull((Object)((RaceLogStartOfTrackingEvent)trackingTimesEvents.getA()).getLogicalTimePoint(), dto.currentStartOfTracking == null ? null : dto.currentStartOfTracking.getTimePoint())) {
                    throw new NotFoundException("Old start of tracking time in the race log (" + (trackingTimesEvents == null || trackingTimesEvents.getA() == null ? "unset" : ((RaceLogStartOfTrackingEvent)trackingTimesEvents.getA()).getLogicalTimePoint()) + ") does not match start of tracking time at transaction start (" + dto.currentStartOfTracking == null ? null : dto.currentStartOfTracking.getTimePoint() + ")");
                }
                try {
                    raceLog.revokeEvent((AbstractLogEventAuthor)author, (AbstractLogEvent)((RaceLogEvent)trackingTimesEvents.getA()), "resetting tracking start time");
                }
                catch (NotRevokableException e) {
                    logger.log(Level.WARNING, "Internal error: event " + trackingTimesEvents.getA() + " was expected to be revokable", e);
                }
            }
        }
        if (!Util.equalsWithNull((Object)dto.newEndOfTracking, (Object)dto.currentEndOfTracking)) {
            if (dto.newEndOfTracking != null) {
                raceLog.add((AbstractLogEvent)new RaceLogEndOfTrackingEventImpl(dto.newEndOfTracking.getTimePoint(), (AbstractLogEventAuthor)author, raceLog.getCurrentPassId()));
            } else {
                trackingTimesEvents = (Util.Pair)new TrackingTimesEventFinder(raceLog).analyze();
                if (trackingTimesEvents == null || trackingTimesEvents.getB() == null || !Util.equalsWithNull((Object)((RaceLogEndOfTrackingEvent)trackingTimesEvents.getB()).getLogicalTimePoint(), dto.currentEndOfTracking == null ? null : dto.currentEndOfTracking.getTimePoint())) {
                    throw new NotFoundException("Old end of tracking time in the race log (" + (trackingTimesEvents == null || trackingTimesEvents.getB() == null ? "unset" : ((RaceLogEndOfTrackingEvent)trackingTimesEvents.getB()).getLogicalTimePoint()) + ") does not match end of tracking time at transaction start (" + dto.currentEndOfTracking == null ? null : dto.currentEndOfTracking.getTimePoint() + ")");
                }
                try {
                    raceLog.revokeEvent((AbstractLogEventAuthor)author, (AbstractLogEvent)((RaceLogEvent)trackingTimesEvents.getB()), "resetting tracking end time");
                }
                catch (NotRevokableException e) {
                    logger.log(Level.WARNING, "Internal error: event " + trackingTimesEvents.getB() + " was expected to be revokable", e);
                }
            }
        }
    }

    public IgtimiDataAccessWindowWithSecurityDTO addIgtimiDataAccessWindow(String deviceSerialNumber, Date from, Date to) {
        DataAccessWindow result = (DataAccessWindow)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.IGTIMI_DATA_ACCESS_WINDOW, new TypeRelativeObjectIdentifier(new String[]{deviceSerialNumber, "" + from.getTime(), "" + to.getTime()}), "Data Access Window for device " + deviceSerialNumber + " from " + from + " to " + to, () -> this.getRiotServer().createDataAccessWindow(deviceSerialNumber, TimePoint.of((Date)from), TimePoint.of((Date)to)));
        IgtimiDataAccessWindowWithSecurityDTO resultWithSecurity = new IgtimiDataAccessWindowWithSecurityDTO(result.getId(), result.getDeviceSerialNumber(), result.getStartTime().asDate(), result.getEndTime().asDate());
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)resultWithSecurity);
        return resultWithSecurity;
    }

    public void removeIgtimiDataAccessWindow(long id) {
        RiotServer riotServer = this.getRiotServer();
        DataAccessWindow daw = riotServer.getDataAccessWindowById(id);
        if (daw != null) {
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)daw, () -> this.getRiotServer().removeDataAccessWindow(id));
        }
    }

    public void updateIgtimiDevice(IgtimiDeviceWithSecurityDTO editedObject) {
        RiotServer riotServer = this.getRiotServer();
        Device existingDevice = riotServer.getDeviceBySerialNumber(editedObject.getSerialNumber());
        if (existingDevice != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)existingDevice);
            riotServer.updateDeviceName(existingDevice.getId(), editedObject.getName());
        }
    }

    public void removeIgtimiDevice(String serialNumber) {
        RiotServer riotServer = this.getRiotServer();
        Device existingDevice = riotServer.getDeviceBySerialNumber(serialNumber);
        if (existingDevice != null) {
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)existingDevice, () -> riotServer.removeDevice(existingDevice.getId()));
        }
    }

    private void checkCurrentUserUpdatePermissionForIgtimiDevice(String serialNumber) {
        Device existingDevice = this.getIgtimiDevice(serialNumber);
        if (existingDevice != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)existingDevice);
        }
    }

    private Device getIgtimiDevice(String serialNumber) {
        RiotServer riotServer = this.getRiotServer();
        Device existingDevice = riotServer.getDeviceBySerialNumber(serialNumber);
        return existingDevice;
    }

    private void checkCurrentUserReadPermissionForIgtimiDevice(String serialNumber) {
        Device existingDevice = this.getIgtimiDevice(serialNumber);
        if (existingDevice != null) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)existingDevice);
        }
    }

    public boolean sendGPSOffCommandToIgtimiDevice(String serialNumber) throws IOException {
        this.checkCurrentUserUpdatePermissionForIgtimiDevice(serialNumber);
        return this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_GPS_OFF);
    }

    public boolean sendGPSOnCommandToIgtimiDevice(String serialNumber) throws IOException {
        this.checkCurrentUserUpdatePermissionForIgtimiDevice(serialNumber);
        return this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_GPS_ON);
    }

    public boolean sendPowerOffCommandToIgtimiDevice(String serialNumber) throws IOException {
        this.checkCurrentUserUpdatePermissionForIgtimiDevice(serialNumber);
        return this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_POWER_OFF);
    }

    public boolean sendRestartCommandToIgtimiDevice(String serialNumber) throws IOException {
        this.checkCurrentUserUpdatePermissionForIgtimiDevice(serialNumber);
        return this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_RESTART);
    }

    public boolean sendIMUCalibrationCommandSequenceToIgtimiDevice(String serialNumber) throws IOException, InterruptedException {
        this.checkCurrentUserUpdatePermissionForIgtimiDevice(serialNumber);
        boolean result = true;
        result = this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_IMU_STOP) && result;
        Thread.sleep(1000L);
        result = this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_IMU_GYROCAL_PERFORM) && result;
        Thread.sleep(1000L);
        result = this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_IMU_CAL_FROM_FILE) && result;
        Thread.sleep(1000L);
        result = this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_IMU_GYROCAL_PERFORM) && result;
        Thread.sleep(1000L);
        result = this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_IMU_SAVE) && result;
        Thread.sleep(1000L);
        result = this.getRiotServer().sendStandardCommand(serialNumber, RiotStandardCommand.CMD_IMU_ON) && result;
        return result;
    }

    public boolean sendIgtimiCommand(String serialNumber, String command) throws IOException, InterruptedException {
        this.checkCurrentUserUpdatePermissionForIgtimiDevice(serialNumber);
        return this.getRiotServer().sendFreestyleCommand(serialNumber, command);
    }

    public boolean enableIgtimiDeviceOverTheAirLog(String deviceSerialNumber, boolean enable) throws Exception {
        this.checkCurrentUserUpdatePermissionForIgtimiDevice(deviceSerialNumber);
        return this.getRiotServer().enableOverTheAirLog(deviceSerialNumber, enable);
    }

    public ArrayList<Util.Pair<TimePoint, String>> getIgtimiDeviceLogs(String serialNumber, Duration duration) throws IOException, ParseException {
        this.checkCurrentUserReadPermissionForIgtimiDevice(serialNumber);
        return Util.mapToArrayList((Iterable)this.getRiotServer().getDeviceLogs(serialNumber, duration), s -> s);
    }

    public Map<RegattaAndRaceIdentifier, Integer> importWindFromIgtimi(List<RaceDTO> selectedRaces, boolean correctByDeclination, String optionalBearerTokenOrNull) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        ArrayList<DynamicTrackedRace> trackedRaces = new ArrayList<DynamicTrackedRace>();
        if (selectedRaces != null && !selectedRaces.isEmpty()) {
            for (RaceDTO raceDTO : selectedRaces) {
                DynamicTrackedRace trackedRace = this.getTrackedRace(raceDTO.getRaceIdentifier());
                if (trackedRace == null) continue;
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)trackedRace);
                trackedRaces.add(trackedRace);
            }
        } else {
            for (DynamicTrackedRace race : this.getAllTrackedRaces()) {
                if (!this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)race)) continue;
                trackedRaces.add(race);
            }
        }
        HashMap<RegattaAndRaceIdentifier, Integer> numberOfWindFixesImportedPerRace = new HashMap<RegattaAndRaceIdentifier, Integer>();
        IgtimiConnection conn = this.createIgtimiConnection(Optional.ofNullable(optionalBearerTokenOrNull));
        Map resultsForAccounts = conn.importWindIntoRace(trackedRaces, correctByDeclination);
        for (Map.Entry entry : resultsForAccounts.entrySet()) {
            RegattaAndRaceIdentifier key = ((TrackedRace)entry.getKey()).getRaceIdentifier();
            Integer i = (Integer)numberOfWindFixesImportedPerRace.get(key);
            if (i == null) {
                i = 0;
            }
            numberOfWindFixesImportedPerRace.put(key, i + (Integer)entry.getValue());
        }
        for (TrackedRace trackedRace : trackedRaces) {
            this.getService().getPolarDataService().insertExistingFixes(trackedRace);
        }
        return numberOfWindFixesImportedPerRace;
    }

    public Boolean denoteForRaceLogTracking(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException, NotDenotableForRaceLogTrackingException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        return this.getRaceLogTrackingAdapter().denoteRaceForRaceLogTracking(this.getService(), leaderboard, raceColumn, fleet, null);
    }

    public void removeDenotationForRaceLogTracking(String leaderboardName, String raceColumnName, String fleetName) throws Exception {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        TrackedRace trackedRace = raceColumn.getTrackedRace(raceColumn.getFleetByName(fleetName));
        if (trackedRace != null) {
            this.getSecurityService().checkCurrentUserDeletePermission((WithQualifiedObjectIdentifier)trackedRace);
            this.removeAndUntrackRaces(Arrays.asList(trackedRace.getRaceIdentifier()));
        }
        this.getRaceLogTrackingAdapter().removeDenotationForRaceLogTracking(this.getService(), raceLog);
    }

    public void denoteForRaceLogTracking(String leaderboardName, String prefix) throws Exception {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        this.getRaceLogTrackingAdapter().denoteAllRacesForRaceLogTracking(this.getService(), leaderboard, prefix);
    }

    public void setCompetitorRegistrationsInRaceLog(String leaderboardName, String raceColumnName, String fleetName, Map<? extends CompetitorDTO, BoatDTO> competitorAndBoatDTOs) throws CompetitorRegistrationOnRaceLogDisabledException, NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        HashMap<Competitor, Boat> competitorToBoatMappingsToRegister = new HashMap<Competitor, Boat>();
        for (Map.Entry<? extends CompetitorDTO, BoatDTO> competitorAndBoatEntry : competitorAndBoatDTOs.entrySet()) {
            competitorToBoatMappingsToRegister.put(this.getCompetitor(competitorAndBoatEntry.getKey()), this.getBoat(competitorAndBoatEntry.getValue()));
        }
        Iterable competitorRegistrationsToRemove = this.filterCompetitorDuplicates(competitorToBoatMappingsToRegister, raceColumn.getCompetitorsRegisteredInRacelog(fleet));
        raceColumn.deregisterCompetitors(competitorRegistrationsToRemove, fleet);
        for (Map.Entry competitorAndBoatToRegister : competitorToBoatMappingsToRegister.entrySet()) {
            raceColumn.registerCompetitor((Competitor)competitorAndBoatToRegister.getKey(), (Boat)competitorAndBoatToRegister.getValue(), fleet);
        }
    }

    public void setCompetitorRegistrationsInRaceLog(String leaderboardName, String raceColumnName, String fleetName, Set<CompetitorWithBoatDTO> competitorDTOs) throws CompetitorRegistrationOnRaceLogDisabledException, NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        HashMap<CompetitorWithBoat, Boat> competitorsToRegister = new HashMap<CompetitorWithBoat, Boat>();
        for (CompetitorWithBoatDTO dto : competitorDTOs) {
            competitorsToRegister.put(this.getCompetitor(dto), this.getBoat(dto.getBoat()));
        }
        HashMap<CompetitorWithBoat, Boat> competitorsRegisteredInRaceLog = new HashMap<CompetitorWithBoat, Boat>();
        for (Map.Entry e : raceColumn.getCompetitorsRegisteredInRacelog(fleet).entrySet()) {
            competitorsRegisteredInRaceLog.put((CompetitorWithBoat)e.getKey(), (Boat)e.getValue());
        }
        Iterable competitorSetToRemove = this.filterCompetitorDuplicates(competitorsToRegister, competitorsRegisteredInRaceLog);
        raceColumn.deregisterCompetitors(competitorSetToRemove, fleet);
        for (CompetitorWithBoat competitorToRegister : competitorsToRegister.keySet()) {
            if (competitorToRegister.hasBoat()) {
                raceColumn.registerCompetitor(competitorToRegister, fleet);
                continue;
            }
            logger.warning("The competitor " + competitorToRegister.getName() + " does not have a boat associated but should have; " + "competitor is not registered for race log of race " + raceColumnName + " in leaderboard " + leaderboardName + " for fleet " + fleetName);
        }
    }

    public void setCompetitorRegistrationsInRegattaLog(String leaderboardName, Set<? extends CompetitorDTO> competitorDTOs) throws DoesNotHaveRegattaLogException, NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        if (!(leaderboard instanceof HasRegattaLike)) {
            throw new DoesNotHaveRegattaLogException();
        }
        HashMap competitorsToRegister = new HashMap();
        for (CompetitorDTO competitorDTO : competitorDTOs) {
            competitorsToRegister.put(this.getCompetitor(competitorDTO), null);
        }
        HasRegattaLike hasRegattaLike = (HasRegattaLike)leaderboard;
        HashMap<Competitor, Object> competitorsAlreadyRegistered = new HashMap<Competitor, Object>();
        for (Competitor c : leaderboard.getAllCompetitors()) {
            competitorsAlreadyRegistered.put(c, null);
        }
        Iterable competitorSetToRemove = this.filterCompetitorDuplicates(competitorsToRegister, competitorsAlreadyRegistered);
        hasRegattaLike.deregisterCompetitors(competitorSetToRemove);
        hasRegattaLike.registerCompetitors(competitorsToRegister.keySet());
    }

    private <CompetitorType extends Competitor> Iterable<CompetitorType> filterCompetitorDuplicates(Map<CompetitorType, Boat> competitorToBoatMappingsToRegister, Map<CompetitorType, Boat> competitorToBoatMappingsRegistered) {
        HashSet competitorsToUnregister = new HashSet();
        Util.addAll(competitorToBoatMappingsRegistered.keySet(), competitorsToUnregister);
        for (Map.Entry<CompetitorType, Boat> e : competitorToBoatMappingsRegistered.entrySet()) {
            Boat boatOfRegisteredCompetitor;
            Boat boatOfCompetitorToRegister;
            Competitor competitor = (Competitor)e.getKey();
            if (!competitorToBoatMappingsToRegister.containsKey(competitor) || (boatOfCompetitorToRegister = competitorToBoatMappingsToRegister.get(competitor)) != (boatOfRegisteredCompetitor = e.getValue())) continue;
            competitorToBoatMappingsToRegister.remove(competitor);
            competitorsToUnregister.remove(competitor);
        }
        return competitorsToUnregister;
    }

    private HashSet<Boat> filterBoatDuplicates(Set<Boat> boatsToRegister, HashSet<Boat> boatSetToRemove) {
        Iterator<Boat> iterator = boatSetToRemove.iterator();
        while (iterator.hasNext()) {
            Boat boat = iterator.next();
            if (!boatsToRegister.remove(boat)) continue;
            iterator.remove();
        }
        return boatSetToRemove;
    }

    public void setBoatRegistrationsInRegattaLog(String leaderboardName, Set<BoatDTO> boatDTOs) throws DoesNotHaveRegattaLogException, NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        if (!(leaderboard instanceof HasRegattaLike)) {
            throw new DoesNotHaveRegattaLogException();
        }
        HashSet<Boat> boatsToRegister = new HashSet<Boat>();
        for (BoatDTO dto : boatDTOs) {
            Boat boat = this.getBoat(dto);
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)boat);
            boatsToRegister.add(boat);
        }
        HasRegattaLike hasRegattaLike = (HasRegattaLike)leaderboard;
        Iterable boatsToRemove = leaderboard.getAllBoats();
        HashSet boatSetToRemove = new HashSet();
        Util.addAll((Iterable)boatsToRemove, boatSetToRemove);
        this.filterBoatDuplicates(boatsToRegister, boatSetToRemove);
        hasRegattaLike.deregisterBoats(boatSetToRemove);
        hasRegattaLike.registerBoats(boatsToRegister);
    }

    public void fillRaceLogsFromPairingListTemplate(String leaderboardName, int flightMultiplier, List<String> selectedFlightNames, PairingListDTO pairingListDTO) throws NotFoundException, CompetitorRegistrationOnRaceLogDisabledException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        int flightCount = 0;
        int groupCount = 0;
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            groupCount = 0;
            for (Fleet fleet : raceColumn.getFleets()) {
                raceColumn.enableCompetitorRegistrationOnRaceLog(fleet);
                if (Util.contains(selectedFlightNames, (Object)raceColumn.getName())) {
                    HashMap<CompetitorDTO, BoatDTO> competitors = new HashMap<CompetitorDTO, BoatDTO>();
                    List competitorsFromPairingList = (List)((List)pairingListDTO.getPairingList().get(flightCount)).get(groupCount);
                    for (Util.Pair competitorAndBoatPair : competitorsFromPairingList) {
                        if (competitorAndBoatPair.getA() == null || ((CompetitorDTO)competitorAndBoatPair.getA()).getName() == null) continue;
                        competitors.put((CompetitorDTO)competitorAndBoatPair.getA(), (BoatDTO)competitorAndBoatPair.getB());
                    }
                    this.setCompetitorRegistrationsInRaceLog(leaderboard.getName(), raceColumn.getName(), fleet.getName(), competitors);
                    ++groupCount;
                    continue;
                }
                this.setCompetitorRegistrationsInRaceLog(leaderboard.getName(), raceColumn.getName(), fleet.getName(), new HashSet());
            }
            ++flightCount;
        }
        if (leaderboard instanceof LeaderboardThatHasRegattaLike && flightMultiplier > 1) {
            IsRegattaLike regattaLike = ((LeaderboardThatHasRegattaLike)leaderboard).getRegattaLike();
            logger.info("Updating regatta " + regattaLike.getRegattaLikeIdentifier().getName() + ", setting flag that fleets can run in parallel because a pairing list with flight multiplier " + flightMultiplier + " has been used.");
            regattaLike.setFleetsCanRunInParallelToTrue();
        }
    }

    public void addMarkToRegattaLog(String leaderboardName, MarkDTO markDTO) throws DoesNotHaveRegattaLogException {
        Mark mark = this.convertToMark(markDTO, false);
        this.getService().addMarkToRegattaLog(leaderboardName, mark);
    }

    public void revokeMarkDefinitionEventInRegattaLog(String leaderboardName, String raceColumnName, String fleetName, MarkDTO markDTO) throws DoesNotHaveRegattaLogException, MarkAlreadyUsedInRaceException {
        this.getService().revokeMarkDefinitionEventInRegattaLog(leaderboardName, raceColumnName, fleetName, markDTO.getIdAsString());
    }

    public void addCourseDefinitionToRaceLog(String leaderboardName, String raceColumnName, String fleetName, List<Util.Pair<ControlPointDTO, PassingInstruction>> courseDTO, int priority) throws NotFoundException {
        CourseBase lastPublishedCourse;
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        String courseName = "Course of " + raceColumnName;
        if (!"Default".equals(fleetName)) {
            courseName = String.valueOf(courseName) + " - " + fleetName;
        }
        if ((lastPublishedCourse = (CourseBase)new LastPublishedCourseDesignFinder(raceLog, false).analyze()) == null) {
            lastPublishedCourse = new CourseDataImpl(courseName);
        }
        ArrayList<Util.Pair> controlPoints = new ArrayList<Util.Pair>();
        for (Util.Pair<ControlPointDTO, PassingInstruction> waypointDTO : courseDTO) {
            controlPoints.add(new Util.Pair((Object)this.getOrCreateControlPoint((ControlPointDTO)waypointDTO.getA()), (Object)((PassingInstruction)waypointDTO.getB())));
        }
        CourseImpl course = new CourseImpl(courseName, lastPublishedCourse.getWaypoints());
        try {
            course.update(controlPoints, lastPublishedCourse.getAssociatedRoles(), lastPublishedCourse.getOriginatingCourseTemplateIdOrNull(), this.baseDomainFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        RaceLogCourseDesignChangedEventImpl event = new RaceLogCourseDesignChangedEventImpl(MillisecondsTimePoint.now(), (AbstractLogEventAuthor)new LogEventAuthorImpl(this.getService().getServerAuthor().getName(), priority), raceLog.getCurrentPassId(), (CourseBase)course, CourseDesignerMode.ADMIN_CONSOLE);
        raceLog.add((AbstractLogEvent)event);
    }

    public void pingMark(String leaderboardName, MarkDTO markDTO, TimePoint timePoint, Position positionDTO) throws DoesNotHaveRegattaLogException, NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        Mark mark = this.convertToMark(markDTO, true);
        TimePoint time = timePoint == null ? MillisecondsTimePoint.now() : timePoint;
        Position position = positionDTO;
        GPSFixImpl fix = new GPSFixImpl(position, time);
        this.getRaceLogTrackingAdapter().pingMark(regattaLog, mark, (GPSFix)fix, this.getService());
    }

    public void copyCourseToOtherRaceLogs(Util.Triple<String, String, String> fromTriple, Set<Util.Triple<String, String, String>> toTriples, boolean copyMarkDeviceMappings, int priority) throws NotFoundException {
        LeaderboardThatHasRegattaLike fromLeaderboard = (LeaderboardThatHasRegattaLike)this.getLeaderboardByName((String)fromTriple.getA());
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)fromLeaderboard);
        LeaderboardThatHasRegattaLike toLeaderboard = null;
        for (Util.Triple<String, String, String> toTriple : toTriples) {
            toLeaderboard = (LeaderboardThatHasRegattaLike)this.getLeaderboardByName((String)toTriple.getA());
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)toLeaderboard);
        }
        RaceLog fromRaceLog = this.getRaceLog(fromTriple);
        HashSet<RaceLog> toRaceLogs = new HashSet<RaceLog>();
        for (Util.Triple<String, String, String> toTriple : toTriples) {
            toRaceLogs.add(this.getRaceLog(toTriple));
        }
        this.getRaceLogTrackingAdapter().copyCourse(fromRaceLog, fromLeaderboard, toRaceLogs, toLeaderboard, copyMarkDeviceMappings, (SharedDomainFactory)this.baseDomainFactory, this.getService(), priority);
    }

    public void copyCompetitorsToOtherRaceLogs(Util.Triple<String, String, String> fromTriple, Set<Util.Triple<String, String, String>> toTriples) throws NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName((String)fromTriple.getA()));
        for (Util.Triple<String, String, String> toTriple : toTriples) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName((String)toTriple.getA()));
        }
        RaceColumn raceColumn = this.getRaceColumn((String)fromTriple.getA(), (String)fromTriple.getB());
        HashSet<Util.Pair> toRaces = new HashSet<Util.Pair>();
        for (Util.Triple<String, String, String> toTriple : toTriples) {
            RaceColumn toRaceColumn = this.getRaceColumn((String)toTriple.getA(), (String)toTriple.getB());
            Fleet toFleet = this.getFleetByName(toRaceColumn, (String)toTriple.getC());
            toRaces.add(new Util.Pair((Object)toRaceColumn, (Object)toFleet));
        }
        this.getRaceLogTrackingAdapter().copyCompetitors(raceColumn, this.getFleetByName(raceColumn, (String)fromTriple.getC()), toRaces);
    }

    public void addDeviceMappingToRegattaLog(String leaderboardName, DeviceMappingDTO dto) throws NoCorrespondingServiceRegisteredException, TransformationException, DoesNotHaveRegattaLogException {
        TimePoint to;
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)this.getService().getRegattaByName(leaderboardName)));
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        DeviceMapping mapping = this.convertToDeviceMapping(dto);
        TimePoint now = MillisecondsTimePoint.now();
        Object event = null;
        TimePoint from = mapping.getTimeRange().hasOpenBeginning() ? null : mapping.getTimeRange().from();
        TimePoint timePoint = to = mapping.getTimeRange().hasOpenEnd() ? null : mapping.getTimeRange().to();
        if (mapping.getMappedTo() instanceof Mark) {
            Mark mark = (Mark)mapping.getMappedTo();
            event = new RegattaLogDeviceMarkMappingEventImpl(now, now, this.getService().getServerAuthor(), (Serializable)UUID.randomUUID(), mark, mapping.getDevice(), from, to);
        } else if (mapping.getMappedTo() instanceof Competitor) {
            Competitor competitor = (Competitor)mapping.getMappedTo();
            event = mapping.getDevice().getIdentifierType().equals("EXPEDITION_SENSOR") ? new RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl(now, now, this.getService().getServerAuthor(), (Serializable)UUID.randomUUID(), competitor, mapping.getDevice(), from, to) : new RegattaLogDeviceCompetitorMappingEventImpl(now, now, this.getService().getServerAuthor(), (Serializable)UUID.randomUUID(), competitor, mapping.getDevice(), from, to);
        } else if (mapping.getMappedTo() instanceof Boat) {
            Boat boat = (Boat)mapping.getMappedTo();
            event = new RegattaLogDeviceBoatMappingEventImpl(now, now, this.getService().getServerAuthor(), (Serializable)UUID.randomUUID(), boat, mapping.getDevice(), from, to);
        } else {
            throw new RuntimeException("Can only map devices to competitors, boats or marks");
        }
        regattaLog.add((AbstractLogEvent)event);
    }

    public void addTypedDeviceMappingToRegattaLog(String leaderboardName, TypedDeviceMappingDTO dto) throws NoCorrespondingServiceRegisteredException, TransformationException, DoesNotHaveRegattaLogException, NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        DeviceMapping mapping = this.convertToDeviceMapping((DeviceMappingDTO)dto);
        TimePoint now = MillisecondsTimePoint.now();
        RegattaLogDeviceCompetitorSensorDataMappingEvent event = null;
        TimePoint from = mapping.getTimeRange().hasOpenBeginning() ? null : mapping.getTimeRange().from();
        TimePoint to = mapping.getTimeRange().hasOpenEnd() ? null : mapping.getTimeRange().to();
        DoubleVectorFixImporter importer = this.getRegisteredImporter(DoubleVectorFixImporter.class, dto.dataType);
        if (dto.mappedTo instanceof CompetitorWithBoatDTO) {
            event = importer.createEvent(now, now, this.getService().getServerAuthor(), (Serializable)UUID.randomUUID(), (Competitor)this.getCompetitor((CompetitorWithBoatDTO)dto.mappedTo), mapping.getDevice(), from, to);
        } else if (dto.mappedTo instanceof BoatDTO) {
            event = importer.createEvent(now, now, this.getService().getServerAuthor(), (Serializable)UUID.randomUUID(), this.getBoat((BoatDTO)dto.mappedTo), mapping.getDevice(), from, to);
        } else {
            throw new RuntimeException("Can only map devices to a competitor or boat");
        }
        regattaLog.add((AbstractLogEvent)event);
    }

    private void closeOpenEndedDeviceMapping(RegattaLog regattaLog, DeviceMappingDTO mappingDTO, Date closingTimePoint) throws TransformationException, UnableToCloseDeviceMappingException {
        boolean successfullyClosed = false;
        List closingEvents = null;
        regattaLog.lockForRead();
        try {
            RegattaLogEvent event = (RegattaLogEvent)regattaLog.getEventById((Serializable)mappingDTO.originalRaceLogEventIds.get(0));
            if (event != null) {
                successfullyClosed = true;
                DeviceMapping mapping = this.convertToDeviceMapping(mappingDTO);
                closingEvents = (List)new RegattaLogOpenEndedDeviceMappingCloser(regattaLog, mapping, this.getService().getServerAuthor(), (TimePoint)new MillisecondsTimePoint(closingTimePoint)).analyze();
            }
        }
        finally {
            regattaLog.unlockAfterRead();
        }
        if (successfullyClosed) {
            for (RegattaLogEvent closingEvent : closingEvents) {
                regattaLog.add((AbstractLogEvent)closingEvent);
            }
        } else {
            throw new UnableToCloseDeviceMappingException();
        }
    }

    public void revokeRaceAndRegattaLogEvents(String leaderboardName, List<UUID> eventIds) throws NotRevokableException, DoesNotHaveRegattaLogException, NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        List logs = this.getLogHierarchy(leaderboardName);
        this.revokeEventsFromLogs(logs, eventIds);
    }

    private void revokeEventsFromLogs(List<AbstractLog<?, ?>> logs, List<UUID> eventIds) throws NotRevokableException {
        boolean eventRevoked = false;
        for (Serializable serializable : eventIds) {
            eventRevoked = false;
            for (AbstractLog<?, ?> abstractLog : logs) {
                eventRevoked = this.revokeEvent(eventRevoked, serializable, abstractLog);
            }
            if (eventRevoked) continue;
            logger.warning("Could not revoke event with id " + serializable);
        }
    }

    private <EventT extends AbstractLogEvent<VisitorT>, VisitorT> boolean revokeEvent(boolean eventRevoked, Serializable idToRevoke, AbstractLog<EventT, VisitorT> abstractLog) throws NotRevokableException {
        AbstractLogEvent event;
        abstractLog.lockForRead();
        try {
            event = abstractLog.getEventById(idToRevoke);
        }
        finally {
            abstractLog.unlockAfterRead();
        }
        if (event != null) {
            abstractLog.revokeEvent(this.getService().getServerAuthor(), event, "revoke triggered by GWT user action");
            eventRevoked = true;
        }
        return eventRevoked;
    }

    private void startRaceLogTracking(String leaderboardName, String raceColumnName, String fleetName, boolean trackWind, boolean correctWindByDeclination) throws NotDenotedForRaceLogTrackingException, Exception {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        this.getRaceLogTrackingAdapter().startTracking(this.getService(), leaderboard, raceColumn, fleet, trackWind, correctWindByDeclination, this.getService().getPermissionAwareRaceTrackingHandler());
    }

    public void startRaceLogTracking(List<Util.Triple<String, String, String>> leaderboardRaceColumnFleetNames, boolean trackWind, boolean correctWindByDeclination) throws NotDenotedForRaceLogTrackingException, Exception {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CREATE_OBJECT);
        for (Util.Triple<String, String, String> leaderboardRaceColumnFleetName : leaderboardRaceColumnFleetNames) {
            this.startRaceLogTracking((String)leaderboardRaceColumnFleetName.getA(), (String)leaderboardRaceColumnFleetName.getB(), (String)leaderboardRaceColumnFleetName.getC(), trackWind, correctWindByDeclination);
        }
    }

    public RaceDTO setStartTimeReceivedForRace(RaceIdentifier raceIdentifier, Date newStartTimeReceived) {
        RegattaNameAndRaceName regattaAndRaceIdentifier = new RegattaNameAndRaceName(raceIdentifier.getRegattaName(), raceIdentifier.getRaceName());
        DynamicTrackedRace trackedRace = this.getService().getTrackedRace((RegattaAndRaceIdentifier)regattaAndRaceIdentifier);
        if (trackedRace != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)trackedRace);
            trackedRace.setStartTimeReceived((TimePoint)(newStartTimeReceived == null ? null : new MillisecondsTimePoint(newStartTimeReceived)));
        }
        return trackedRace == null ? null : this.baseDomainFactory.createRaceDTO((TrackedRegattaRegistry)this.getService(), false, (RegattaAndRaceIdentifier)regattaAndRaceIdentifier, (TrackedRace)trackedRace);
    }

    public void closeOpenEndedDeviceMapping(String leaderboardName, DeviceMappingDTO mappingDTO, Date closingTimePoint) throws TransformationException, DoesNotHaveRegattaLogException, UnableToCloseDeviceMappingException, NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        this.closeOpenEndedDeviceMapping(regattaLog, mappingDTO, closingTimePoint);
    }

    public void updateFixedMarkPassing(String leaderboardName, String raceColumnName, String fleetName, Integer indexOfWaypoint, Date dateOfMarkPassing, CompetitorDTO competitorDTO) throws NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceLog raceLog = this.getService().getRaceLog(leaderboardName, raceColumnName, fleetName);
        Competitor competitor = this.getCompetitor(competitorDTO);
        RaceLogFixedMarkPassingEvent oldFixedMarkPassingEvent = null;
        raceLog.lockForRead();
        try {
            for (RaceLogEvent event : raceLog.getUnrevokedEvents()) {
                RaceLogFixedMarkPassingEvent fixedEvent;
                if (!(event instanceof RaceLogFixedMarkPassingEventImpl) || !event.getInvolvedCompetitors().contains(competitor) || !Util.equalsWithNull((Object)(fixedEvent = (RaceLogFixedMarkPassingEvent)event).getZeroBasedIndexOfPassedWaypoint(), (Object)indexOfWaypoint)) continue;
                oldFixedMarkPassingEvent = fixedEvent;
            }
        }
        finally {
            raceLog.unlockAfterRead();
        }
        if (oldFixedMarkPassingEvent != null) {
            try {
                raceLog.revokeEvent(this.getService().getServerAuthor(), oldFixedMarkPassingEvent);
            }
            catch (NotRevokableException e) {
                e.printStackTrace();
            }
        }
        if (dateOfMarkPassing != null) {
            raceLog.add((AbstractLogEvent)new RaceLogFixedMarkPassingEventImpl(MillisecondsTimePoint.now(), this.getService().getServerAuthor(), competitor, raceLog.getCurrentPassId(), (TimePoint)new MillisecondsTimePoint(dateOfMarkPassing), indexOfWaypoint));
        }
    }

    public void updateSuppressedMarkPassings(String leaderboardName, String raceColumnName, String fleetName, Integer newZeroBasedIndexOfSuppressedMarkPassing, CompetitorDTO competitorDTO) throws NotFoundException {
        boolean revoke;
        boolean create;
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RaceLogSuppressedMarkPassingsEvent oldSuppressedMarkPassingEvent = null;
        RaceLog raceLog = this.getService().getRaceLog(leaderboardName, raceColumnName, fleetName);
        Competitor competitor = this.getCompetitor(competitorDTO);
        raceLog.lockForRead();
        try {
            NavigableSet unrevokedEvents = raceLog.getUnrevokedEvents();
            for (RaceLogEvent event : unrevokedEvents) {
                if (!(event instanceof RaceLogSuppressedMarkPassingsEvent) || !event.getInvolvedCompetitors().contains(competitor)) continue;
                oldSuppressedMarkPassingEvent = (RaceLogSuppressedMarkPassingsEvent)event;
                break;
            }
        }
        finally {
            raceLog.unlockAfterRead();
        }
        if (oldSuppressedMarkPassingEvent == null) {
            if (newZeroBasedIndexOfSuppressedMarkPassing == null) {
                create = false;
                revoke = false;
            } else {
                create = true;
                revoke = false;
            }
        } else if (newZeroBasedIndexOfSuppressedMarkPassing == null) {
            revoke = true;
            create = false;
        } else {
            boolean equal = Util.equalsWithNull((Object)newZeroBasedIndexOfSuppressedMarkPassing, (Object)oldSuppressedMarkPassingEvent.getZeroBasedIndexOfFirstSuppressedWaypoint());
            create = !equal;
            boolean bl = revoke = !equal;
        }
        if (revoke) {
            try {
                raceLog.revokeEvent(this.getService().getServerAuthor(), (AbstractLogEvent)oldSuppressedMarkPassingEvent);
            }
            catch (NotRevokableException e) {
                logger.log(Level.SEVERE, "Unable to revoke event " + oldSuppressedMarkPassingEvent, e);
            }
        }
        if (create) {
            raceLog.add((AbstractLogEvent)new RaceLogSuppressedMarkPassingsEventImpl(MillisecondsTimePoint.now(), this.getService().getServerAuthor(), competitor, raceLog.getCurrentPassId(), newZeroBasedIndexOfSuppressedMarkPassing));
        }
    }

    private FileStorageService getFileStorageService(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        return this.getService().getFileStorageManagementService().getFileStorageService(name);
    }

    public FileStorageServiceDTO[] getAvailableFileStorageServices(String localeInfoName) {
        ArrayList<FileStorageServiceDTO> serviceDtos = new ArrayList<FileStorageServiceDTO>();
        FileStorageManagementService fileStorageManagementService = this.getService().getFileStorageManagementService();
        if (fileStorageManagementService != null) {
            FileStorageService[] fileStorageServiceArray = fileStorageManagementService.getAvailableFileStorageServices();
            int n = fileStorageServiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileStorageService s = fileStorageServiceArray[n2];
                serviceDtos.add(FileStorageServiceDTOUtils.convert((FileStorageService)s, (Locale)this.getLocale(localeInfoName)));
                ++n2;
            }
        }
        return serviceDtos.toArray(new FileStorageServiceDTO[0]);
    }

    public void setFileStorageServiceProperties(String serviceName, Map<String, String> properties) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getServerInfo());
        for (Map.Entry<String, String> p : properties.entrySet()) {
            try {
                this.getService().getFileStorageManagementService().setFileStorageServiceProperty(this.getFileStorageService(serviceName), p.getKey(), p.getValue());
            }
            catch (NoCorrespondingServiceRegisteredException | IllegalArgumentException throwable) {
                // empty catch block
            }
        }
    }

    public FileStorageServicePropertyErrorsDTO testFileStorageServiceProperties(String serviceName, String localeInfoName) throws IOException {
        try {
            FileStorageService service;
            if (serviceName == null) {
                serviceName = this.getActiveFileStorageServiceName();
            }
            if ((service = this.getFileStorageService(serviceName)) != null) {
                service.testProperties();
            }
        }
        catch (InvalidPropertiesException e) {
            return FileStorageServiceDTOUtils.convert((InvalidPropertiesException)e, (Locale)this.getLocale(localeInfoName));
        }
        return null;
    }

    public void setActiveFileStorageService(String serviceName, String localeInfoName) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getServerInfo());
        this.getService().getFileStorageManagementService().setActiveFileStorageService(this.getFileStorageService(serviceName));
    }

    public String getActiveFileStorageServiceName() {
        try {
            FileStorageService activeFileStorageService = this.getService().getFileStorageManagementService().getActiveFileStorageService();
            return activeFileStorageService == null ? null : activeFileStorageService.getName();
        }
        catch (NoCorrespondingServiceRegisteredException e) {
            return null;
        }
    }

    public void inviteCompetitorsForTrackingViaEmail(String serverUrlWithoutTrailingSlash, EventDTO eventDto, String leaderboardName, Collection<CompetitorDTO> competitorDtos, String iOSAppUrl, String androidAppUrl, String localeInfoName) throws MailException {
        Event event = this.getService().getEvent((Serializable)eventDto.id);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
        HashSet<Competitor> competitors = new HashSet<Competitor>();
        for (CompetitorDTO c : competitorDtos) {
            competitors.add(this.getCompetitor(c));
        }
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        Regatta regatta = this.getService().getRegattaByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
        this.getRaceLogTrackingAdapter().inviteCompetitorsForTrackingViaEmail(event, leaderboard, regatta, serverUrlWithoutTrailingSlash, competitors, iOSAppUrl, androidAppUrl, this.getLocale(localeInfoName), this.getMailType());
    }

    public void inviteBuoyTenderViaEmail(String serverUrlWithoutTrailingSlash, EventDTO eventDto, String leaderboardName, String emails, String iOSAppUrl, String androidAppUrl, String localeInfoName) throws MailException {
        Event event = this.getService().getEvent((Serializable)eventDto.id);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        Regatta regatta = this.getService().getRegattaByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
        MailInvitationType type = MailInvitationType.valueOf((String)System.getProperty("com.sap.sailing.domain.tracking.MailInvitationType", MailInvitationType.SailInsight1.name()));
        this.getRaceLogTrackingAdapter().inviteBuoyTenderViaEmail(event, leaderboard, regatta, serverUrlWithoutTrailingSlash, emails, iOSAppUrl, androidAppUrl, this.getLocale(localeInfoName), type);
    }

    public void disableCompetitorRegistrationsForRace(String leaderboardName, String raceColumnName, String fleetName) throws NotRevokableException, NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        if (this.areCompetitorRegistrationsEnabledForRace(leaderboardName, raceColumnName, fleetName).booleanValue()) {
            RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
            raceColumn.disableCompetitorRegistrationOnRaceLog(this.getFleetByName(raceColumn, fleetName));
        }
    }

    public void enableCompetitorRegistrationsForRace(String leaderboardName, String raceColumnName, String fleetName) throws IllegalArgumentException, NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        if (!this.areCompetitorRegistrationsEnabledForRace(leaderboardName, raceColumnName, fleetName).booleanValue()) {
            RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
            raceColumn.enableCompetitorRegistrationOnRaceLog(this.getFleetByName(raceColumn, fleetName));
        }
    }

    public void removeMarkFix(String leaderboardName, String raceColumnName, String fleetName, String markIdAsString, GPSFixDTO fix) throws NotRevokableException {
        RaceColumn raceColumn;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null) {
            MillisecondsTimePoint fixTimePoint = new MillisecondsTimePoint(fix.timepoint);
            RegattaLog regattaLog = raceColumn.getRegattaLog();
            RegattaLogDeviceMarkMappingFinder mappingFinder = new RegattaLogDeviceMarkMappingFinder(regattaLog);
            Fleet fleet = raceColumn.getFleetByName(fleetName);
            if (fleet != null) {
                for (Mark mark : raceColumn.getAvailableMarks(fleet)) {
                    if (!mark.getId().toString().equals(markIdAsString)) continue;
                    mappingFinder.removeTimePointFromMapping((WithID)mark, (TimePoint)fixTimePoint);
                }
            }
        }
    }

    public void addMarkFix(String leaderboardName, String raceColumnName, String fleetName, String markIdAsString, GPSFixDTO newFix) {
        RaceColumn raceColumn;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null) {
            RegattaLog regattaLog = raceColumn.getRegattaLog();
            Fleet fleet = raceColumn.getFleetByName(fleetName);
            if (fleet != null) {
                for (Mark mark : raceColumn.getAvailableMarks(fleet)) {
                    if (!mark.getId().toString().equals(markIdAsString)) continue;
                    this.getRaceLogTrackingAdapter().pingMark(regattaLog, mark, (GPSFix)new GPSFixImpl(newFix.position, (TimePoint)new MillisecondsTimePoint(newFix.timepoint)), this.getService());
                }
            }
        }
    }

    public void editMarkFix(String leaderboardName, String raceColumnName, String fleetName, String markIdAsString, GPSFixDTO oldFix, Position newPosition) throws NotRevokableException {
        RaceColumn raceColumn;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null) {
            RegattaLog regattaLog = raceColumn.getRegattaLog();
            RegattaLogDeviceMarkMappingFinder mappingFinder = new RegattaLogDeviceMarkMappingFinder(regattaLog);
            Fleet fleet = raceColumn.getFleetByName(fleetName);
            if (fleet != null) {
                MillisecondsTimePoint fixTimePoint = new MillisecondsTimePoint(oldFix.timepoint);
                for (Mark mark : raceColumn.getAvailableMarks(fleet)) {
                    if (!mark.getId().toString().equals(markIdAsString)) continue;
                    mappingFinder.removeTimePointFromMapping((WithID)mark, (TimePoint)fixTimePoint);
                    this.getRaceLogTrackingAdapter().pingMark(regattaLog, mark, (GPSFix)new GPSFixImpl(newPosition, (TimePoint)fixTimePoint), this.getService());
                }
            }
        }
    }

    public void setEliminatedCompetitors(String leaderboardName, Set<CompetitorDTO> newEliminatedCompetitorDTOs) throws NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        HashSet<Competitor> newEliminatedCompetitors = new HashSet<Competitor>();
        for (CompetitorDTO cDTO : newEliminatedCompetitorDTOs) {
            Competitor competitor = this.getCompetitor(cDTO);
            newEliminatedCompetitors.add(competitor);
        }
        this.getService().apply((OperationWithResult)new UpdateEliminatedCompetitorsInLeaderboard(leaderboardName, newEliminatedCompetitors));
    }

    public void addOrReplaceExpeditionDeviceConfiguration(ExpeditionDeviceConfiguration deviceConfiguration) throws IllegalStateException {
        this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.EXPEDITION_DEVICE_CONFIGURATION, deviceConfiguration.getTypeRelativeObjectIdentifier(), deviceConfiguration.getName(), () -> this.getService().apply((OperationWithResult)new AddOrReplaceExpeditionDeviceConfiguration(deviceConfiguration.getDeviceUuid(), deviceConfiguration.getName(), deviceConfiguration.getExpeditionBoatId())));
    }

    public void removeExpeditionDeviceConfiguration(ExpeditionDeviceConfiguration deviceConfiguration) {
        this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval(deviceConfiguration.getIdentifier(), (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public RegattaAndRaceIdentifier sliceRace(RegattaAndRaceIdentifier raceIdentifier, String newRaceColumnName, TimePoint sliceFrom, TimePoint sliceTo) throws ServiceException {
        boolean hasFinishedTime;
        boolean hasFinishingTime;
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Regatta.getTypeRelativeObjectIdentifier((String)raceIdentifier.getRegattaName())));
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)raceIdentifier.getRegattaName())));
        Locale locale = this.getClientLocale();
        if (!this.canSliceRace(raceIdentifier)) {
            throw new ServiceException(this.serverStringMessages.get(locale, "slicingCannotSliceRace"));
        }
        String trackedRaceName = newRaceColumnName;
        RegattaName regattaIdentifier = new RegattaName(raceIdentifier.getRegattaName());
        Regatta regatta = this.getService().getRegatta((RegattaIdentifier)regattaIdentifier);
        Leaderboard regattaLeaderboard = this.getService().getLeaderboardByName(regatta.getName());
        if (regattaLeaderboard == null) {
            throw new IllegalArgumentException("Cannot slice a race for which no regatta leaderboard exists");
        }
        if (regatta.getRaceColumnByName(newRaceColumnName) != null) {
            throw new ServiceException(this.serverStringMessages.get(locale, "slicingRaceColumnAlreadyUsedThe"));
        }
        DynamicTrackedRace trackedRaceToSlice = this.getService().getTrackedRace(raceIdentifier);
        TimePoint startOfTrackingOfRaceToSlice = trackedRaceToSlice.getStartOfTracking();
        TimePoint endOfTrackingOfRaceToSlice = trackedRaceToSlice.getEndOfTracking();
        if (sliceFrom == null || sliceTo == null || startOfTrackingOfRaceToSlice.after(sliceFrom) || endOfTrackingOfRaceToSlice != null && endOfTrackingOfRaceToSlice.before(sliceTo)) {
            throw new ServiceException(this.serverStringMessages.get(locale, "slicingTimeRangeOutOfBounds"));
        }
        Util.Pair raceColumnAndFleetOfRaceToSlice = regatta.getRaceColumnAndFleet((TrackedRace)trackedRaceToSlice);
        RaceColumnInSeries raceColumnOfRaceToSlice = (RaceColumnInSeries)raceColumnAndFleetOfRaceToSlice.getA();
        Fleet fleet = (Fleet)raceColumnAndFleetOfRaceToSlice.getB();
        Series series = raceColumnOfRaceToSlice.getSeries();
        RaceLog raceLogOfRaceToSlice = raceColumnOfRaceToSlice.getRaceLog(fleet);
        RaceColumn raceColumn = (RaceColumn)this.getService().apply((OperationWithResult)new AddColumnToSeries((RegattaIdentifier)regattaIdentifier, series.getName(), newRaceColumnName));
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        AbstractLogEventAuthor author = this.getService().getServerAuthor();
        TimePoint startOfTracking = sliceFrom;
        TimePoint endOfTracking = sliceTo;
        raceLog.add((AbstractLogEvent)new RaceLogStartOfTrackingEventImpl(startOfTracking, author, raceLog.getCurrentPassId()));
        raceLog.add((AbstractLogEvent)new RaceLogEndOfTrackingEventImpl(endOfTracking, author, raceLog.getCurrentPassId()));
        TimeRangeImpl timeRange = new TimeRangeImpl(sliceFrom, sliceTo);
        StartTimeFinderResult startTimeFinderResult = (StartTimeFinderResult)new StartTimeFinder((RaceLogResolver)this.getService(), raceLogOfRaceToSlice).analyze();
        TimePoint startTime = startTimeFinderResult.getStartTime();
        boolean hasStartTime = startTime != null && timeRange.includes(startTime);
        boolean dependentStartTime = startTimeFinderResult.isDependentStartTime();
        if (hasStartTime) {
            TimePoint finishedTime;
            TimePoint finishingTime = (TimePoint)new FinishingTimeFinder(raceLog).analyze();
            boolean bl = hasFinishingTime = finishingTime != null && timeRange.includes(finishingTime);
            hasFinishedTime = hasFinishingTime ? (finishedTime = (TimePoint)new FinishedTimeFinder(raceLog).analyze()) != null && timeRange.includes(finishedTime) : false;
        } else {
            hasFinishingTime = false;
            hasFinishedTime = false;
        }
        LogEventTimeRangeWithFallbackFilter windFixEvents = new LogEventTimeRangeWithFallbackFilter((TimeRange)timeRange);
        raceLogOfRaceToSlice.lockForRead();
        try {
            for (RaceLogEvent raceLogEvent : raceLogOfRaceToSlice.getUnrevokedEvents()) {
                raceLogEvent.accept((Object)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        finally {
            raceLogOfRaceToSlice.unlockAfterRead();
        }
        windFixEvents.getFilteredEvents().forEach(event -> {
            boolean bl = raceLog.add((AbstractLogEvent)new RaceLogWindFixEventImpl(event.getCreatedAt(), event.getLogicalTimePoint(), event.getAuthor(), (Serializable)UUID.randomUUID(), raceLog.getCurrentPassId(), event.getWindFix(), event.isMagnetic()));
        });
        TimePoint startTrackingTimePoint = MillisecondsTimePoint.now();
        TimePoint denotationTimePoint = startTrackingTimePoint.minus(1L);
        raceLog.add((AbstractLogEvent)new RaceLogDenoteForTrackingEventImpl(denotationTimePoint, author, raceLog.getCurrentPassId(), trackedRaceName, regatta.getBoatClass(), (Serializable)UUID.randomUUID()));
        raceLog.add((AbstractLogEvent)new RaceLogStartTrackingEventImpl(startTrackingTimePoint, author, raceLog.getCurrentPassId()));
        try {
            RaceHandle raceHandle = this.getRaceLogTrackingAdapter().startTracking(this.getService(), regattaLeaderboard, raceColumn, fleet, true, true, this.getService().getPermissionAwareRaceTrackingHandler());
            raceHandle.getRace();
            DynamicTrackedRace trackedRace = (DynamicTrackedRace)WaitForTrackedRaceUtil.waitForTrackedRace((RaceColumn)raceColumn, (Fleet)fleet, (int)10);
            if (trackedRace == null) {
                throw new ServiceException(this.serverStringMessages.get(locale, "slicingCouldNotObtainRace"));
            }
            for (WindSource windSourceToCopy : trackedRaceToSlice.getWindSources()) {
                if (!windSourceToCopy.canBeStored()) continue;
                WindTrack windTrackToCopyFrom = trackedRaceToSlice.getOrCreateWindTrack(windSourceToCopy);
                windTrackToCopyFrom.lockForRead();
                try {
                    for (Wind windToCopy : windTrackToCopyFrom.getFixes(startOfTracking, true, endOfTracking, true)) {
                        trackedRace.recordWind(windToCopy, windSourceToCopy);
                    }
                }
                finally {
                    windTrackToCopyFrom.unlockAfterRead();
                }
            }
            Iterable mediaTracksForOriginalRace = this.getService().getMediaTracksForRace(raceIdentifier);
            for (MediaTrack mediaTrack : mediaTracksForOriginalRace) {
                if (!mediaTrack.overlapsWith(sliceFrom, sliceTo)) continue;
                HashSet<RegattaAndRaceIdentifier> assignedRaces = new HashSet<RegattaAndRaceIdentifier>(mediaTrack.assignedRaces);
                assignedRaces.add(trackedRace.getRaceIdentifier());
                MediaTrack mediaTrackToSave = new MediaTrack(mediaTrack.dbId, mediaTrack.title, mediaTrack.url, mediaTrack.startTime, mediaTrack.duration, mediaTrack.mimeType, assignedRaces);
                this.getService().mediaTrackAssignedRacesChanged(mediaTrackToSave);
            }
            return trackedRace.getRaceIdentifier();
        }
        catch (Exception e) {
            throw new ServiceException(this.serverStringMessages.get(locale, "slicingError"));
        }
    }

    public Set<ImageDTO> resizeImage(ImageResizingTaskDTO resizingTask) throws Exception {
        if (resizingTask.getResizingTask() == null || resizingTask.getResizingTask().size() == 0) {
            throw new InvalidAttributeValueException("Resizing Task can not be null or empty");
        }
        ImageConverter converter = new ImageConverter();
        String sourceRef = resizingTask.getImage().getSourceRef();
        String fileType = sourceRef.substring(sourceRef.lastIndexOf(".") + 1);
        ImageConverter.ImageWithMetadata imageAndMetadata = converter.loadImage(HttpUrlConnectionHelper.redirectConnection((URL)new URL(sourceRef)).getInputStream(), fileType);
        List resizedImages = converter.convertImage(imageAndMetadata.getImage(), resizingTask.getResizingTask());
        List sourceRefs = this.storeImages(resizedImages, fileType, imageAndMetadata.getMetadata());
        if (sourceRefs == null || sourceRefs.size() < resizingTask.getResizingTask().size()) {
            for (String alreadyStoredFileRef : sourceRefs) {
                try {
                    this.getService().getFileStorageManagementService().getActiveFileStorageService().removeFile(new URI(alreadyStoredFileRef));
                }
                catch (Exception e) {
                    logger.warning("Exception trying to remove image file " + alreadyStoredFileRef + ": " + e.getMessage());
                }
            }
            throw new Exception("Error occured while storing images on the FileStorage");
        }
        Set resizedImagesAsDTOs = this.createImageDTOsFromURLsAndResizingTask(sourceRefs, resizingTask, resizedImages);
        ImageDTO image = resizingTask.getImage();
        for (String tag : new ArrayList(image.getTags())) {
            MediaTagConstants predefinedTag = MediaTagConstants.fromName((String)tag);
            if (predefinedTag == null || resizingTask.getResizingTask().contains(predefinedTag)) continue;
            for (MediaTagConstants tagConstant : resizingTask.getResizingTask()) {
                image.getTags().remove(tagConstant.getName());
            }
            resizedImagesAsDTOs.add(image);
        }
        return resizedImagesAsDTOs;
    }

    private List<String> storeImages(List<BufferedImage> resizedImages, String fileType, IIOMetadata metadata) {
        ArrayList<String> sourceRefs = new ArrayList<String>();
        try {
            for (BufferedImage resizedImage : resizedImages) {
                InputStream fileStorageStream = new ImageConverter().imageWithMetadataToInputStream(resizedImage, metadata, fileType);
                sourceRefs.add(this.getService().getFileStorageManagementService().getActiveFileStorageService().storeFile(fileStorageStream, "." + fileType, Long.valueOf(fileStorageStream.available()).longValue()).toString());
            }
        }
        catch (NoCorrespondingServiceRegisteredException | InvalidPropertiesException | OperationFailedException | IOException e) {
            logger.log(Level.SEVERE, "Could not store file. Cause: " + e.getMessage());
        }
        return sourceRefs;
    }

    public SuccessInfo addTag(String leaderboardName, String raceColumnName, String fleetName, String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, boolean visibleForPublic, TimePoint raceTimepoint) {
        SuccessInfo successInfo = new SuccessInfo(true, null, null, null);
        try {
            if (visibleForPublic) {
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getService().getLeaderboardByName(leaderboardName));
            }
            this.getService().getTaggingService().addTag(leaderboardName, raceColumnName, fleetName, tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic, raceTimepoint);
        }
        catch (AuthorizationException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "missingAuthorization"), null, null);
        }
        catch (IllegalArgumentException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "invalidParameters"), null, null);
        }
        catch (RaceLogNotFoundException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "raceLogNotFound"), null, null);
        }
        catch (ServiceNotFoundException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "securityServiceNotFound"), null, null);
        }
        catch (TagAlreadyExistsException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "tagAlreadyExists"), null, null);
        }
        catch (Exception e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "unknownError"), null, null);
        }
        return successInfo;
    }

    public SuccessInfo removeTag(String leaderboardName, String raceColumnName, String fleetName, TagDTO tag) {
        SuccessInfo successInfo = new SuccessInfo(true, null, null, null);
        try {
            this.getService().getTaggingService().removeTag(leaderboardName, raceColumnName, fleetName, tag);
        }
        catch (AuthorizationException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "missingAuthorization"), null, null);
        }
        catch (IllegalArgumentException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "invalidParameters"), null, null);
        }
        catch (NotRevokableException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "tagNotRevokable"), null, null);
        }
        catch (RaceLogNotFoundException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "raceLogNotFound"), null, null);
        }
        catch (Exception e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "unknownError"), null, null);
        }
        return successInfo;
    }

    public SuccessInfo updateTag(String leaderboardName, String raceColumnName, String fleetName, TagDTO tagToUpdate, String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, boolean visibleForPublic) {
        SuccessInfo successInfo = new SuccessInfo(true, null, null, null);
        try {
            if (visibleForPublic) {
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getService().getLeaderboardByName(leaderboardName));
            }
            this.getService().getTaggingService().updateTag(leaderboardName, raceColumnName, fleetName, tagToUpdate, tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic);
        }
        catch (AuthorizationException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "missingAuthorization"), null, null);
        }
        catch (IllegalArgumentException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "invalidParameters"), null, null);
        }
        catch (NotRevokableException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "tagNotRevokable"), null, null);
        }
        catch (RaceLogNotFoundException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "raceLogNotFound"), null, null);
        }
        catch (TagAlreadyExistsException e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "tagAlreadyExists"), null, null);
        }
        catch (Exception e) {
            successInfo = new SuccessInfo(false, this.serverStringMessages.get(this.getClientLocale(), "unknownError"), null, null);
        }
        return successInfo;
    }

    public void updateGroupOwnerForEventHierarchy(UUID eventId, MigrateGroupOwnerForHierarchyDTO migrateGroupOwnerForHierarchyDTO) {
        Event event = this.getService().getEvent((Serializable)eventId);
        if (event != null) {
            this.createOwnershipUpdater(migrateGroupOwnerForHierarchyDTO).updateGroupOwnershipForEventHierarchy(event);
        }
    }

    private SailingHierarchyOwnershipUpdater createOwnershipUpdater(MigrateGroupOwnerForHierarchyDTO migrateGroupOwnerForHierarchyDTO) {
        return SailingHierarchyOwnershipUpdater.createOwnershipUpdater((boolean)migrateGroupOwnerForHierarchyDTO.isCreateNewGroup(), (UUID)migrateGroupOwnerForHierarchyDTO.getExistingUserGroupIdOrNull(), (String)migrateGroupOwnerForHierarchyDTO.getGroupName(), (boolean)migrateGroupOwnerForHierarchyDTO.isUpdateCompetitors(), (boolean)migrateGroupOwnerForHierarchyDTO.isUpdateBoats(), (boolean)migrateGroupOwnerForHierarchyDTO.isCopyMembersAndRoles(), (RacingEventService)this.getService());
    }

    public void updateGroupOwnerForLeaderboardGroupHierarchy(UUID leaderboardGroupId, MigrateGroupOwnerForHierarchyDTO migrateGroupOwnerForHierarchyDTO) {
        LeaderboardGroup leaderboardGroup = this.getService().getLeaderboardGroupByID(leaderboardGroupId);
        if (leaderboardGroup != null) {
            this.createOwnershipUpdater(migrateGroupOwnerForHierarchyDTO).updateGroupOwnershipForLeaderboardGroupHierarchy(leaderboardGroup);
        }
    }

    public String getSecretForRegattaByName(String regattaName) {
        String result = "";
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        if (regatta != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
            result = regatta.getRegistrationLinkSecret();
        }
        return result;
    }

    public void setORCPerformanceCurveLegInfo(RegattaAndRaceIdentifier raceIdentifier, Map<Integer, ORCPerformanceCurveLegImpl> legInfo) throws NotRevokableException {
        TrackedRace existingTrackedRace = this.getExistingTrackedRace(raceIdentifier);
        this.getService().getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)existingTrackedRace);
        this.setORCPerformanceCurveInfo((RaceLog)existingTrackedRace.getAttachedRaceLogs().iterator().next(), legInfo);
    }

    private void setORCPerformanceCurveInfo(RaceLog raceLog, Map<Integer, ORCPerformanceCurveLegImpl> legInfo) throws NotRevokableException {
        AbstractLogEventAuthor author = this.getService().getServerAuthor();
        for (Map.Entry e : ((Map)new RaceLogORCLegDataEventFinder(raceLog).analyze()).entrySet()) {
            boolean explicitRevoke;
            assert (e.getValue() != null);
            ORCPerformanceCurveLeg leg = RaceLogORCLegDataAnalyzer.createORCPerformanceCurveLeg((RaceLogORCLegDataEvent)((RaceLogORCLegDataEvent)e.getValue()));
            ORCPerformanceCurveLegImpl desiredLeg = legInfo.get(e.getKey());
            boolean bl = explicitRevoke = legInfo.containsKey(e.getKey()) && legInfo.get(e.getKey()) == null;
            if (Util.equalsWithNull((Object)desiredLeg, (Object)leg)) {
                assert (desiredLeg != null);
                legInfo.remove(e.getKey());
                continue;
            }
            raceLog.revokeEvent(author, (AbstractLogEvent)((RaceLogEvent)e.getValue()));
            if (!explicitRevoke) continue;
            legInfo.remove(e.getKey());
        }
        TimePoint now = MillisecondsTimePoint.now();
        for (Map.Entry<Integer, ORCPerformanceCurveLegImpl> e : legInfo.entrySet()) {
            if (e.getValue() == null) continue;
            raceLog.add((AbstractLogEvent)new RaceLogORCLegDataEventImpl(now, now, author, (Serializable)UUID.randomUUID(), 0, e.getKey().intValue(), e.getValue().getTwa(), e.getValue().getLength(), e.getValue().getType()));
        }
    }

    public void setORCPerformanceCurveLegInfo(String leaderboardName, String raceColumnName, String fleetName, Map<Integer, ORCPerformanceCurveLegImpl> legInfo) throws NotFoundException, NotRevokableException {
        this.setORCPerformanceCurveInfo(this.getRaceLog(leaderboardName, raceColumnName, fleetName), legInfo);
    }

    private Util.Triple<Integer, Integer, Integer> createCertificateAssignmentsForRaceLog(String leaderboardName, String raceColumnName, String fleetName, Map<String, ORCCertificate> certificatesForBoatIdsAsString) throws IOException, NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getService().getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        SailingServiceImpl.LogEventConstructor logEventConstructor = this.createRaceLogEventConstructor();
        return this.createCertificateAssignments((AbstractLog)raceLog, logEventConstructor, certificatesForBoatIdsAsString);
    }

    private Util.Triple<Integer, Integer, Integer> createCertificateAssignmentsForRegatta(RegattaIdentifier regattaIdentifier, Map<String, ORCCertificate> certificatesForBoatIdsAsString) throws IOException, NotFoundException {
        Regatta regatta = (Regatta)regattaIdentifier.getRegatta((RegattaFetcher)this.getService());
        if (regatta == null) {
            throw new NotFoundException("Regatta named " + regattaIdentifier + " not found");
        }
        this.getService().getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
        RegattaLog regattaLog = regatta.getRegattaLog();
        SailingServiceImpl.LogEventConstructor logEventConstructor = this.createRegattaLogEventConstructor();
        return this.createCertificateAssignments((AbstractLog)regattaLog, logEventConstructor, certificatesForBoatIdsAsString);
    }

    private SailingServiceImpl.LogEventConstructor<RegattaLogEvent, RegattaLogEventVisitor> createRegattaLogEventConstructor() {
        SailingServiceImpl.LogEventConstructor logEventConstructor = (createdAt, logicalTimePoint, author, pId, certificate, boat) -> new RegattaLogORCCertificateAssignmentEventImpl(createdAt, logicalTimePoint, author, pId, certificate, boat);
        return logEventConstructor;
    }

    public Util.Triple<Integer, Integer, Integer> assignORCPerformanceCurveCertificates(RegattaIdentifier regattaIdentifier, Map<String, ORCCertificate> certificatesForBoatsWithIdAsString) throws IOException, NotFoundException {
        return this.createCertificateAssignmentsForRegatta(regattaIdentifier, certificatesForBoatsWithIdAsString);
    }

    public Util.Triple<Integer, Integer, Integer> assignORCPerformanceCurveCertificates(String leaderboardName, String raceColumnName, String fleetName, Map<String, ORCCertificate> certificatesForBoatsWithIdAsString) throws IOException, NotFoundException {
        return this.createCertificateAssignmentsForRaceLog(leaderboardName, raceColumnName, fleetName, certificatesForBoatsWithIdAsString);
    }

    protected <LogT extends AbstractLog<LogEventT, VisitorT>, VisitorT, LogEventT extends AbstractLogEvent<VisitorT>, AssignmentEventT extends ORCCertificateAssignmentEvent<VisitorT>> Util.Triple<Integer, Integer, Integer> createCertificateAssignments(LogT logToAddTo, SailingServiceImpl.LogEventConstructor<LogEventT, VisitorT> logEventConstructor, Map<String, ORCCertificate> certificatesForBoatIdsAsString) throws IOException {
        int insertedCount = 0;
        int replacedCount = 0;
        int removedCount = 0;
        BaseORCCertificateAssignmentAnalyzer analyzerForPreviousAssignments = new BaseORCCertificateAssignmentAnalyzer(logToAddTo);
        Map validCertificateAssignmentsInLogByBoatId = (Map)analyzerForPreviousAssignments.analyze();
        TimePoint now = MillisecondsTimePoint.now();
        CompetitorAndBoatStore boatStore = this.getService().getCompetitorAndBoatStore();
        AbstractLogEventAuthor serverAuthor = this.getService().getServerAuthor();
        for (Map.Entry<String, ORCCertificate> entry : certificatesForBoatIdsAsString.entrySet()) {
            boolean addEvent;
            Serializable boatId = UUIDHelper.tryUuidConversion((Serializable)((Serializable)((Object)entry.getKey())));
            ORCCertificateAssignmentEvent previouslyValidAssignmentEventForBoat = (ORCCertificateAssignmentEvent)validCertificateAssignmentsInLogByBoatId.remove(boatId);
            ORCCertificate certificate = entry.getValue();
            DynamicBoat boat = boatStore.getExistingBoatById(boatId);
            if (boat == null) continue;
            if (previouslyValidAssignmentEventForBoat != null) {
                if (!previouslyValidAssignmentEventForBoat.getCertificate().getId().equals(certificate.getId())) {
                    logger.info("Replacing certificate " + previouslyValidAssignmentEventForBoat.getCertificate() + " for boat " + boat + " by " + certificate);
                    ++replacedCount;
                    addEvent = true;
                    try {
                        ORCCertificateAssignmentEvent previouslyValidAssignmentEventForBoatAsLogEventT = previouslyValidAssignmentEventForBoat;
                        logToAddTo.revokeEvent(serverAuthor, (AbstractLogEvent)previouslyValidAssignmentEventForBoatAsLogEventT);
                    }
                    catch (NotRevokableException e) {
                        logger.severe("Couldn't revoke old certificate assignment event " + previouslyValidAssignmentEventForBoat + ": " + e.getMessage());
                    }
                } else {
                    addEvent = false;
                    logger.info("Not replacing certificate " + previouslyValidAssignmentEventForBoat.getCertificate() + " because the certificate " + certificate + " requested to be assigned is considered equal.");
                }
            } else {
                addEvent = true;
                ++insertedCount;
            }
            if (!addEvent) continue;
            AbstractLogEvent assignment = logEventConstructor.create(now, now, serverAuthor, (Serializable)UUID.randomUUID(), certificate, (Boat)boat);
            logToAddTo.add(assignment);
        }
        for (Map.Entry<String, Object> entry : validCertificateAssignmentsInLogByBoatId.entrySet()) {
            AbstractLogEvent eventToRevoke = (AbstractLogEvent)entry.getValue();
            try {
                logToAddTo.revokeEvent(serverAuthor, eventToRevoke);
                ++removedCount;
            }
            catch (NotRevokableException e) {
                logger.severe("Couldn't revoke old certificate assignment event " + eventToRevoke + ": " + e.getMessage());
            }
        }
        return new Util.Triple((Object)insertedCount, (Object)replacedCount, (Object)removedCount);
    }

    protected SailingServiceImpl.LogEventConstructor<RaceLogEvent, RaceLogEventVisitor> createRaceLogEventConstructor() {
        return (createdAt, logicalTimePoint, author, pId, certificate, boat) -> new RaceLogORCCertificateAssignmentEventImpl(createdAt, logicalTimePoint, author, pId, 0, certificate, boat);
    }

    public CompetitorDTO getORCPerformanceCurveScratchBoat(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getService().getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        RaceLogORCScratchBoatFinder finder = new RaceLogORCScratchBoatFinder(raceLog);
        Competitor scratchBoat = (Competitor)finder.analyze();
        return scratchBoat == null ? null : this.convertToCompetitorDTO(scratchBoat);
    }

    public void setORCPerformanceCurveScratchBoat(String leaderboardName, String raceColumnName, String fleetName, CompetitorDTO newScratchBoatDTO) throws NotFoundException {
        Competitor previousScratchBoat;
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getService().getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        Competitor newScratchBoat = newScratchBoatDTO == null ? null : this.getService().getCompetitorAndBoatStore().getExistingCompetitorById(UUIDHelper.tryUuidConversion((Serializable)((Object)newScratchBoatDTO.getIdAsString())));
        RaceLogORCScratchBoatAnalyzer analyzer = new RaceLogORCScratchBoatAnalyzer(raceLog);
        Util.Pair previousScratchBoatAndEvent = (Util.Pair)analyzer.analyze();
        Competitor competitor = previousScratchBoat = previousScratchBoatAndEvent == null ? null : (Competitor)previousScratchBoatAndEvent.getA();
        if (!Util.equalsWithNull((Object)newScratchBoat, (Object)previousScratchBoat)) {
            AbstractLogEventAuthor serverAuthor = this.getService().getServerAuthor();
            if (previousScratchBoatAndEvent != null) {
                try {
                    raceLog.revokeEvent(serverAuthor, (AbstractLogEvent)((RaceLogEvent)previousScratchBoatAndEvent.getB()));
                }
                catch (NotRevokableException e) {
                    logger.log(Level.SEVERE, "Unable to revoke scratch boat definition event " + previousScratchBoatAndEvent.getB(), e);
                }
            }
            if (newScratchBoat != null) {
                TimePoint now = MillisecondsTimePoint.now();
                raceLog.add((AbstractLogEvent)new RaceLogORCScratchBoatEventImpl(now, now, serverAuthor, (Serializable)UUID.randomUUID(), raceLog.getCurrentPassId(), newScratchBoat));
            }
        }
    }

    public MarkTemplateDTO addOrUpdateMarkTemplate(MarkTemplateDTO markTemplate) {
        UUID markTemplateUUID = UUID.randomUUID();
        MarkTemplate mTemplate = (MarkTemplate)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.MARK_TEMPLATE, MarkTemplate.getTypeRelativeObjectIdentifier((UUID)markTemplateUUID), markTemplate.getName(), () -> this.getSharedSailingData().createMarkTemplate(this.convertDtoToCommonMarkProperties(markTemplate.getCommonMarkProperties())));
        return this.convertToMarkTemplateDTO(mTemplate);
    }

    private boolean existsSwissTimingArchiveConfigurationForCurrentUser(String jsonUrl) throws Exception, UnauthorizedException {
        boolean found = false;
        String currentUserName = this.getSecurityService().getCurrentUser().getName();
        for (SwissTimingArchiveConfigurationWithSecurityDTO dto : this.getPreviousSwissTimingArchiveConfigurations()) {
            if (!dto.getJsonUrl().equals(jsonUrl) || !currentUserName.equals(dto.getCreatorName())) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean existsYellowBrickConfigurationForCurrentUser(String raceUrl) {
        boolean found = false;
        String currentUserName = this.getSecurityService().getCurrentUser().getName();
        for (YellowBrickConfigurationWithSecurityDTO dto : this.getPreviousYellowBrickConfigurations()) {
            if (!dto.getRaceUrl().equals(raceUrl) || !currentUserName.equals(dto.getCreatorName())) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean existsTracTracConfigurationForCurrentUser(String jsonUrl) throws Exception, UnauthorizedException {
        boolean found = false;
        String currentUserName = this.getSecurityService().getCurrentUser().getName();
        for (TracTracConfigurationWithSecurityDTO dto : this.getPreviousTracTracConfigurations()) {
            if (!dto.getJsonUrl().equals(jsonUrl) || !currentUserName.equals(dto.getCreatorName())) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean existsSwissTimingConfigurationForCurrentUser(String jsonUrl) throws Exception, UnauthorizedException {
        boolean found = false;
        String currentUserName = this.getSecurityService().getCurrentUser().getName();
        for (SwissTimingConfigurationWithSecurityDTO dto : this.getPreviousSwissTimingConfigurations()) {
            if (!dto.getJsonUrl().equals(jsonUrl) || !currentUserName.equals(dto.getCreatorName())) continue;
            found = true;
            break;
        }
        return found;
    }

    public void createOrUpdateDeviceConfiguration(DeviceConfigurationDTO configurationDTO) {
        if (this.getService().getDeviceConfigurationById(configurationDTO.id) == null) {
            DeviceConfigurationImpl configuration = this.convertToDeviceConfiguration(configurationDTO);
            this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(configuration.getPermissionType(), configuration.getIdentifier().getTypeRelativeObjectIdentifier(), configuration.getName(), (Action)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            DeviceConfigurationImpl configuration = this.convertToDeviceConfiguration(configurationDTO);
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)configuration);
            this.getService().createOrUpdateDeviceConfiguration((DeviceConfiguration)configuration);
        }
    }

    private DeviceConfigurationImpl convertToDeviceConfiguration(DeviceConfigurationDTO dto) {
        DeviceConfigurationImpl configuration = new DeviceConfigurationImpl(this.convertToRegattaConfiguration(dto.regattaConfiguration), dto.id, dto.name);
        configuration.setAllowedCourseAreaNames(dto.allowedCourseAreaNames);
        configuration.setResultsMailRecipient(dto.resultsMailRecipient);
        configuration.setByNameDesignerCourseNames(dto.byNameDesignerCourseNames);
        configuration.setEventId(dto.eventId);
        configuration.setCourseAreaId(dto.courseAreaId);
        configuration.setPriority(dto.priority);
        return configuration;
    }

    public Util.Pair<Boolean, Boolean> setFinishingAndEndTime(RaceLogSetFinishingAndFinishTimeDTO dto) throws NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(dto.leaderboardName));
        MillisecondsTimePoint finishingTimePoint = dto.finishingTime == null ? null : new MillisecondsTimePoint(dto.finishingTime);
        TimePoint newFinsihingTime = this.getService().setFinishingTime(dto.leaderboardName, dto.raceColumnName, dto.fleetName, dto.authorName, dto.authorPriority, dto.passId, finishingTimePoint);
        MillisecondsTimePoint finishTimePoint = dto.finishTime == null ? null : new MillisecondsTimePoint(dto.finishTime);
        TimePoint newEndTime = this.getService().setEndTime(dto.leaderboardName, dto.raceColumnName, dto.fleetName, dto.authorName, dto.authorPriority.intValue(), dto.passId, (TimePoint)finishTimePoint);
        return new Util.Pair((Object)Util.equalsWithNull((Object)finishingTimePoint, (Object)newFinsihingTime), (Object)Util.equalsWithNull((Object)finishTimePoint, (Object)newEndTime));
    }

    public boolean setStartTimeAndProcedure(RaceLogSetStartTimeAndProcedureDTO dto) throws NotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(dto.leaderboardName));
        TimePoint newStartTime = this.getService().setStartTimeAndProcedure(dto.leaderboardName, dto.raceColumnName, dto.fleetName, dto.authorName, dto.authorPriority.intValue(), dto.passId, (TimePoint)new MillisecondsTimePoint(dto.logicalTimePoint), (TimePoint)new MillisecondsTimePoint(dto.startTime), dto.racingProcedure, dto.courseAreaId);
        return new MillisecondsTimePoint(dto.startTime).equals((Object)newStartTime);
    }

    public void setImpliedWindSource(String leaderboardName, String raceColumnName, String fleetName, ImpliedWindSource impliedWindSource) throws NotFoundException {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        this.getService().getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        TimePoint now = MillisecondsTimePoint.now();
        RaceLogORCImpliedWindSourceEventImpl impliedWindSourceEvent = new RaceLogORCImpliedWindSourceEventImpl(now, now, this.getService().getServerAuthor(), (Serializable)UUID.randomUUID(), raceLog.getCurrentPassId(), impliedWindSource);
        raceLog.add((AbstractLogEvent)impliedWindSourceEvent);
    }

    public List<TrackFileImportDeviceIdentifierDTO> getTrackFileImportDeviceIds(List<String> uuids) throws NoCorrespondingServiceRegisteredException, TransformationException {
        try {
            ArrayList<TrackFileImportDeviceIdentifierDTO> result = new ArrayList<TrackFileImportDeviceIdentifierDTO>();
            for (String uuidAsString : uuids) {
                UUID uuid = UUID.fromString(uuidAsString);
                TrackFileImportDeviceIdentifier device = TrackFileImportDeviceIdentifierImpl.getOrCreate((UUID)uuid);
                long numFixes = this.getService().getSensorFixStore().getNumberOfFixes((DeviceIdentifier)device);
                TimeRange timeRange = this.getService().getSensorFixStore().getTimeRangeCoveredByFixes((DeviceIdentifier)device);
                Date from = timeRange == null ? null : timeRange.from().asDate();
                Date to = timeRange == null ? null : timeRange.to().asDate();
                result.add(new TrackFileImportDeviceIdentifierDTO(uuidAsString, device.getFileName(), device.getTrackName(), numFixes, from, to));
            }
            return result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception trying to obtain track file import device IDs", e);
            throw e;
        }
    }

    public MarkPositionService.MarkTrackDTO getMarkTrack(String leaderboardName, String raceColumnName, String fleetName, String markIdAsString) {
        Fleet fleet;
        RaceColumn raceColumn;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null && (fleet = raceColumn.getFleetByName(fleetName)) != null) {
            return this.getMarkTrack(leaderboard, raceColumn, fleet, markIdAsString);
        }
        return null;
    }

    private MarkPositionService.MarkTrackDTO getMarkTrack(Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, String markIdAsString) {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        MarkDTO markDTO = null;
        Mark mark = null;
        for (Mark currMark : raceColumn.getAvailableMarks(fleet)) {
            if (!currMark.getId().toString().equals(markIdAsString)) continue;
            mark = currMark;
            markDTO = this.convertToMarkDTO(currMark, null);
            break;
        }
        if (markDTO != null) {
            GPSFixTrack markTrack;
            TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
            if (trackedRace != null) {
                markTrack = trackedRace.getOrCreateTrack(mark);
            } else {
                DynamicGPSFixTrackImpl writeableMarkTrack = new DynamicGPSFixTrackImpl((Object)mark, BoatClass.APPROXIMATE_AVERAGE_MANEUVER_DURATION.asMillis());
                markTrack = writeableMarkTrack;
                RaceLog raceLog = raceColumn.getRaceLog(fleet);
                RegattaLog regattaLog = raceColumn.getRegattaLog();
                TrackingTimesFinder trackingTimesFinder = new TrackingTimesFinder(raceLog);
                Util.Pair trackingTimes = (Util.Pair)trackingTimesFinder.analyze();
                try {
                    SensorFixStore sensorFixStore = this.getService().getSensorFixStore();
                    List mappings = (List)((Map)new RegattaLogDeviceMarkMappingFinder(regattaLog).analyze()).get(mark);
                    if (mappings != null) {
                        for (DeviceMapping mapping : mappings) {
                            TimePoint from = Util.getLatestOfTimePoints((TimePoint)((TimePointSpecificationFoundInLog)trackingTimes.getA()).getTimePoint(), (TimePoint)mapping.getTimeRange().from());
                            TimePoint to = Util.getEarliestOfTimePoints((TimePoint)((TimePointSpecificationFoundInLog)trackingTimes.getB()).getTimePoint(), (TimePoint)mapping.getTimeRange().to());
                            sensorFixStore.loadFixes(loadedFix -> {
                                boolean bl = writeableMarkTrack.add(loadedFix, true);
                            }, mapping.getDevice(), from, to, false, () -> false, progressIgnoringConsumer -> {});
                        }
                    }
                }
                catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                    logger.info("Error trying to load mark track for mark " + mark + " from " + trackingTimes.getA() + " to " + trackingTimes.getB());
                }
            }
            Iterable gpsFixDTOTrack = this.convertToGPSFixDTOTrack((Track)markTrack);
            return new MarkPositionService.MarkTrackDTO(markDTO, gpsFixDTOTrack, false);
        }
        return null;
    }

    private List<DeviceMappingDTO> getDeviceMappings(RegattaLog regattaLog) throws TransformationException {
        ArrayList<DeviceMappingDTO> result = new ArrayList<DeviceMappingDTO>();
        for (List list : ((Map)new RegattaLogDeviceMappingFinder(regattaLog).analyze()).values()) {
            for (DeviceMapping mapping : list) {
                result.add(this.convertToDeviceMappingDTO(mapping));
            }
        }
        return result;
    }

    public List<DeviceMappingDTO> getDeviceMappings(String leaderboardName) throws DoesNotHaveRegattaLogException, TransformationException, NotFoundException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        return this.getDeviceMappings(regattaLog);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateServerConfiguration(ServerConfigurationDTO serverConfiguration) {
        boolean shouldBePublic;
        boolean shouldBeSelfService;
        boolean isCurrentlySelfService;
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_LOCAL_SERVER);
        this.getService().apply((OperationWithResult)new UpdateServerConfiguration((SailingServerConfiguration)new SailingServerConfigurationImpl(serverConfiguration.isStandaloneServer())));
        if (serverConfiguration.isSelfService() != null && (isCurrentlySelfService = this.isSelfServiceServer().booleanValue()) != (shouldBeSelfService = serverConfiguration.isSelfService().booleanValue())) {
            SecurityUtils.getSubject().checkPermission(this.getServerInfo().getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL));
            if (shouldBeSelfService) {
                this.getSecurityService().addToAccessControlList(this.getServerInfo().getIdentifier(), null, SecuredSecurityTypes.ServerActions.CREATE_OBJECT.name());
            } else {
                this.getSecurityService().removeFromAccessControlList(this.getServerInfo().getIdentifier(), null, SecuredSecurityTypes.ServerActions.CREATE_OBJECT.name());
            }
        }
        if (serverConfiguration.isPublic() == null) return;
        RoleDefinition viewerRole = this.getSecurityService().getRoleDefinition(SailingViewerRole.getInstance().getId());
        UserGroup serverGroup = this.getSecurityService().getServerGroup();
        if (viewerRole == null || serverGroup == null) throw new IllegalArgumentException(String.valueOf(SailingViewerRole.getInstance().getName()) + " role or default server tenant does not exist");
        boolean isCurrentlyPublic = Boolean.TRUE.equals(serverGroup.getRoleAssociation(viewerRole));
        if (isCurrentlyPublic == (shouldBePublic = serverConfiguration.isPublic().booleanValue())) return;
        if (!this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)serverGroup) || !this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(viewerRole, new Ownership(null, serverGroup))) throw new AuthorizationException("No permission to make the server public");
        if (serverConfiguration.isPublic().booleanValue()) {
            this.getSecurityService().putRoleDefinitionToUserGroup(serverGroup, viewerRole, true);
            return;
        } else {
            this.getSecurityService().removeRoleDefintionFromUserGroup(serverGroup, viewerRole);
        }
    }

    public void deleteYellowBrickConfigurations(Collection<YellowBrickConfigurationWithSecurityDTO> configs) {
        for (YellowBrickConfigurationWithSecurityDTO config : configs) {
            this.getYellowBrickTrackingAdapter().removeYellowBrickConfiguration(config.getRaceUrl(), config.getCreatorName());
        }
    }

    public void updateYellowBrickConfiguration(YellowBrickConfigurationWithSecurityDTO editedObject) {
        this.getYellowBrickTrackingAdapter().updateYellowBrickConfiguration(editedObject.getName(), editedObject.getRaceUrl(), editedObject.getUsername(), editedObject.getPassword(), editedObject.getCreatorName());
    }

    private void checkAIAgentConfigPermission() throws AuthorizationException {
        Subject subject = SecurityUtils.getSubject();
        subject.checkPermission(SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CONFIGURE_AI_AGENT, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
    }

    public void startAICommentingOnEvent(UUID eventId) {
        this.changeAICommentingForEvent(eventId, arg_0 -> ((AIAgent)this.getAIAgent()).startCommentingOnEvent(arg_0));
    }

    private void changeAICommentingForEvent(UUID eventId, Consumer<Event> changeFunction) {
        this.checkAIAgentConfigPermission();
        Event event = this.getService().getEvent((Serializable)eventId);
        if (event != null) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)event);
            changeFunction.accept(event);
        } else {
            logger.warning("User " + SecurityUtils.getSubject().getPrincipal() + " was trying to change AI commenting for event with ID " + eventId + ", but that event wasn't found");
        }
    }

    public void stopAICommentingOnEvent(UUID eventId) {
        this.changeAICommentingForEvent(eventId, arg_0 -> ((AIAgent)this.getAIAgent()).stopCommentingOnEvent(arg_0));
    }

    public List<EventDTO> getIdsOfEventsWithAICommenting() {
        this.checkAIAgentConfigPermission();
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getAIAgent().getCommentingOnEvents(), event -> this.convertToEventDTO(event, false));
    }

    public String getAIAgentLanguageModelName() {
        this.checkAIAgentConfigPermission();
        AIAgent aiAgent = this.getAIAgent();
        return aiAgent == null ? null : aiAgent.getModelName();
    }

    public boolean hasAIAgentCredentials() {
        this.checkAIAgentConfigPermission();
        AIAgent aiAgent = this.getAIAgent();
        return aiAgent == null ? false : aiAgent.hasCredentials();
    }

    public void setAIAgentCredentials(String credentials) throws MalformedURLException, ParseException {
        this.checkAIAgentConfigPermission();
        AIAgent aiAgent = this.getAIAgent();
        if (aiAgent != null) {
            if (Util.hasLength((String)credentials)) {
                Credentials parsedCredentials;
                try {
                    parsedCredentials = CredentialsParser.create().parse((CharSequence)credentials);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Credentials could not be parsed");
                }
                if (parsedCredentials != null) {
                    aiAgent.setCredentials(parsedCredentials);
                }
            } else {
                throw new IllegalStateException("Blank credentials received");
            }
        }
    }

    public void resetAIAgentCredentials() {
        this.checkAIAgentConfigPermission();
        AIAgent aiAgent = this.getAIAgent();
        if (aiAgent != null) {
            aiAgent.setCredentials(null);
        }
    }

    public void copyPairingListFromOtherLeaderboard(String sourceLeaderboardName, String targetLeaderboardName, String fromRaceColumnName, String toRaceColumnInclusiveName) throws UnauthorizedException, NotFoundException {
        Leaderboard sourceLeaderboard = this.getLeaderboardByName(sourceLeaderboardName);
        this.getService().getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)sourceLeaderboard);
        Leaderboard targetLeaderboard = this.getLeaderboardByName(targetLeaderboardName);
        this.getService().getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)targetLeaderboard);
        if (!(sourceLeaderboard instanceof RegattaLeaderboard)) {
            throw new IllegalArgumentException("Source leaderboard " + sourceLeaderboardName + " must be a regatta leaderboard, but was: " + sourceLeaderboard.getLeaderboardType());
        }
        if (!(targetLeaderboard instanceof RegattaLeaderboard)) {
            throw new IllegalArgumentException("Target leaderboard " + sourceLeaderboardName + " must be a regatta leaderboard, but was: " + targetLeaderboard.getLeaderboardType());
        }
        this.getRaceLogTrackingAdapter().copyPairingListFromOtherLeaderboard((RegattaLeaderboard)sourceLeaderboard, (RegattaLeaderboard)targetLeaderboard, fromRaceColumnName, toRaceColumnInclusiveName);
    }

    private /* synthetic */ DynamicCompetitorWithBoat lambda$33(UUID uUID, CompetitorWithBoatDTO competitorWithBoatDTO, DynamicTeam dynamicTeam, DynamicBoat dynamicBoat) throws Exception {
        return this.getBaseDomainFactory().getCompetitorAndBoatStore().getOrCreateCompetitorWithBoat((Serializable)uUID, competitorWithBoatDTO.getName(), competitorWithBoatDTO.getShortName(), competitorWithBoatDTO.getColor(), competitorWithBoatDTO.getEmail(), competitorWithBoatDTO.getFlagImageURL() == null ? null : new URI(competitorWithBoatDTO.getFlagImageURL()), dynamicTeam, competitorWithBoatDTO.getTimeOnTimeFactor(), competitorWithBoatDTO.getTimeOnDistanceAllowancePerNauticalMile(), competitorWithBoatDTO.getSearchTag(), dynamicBoat, true);
    }

    private /* synthetic */ DynamicCompetitor lambda$34(UUID uUID, CompetitorDTO competitorDTO, DynamicTeam dynamicTeam) throws Exception {
        return this.getBaseDomainFactory().getOrCreateCompetitor((Serializable)uUID, competitorDTO.getName(), competitorDTO.getShortName(), competitorDTO.getColor(), competitorDTO.getEmail(), competitorDTO.getFlagImageURL() == null ? null : new URI(competitorDTO.getFlagImageURL()), dynamicTeam, competitorDTO.getTimeOnTimeFactor(), competitorDTO.getTimeOnDistanceAllowancePerNauticalMile(), competitorDTO.getSearchTag(), true);
    }
}

