/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LogEventTimeRangeWithFallbackFilter<E extends AbstractLogEvent<?>> {
    private final NavigableMap<TimePoint, E> filteredEvents;
    private final TimeRange timeRangeToInclude;

    public LogEventTimeRangeWithFallbackFilter(TimeRange timeRangeToInclude) {
        this.timeRangeToInclude = timeRangeToInclude;
        this.filteredEvents = new TreeMap();
    }

    public void addEvent(E event) {
        TimePoint currentFallbackAfter;
        TimePoint logicalTimePoint = event.getLogicalTimePoint();
        if (this.timeRangeToInclude.includes(logicalTimePoint)) {
            this.filteredEvents.put(logicalTimePoint, event);
        } else if (logicalTimePoint.before(this.timeRangeToInclude.from())) {
            TimePoint currentFallbackBefore = this.filteredEvents.lowerKey(this.timeRangeToInclude.from());
            if (currentFallbackBefore == null || logicalTimePoint.after(currentFallbackBefore)) {
                if (currentFallbackBefore != null) {
                    this.filteredEvents.remove(currentFallbackBefore);
                }
                this.filteredEvents.put(logicalTimePoint, event);
            }
        } else if (logicalTimePoint.after(this.timeRangeToInclude.to()) && ((currentFallbackAfter = this.filteredEvents.higherKey(this.timeRangeToInclude.to())) == null || logicalTimePoint.before(currentFallbackAfter))) {
            if (currentFallbackAfter != null) {
                this.filteredEvents.remove(currentFallbackAfter);
            }
            this.filteredEvents.put(logicalTimePoint, event);
        }
    }

    public Iterable<E> getFilteredEvents() {
        return this.filteredEvents.values();
    }
}

