/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.gwt.common.authentication.FixedSailingAuthentication;
import com.sap.sailing.gwt.common.authentication.SailingHeaderWithAuthentication;
import com.sap.sailing.gwt.common.communication.routing.ProvidesLeaderboardRouting;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardContextDefinition;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiCompetitorLeaderboardChartSettings;
import com.sap.sailing.gwt.settings.client.utils.StoredSettingsLocationFactory;
import com.sap.sailing.gwt.ui.client.AbstractSailingReadEntryPoint;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.settings.SettingsToUrlSerializer;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import com.sap.sse.security.ui.settings.StoredSettingsLocation;
import java.util.UUID;
import java.util.logging.Logger;

public class LeaderboardEntryPoint
extends AbstractSailingReadEntryPoint
implements ProvidesLeaderboardRouting {
    public static final long DEFAULT_REFRESH_INTERVAL_MILLIS = 3000L;
    private static final Logger logger = Logger.getLogger(LeaderboardEntryPoint.class.getName());
    private StringMessages stringmessages = StringMessages.INSTANCE;
    private UUID eventId;
    private String leaderboardName;
    private AbstractLeaderboardDTO leaderboardDTO;
    private LeaderboardContextDefinition leaderboardContextDefinition;

    protected void doOnModuleLoad() {
        super.doOnModuleLoad();
        this.leaderboardContextDefinition = (LeaderboardContextDefinition)new SettingsToUrlSerializer().deserializeFromCurrentLocation((GenericSerializableSettings)new LeaderboardContextDefinition());
        this.eventId = this.leaderboardContextDefinition.getEventId();
        this.leaderboardName = this.leaderboardContextDefinition.getLeaderboardName();
        if (this.leaderboardName != null) {
            if (this.eventId == null) {
                this.checkLeaderboardNameAndCreateUI();
            } else {
                this.getSailingService().getEventById(this.eventId, false, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
            }
        } else {
            RootPanel.get().add((Widget)new Label(((StringMessages)this.getStringMessages()).noSuchLeaderboard()));
        }
    }

    private void checkLeaderboardNameAndCreateUI() {
        if (this.leaderboardDTO == null) {
            this.getSailingService().getLeaderboard(this.leaderboardName, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        } else {
            this.loadSettingsAndCreateUI();
        }
    }

    private void loadSettingsAndCreateUI() {
        long delayBetweenAutoAdvancesInMilliseconds = 3000L;
        Timer timer = new Timer(Timer.PlayModes.Live, Timer.PlayStates.Paused, delayBetweenAutoAdvancesInMilliseconds);
        StoredSettingsLocation storageDefinition = StoredSettingsLocationFactory.createStoredSettingsLocatorForLeaderboard((LeaderboardContextDefinition)this.leaderboardContextDefinition);
        this.getSailingService().getAvailableDetailTypesForLeaderboard(this.leaderboardName, null, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private DetailType getActualChartDetailType(PerspectiveCompositeSettings<LeaderboardPerspectiveOwnSettings> settings) {
        DetailType chartDetailType;
        MultiCompetitorLeaderboardChartSettings chartSettings = (MultiCompetitorLeaderboardChartSettings)settings.findSettingsByComponentId("lbc");
        DetailType detailType = chartDetailType = chartSettings == null ? null : chartSettings.getDetailType();
        if (chartDetailType == DetailType.REGATTA_NET_POINTS_SUM) {
            return chartDetailType;
        }
        return MultiCompetitorLeaderboardChartSettings.getDefaultDetailType((boolean)this.leaderboardDTO.type.isMetaLeaderboard());
    }

    private void createUi(Widget leaderboardViewer, PerspectiveCompositeSettings<LeaderboardPerspectiveOwnSettings> settings, Timer timer, LeaderboardContextDefinition leaderboardContextSettings) {
        LeaderboardPerspectiveOwnSettings ownSettings = (LeaderboardPerspectiveOwnSettings)settings.getPerspectiveOwnSettings();
        DockLayoutPanel mainPanel = new DockLayoutPanel(Style.Unit.PX);
        RootLayoutPanel.get().add((Widget)mainPanel);
        if (!ownSettings.isEmbedded()) {
            String leaderboardDisplayName = leaderboardContextSettings.getDisplayName();
            if (leaderboardDisplayName == null || leaderboardDisplayName.isEmpty()) {
                leaderboardDisplayName = this.leaderboardName;
            }
            SailingHeaderWithAuthentication header = new SailingHeaderWithAuthentication(leaderboardDisplayName);
            PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
            new FixedSailingAuthentication(this.getUserService(), (PaywallResolver)paywallResolver, header.getAuthenticationMenuView());
            mainPanel.addNorth((Widget)header, 75.0);
        }
        mainPanel.add((Widget)new ScrollPanel(leaderboardViewer));
    }

    protected void configureWithSettings(PerspectiveCompositeSettings<LeaderboardPerspectiveOwnSettings> settings, Timer timer) {
        LeaderboardPerspectiveOwnSettings perspectiveOwnSettings = (LeaderboardPerspectiveOwnSettings)settings.getPerspectiveOwnSettings();
        String zoomTo = perspectiveOwnSettings.getZoomTo();
        if (zoomTo != null) {
            RootPanel.getBodyElement().setAttribute("style", "zoom: " + zoomTo + ";-moz-transform: scale(" + zoomTo + ");-moz-transform-origin: 0 0;-o-transform: scale(" + zoomTo + ");-o-transform-origin: 0 0;-webkit-transform: scale(" + zoomTo + ");-webkit-transform-origin: 0 0;");
        }
        if (perspectiveOwnSettings.isLifePlay()) {
            timer.setPlayMode(Timer.PlayModes.Live);
        }
    }

    public String getLeaderboardName() {
        return this.leaderboardName;
    }

    static /* synthetic */ UUID access$0(LeaderboardEntryPoint leaderboardEntryPoint) {
        return leaderboardEntryPoint.eventId;
    }

    static /* synthetic */ String access$1(LeaderboardEntryPoint leaderboardEntryPoint) {
        return leaderboardEntryPoint.leaderboardName;
    }

    static /* synthetic */ void access$2(LeaderboardEntryPoint leaderboardEntryPoint, AbstractLeaderboardDTO abstractLeaderboardDTO) {
        leaderboardEntryPoint.leaderboardDTO = abstractLeaderboardDTO;
    }

    static /* synthetic */ void access$3(LeaderboardEntryPoint leaderboardEntryPoint) {
        leaderboardEntryPoint.checkLeaderboardNameAndCreateUI();
    }

    static /* synthetic */ void access$4(LeaderboardEntryPoint leaderboardEntryPoint) {
        leaderboardEntryPoint.loadSettingsAndCreateUI();
    }

    static /* synthetic */ com.sap.sse.gwt.client.StringMessages access$5(LeaderboardEntryPoint leaderboardEntryPoint) {
        return leaderboardEntryPoint.getStringMessages();
    }

    static /* synthetic */ Logger access$6() {
        return logger;
    }

    static /* synthetic */ AbstractLeaderboardDTO access$7(LeaderboardEntryPoint leaderboardEntryPoint) {
        return leaderboardEntryPoint.leaderboardDTO;
    }

    static /* synthetic */ StringMessages access$8(LeaderboardEntryPoint leaderboardEntryPoint) {
        return leaderboardEntryPoint.stringmessages;
    }

    static /* synthetic */ DetailType access$9(LeaderboardEntryPoint leaderboardEntryPoint, PerspectiveCompositeSettings perspectiveCompositeSettings) {
        return leaderboardEntryPoint.getActualChartDetailType(perspectiveCompositeSettings);
    }

    static /* synthetic */ LeaderboardContextDefinition access$10(LeaderboardEntryPoint leaderboardEntryPoint) {
        return leaderboardEntryPoint.leaderboardContextDefinition;
    }

    static /* synthetic */ void access$11(LeaderboardEntryPoint leaderboardEntryPoint, Widget widget, PerspectiveCompositeSettings perspectiveCompositeSettings, Timer timer, LeaderboardContextDefinition leaderboardContextDefinition) {
        leaderboardEntryPoint.createUi(widget, perspectiveCompositeSettings, timer, leaderboardContextDefinition);
    }

    static /* synthetic */ SailingServiceAsync access$12(LeaderboardEntryPoint leaderboardEntryPoint) {
        return leaderboardEntryPoint.getSailingService();
    }
}

