/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.ImageResourceRenderer;
import com.sap.sailing.gwt.ui.leaderboard.ExpandableSortableColumn;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardResources;

public class ExpandCollapseButtonCell
extends AbstractCell<SafeHtml> {
    private static final LeaderboardResources leaderboardResources = (LeaderboardResources)GWT.create(LeaderboardResources.class);
    private final SafeHtml html;
    private final ActionCell.Delegate<SafeHtml> delegate;
    private final ExpandableSortableColumn<?> column;

    public ExpandCollapseButtonCell(ExpandableSortableColumn<?> column, ActionCell.Delegate<SafeHtml> delegate) {
        super(new String[]{"click", "keydown"});
        this.column = column;
        this.delegate = delegate;
        ImageResourceRenderer imgRenderer = new ImageResourceRenderer();
        ImageResource imgResource = column.isExpanded() ? leaderboardResources.minusIcon() : leaderboardResources.plusIcon();
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.appendHtmlConstant("<div class=\"openColumn\" isExpanded=\"" + Boolean.toString(column.isExpanded()) + "\">");
        sb.append(imgRenderer.render(imgResource));
        sb.appendHtmlConstant("</div>");
        this.html = sb.toSafeHtml();
    }

    public void onBrowserEvent(Cell.Context context, Element parent, SafeHtml value, NativeEvent event, ValueUpdater<SafeHtml> valueUpdater) {
        EventTarget eventTarget;
        this.column.suppressSortingOnce();
        super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
        if ("click".equals(event.getType()) && Element.is((JavaScriptObject)(eventTarget = event.getEventTarget())) && parent.getFirstChildElement().isOrHasChild((Node)Element.as((JavaScriptObject)eventTarget)) && !this.column.isTogglingInProcess()) {
            this.onEnterKeyDown(context, parent, value, event, valueUpdater);
        }
    }

    public void render(Cell.Context context, SafeHtml value, SafeHtmlBuilder sb) {
        sb.append(this.html);
    }

    protected void onEnterKeyDown(Cell.Context context, Element parent, SafeHtml value, NativeEvent event, ValueUpdater<SafeHtml> valueUpdater) {
        this.delegate.execute((Object)value);
    }
}

