/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap.maneuver;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.gwt.ui.client.ManeuverTypeFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTableSettings;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ManeuverTableSettingsDialogComponent
implements SettingsDialogComponent<ManeuverTableSettings> {
    private final Map<ManeuverType, CheckBox> maneuverType = new HashMap();
    private final ManeuverTableSettings initialSettings;
    private final StringMessages stringMessages;

    public ManeuverTableSettingsDialogComponent(ManeuverTableSettings initialSettings, StringMessages stringMessages) {
        this.stringMessages = stringMessages;
        this.initialSettings = initialSettings;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel contentPanel = new VerticalPanel();
        Label label = dialog.createHeadlineLabel(this.stringMessages.maneuverTypesToShowWhenCompetitorIsClicked());
        label.getElement().getStyle().clearPaddingTop();
        contentPanel.add((Widget)label);
        ManeuverType[] maneuverTypeArray = ManeuverType.values();
        int n = maneuverTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManeuverType maneuvertype = maneuverTypeArray[n2];
            CheckBox checkbox = dialog.createCheckbox(ManeuverTypeFormatter.format((ManeuverType)maneuvertype, (StringMessages)this.stringMessages));
            checkbox.setValue(Boolean.valueOf(this.initialSettings.getSelectedManeuverTypes().contains(maneuvertype)));
            contentPanel.add((Widget)checkbox);
            this.maneuverType.put(maneuvertype, checkbox);
            ++n2;
        }
        return contentPanel;
    }

    public ManeuverTableSettings getResult() {
        HashSet<ManeuverType> selectedManeuverTypes = new HashSet<ManeuverType>();
        for (Map.Entry entry : this.maneuverType.entrySet()) {
            if (!((CheckBox)entry.getValue()).getValue().booleanValue()) continue;
            selectedManeuverTypes.add((ManeuverType)entry.getKey());
        }
        return new ManeuverTableSettings(selectedManeuverTypes);
    }

    public DataEntryDialog.Validator<ManeuverTableSettings> getValidator() {
        return null;
    }

    public FocusWidget getFocusWidget() {
        return (FocusWidget)this.maneuverType.values().iterator().next();
    }
}

