/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.TagFilterSets;
import com.sap.sailing.gwt.ui.client.shared.filter.TagFilterSetsDialog;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.List;

public class TagFilterSetsDialog
extends DataEntryDialog<TagFilterSets> {
    private final TagFilterSets tagFilterSets;
    private final StringMessages stringMessages;
    private final Button addFilterSetButton;
    private Grid tagFilterSetsGrid;
    private VerticalPanel mainPanel;
    private final List<String> availableTagFilterNames;
    private final List<RadioButton> activeFilterSetRadioButtons;
    private final List<Button> editFilterSetButtons;
    private final List<Button> deleteFilterSetButtons;
    private final List<FilterSet<TagDTO, FilterWithUI<TagDTO>>> filterSets;
    private final String ACTIVE_FILTERSET_RADIOBUTTON_GROUPNAME = "ActiveFilterSetRB";
    private final String filterNothingFiltersetName;
    private final UserService userService;

    public TagFilterSetsDialog(TagFilterSets tagFilterSets, StringMessages stringMessages, DataEntryDialog.DialogCallback<TagFilterSets> callback, UserService userService) {
        super(stringMessages.tagsFilter(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new TagsFilterSetsValidator(), callback);
        this.userService = userService;
        this.tagFilterSets = tagFilterSets;
        this.stringMessages = stringMessages;
        this.filterNothingFiltersetName = stringMessages.filterNothing();
        this.tagFilterSetsGrid = new Grid(0, 0);
        this.activeFilterSetRadioButtons = new ArrayList();
        this.editFilterSetButtons = new ArrayList();
        this.deleteFilterSetButtons = new ArrayList();
        this.filterSets = new ArrayList();
        this.addFilterSetButton = new Button(stringMessages.actionAddFilter());
        this.addFilterSetButton.addStyleName("btn-secondary");
        this.availableTagFilterNames = new ArrayList();
        this.availableTagFilterNames.add("TagTagFilter");
        this.availableTagFilterNames.add("TagUsernameFilter");
    }

    protected Widget getAdditionalWidget() {
        this.mainPanel = new VerticalPanel();
        if (this.userService.getCurrentUser() == null) {
            Label notLoggedInLabel = new Label(this.stringMessages.tagCreateFilterNotLoggedIn());
            notLoggedInLabel.getElement().getStyle().setColor("red");
            this.mainPanel.add((Widget)notLoggedInLabel);
        }
        String headLineText = this.tagFilterSets.getFilterSets().size() < 1 ? this.stringMessages.tagCreateFilterHint() : this.stringMessages.availableFilters();
        this.mainPanel.add((Widget)new Label(headLineText));
        this.mainPanel.add((Widget)this.tagFilterSetsGrid);
        FilterSet noFilterSet = new FilterSet(this.filterNothingFiltersetName);
        this.createActiveFilterSetRadioButton(noFilterSet, this.tagFilterSets.getActiveFilterSet() == null);
        Button noFilterSetEditBtn = this.createEditFilterSetButton(noFilterSet);
        Button noFilterSetDeleteBtn = this.createDeleteFilterSetButton(noFilterSet);
        this.filterSets.add(noFilterSet);
        noFilterSetEditBtn.setVisible(false);
        noFilterSetDeleteBtn.setVisible(false);
        for (FilterSet filterSet : this.tagFilterSets.getFilterSets()) {
            this.createActiveFilterSetRadioButton(filterSet, this.tagFilterSets.getActiveFilterSet() == filterSet);
            this.createEditFilterSetButton(filterSet);
            this.createDeleteFilterSetButton(filterSet);
            this.filterSets.add(filterSet);
        }
        this.updateTagsFilterSetsGrid(this.mainPanel);
        this.mainPanel.add((Widget)this.addFilterSetButton);
        this.addFilterSetButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return this.mainPanel;
    }

    private RadioButton createActiveFilterSetRadioButton(FilterSet<TagDTO, FilterWithUI<TagDTO>> filterSet, boolean isActiveFilterSet) {
        RadioButton activeFilterSetRadioButton = this.createRadioButton("ActiveFilterSetRB", filterSet.getName());
        activeFilterSetRadioButton.setValue(Boolean.valueOf(isActiveFilterSet));
        this.activeFilterSetRadioButtons.add(activeFilterSetRadioButton);
        return activeFilterSetRadioButton;
    }

    private Button createEditFilterSetButton(FilterSet<TagDTO, FilterWithUI<TagDTO>> filterSetToEdit) {
        Button editFilterSetBtn = new Button(this.stringMessages.edit());
        String filterSetToEditName = filterSetToEdit.getName();
        editFilterSetBtn.addStyleName("inlineButton");
        editFilterSetBtn.addStyleName("btn-secondary");
        editFilterSetBtn.setVisible(filterSetToEdit.isEditable());
        this.editFilterSetButtons.add(editFilterSetBtn);
        editFilterSetBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return editFilterSetBtn;
    }

    private Button createDeleteFilterSetButton(FilterSet<TagDTO, FilterWithUI<TagDTO>> filterSet) {
        Button deleteFilterSetBtn = new Button(this.stringMessages.delete());
        deleteFilterSetBtn.addStyleName("inlineButton");
        deleteFilterSetBtn.addStyleName("btn-secondary");
        deleteFilterSetBtn.setVisible(filterSet.isEditable());
        this.deleteFilterSetButtons.add(deleteFilterSetBtn);
        deleteFilterSetBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return deleteFilterSetBtn;
    }

    protected TagFilterSets getResult() {
        TagFilterSets result = new TagFilterSets();
        int filterSetCount = this.activeFilterSetRadioButtons.size();
        int i = 0;
        while (i < filterSetCount) {
            FilterSet filterSet = (FilterSet)this.filterSets.get(i);
            boolean isActiveFilterSet = ((RadioButton)this.activeFilterSetRadioButtons.get(i)).getValue();
            if (!filterSet.getName().equals(this.filterNothingFiltersetName)) {
                result.addFilterSet(filterSet);
                if (isActiveFilterSet) {
                    result.setActiveFilterSet(filterSet);
                }
            } else if (isActiveFilterSet) {
                result.setActiveFilterSet(null);
            }
            ++i;
        }
        return result;
    }

    private void updateTagsFilterSetsGrid(VerticalPanel parentPanel) {
        int widgetIndex = parentPanel.getWidgetIndex((Widget)this.tagFilterSetsGrid);
        parentPanel.remove((Widget)this.tagFilterSetsGrid);
        int filterCount = this.activeFilterSetRadioButtons.size();
        if (filterCount > 0) {
            this.tagFilterSetsGrid = new Grid(filterCount, 3);
            this.tagFilterSetsGrid.setCellSpacing(3);
            int i = 0;
            while (i < filterCount) {
                this.tagFilterSetsGrid.setWidget(i, 0, (Widget)this.activeFilterSetRadioButtons.get(i));
                this.tagFilterSetsGrid.setWidget(i, 1, (Widget)this.editFilterSetButtons.get(i));
                this.tagFilterSetsGrid.setWidget(i, 2, (Widget)this.deleteFilterSetButtons.get(i));
                this.tagFilterSetsGrid.getCellFormatter().setVerticalAlignment(i, 0, HasVerticalAlignment.ALIGN_MIDDLE);
                this.tagFilterSetsGrid.getCellFormatter().setVerticalAlignment(i, 1, HasVerticalAlignment.ALIGN_MIDDLE);
                this.tagFilterSetsGrid.getCellFormatter().setVerticalAlignment(i, 2, HasVerticalAlignment.ALIGN_MIDDLE);
                ++i;
            }
        } else {
            this.tagFilterSetsGrid = new Grid(0, 0);
        }
        parentPanel.insert((Widget)this.tagFilterSetsGrid, widgetIndex);
    }

    static /* synthetic */ List access$1(TagFilterSetsDialog tagFilterSetsDialog) {
        return tagFilterSetsDialog.availableTagFilterNames;
    }

    static /* synthetic */ StringMessages access$2(TagFilterSetsDialog tagFilterSetsDialog) {
        return tagFilterSetsDialog.stringMessages;
    }

    static /* synthetic */ RadioButton access$3(TagFilterSetsDialog tagFilterSetsDialog, FilterSet filterSet, boolean bl) {
        return tagFilterSetsDialog.createActiveFilterSetRadioButton(filterSet, bl);
    }

    static /* synthetic */ Button access$4(TagFilterSetsDialog tagFilterSetsDialog, FilterSet filterSet) {
        return tagFilterSetsDialog.createEditFilterSetButton(filterSet);
    }

    static /* synthetic */ Button access$5(TagFilterSetsDialog tagFilterSetsDialog, FilterSet filterSet) {
        return tagFilterSetsDialog.createDeleteFilterSetButton(filterSet);
    }

    static /* synthetic */ List access$6(TagFilterSetsDialog tagFilterSetsDialog) {
        return tagFilterSetsDialog.filterSets;
    }

    static /* synthetic */ VerticalPanel access$7(TagFilterSetsDialog tagFilterSetsDialog) {
        return tagFilterSetsDialog.mainPanel;
    }

    static /* synthetic */ void access$8(TagFilterSetsDialog tagFilterSetsDialog, VerticalPanel verticalPanel) {
        tagFilterSetsDialog.updateTagsFilterSetsGrid(verticalPanel);
    }

    static /* synthetic */ void access$9(TagFilterSetsDialog tagFilterSetsDialog) {
        tagFilterSetsDialog.validateAndUpdate();
    }

    static /* synthetic */ List access$10(TagFilterSetsDialog tagFilterSetsDialog) {
        return tagFilterSetsDialog.activeFilterSetRadioButtons;
    }

    static /* synthetic */ List access$11(TagFilterSetsDialog tagFilterSetsDialog) {
        return tagFilterSetsDialog.editFilterSetButtons;
    }

    static /* synthetic */ List access$12(TagFilterSetsDialog tagFilterSetsDialog) {
        return tagFilterSetsDialog.deleteFilterSetButtons;
    }
}

