/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.dom.client.MediaElement;
import com.google.gwt.dom.client.VideoElement;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.media.client.Video;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.FileStorageServiceConnectionTestObservable;
import com.sap.sailing.gwt.ui.client.MediaServiceAsync;
import com.sap.sailing.gwt.ui.client.MediaServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.FloatingMediaPlayerContainer;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerContainer;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerLifecycle;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerManager;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerManagerComponent;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerSettings;
import com.sap.sailing.gwt.ui.client.media.NewMediaDialog;
import com.sap.sailing.gwt.ui.client.media.PopoutListener;
import com.sap.sailing.gwt.ui.client.media.PopupPositionProvider;
import com.sap.sailing.gwt.ui.client.media.VideoJSSyncPlayer;
import com.sap.sailing.gwt.ui.client.media.VideoYoutubePlayer;
import com.sap.sailing.gwt.ui.client.media.popup.PopoutWindowPlayer;
import com.sap.sailing.gwt.ui.client.media.shared.MediaPlayer;
import com.sap.sailing.gwt.ui.client.media.shared.MediaSynchPlayer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.MediaType;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.formfactor.DeviceDetector;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.client.player.PlayStateListener;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.AbstractComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.gwt.client.useragent.UserAgentDetails;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class MediaPlayerManagerComponent
extends AbstractComponent<MediaPlayerSettings>
implements PlayStateListener,
TimeListener,
MediaPlayerManager,
CloseHandler<Window>,
Window.ClosingHandler {
    private final SimplePanel rootPanel = new SimplePanel();
    private final UserService userService;
    private final Map<MediaTrack, MediaPlayerContainer> activePlayerContainers = new HashMap();
    private Collection<MediaTrackWithSecurityDTO> assignedMediaTracks = new ArrayList();
    private Collection<MediaTrackWithSecurityDTO> overlappingMediaTracks = new ArrayList();
    private Map<MediaTrack, MediaPlayerManager.Status> mediaTrackStatus = new HashMap();
    private final RegattaAndRaceIdentifier raceIdentifier;
    private final RaceTimesInfoProvider raceTimesInfoProvider;
    private final Timer raceTimer;
    private final MediaServiceAsync mediaService;
    private final MediaServiceWriteAsync mediaServiceWrite;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private final UserAgentDetails userAgent;
    private final PopupPositionProvider popupPositionProvider;
    private MediaPlayerSettings settings;
    private final MediaPlayerLifecycle mediaPlayerLifecycle;
    private final RaceDTO raceDto;
    private final FileStorageServiceConnectionTestObservable storageServiceAvailable;
    private List<MediaPlayerManager.PlayerChangeListener> playerChangeListener = new ArrayList();
    private UUID eventId;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes;

    public MediaPlayerManagerComponent(Component<?> parent, ComponentContext<?> context, MediaPlayerLifecycle mediaPlayerLifecycle, SailingServiceWriteAsync sailingServiceWrite, RegattaAndRaceIdentifier selectedRaceIdentifier, RaceTimesInfoProvider raceTimesInfoProvider, Timer raceTimer, MediaServiceAsync mediaService, MediaServiceWriteAsync mediaServiceWrite, UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, UserAgentDetails userAgent, PopupPositionProvider popupPositionProvider, MediaPlayerSettings settings, RaceDTO raceDto, String leaderboardGroupName, UUID eventId) {
        super(parent, context);
        this.eventId = eventId;
        this.mediaPlayerLifecycle = mediaPlayerLifecycle;
        this.userService = userService;
        this.raceIdentifier = selectedRaceIdentifier;
        this.raceTimesInfoProvider = raceTimesInfoProvider;
        this.raceTimer = raceTimer;
        this.raceDto = raceDto;
        this.raceTimer.addPlayStateListener((PlayStateListener)this);
        this.raceTimer.addTimeListener((TimeListener)this);
        this.playSpeedFactorChanged(raceTimer.getPlaySpeedFactor());
        this.timeChanged(raceTimer.getTime(), null);
        this.playStateChanged(raceTimer.getPlayState(), raceTimer.getPlayMode());
        this.mediaService = mediaService;
        this.mediaServiceWrite = mediaServiceWrite;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        this.userAgent = userAgent;
        this.popupPositionProvider = popupPositionProvider;
        this.settings = settings;
        this.storageServiceAvailable = new FileStorageServiceConnectionTestObservable(sailingServiceWrite);
        Window.addWindowClosingHandler((Window.ClosingHandler)this);
        userService.addUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */, true);
    }

    private boolean isPotentiallyPlayable(MediaTrack mediaTrack) {
        MediaPlayerManager.Status status = (MediaPlayerManager.Status)this.mediaTrackStatus.get(mediaTrack);
        return MediaPlayerManager.Status.REACHABLE.equals((Object)status) || MediaPlayerManager.Status.UNDEFINED.equals((Object)status);
    }

    private void setStatus(MediaTrack mediaTrack) {
        if (mediaTrack.isYoutube()) {
            this.mediaTrackStatus.put(mediaTrack, MediaPlayerManager.Status.REACHABLE);
        } else {
            Video video = Video.createIfSupported();
            if (video != null) {
                VideoElement mediaReachableTester = video.getVideoElement();
                this.addLoadMetadataHandler((MediaElement)mediaReachableTester, mediaTrack);
                mediaReachableTester.setPreload("metadata");
                mediaReachableTester.setSrc(UriUtils.fromString((String)mediaTrack.url).asString());
                mediaReachableTester.load();
            } else {
                this.mediaTrackStatus.put(mediaTrack, MediaPlayerManager.Status.CANNOT_PLAY);
            }
        }
    }

    native void addLoadMetadataHandler(MediaElement var1, MediaTrack var2);

    public void loadedmetadata(MediaTrack mediaTrack) {
        this.mediaTrackStatus.put(mediaTrack, MediaPlayerManager.Status.REACHABLE);
    }

    public void mediaError(MediaTrack mediaTrack) {
        this.mediaTrackStatus.put(mediaTrack, MediaPlayerManager.Status.NOT_REACHABLE);
    }

    public void playDefault() {
        MediaTrackWithSecurityDTO defaultVideo = this.getDefaultMedia(MediaType.video);
        if (defaultVideo != null) {
            this.playFloatingVideo(defaultVideo);
        } else {
            MediaTrackWithSecurityDTO defaultAudio = this.getDefaultMedia(MediaType.audio);
            if (defaultAudio != null) {
                this.playAudio(defaultAudio);
            }
        }
    }

    private MediaTrackWithSecurityDTO getDefaultMedia(MediaType mediaType) {
        for (MediaTrackWithSecurityDTO mediaTrack : this.assignedMediaTracks) {
            if (mediaTrack.mimeType == null || !mediaType.equals((Object)mediaTrack.mimeType.mediaType) || !this.getMediaTrackStatus((MediaTrack)mediaTrack).isPotentiallyPlayable()) continue;
            return mediaTrack;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public void playStateChanged(Timer.PlayStates playState, Timer.PlayModes playMode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void playSpeedFactorChanged(double newPlaySpeedFactor) {
        for (MediaPlayerContainer videoContainer : this.activePlayerContainers.values()) {
            MediaPlayer videoPlayer = videoContainer.getMediaPlayer();
            videoPlayer.setPlaybackSpeed(newPlaySpeedFactor);
        }
    }

    private void pausePlaying() {
        for (MediaPlayerContainer videoContainer : this.activePlayerContainers.values()) {
            MediaPlayer videoPlayer = videoContainer.getMediaPlayer();
            if (videoPlayer.isMediaPaused()) continue;
            videoPlayer.pauseMedia();
        }
    }

    private void startPlaying() {
        for (MediaPlayerContainer videoContainer : this.activePlayerContainers.values()) {
            MediaPlayer videoPlayer = videoContainer.getMediaPlayer();
            if (!videoPlayer.isMediaPaused() || !videoPlayer.isCoveringCurrentRaceTime()) continue;
            videoPlayer.playMedia();
        }
    }

    public void timeChanged(Date newRaceTime, Date oldRaceTime) {
        for (MediaPlayerContainer videoContainer : this.activePlayerContainers.values()) {
            MediaPlayer videoPlayer = videoContainer.getMediaPlayer();
            this.ensurePlayState(videoPlayer);
            videoPlayer.raceTimeChanged(newRaceTime);
        }
    }

    private AsyncCallback<Iterable<MediaTrackWithSecurityDTO>> getAssignedMediaCallback() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private AsyncCallback<Iterable<MediaTrackWithSecurityDTO>> getOverlappingMediaCallback() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void notifyStateChange() {
        for (MediaPlayerManager.PlayerChangeListener listener : this.playerChangeListener) {
            listener.notifyStateChange();
        }
    }

    public void playAudio(MediaTrackWithSecurityDTO audioTrack) {
        this.muteAudio();
        this.playFloatingVideo(audioTrack);
        ((MediaPlayerContainer)this.activePlayerContainers.get(audioTrack)).getMediaPlayer().setMuted(false);
    }

    public List<MediaPlayerContainer> getActiveAudioContainers() {
        return this.activePlayerContainers.entrySet().stream().filter(f -> ((MediaTrack)f.getKey()).mimeType.mediaType == MediaType.audio).map(f -> (MediaPlayerContainer)f.getValue()).collect(Collectors.toList());
    }

    public void muteAudio() {
        for (MediaPlayerContainer player : this.getActiveAudioContainers()) {
            this.closeFloatingPlayer(player.getMediaPlayer().getMediaTrack());
        }
    }

    public void playFloatingVideo(MediaTrackWithSecurityDTO videoTrack) {
        MediaPlayerContainer activeVideoContainer = (MediaPlayerContainer)this.activePlayerContainers.get(videoTrack);
        if (activeVideoContainer == null) {
            FloatingMediaPlayerContainer videoFloatingContainer = (FloatingMediaPlayerContainer)this.createAndWrapVideoPlayer(videoTrack, (VideoContainerFactory)new /* Unavailable Anonymous Inner Class!! */);
            this.registerVideoContainer((MediaTrack)videoTrack, (MediaPlayerContainer)videoFloatingContainer);
            this.notifyStateChange();
        }
    }

    private <T> T createAndWrapVideoPlayer(MediaTrackWithSecurityDTO videoTrack, VideoContainerFactory<T> videoContainerFactory) {
        5 playerCloseListener = new /* Unavailable Anonymous Inner Class!! */;
        6 popoutListener = new /* Unavailable Anonymous Inner Class!! */;
        Object videoPlayer = videoTrack.isYoutube() ? new VideoYoutubePlayer(videoTrack, this.getRaceStartTime(), this.raceTimer, (TakedownNoticeService)this.userService, this.raceIdentifier) : new VideoJSSyncPlayer(videoTrack, this.getRaceStartTime(), this.raceTimer, (TakedownNoticeService)this.userService, this.raceIdentifier.toString(), this.eventId);
        return (T)videoContainerFactory.createVideoContainer((MediaSynchPlayer)videoPlayer, this.userService, this.getMediaServiceWrite(), this.errorReporter, (PopoutWindowPlayer.PlayerCloseListener)playerCloseListener, (PopoutListener)popoutListener);
    }

    private void registerVideoContainer(MediaTrack videoTrack, MediaPlayerContainer videoContainer) {
        MediaPlayer videoPlayer = videoContainer.getMediaPlayer();
        this.activePlayerContainers.put(videoTrack, videoContainer);
        this.synchPlayState(videoPlayer);
        this.notifyStateChange();
    }

    private TimePoint getRaceStartTime() {
        Date startOfRace = this.raceTimesInfoProvider.getRaceTimesInfo((RegattaAndRaceIdentifier)this.getCurrentRace()).startOfRace;
        if (startOfRace != null) {
            return new MillisecondsTimePoint(startOfRace);
        }
        return null;
    }

    private TimePoint getTrackingStartTime() {
        Date startOfTracking = this.raceTimesInfoProvider.getRaceTimesInfo((RegattaAndRaceIdentifier)this.getCurrentRace()).startOfTracking;
        if (startOfTracking != null) {
            return new MillisecondsTimePoint(startOfTracking);
        }
        return null;
    }

    private TimePoint getTrackingEndTime() {
        Date endOfTracking = this.raceTimesInfoProvider.getRaceTimesInfo((RegattaAndRaceIdentifier)this.getCurrentRace()).endOfTracking;
        if (endOfTracking != null) {
            return new MillisecondsTimePoint(endOfTracking);
        }
        return null;
    }

    private TimePoint getCurrentCursorTime() {
        Date raceTimerTime = this.raceTimer.getTime();
        if (raceTimerTime != null) {
            return new MillisecondsTimePoint(raceTimerTime);
        }
        return null;
    }

    public void closeFloatingPlayer(MediaTrackWithSecurityDTO videoTrack) {
        MediaPlayerContainer removedVideoContainer = (MediaPlayerContainer)this.activePlayerContainers.remove(videoTrack);
        if (removedVideoContainer != null) {
            removedVideoContainer.shutDown();
        }
        this.notifyStateChange();
    }

    private boolean isLive() {
        return this.raceTimer.getPlayMode() == Timer.PlayModes.Live;
    }

    private void synchPlayState(MediaPlayer mediaPlayer) {
        mediaPlayer.setPlaybackSpeed(this.raceTimer.getPlaySpeedFactor());
        this.ensurePlayState(mediaPlayer);
        mediaPlayer.raceTimeChanged(this.raceTimer.getTime());
    }

    /*
     * Exception decompiling
     */
    private void ensurePlayState(MediaPlayer mediaPlayer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onClose(CloseEvent<Window> arg0) {
        this.stopAll();
    }

    public void onWindowClosing(Window.ClosingEvent arg0) {
        this.stopAll();
    }

    public void stopAll() {
        for (MediaPlayerContainer mediaContainer : new ArrayList(this.activePlayerContainers.values())) {
            mediaContainer.shutDown();
        }
        this.activePlayerContainers.clear();
        this.notifyStateChange();
    }

    public void addMediaTrack() {
        TimePoint currentCursorTime = this.getCurrentCursorTime();
        TimePoint defaultStartTime = this.getTrackingEndTime() == null ? TimePoint.now() : (currentCursorTime != null ? currentCursorTime : this.getTrackingStartTime());
        NewMediaDialog dialog = new NewMediaDialog(this.mediaService, defaultStartTime, this.stringMessages, this.getCurrentRace(), this.storageServiceAvailable, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
        if (!DeviceDetector.isDesktop()) {
            dialog.openFileChooserDialog();
        }
    }

    public boolean deleteMediaTrack(MediaTrackWithSecurityDTO mediaTrack) {
        if (Window.confirm((String)this.stringMessages.reallyRemoveMediaTrack(mediaTrack.title))) {
            this.mediaServiceWrite.deleteMediaTrack((MediaTrack)mediaTrack, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            return true;
        }
        return false;
    }

    public boolean allowsEditing(MediaTrackWithSecurityDTO mediaTrack) {
        return this.userService.hasPermission((SecuredDTO)mediaTrack, (HasPermissions.Action)HasPermissions.DefaultActions.READ) && this.userService.hasPermission(this.getCurrentRaceDTO(), (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
    }

    public boolean allowsCreating() {
        return this.userService.hasCreatePermission(SecuredDomainType.MEDIA_TRACK) && this.userService.hasPermission(this.getCurrentRaceDTO(), (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
    }

    public Boolean isPlaying() {
        return !this.activePlayerContainers.isEmpty();
    }

    public void addPlayerChangeListener(MediaPlayerManager.PlayerChangeListener playerChangeListener) {
        this.playerChangeListener.add(playerChangeListener);
    }

    public Set<MediaTrack> getPlayingVideoTracks() {
        return this.activePlayerContainers.keySet();
    }

    public Collection<MediaTrackWithSecurityDTO> getAssignedMediaTracks() {
        return Collections.unmodifiableCollection(this.assignedMediaTracks);
    }

    public Collection<MediaTrackWithSecurityDTO> getOverlappingMediaTracks() {
        this.removeMediaTracksWhichAreInAssignedMediaTracks();
        return Collections.unmodifiableCollection(this.overlappingMediaTracks);
    }

    private void removeMediaTracksWhichAreInAssignedMediaTracks() {
        HashSet temp = new HashSet(this.overlappingMediaTracks);
        for (MediaTrack mediaTrack : temp) {
            if (!this.assignedMediaTracks.contains(mediaTrack)) continue;
            this.overlappingMediaTracks.remove(mediaTrack);
        }
    }

    public List<MediaTrack> getVideoTracks() {
        return this.getMediaTracks(MediaType.video);
    }

    public List<MediaTrack> getAudioTracks() {
        return this.getMediaTracks(MediaType.audio);
    }

    private List<MediaTrack> getMediaTracks(MediaType mediaType) {
        return this.assignedMediaTracks.stream().filter(mediaTrack -> mediaTrack.mimeType != null && mediaType == mediaTrack.mimeType.mediaType).collect(Collectors.toList());
    }

    public String getLocalizedShortName() {
        return this.mediaPlayerLifecycle.getLocalizedShortName();
    }

    public boolean hasSettings() {
        return this.mediaPlayerLifecycle.hasSettings();
    }

    public SettingsDialogComponent<MediaPlayerSettings> getSettingsDialogComponent(MediaPlayerSettings settings) {
        return this.mediaPlayerLifecycle.getSettingsDialogComponent(settings);
    }

    public void updateSettings(MediaPlayerSettings newSettings) {
        this.settings = newSettings;
    }

    public MediaPlayerSettings getSettings() {
        return this.settings;
    }

    public Widget getEntryWidget() {
        return this.rootPanel;
    }

    public boolean isVisible() {
        return this.rootPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.rootPanel.setVisible(visibility);
    }

    public String getDependentCssClassName() {
        return "media";
    }

    public UserAgentDetails getUserAgent() {
        return this.userAgent;
    }

    public RegattaAndRaceIdentifier getCurrentRace() {
        return this.raceIdentifier;
    }

    public MediaServiceAsync getMediaService() {
        return this.mediaService;
    }

    public MediaServiceWriteAsync getMediaServiceWrite() {
        return this.mediaServiceWrite;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public String getId() {
        return this.mediaPlayerLifecycle.getComponentId();
    }

    public Set<MediaTrackWithSecurityDTO> getPlayingAudioTrack() {
        return this.getActiveAudioContainers().stream().map(f -> f.getMediaPlayer().getMediaTrack()).collect(Collectors.toSet());
    }

    public MediaPlayerManager.Status getMediaTrackStatus(MediaTrack track) {
        return this.mediaTrackStatus.getOrDefault(track, MediaPlayerManager.Status.UNDEFINED);
    }

    public SecuredDTO getCurrentRaceDTO() {
        return this.raceDto;
    }

    static /* synthetic */ AsyncCallback access$3(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.getAssignedMediaCallback();
    }

    static /* synthetic */ AsyncCallback access$4(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.getOverlappingMediaCallback();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates() {
        if ($SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates != null) {
            return $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates;
        }
        int[] nArray = new int[Timer.PlayStates.values().length];
        try {
            nArray[Timer.PlayStates.Paused.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Timer.PlayStates.Playing.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes() {
        if ($SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes != null) {
            return $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes;
        }
        int[] nArray = new int[Timer.PlayModes.values().length];
        try {
            nArray[Timer.PlayModes.Live.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Timer.PlayModes.Replay.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes = nArray;
        return nArray;
    }

    static /* synthetic */ void access$7(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        mediaPlayerManagerComponent.notifyStateChange();
    }

    static /* synthetic */ ErrorReporter access$8(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.errorReporter;
    }

    static /* synthetic */ StringMessages access$9(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.stringMessages;
    }

    static /* synthetic */ Collection access$10(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.assignedMediaTracks;
    }

    static /* synthetic */ void access$11(MediaPlayerManagerComponent mediaPlayerManagerComponent, MediaTrack mediaTrack) {
        mediaPlayerManagerComponent.setStatus(mediaTrack);
    }

    static /* synthetic */ MediaPlayerSettings access$12(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.settings;
    }

    static /* synthetic */ Collection access$13(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.overlappingMediaTracks;
    }

    static /* synthetic */ PopupPositionProvider access$14(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.popupPositionProvider;
    }

    static /* synthetic */ void access$15(MediaPlayerManagerComponent mediaPlayerManagerComponent, MediaTrack mediaTrack, MediaPlayerContainer mediaPlayerContainer) {
        mediaPlayerManagerComponent.registerVideoContainer(mediaTrack, mediaPlayerContainer);
    }

    static /* synthetic */ RegattaAndRaceIdentifier access$16(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.raceIdentifier;
    }

    static /* synthetic */ UUID access$17(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.eventId;
    }

    static /* synthetic */ MediaServiceWriteAsync access$18(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return mediaPlayerManagerComponent.mediaServiceWrite;
    }
}

