/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.gwt.ui.adminconsole.FileStorageServiceConnectionTestObservable;
import com.sap.sailing.gwt.ui.adminconsole.VideoConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.VideoCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.VideoEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.VideosListComposite;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.ImagesBarColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.media.VideoDTO;
import java.util.Comparator;
import java.util.List;

public class VideosListComposite
extends Composite {
    private final StringMessages stringMessages;
    private CellTable<VideoDTO> videoTable;
    private SingleSelectionModel<VideoDTO> videoSelectionModel;
    private ListDataProvider<VideoDTO> videoListDataProvider;
    private final Label noVideosLabel;
    private final FileStorageServiceConnectionTestObservable storageServiceAvailable;
    private final SimplePanel mainPanel;
    private final VerticalPanel panel;
    private static AnchorTemplates ANCHORTEMPLATE = (AnchorTemplates)GWT.create(AnchorTemplates.class);
    private final AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);

    public VideosListComposite(StringMessages stringMessages, FileStorageServiceConnectionTestObservable storageServiceAvailable) {
        this.stringMessages = stringMessages;
        this.storageServiceAvailable = storageServiceAvailable;
        this.mainPanel = new SimplePanel();
        this.panel = new VerticalPanel();
        this.mainPanel.setWidget((Widget)this.panel);
        HorizontalPanel videosControlsPanel = new HorizontalPanel();
        videosControlsPanel.setSpacing(5);
        this.panel.add((Widget)videosControlsPanel);
        Button createVideoBtn = new Button("Add gallery video");
        createVideoBtn.ensureDebugId("addVideoBtn");
        createVideoBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        videosControlsPanel.add((Widget)createVideoBtn);
        Button addLiveStreamBtn = new Button("Add livestream video");
        addLiveStreamBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        videosControlsPanel.add((Widget)addLiveStreamBtn);
        Button addHighlightBtn = new Button("Add highlight video");
        addHighlightBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        videosControlsPanel.add((Widget)addHighlightBtn);
        this.videoSelectionModel = new SingleSelectionModel();
        this.videoListDataProvider = new ListDataProvider();
        this.videoTable = this.createVideosTable();
        this.videoTable.ensureDebugId("VideosCellTable");
        this.videoTable.setVisible(false);
        this.videoSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.panel.add((Widget)this.videoTable);
        this.noVideosLabel = new Label("No videos defined yet.");
        this.noVideosLabel.ensureDebugId("NoVideosLabel");
        this.noVideosLabel.setWordWrap(false);
        this.panel.add((Widget)this.noVideosLabel);
        this.initWidget((Widget)this.mainPanel);
    }

    private CellTable<VideoDTO> createVideosTable() {
        BaseCelltable table = new BaseCelltable(10000, (CellTable.Resources)this.tableRes);
        this.videoListDataProvider.addDataDisplay((HasData)table);
        table.setWidth("100%");
        AnchorCell anchorCell = new AnchorCell();
        5 videoTitleAsLinkColumn = new /* Unavailable Anonymous Inner Class!! */;
        6 createdAtDateColumn = new /* Unavailable Anonymous Inner Class!! */;
        7 mimeTypeColumn = new /* Unavailable Anonymous Inner Class!! */;
        8 localeColumn = new /* Unavailable Anonymous Inner Class!! */;
        SafeHtmlCell tagsCell = new SafeHtmlCell();
        9 tagsColumn = new /* Unavailable Anonymous Inner Class!! */;
        ImagesBarColumn videoActionColumn = new ImagesBarColumn((ImagesBarCell)new VideoConfigImagesBarCell(this.stringMessages));
        videoActionColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        videoTitleAsLinkColumn.setSortable(true);
        createdAtDateColumn.setSortable(true);
        table.addColumn((Column)videoTitleAsLinkColumn, this.stringMessages.title());
        table.addColumn((Column)createdAtDateColumn, "Created At");
        table.addColumn((Column)mimeTypeColumn, this.stringMessages.mimeType());
        table.addColumn((Column)localeColumn, "Lang");
        table.addColumn((Column)tagsColumn, "Tags");
        table.addColumn((Column)videoActionColumn, this.stringMessages.actions());
        table.addColumnSortHandler((ColumnSortEvent.Handler)this.getVideoTableColumnSortHandler(this.videoListDataProvider.getList(), (Column)videoTitleAsLinkColumn, (TextColumn)createdAtDateColumn));
        table.getColumnSortList().push((Column)createdAtDateColumn);
        return table;
    }

    private ColumnSortEvent.ListHandler<VideoDTO> getVideoTableColumnSortHandler(List<VideoDTO> videoRecords, Column<VideoDTO, SafeHtml> titleColumn, TextColumn<VideoDTO> createdAtDateColumn) {
        ColumnSortEvent.ListHandler result = new ColumnSortEvent.ListHandler(videoRecords);
        result.setComparator(titleColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(createdAtDateColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private void openCreateVideoDialog(String initialTag) {
        VideoCreateDialog dialog = new VideoCreateDialog(initialTag, this.stringMessages, this.storageServiceAvailable, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("createVideoDialog");
        dialog.show();
    }

    private void openEditVideoDialog(VideoDTO selectedVideo) {
        VideoEditDialog dialog = new VideoEditDialog(selectedVideo, this.stringMessages, this.storageServiceAvailable, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("editVideoDialog");
        dialog.show();
    }

    private void updateTableVisisbilty() {
        if (this.videoListDataProvider.getList().isEmpty()) {
            this.videoTable.setVisible(false);
            this.noVideosLabel.setVisible(true);
        } else {
            this.videoTable.setVisible(true);
            this.noVideosLabel.setVisible(false);
        }
    }

    public void fillVideos(List<? extends VideoDTO> videos) {
        this.videoSelectionModel.clear();
        this.videoListDataProvider.getList().clear();
        this.videoListDataProvider.getList().addAll(videos);
        this.updateTableVisisbilty();
    }

    public List<VideoDTO> getAllVideos() {
        return this.videoListDataProvider.getList();
    }

    static /* synthetic */ void access$0(VideosListComposite videosListComposite, String string) {
        videosListComposite.openCreateVideoDialog(string);
    }

    static /* synthetic */ AnchorTemplates access$1() {
        return ANCHORTEMPLATE;
    }

    static /* synthetic */ ListDataProvider access$2(VideosListComposite videosListComposite) {
        return videosListComposite.videoListDataProvider;
    }

    static /* synthetic */ void access$3(VideosListComposite videosListComposite) {
        videosListComposite.updateTableVisisbilty();
    }

    static /* synthetic */ void access$4(VideosListComposite videosListComposite, VideoDTO videoDTO) {
        videosListComposite.openEditVideoDialog(videoDTO);
    }
}

