/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.gwt.ui.adminconsole.RemoteServerInstancesManagementTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.SailingServerCreateOrEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.ServerActionsColumn;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RemoteSailingServerReferenceDTO;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.SelectedElementsCountingButton;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class RemoteServerInstancesManagementPanel
extends SimplePanel
implements FilterablePanelProvider<RemoteSailingServerReferenceDTO> {
    private final SailingServiceWriteAsync sailingService;
    private final UserService userService;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private FlushableCellTable<RemoteSailingServerReferenceDTO> remoteServersTable;
    private final ListDataProvider<RemoteSailingServerReferenceDTO> serverDataProvider;
    private MultiSelectionModel<RemoteSailingServerReferenceDTO> refreshableServerSelectionModel;
    private LabeledAbstractFilterablePanel<RemoteSailingServerReferenceDTO> filteredServerTablePanel;
    private final CaptionPanel remoteServersPanel;

    public RemoteServerInstancesManagementPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages, CellTableWithCheckboxResources tableResources) {
        this.sailingService = presenter.getSailingService();
        this.userService = presenter.getUserService();
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        this.remoteServersPanel = new CaptionPanel(stringMessages.registeredSailingServerInstances());
        mainPanel.add((Widget)this.remoteServersPanel);
        VerticalPanel remoteServersContentPanel = new VerticalPanel();
        this.remoteServersPanel.setContentWidget((Widget)remoteServersContentPanel);
        this.serverDataProvider = new ListDataProvider();
        this.filteredServerTablePanel = this.createFilteredServerTablePanel();
        this.remoteServersTable = this.createRemoteServersTable(tableResources);
        this.serverDataProvider.addDataDisplay((HasData)this.remoteServersTable);
        remoteServersContentPanel.add((Widget)this.filteredServerTablePanel);
        remoteServersContentPanel.add((Widget)this.remoteServersTable);
        remoteServersContentPanel.add((Widget)this.createButtonToolbar());
        this.refreshSailingServerList();
    }

    private LabeledAbstractFilterablePanel<RemoteSailingServerReferenceDTO> createFilteredServerTablePanel() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Panel createButtonToolbar() {
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setSpacing(5);
        buttonPanel.add((Widget)new Button(this.stringMessages.add(), event -> this.addRemoteSailingServerReference()));
        buttonPanel.add((Widget)this.createRemoveButton(buttonPanel, event -> this.removeSelectedSailingServers()));
        buttonPanel.add((Widget)new Button(this.stringMessages.refresh(), event -> this.refreshSailingServerList()));
        return buttonPanel;
    }

    private Button createRemoveButton(HorizontalPanel buttonPanel, ClickHandler handler) {
        return new SelectedElementsCountingButton(this.stringMessages.remove(), (SetSelectionModel)this.refreshableServerSelectionModel, arg_0 -> ((StringMessages)StringMessages.INSTANCE).doYouReallyWantToRemoveSelectedElements(arg_0), event -> this.removeSelectedSailingServers());
    }

    private FlushableCellTable<RemoteSailingServerReferenceDTO> createRemoteServersTable(CellTableWithCheckboxResources tableResources) {
        RemoteServerInstancesManagementTableWrapper wrapper = new RemoteServerInstancesManagementTableWrapper((com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages, this.errorReporter, this.filteredServerTablePanel.getAllListDataProvider(), tableResources);
        wrapper.addColumn((Column)this.createTextColumn(NamedDTO::getName), this.stringMessages.name());
        wrapper.addColumn((Column)this.createTextColumn(RemoteSailingServerReferenceDTO::getUrl), this.stringMessages.url());
        wrapper.addColumn(this.createEventsColumn(), this.stringMessages.events());
        wrapper.addColumn((Column)this.createActionsColumn(), this.stringMessages.actions());
        wrapper.setEmptyTableWidget((Widget)new Label(this.stringMessages.noSailingServerInstancesYet()));
        this.refreshableServerSelectionModel = (MultiSelectionModel)wrapper.getSelectionModel();
        return wrapper.getTable();
    }

    private TextColumn<RemoteSailingServerReferenceDTO> createTextColumn(Function<RemoteSailingServerReferenceDTO, String> getter) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Column<RemoteSailingServerReferenceDTO, SafeHtml> createEventsColumn() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private ServerActionsColumn<RemoteSailingServerReferenceDTO, DefaultActionsImagesBarCell> createActionsColumn() {
        ServerActionsColumn actionsColumn = ServerActionsColumn.create((ImagesBarCell)new /* Unavailable Anonymous Inner Class!! */, (UserService)this.userService);
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES, e -> {
            if (Window.confirm((String)StringMessages.INSTANCE.doYouReallyWantToRemoveSelectedElements(e.getName()))) {
                HashSet<String> toDelete = new HashSet<String>();
                toDelete.add(e.getName());
                this.removeSailingServers(toDelete);
            }
        });
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES, loadedSalingServer -> this.sailingService.getCompleteRemoteServerReference(loadedSalingServer.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        return actionsColumn;
    }

    private void refreshSailingServerList() {
        this.sailingService.getRemoteSailingServerReferences(this.createCallback(arg_0 -> ((StringMessages)this.stringMessages).errorRefreshingSailingServers(arg_0), arg_0 -> ((LabeledAbstractFilterablePanel)this.filteredServerTablePanel).updateAll(arg_0), false));
    }

    private void removeSelectedSailingServers() {
        HashSet<String> toRemove = new HashSet<String>();
        for (RemoteSailingServerReferenceDTO selectedServer : this.refreshableServerSelectionModel.getSelectedSet()) {
            toRemove.add(selectedServer.getName());
        }
        this.removeSailingServers(toRemove);
    }

    private void removeSailingServers(Set<String> toRemove) {
        this.sailingService.removeSailingServers(toRemove, this.createCallback(arg_0 -> ((StringMessages)this.stringMessages).errorRemovingSailingServers(arg_0), result -> this.refreshSailingServerList(), true));
    }

    private void addRemoteSailingServerReference() {
        new SailingServerCreateOrEditDialog(this.filteredServerTablePanel.getAll(), this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private <T> AsyncCallback<T> createCallback(Function<String, String> errorMapper, Consumer<T> resultConsumer, boolean notify) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public AbstractFilterablePanel<RemoteSailingServerReferenceDTO> getFilterablePanel() {
        return this.filteredServerTablePanel;
    }

    static /* synthetic */ FlushableCellTable access$0(RemoteServerInstancesManagementPanel remoteServerInstancesManagementPanel) {
        return remoteServerInstancesManagementPanel.remoteServersTable;
    }

    static /* synthetic */ StringMessages access$1(RemoteServerInstancesManagementPanel remoteServerInstancesManagementPanel) {
        return remoteServerInstancesManagementPanel.stringMessages;
    }

    static /* synthetic */ SailingServiceWriteAsync access$2(RemoteServerInstancesManagementPanel remoteServerInstancesManagementPanel) {
        return remoteServerInstancesManagementPanel.sailingService;
    }

    static /* synthetic */ void access$3(RemoteServerInstancesManagementPanel remoteServerInstancesManagementPanel) {
        remoteServerInstancesManagementPanel.refreshSailingServerList();
    }

    static /* synthetic */ ErrorReporter access$4(RemoteServerInstancesManagementPanel remoteServerInstancesManagementPanel) {
        return remoteServerInstancesManagementPanel.errorReporter;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$5(RemoteServerInstancesManagementPanel remoteServerInstancesManagementPanel) {
        return remoteServerInstancesManagementPanel.filteredServerTablePanel;
    }

    static /* synthetic */ AsyncCallback access$6(RemoteServerInstancesManagementPanel remoteServerInstancesManagementPanel, Function function, Consumer consumer, boolean bl) {
        return remoteServerInstancesManagementPanel.createCallback(function, consumer, bl);
    }
}

