/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.PairingListDTO;
import com.sap.sailing.domain.common.dto.PairingListTemplateDTO;
import com.sap.sailing.gwt.ui.adminconsole.AdminConsoleResources;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PairingListCreationDialog
extends DataEntryDialog<PairingListTemplateDTO> {
    private final PairingListTemplateDTO template;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final StrippedLeaderboardDTO leaderboardDTO;
    private final StringMessages stringMessages;
    private PairingListDTO pairingListDTO;
    private final AdminConsoleResources resources = (AdminConsoleResources)GWT.create(AdminConsoleResources.class);
    private final Button applyToRacelogButton;
    private final Button printPreViewButton;
    private final Button refreshButton;
    private final Anchor cSVExportAnchor;
    private final ErrorReporter errorReporter;
    private final ScrollPanel pairingListTemplateScrollPanel;
    private final Grid pairingListGrid;

    public PairingListCreationDialog(StrippedLeaderboardDTO leaderboardDTO, StringMessages stringMessages, PairingListTemplateDTO template, SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter) {
        super(stringMessages.pairingList(), null, stringMessages.close(), null, null, null);
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.template = template;
        this.sailingServiceWrite = sailingServiceWrite;
        this.leaderboardDTO = leaderboardDTO;
        this.ensureDebugId("PairingListCreationDialog");
        this.applyToRacelogButton = new Button(stringMessages.insertIntoRegatta());
        this.printPreViewButton = new Button(stringMessages.printView());
        this.refreshButton = new Button(stringMessages.recalculate());
        this.cSVExportAnchor = new Anchor(stringMessages.csvExport());
        this.cSVExportAnchor.ensureDebugId("CSVExportAnchor");
        this.cSVExportAnchor.getElement().setAttribute("href", "data:text/plain;charset=utf-8," + this.getCSVFromPairingListTemplate(this.template.getPairingListTemplate()));
        this.cSVExportAnchor.getElement().setAttribute("download", "pairingListTemplate.csv");
        this.pairingListGrid = new Grid(this.template.getPairingListTemplate().length, this.template.getPairingListTemplate()[0].length);
        this.pairingListTemplateScrollPanel = new ScrollPanel((Widget)this.pairingListGrid);
        if (template.getCompetitorCount() == leaderboardDTO.competitorsCount) {
            sailingServiceWrite.getPairingListFromTemplate(this.leaderboardDTO.getName(), this.template.getFlightMultiplier(), (Iterable)this.template.getSelectedFlightNames(), this.template, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.disableApplyToRacelogsAndPrintPreview();
            this.initTemplatePanel();
        }
    }

    protected Widget getAdditionalWidget() {
        HorizontalPanel panel = new HorizontalPanel();
        CaptionPanel dataPanel = new CaptionPanel();
        dataPanel.setCaptionText(this.stringMessages.parameters());
        Grid formGrid = new Grid(8, 2);
        dataPanel.add((Widget)formGrid);
        Label flights = new Label(String.valueOf(this.template.getFlightCount()));
        flights.ensureDebugId("FlightCountLabel");
        Label groups = new Label(String.valueOf(this.template.getGroupCount()));
        groups.ensureDebugId("GroupCountLabel");
        Label competitors = new Label(String.valueOf(this.template.getCompetitorCount()));
        competitors.ensureDebugId("CompetitorCountLabel");
        formGrid.setWidget(0, 0, (Widget)new Label(this.stringMessages.numberOfFlights()));
        formGrid.setWidget(0, 1, (Widget)flights);
        formGrid.setWidget(1, 0, (Widget)new Label(this.stringMessages.numberOfFleets()));
        formGrid.setWidget(1, 1, (Widget)groups);
        formGrid.setWidget(2, 0, (Widget)new Label(this.stringMessages.numberOfRaces()));
        formGrid.setWidget(2, 1, (Widget)new Label(String.valueOf(this.template.getFlightCount() * this.template.getGroupCount())));
        formGrid.setWidget(3, 0, (Widget)new Label(this.stringMessages.numberOfCompetitors()));
        formGrid.setWidget(3, 1, (Widget)competitors);
        HorizontalPanel qualityPanel = new HorizontalPanel();
        qualityPanel.add((Widget)new Label(this.stringMessages.quality()));
        Image qualityHelpImage = new Image(this.resources.help());
        qualityPanel.add((Widget)qualityHelpImage);
        qualityHelpImage.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        qualityHelpImage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        formGrid.setWidget(4, 0, (Widget)qualityPanel);
        formGrid.setWidget(4, 1, (Widget)new Label(String.valueOf(Math.floor(this.template.getQuality() * 1000.0) / 1000.0)));
        formGrid.setWidget(5, 0, (Widget)new Label(this.stringMessages.boatAssignmentQuality()));
        formGrid.setWidget(5, 1, (Widget)new Label(String.valueOf(Math.floor(this.template.getBoatAssignmentQuality() * 1000.0) / 1000.0)));
        formGrid.setWidget(6, 0, (Widget)new Label(this.stringMessages.boatChanges()));
        formGrid.setWidget(6, 1, (Widget)new Label(String.valueOf(this.template.getBoatChanges())));
        if (this.template.getFlightMultiplier() > 1) {
            Label flightMultiplierLabel = new Label(String.valueOf(this.template.getFlightMultiplier()));
            formGrid.setWidget(7, 0, (Widget)new Label(this.stringMessages.amountOfFlightRepeats()));
            formGrid.setWidget(7, 1, (Widget)flightMultiplierLabel);
            flightMultiplierLabel.ensureDebugId("FlightMultiplierCountLabel");
        }
        formGrid.setCellSpacing(10);
        panel.add((Widget)dataPanel);
        CaptionPanel pairingListTemplatePanel = new CaptionPanel();
        pairingListTemplatePanel.setCaptionText(this.stringMessages.pairingListTemplate());
        Grid pairingListGrid = new Grid(this.template.getPairingListTemplate().length, this.template.getPairingListTemplate()[0].length);
        pairingListGrid.setCellSpacing(5);
        this.pairingListTemplateScrollPanel.setPixelSize(Window.getClientWidth() / 4, Window.getClientHeight() / 3);
        pairingListTemplatePanel.add((Widget)this.pairingListTemplateScrollPanel);
        panel.add((Widget)pairingListTemplatePanel);
        this.configButtons();
        return panel;
    }

    protected PairingListTemplateDTO getResult() {
        return this.template;
    }

    private void configButtons() {
        this.applyToRacelogButton.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
        this.applyToRacelogButton.ensureDebugId("ApplyToRacelogButton");
        this.printPreViewButton.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
        this.printPreViewButton.ensureDebugId("printViewButton");
        this.refreshButton.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
        this.refreshButton.ensureDebugId("printViewButton");
        this.getRightButtonPannel().add((Widget)this.applyToRacelogButton);
        this.getRightButtonPannel().add((Widget)this.printPreViewButton);
        this.getRightButtonPannel().add((Widget)this.refreshButton);
        this.getRightButtonPannel().add((Widget)this.cSVExportAnchor);
        if (!this.applyToRacelogButton.isEnabled()) {
            Label label = new Label(this.stringMessages.blockedApplyButton());
            label.getElement().getStyle().setColor("red");
            this.getRightButtonPannel().add((Widget)label);
        }
        this.applyToRacelogButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.printPreViewButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getCSVFromPairingListTemplate(int[][] pairingListTemplate) {
        StringBuilder result = new StringBuilder();
        int[][] nArray = pairingListTemplate;
        int n = pairingListTemplate.length;
        int n2 = 0;
        while (n2 < n) {
            int[] row;
            int[] nArray2 = row = nArray[n2];
            int n3 = row.length;
            int n4 = 0;
            while (n4 < n3) {
                int column = nArray2[n4];
                result.append(String.valueOf(column + 1) + ",");
                ++n4;
            }
            result.append("\n");
            ++n2;
        }
        return result.toString();
    }

    private void disableApplyToRacelogsAndPrintPreview() {
        this.applyToRacelogButton.setEnabled(false);
        this.printPreViewButton.setEnabled(false);
    }

    private void initTemplatePanel() {
        this.pairingListTemplateScrollPanel.remove((Widget)this.pairingListGrid);
        int groupIndex = 0;
        while (groupIndex < this.template.getPairingListTemplate().length) {
            int boatIndex = 0;
            while (boatIndex < this.template.getPairingListTemplate()[0].length) {
                this.pairingListGrid.setWidget(groupIndex, boatIndex, (Widget)new Label(String.valueOf(this.template.getPairingListTemplate()[groupIndex][boatIndex] + 1)));
                this.pairingListGrid.getCellFormatter().setWidth(groupIndex, boatIndex, "50px");
                ++boatIndex;
            }
            ++groupIndex;
        }
        this.pairingListTemplateScrollPanel.add((Widget)this.pairingListGrid);
    }

    private String getBoatDisplayName(BoatDTO boat) {
        return boat.getName() == null ? boat.getSailId() : boat.getName();
    }

    private Comparator<BoatDTO> getBoatsComparator() {
        NaturalComparator naturalComparator = new NaturalComparator();
        return (arg_0, arg_1) -> this.lambda$0((Comparator)naturalComparator, arg_0, arg_1);
    }

    private void swapTemplateColumns(List<BoatDTO> boats, List<BoatDTO> oldBoatPositions) {
        for (BoatDTO boat : boats) {
            int indexB;
            int indexA = oldBoatPositions.indexOf(boat);
            if (indexA == (indexB = boats.indexOf(boat))) continue;
            this.template.swapColumns(indexA, indexB);
            Collections.swap(oldBoatPositions, indexA, indexB);
        }
    }

    static /* synthetic */ ErrorReporter access$1(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.errorReporter;
    }

    static /* synthetic */ void access$2(PairingListCreationDialog pairingListCreationDialog, PairingListDTO pairingListDTO) {
        pairingListCreationDialog.pairingListDTO = pairingListDTO;
    }

    static /* synthetic */ Button access$3(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.applyToRacelogButton;
    }

    static /* synthetic */ Button access$4(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.printPreViewButton;
    }

    static /* synthetic */ void access$5(PairingListCreationDialog pairingListCreationDialog) {
        pairingListCreationDialog.initTemplatePanel();
    }

    static /* synthetic */ PairingListDTO access$6(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.pairingListDTO;
    }

    static /* synthetic */ Comparator access$7(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.getBoatsComparator();
    }

    static /* synthetic */ void access$8(PairingListCreationDialog pairingListCreationDialog, List list, List list2) {
        pairingListCreationDialog.swapTemplateColumns(list, list2);
    }

    static /* synthetic */ SailingServiceWriteAsync access$9(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.sailingServiceWrite;
    }

    static /* synthetic */ StrippedLeaderboardDTO access$10(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.leaderboardDTO;
    }

    static /* synthetic */ PairingListTemplateDTO access$11(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.template;
    }

    static /* synthetic */ StringMessages access$12(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.stringMessages;
    }

    static /* synthetic */ DialogBox access$13(PairingListCreationDialog pairingListCreationDialog) {
        return pairingListCreationDialog.getDialogBox();
    }

    private /* synthetic */ int lambda$0(Comparator comparator, BoatDTO b1, BoatDTO b2) {
        return comparator.compare(this.getBoatDisplayName(b1), this.getBoatDisplayName(b2));
    }
}

