/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sse.common.Util;
import java.util.HashSet;
import java.util.Set;

public class CompetitorImportMatcher {
    private final Iterable<CompetitorDTO> existingCompetitorDTOs;

    public CompetitorImportMatcher(Iterable<CompetitorDTO> existingCompetitors) {
        this.existingCompetitorDTOs = existingCompetitors;
    }

    public Set<CompetitorDTO> getMatchesCompetitors(CompetitorDescriptor competitorDescriptor) {
        HashSet<CompetitorDTO> matchesCompetitor = new HashSet<CompetitorDTO>();
        if (competitorDescriptor == null) {
            return matchesCompetitor;
        }
        for (CompetitorDTO existingCompetitor : this.existingCompetitorDTOs) {
            if (!this.isEqual(competitorDescriptor, existingCompetitor)) continue;
            matchesCompetitor.add(existingCompetitor);
        }
        return matchesCompetitor;
    }

    private boolean isEqual(CompetitorDescriptor competitorDescriptor, CompetitorDTO existingCompetitor) {
        return competitorDescriptor.getCompetitorId().toString().equals(existingCompetitor.getId().toString()) || Util.equalsWithNull((String)competitorDescriptor.getName(), (String)existingCompetitor.getName(), (boolean)true) && (!existingCompetitor.hasBoat() || Util.equalsWithNull((String)this.removeSpaces(competitorDescriptor.getSailNumber()), (String)this.removeSpaces(((CompetitorWithBoatDTO)existingCompetitor).getSailID()), (boolean)true)) && this.compareCountryCode(competitorDescriptor, existingCompetitor);
    }

    private String removeSpaces(String s) {
        return s == null ? null : s.replace(" ", "").replace("\t", "");
    }

    private boolean compareCountryCode(CompetitorDescriptor competitorDescriptor, CompetitorDTO existingCompetitor) {
        return Util.equalsWithNull((String)(competitorDescriptor.getCountryCode() == null ? null : competitorDescriptor.getCountryCode().getThreeLetterIOCCode()), (String)existingCompetitor.getThreeLetterIocCountryCode(), (boolean)true);
    }
}

