/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.actions;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.ui.actions.AbstractGetMapRelatedDataAction;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.shared.CompactBoatPositionsDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.gwt.client.async.TimeRangeAsyncAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class GetBoatPositionsAction
extends AbstractGetMapRelatedDataAction<CompactBoatPositionsDTO>
implements TimeRangeAsyncAction<CompactBoatPositionsDTO, Util.Pair<String, DetailType>> {
    private final String leaderboardName;
    private final String leaderboardGroupName;
    private final UUID leaderboardGroupId;

    public GetBoatPositionsAction(SailingServiceAsync sailingService, RegattaAndRaceIdentifier raceIdentifier, Map<String, Date> from, Map<String, Date> to, boolean extrapolate, DetailType detailType, String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId) {
        super(sailingService, raceIdentifier, from, to, extrapolate, detailType, leaderboardName, leaderboardGroupName, leaderboardGroupId);
        this.leaderboardName = leaderboardName;
        this.leaderboardGroupName = leaderboardGroupName;
        this.leaderboardGroupId = leaderboardGroupId;
    }

    public void execute(Map<Util.Pair<String, DetailType>, TimeRange> timeRanges, AsyncCallback<CompactBoatPositionsDTO> callback) {
        HashMap<String, Date> fromByCompetitorIdAsString = new HashMap<String, Date>();
        HashMap<String, Date> toByCompetitorIdAsString = new HashMap<String, Date>();
        for (Map.Entry<Util.Pair<String, DetailType>, TimeRange> entry : timeRanges.entrySet()) {
            Date from = entry.getValue().from().asDate();
            Date to = entry.getValue().to().asDate();
            fromByCompetitorIdAsString.put((String)entry.getKey().getA(), from);
            toByCompetitorIdAsString.put((String)entry.getKey().getA(), to);
        }
        this.getSailingService().getBoatPositions(this.getRaceIdentifier(), fromByCompetitorIdAsString, toByCompetitorIdAsString, this.isExtrapolate(), this.getDetailType(), this.leaderboardName, this.leaderboardGroupName, this.leaderboardGroupId, callback);
    }

    public Map<Util.Pair<String, DetailType>, TimeRange> getTimeRanges() {
        HashMap<Util.Pair<String, DetailType>, TimeRange> timeRangeByCompetitorId = new HashMap<Util.Pair<String, DetailType>, TimeRange>(this.getFromByCompetitorIdAsString().size());
        for (Map.Entry entry : this.getFromByCompetitorIdAsString().entrySet()) {
            Date fromDate = (Date)entry.getValue();
            Date toDate = (Date)this.getToByCompetitorIdAsString().get(entry.getKey());
            if (fromDate == null || toDate == null) continue;
            timeRangeByCompetitorId.put((Util.Pair<String, DetailType>)new Util.Pair((Object)((String)entry.getKey()), (Object)this.getDetailType()), (TimeRange)new TimeRangeImpl(TimePoint.of((Date)fromDate), TimePoint.of((Date)toDate), true));
        }
        return timeRangeByCompetitorId;
    }
}

