/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.regattaoverview.client;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.gwt.regattaoverview.client.DurationFormat;
import com.sap.sailing.gwt.regattaoverview.client.RaceStateFlagsInterpreter;
import com.sap.sailing.gwt.regattaoverview.client.RegattaOverviewResources;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RaceInfoDTO;
import com.sap.sailing.gwt.ui.shared.RegattaOverviewEntryDTO;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaceDetailPanel
extends SimplePanel {
    private static final int MAX_PROCEDURE_FIELDS = 2;
    private final DateTimeFormat timeFormatter = DateTimeFormat.getFormat((String)"HH:mm:ss");
    private final DateTimeFormat dateFormatter = DateTimeFormat.getFormat((String)"dd.MM.yyyy");
    private final DurationFormat durationFormatter = new DurationFormat();
    private final NumberFormat decimalFormat = NumberFormat.getFormat((String)"#.##");
    private final RaceStateFlagsInterpreter flagInterpreter;
    private final StringMessages stringMessages;
    private static RegattaOverviewResources.LocalCss style = RegattaOverviewResources.INSTANCE.css();
    private final Button closeButton;
    private final Label headerLabel = new Label();
    private final Label startTimeLabel = new Label();
    private final Label startDateLabel = new Label();
    private final Label finishTimeLabel = new Label();
    private final Label finishDurationLabel = new Label();
    private final Label protestStartTimeLabel = new Label();
    private final Label protestFinishTimeLabel = new Label();
    private final Label protestStartDateLabel = new Label();
    private final Label protestFinishDateLabel = new Label();
    private final Label updateTimeLabel = new Label();
    private final Label updateDateLabel = new Label();
    private final Label vesselPositionLabel = new Label();
    private final Label windLabel = new Label();
    private final Label startProcedureLabel = new Label();
    private FlexTable procedureGrid;
    private RegattaOverviewEntryDTO data;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType;

    public static String getDegMinSecFormatForDecimalDegree(double degree) {
        degree = Math.abs(degree);
        int d = (int)degree;
        degree = (degree - (double)d) * 60.0;
        int m = (int)degree;
        double s = (degree - (double)m) * 60.0;
        if (degree < 0.0) {
            d = -d;
        }
        NumberFormat decimalFormat = NumberFormat.getFormat((String)"##.###");
        return "" + d + '\u00b0' + m + '\u2032' + decimalFormat.format(s) + '\u2033';
    }

    public RaceDetailPanel(StringMessages stringMessages, ClickHandler closeButtonHandler) {
        this.stringMessages = stringMessages;
        this.flagInterpreter = new RaceStateFlagsInterpreter(stringMessages);
        this.closeButton = new Button(stringMessages.close());
        this.closeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addStyleName(style.raceDetailPanel());
        HorizontalPanel headerPanel = new HorizontalPanel();
        headerPanel.addStyleName(style.raceDetailPanel_header());
        headerPanel.setWidth("100%");
        headerPanel.add((Widget)this.headerLabel);
        headerPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        headerPanel.add((Widget)this.closeButton);
        int cellSpacing = 3;
        Grid basicsGrid = new Grid(4, 3);
        basicsGrid.setCellSpacing(cellSpacing);
        basicsGrid.setWidget(0, 0, (Widget)new Label(stringMessages.startAt()));
        basicsGrid.setWidget(1, 0, (Widget)new Label(stringMessages.finishAt()));
        basicsGrid.setWidget(2, 0, (Widget)new Label(stringMessages.protestStartsAt()));
        basicsGrid.setWidget(3, 0, (Widget)new Label(stringMessages.protestEndsAt()));
        basicsGrid.setWidget(0, 1, (Widget)this.startTimeLabel);
        basicsGrid.setWidget(1, 1, (Widget)this.finishTimeLabel);
        basicsGrid.setWidget(2, 1, (Widget)this.protestStartTimeLabel);
        basicsGrid.setWidget(3, 1, (Widget)this.protestFinishTimeLabel);
        basicsGrid.setWidget(0, 2, (Widget)this.startDateLabel);
        basicsGrid.setWidget(1, 2, (Widget)this.finishDurationLabel);
        basicsGrid.setWidget(2, 2, (Widget)this.protestStartDateLabel);
        basicsGrid.setWidget(3, 2, (Widget)this.protestFinishDateLabel);
        Grid managementGrid = new Grid(3, 3);
        managementGrid.setCellSpacing(cellSpacing);
        managementGrid.setWidget(0, 0, (Widget)new Label(stringMessages.lastUpdate()));
        managementGrid.setWidget(1, 0, (Widget)new Label(stringMessages.position()));
        managementGrid.setWidget(2, 0, (Widget)new Label(stringMessages.wind()));
        managementGrid.setWidget(0, 1, (Widget)this.updateTimeLabel);
        managementGrid.setWidget(1, 1, (Widget)this.vesselPositionLabel);
        managementGrid.setWidget(2, 1, (Widget)this.windLabel);
        managementGrid.setWidget(0, 2, (Widget)this.updateDateLabel);
        this.procedureGrid = new FlexTable();
        this.procedureGrid.setCellSpacing(cellSpacing);
        this.resetProcedureGrid();
        HorizontalPanel contentPanel = new HorizontalPanel();
        contentPanel.addStyleName(style.raceDetailPanel_content());
        contentPanel.add((Widget)basicsGrid);
        contentPanel.add((Widget)managementGrid);
        contentPanel.add((Widget)this.procedureGrid);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        mainPanel.add((Widget)headerPanel);
        mainPanel.add((Widget)contentPanel);
        this.setWidget((Widget)mainPanel);
    }

    private void resetProcedureGrid() {
        this.procedureGrid.removeAllRows();
        this.procedureGrid.setWidget(0, 0, (Widget)new Label(this.stringMessages.startProcedure()));
        this.procedureGrid.setWidget(0, 1, (Widget)this.startProcedureLabel);
    }

    public void show(RegattaOverviewEntryDTO newEntry) {
        this.data = newEntry;
        this.updateUi();
    }

    private void updateUi() {
        if (this.data != null) {
            String statusText = this.flagInterpreter.getMeaningOfRaceStateAndFlags(this.data.raceInfo.lastStatus, this.data.raceInfo.lastUpperFlag, this.data.raceInfo.lastLowerFlag, this.data.raceInfo.lastFlagsAreDisplayed);
            String headerLabelText = String.valueOf(this.data.regattaDisplayName) + " " + this.data.raceInfo.fleetName + " " + this.data.raceInfo.raceName + " (" + statusText + ")";
            this.headerLabel.setText(this.stringMessages.showingDetailsOfRace(headerLabelText));
            String startTimeLabelText = this.data.raceInfo.startTime == null ? "-" : this.timeFormatter.format(this.data.raceInfo.startTime);
            this.startTimeLabel.setText(startTimeLabelText);
            String startDateLabelText = this.data.raceInfo.startTime == null ? "" : this.dateFormatter.format(this.data.raceInfo.startTime);
            this.startDateLabel.setText(startDateLabelText);
            String finishTimeText = this.data.raceInfo.finishedTime == null ? "-" : this.timeFormatter.format(this.data.raceInfo.finishedTime);
            this.finishTimeLabel.setText(finishTimeText);
            String finishDurationText = "";
            if (this.data.raceInfo.finishedTime != null && this.data.raceInfo.startTime != null) {
                finishDurationText = "(" + this.durationFormatter.format(this.data.raceInfo.startTime, this.data.raceInfo.finishedTime) + ")";
            }
            this.finishDurationLabel.setText(finishDurationText);
            String protestStartTimeText = this.data.raceInfo.protestStartTime == null ? "-" : this.timeFormatter.format(this.data.raceInfo.protestStartTime);
            this.protestStartTimeLabel.setText(protestStartTimeText);
            String protestFinishTimeText = this.data.raceInfo.protestFinishTime == null ? "-" : this.timeFormatter.format(this.data.raceInfo.protestFinishTime);
            this.protestFinishTimeLabel.setText(protestFinishTimeText);
            String protestStartDateText = this.data.raceInfo.protestStartTime == null ? "" : this.dateFormatter.format(this.data.raceInfo.protestStartTime);
            this.protestStartDateLabel.setText(protestStartDateText);
            String protestFinishDateText = this.data.raceInfo.protestFinishTime == null ? "" : this.dateFormatter.format(this.data.raceInfo.protestFinishTime);
            this.protestFinishDateLabel.setText(protestFinishDateText);
            String updateTimeText = this.data.raceInfo.lastUpdateTime == null ? "-" : this.timeFormatter.format(this.data.raceInfo.lastUpdateTime);
            this.updateTimeLabel.setText(updateTimeText);
            String updateDateText = this.data.raceInfo.lastUpdateTime == null ? "" : this.dateFormatter.format(this.data.raceInfo.lastUpdateTime);
            this.updateDateLabel.setText(updateDateText);
            String vesselPositionText = this.stringMessages.unknown();
            String windText = this.stringMessages.unknown();
            if (this.data.raceInfo.lastWind != null) {
                if (this.data.raceInfo.lastWind.position != null) {
                    vesselPositionText = new HTML(String.valueOf(RaceDetailPanel.getDegMinSecFormatForDecimalDegree((double)this.data.raceInfo.lastWind.position.getLatDeg())) + " " + RaceDetailPanel.getDegMinSecFormatForDecimalDegree((double)this.data.raceInfo.lastWind.position.getLngDeg()) + " ").getHTML();
                }
                windText = new HTML(String.valueOf(this.decimalFormat.format((Number)this.data.raceInfo.lastWind.trueWindFromDeg)) + "&deg; " + this.decimalFormat.format((Number)this.data.raceInfo.lastWind.trueWindSpeedInKnots) + "knts").getHTML();
            }
            this.vesselPositionLabel.setText(vesselPositionText);
            this.windLabel.setText(windText);
            this.updateUiStartProcedureSpecifics();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateUiStartProcedureSpecifics() {
        block9: {
            block8: {
                this.resetProcedureGrid();
                if (this.data.raceInfo.startProcedure == null) break block8;
                this.startProcedureLabel.setText(this.data.raceInfo.startProcedure.toString());
                if (this.data.raceInfo.startProcedureDTO == null) break block9;
                switch (RaceDetailPanel.$SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType()[this.data.raceInfo.startProcedure.ordinal()]) {
                    case 2: 
                    case 3: 
                    case 8: 
                    case 9: {
                        rrsInfo = (RaceInfoDTO.LineStartInfoDTO)this.data.raceInfo.startProcedureDTO;
                        if (rrsInfo != null && rrsInfo.startModeFlag != null) {
                            this.showProcedureInfo(this.stringMessages.startMode(), rrsInfo.startModeFlag.toString());
                            ** break;
                        }
                        break block9;
                    }
                    case 4: {
                        gateInfo = (RaceInfoDTO.GateStartInfoDTO)this.data.raceInfo.startProcedureDTO;
                        if (gateInfo != null) {
                            if (gateInfo.pathfinderId != null) {
                                this.showProcedureInfo("Pathfinder", gateInfo.pathfinderId);
                            }
                            if (gateInfo.gateLineOpeningTime != null) {
                                this.showProcedureInfo(this.stringMessages.gateOpeningTime(), String.valueOf((int)((double)gateInfo.gateLineOpeningTime.longValue() / 1000.0 / 60.0)) + "min");
                                ** break;
                            }
                        }
                        break block9;
                    }
                }
lbl22:
                // 3 sources

                break block9;
            }
            this.startProcedureLabel.setText("-");
        }
    }

    private void showProcedureInfo(String label, String value) {
        int i = 1;
        while (i < 3) {
            if (!this.procedureGrid.isCellPresent(i, 0)) {
                this.procedureGrid.setWidget(i, 0, (Widget)new Label(SafeHtmlUtils.fromString((String)label).asString()));
                this.procedureGrid.setWidget(i, 1, (Widget)new Label(SafeHtmlUtils.fromString((String)value).asString()));
                return;
            }
            ++i;
        }
        throw new IllegalStateException("There are too many procedure specific fields.");
    }

    public boolean update(RegattaOverviewEntryDTO newEntry) {
        if (RaceDetailPanel.areOfSameRace((RegattaOverviewEntryDTO)this.data, (RegattaOverviewEntryDTO)newEntry)) {
            this.show(newEntry);
            return true;
        }
        return false;
    }

    private static boolean areOfSameRace(RegattaOverviewEntryDTO left, RegattaOverviewEntryDTO right) {
        if (left == null || right == null) {
            return false;
        }
        return RaceDetailPanel.bothNullOrEquals((Object)left.courseAreaIdAsString, (Object)right.courseAreaIdAsString) && RaceDetailPanel.bothNullOrEquals((Object)left.leaderboardName, (Object)right.leaderboardName) && RaceDetailPanel.bothNullOrEquals((Object)left.raceInfo.seriesName, (Object)right.raceInfo.seriesName) && RaceDetailPanel.bothNullOrEquals((Object)left.raceInfo.fleetName, (Object)right.raceInfo.fleetName) && RaceDetailPanel.bothNullOrEquals((Object)left.raceInfo.raceName, (Object)right.raceInfo.raceName);
    }

    private static boolean bothNullOrEquals(Object left, Object right) {
        return left == null ? right == null : left.equals(right);
    }

    static /* synthetic */ void access$0(RaceDetailPanel raceDetailPanel, RegattaOverviewEntryDTO regattaOverviewEntryDTO) {
        raceDetailPanel.data = regattaOverviewEntryDTO;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType() {
        if ($SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType != null) {
            return $SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType;
        }
        int[] nArray = new int[RacingProcedureType.values().length];
        try {
            nArray[RacingProcedureType.BASIC.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.ESS.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.GateStart.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.LEAGUE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.RRS26.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.RRS26_3MIN.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.SWC.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.SWC_4MIN.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RacingProcedureType.UNKNOWN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$domain$common$racelog$RacingProcedureType = nArray;
        return nArray;
    }
}

