/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.places.user.profile.subscriptions;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.places.subscription.SubscriptionPlace;
import com.sap.sailing.gwt.home.shared.places.user.profile.subscriptions.UserSubscriptionsView;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.dialog.ConfirmationDialog;
import com.sap.sse.security.shared.subscription.InvalidSubscriptionProviderException;
import com.sap.sse.security.ui.authentication.WithUserService;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.WithSecurity;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import com.sap.sse.security.ui.client.subscription.SubscriptionWriteServiceAsync;

public class UserSubscriptionsPresenter<C extends WithUserService & WithSecurity>
implements UserSubscriptionsView.Presenter {
    private final SubscriptionServiceFactory factory;
    private final UserService userService;
    private final PlaceNavigation<SubscriptionPlace> subscribePlaceNavigation;
    private UserSubscriptionsView view;

    public UserSubscriptionsPresenter(C clientFactory, PlaceNavigation<SubscriptionPlace> subscribePlaceNavigation) {
        this.factory = ((WithSecurity)clientFactory).getSubscriptionServiceFactory();
        this.userService = clientFactory.getUserService();
        this.subscribePlaceNavigation = subscribePlaceNavigation;
    }

    public void init() {
        this.factory.initializeProviders();
    }

    public void loadSubscription() {
        this.fetchSubscription();
    }

    public void setView(UserSubscriptionsView view) {
        this.view = view;
    }

    public void nonRenewingSubscription(String planId, String providerName) {
        ConfirmationDialog.create((String)StringMessages.INSTANCE.confirmNonRenewingSubscriptionTitle(), (String)StringMessages.INSTANCE.confirmNonRenewingSubscriptionText(), (String)StringMessages.INSTANCE.confirm(), (String)StringMessages.INSTANCE.cancel(), cancel -> {
            if (cancel.booleanValue()) {
                try {
                    SubscriptionWriteServiceAsync service = this.factory.getWriteAsyncServiceByProvider(providerName);
                    service.nonRenewingSubscription(planId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (InvalidSubscriptionProviderException e) {
                    this.onInvalidSubscriptionProviderError(e);
                }
            }
        }).center();
    }

    public void openSelfServicePortal() {
        ConfirmationDialog.create((String)StringMessages.INSTANCE.goToSelfServicePortalDialogTitle(), (String)StringMessages.INSTANCE.goToSelfServicePortalDialogText(), (String)StringMessages.INSTANCE.confirm(), (String)StringMessages.INSTANCE.cancel(), confirmed -> {
            if (confirmed.booleanValue()) {
                try {
                    this.factory.getDefaultAsyncService().getSelfServicePortalSession((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (InvalidSubscriptionProviderException e) {
                    this.onInvalidSubscriptionProviderError(e);
                }
            }
        }).center();
    }

    private void fetchSubscription() {
        try {
            this.factory.getDefaultAsyncService().getSubscriptions(Boolean.valueOf(false), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InvalidSubscriptionProviderException e) {
            this.onInvalidSubscriptionProviderError(e);
        }
    }

    private void showError(String message) {
        Notification.notify((String)message, (Notification.NotificationType)Notification.NotificationType.ERROR);
    }

    private void onInvalidSubscriptionProviderError(InvalidSubscriptionProviderException e) {
        this.showError(StringMessages.INSTANCE.errorInvalidSubscritionProvider(e.getMessage()));
    }

    public void navigateToSubscribe() {
        this.subscribePlaceNavigation.goToPlace();
    }

    static /* synthetic */ void access$0(UserSubscriptionsPresenter userSubscriptionsPresenter, String string) {
        userSubscriptionsPresenter.showError(string);
    }

    static /* synthetic */ UserService access$1(UserSubscriptionsPresenter userSubscriptionsPresenter) {
        return userSubscriptionsPresenter.userService;
    }

    static /* synthetic */ void access$2(UserSubscriptionsPresenter userSubscriptionsPresenter) {
        userSubscriptionsPresenter.fetchSubscription();
    }

    static /* synthetic */ UserSubscriptionsView access$3(UserSubscriptionsPresenter userSubscriptionsPresenter) {
        return userSubscriptionsPresenter.view;
    }
}

