/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.places.event;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.gwt.home.communication.event.GetEventViewAction;
import com.sap.sailing.gwt.home.communication.eventview.EventViewDTO;
import com.sap.sailing.gwt.home.desktop.places.event.multiregatta.AbstractMultiregattaEventPlace;
import com.sap.sailing.gwt.home.desktop.places.event.multiregatta.mediatab.MultiregattaMediaPlace;
import com.sap.sailing.gwt.home.desktop.places.event.multiregatta.overviewtab.MultiregattaOverviewPlace;
import com.sap.sailing.gwt.home.desktop.places.event.multiregatta.regattastab.MultiregattaRegattasPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.AbstractEventRegattaPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.mediatab.RegattaMediaPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.overviewtab.RegattaOverviewPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.racestab.RegattaRacesPlace;
import com.sap.sailing.gwt.home.shared.app.ClientFactoryWithDispatch;
import com.sap.sailing.gwt.home.shared.app.NavigationPathDisplay;
import com.sap.sailing.gwt.home.shared.app.ProvidesNavigationPath;
import com.sap.sailing.gwt.home.shared.places.event.AbstractEventPlace;
import com.sap.sailing.gwt.home.shared.places.event.EventContext;
import com.sap.sse.gwt.client.mvp.AbstractActivityProxy;
import com.sap.sse.gwt.client.mvp.ClientFactory;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import java.util.UUID;
import java.util.logging.Logger;

public abstract class AbstractEventActivityProxy<C extends ClientFactory & ClientFactoryWithDispatch>
extends AbstractActivityProxy
implements ProvidesNavigationPath {
    private static final Logger logger = Logger.getLogger(AbstractEventActivityProxy.class.getName());
    private final C clientFactory;
    private AbstractEventPlace place;
    private NavigationPathDisplay navigationPathDisplay;

    public AbstractEventActivityProxy(C clientFactory, AbstractEventPlace place) {
        this.clientFactory = clientFactory;
        this.place = place;
    }

    protected final void startAsync() {
        GetEventViewAction action = new GetEventViewAction(UUID.fromString(this.place.getEventUuidAsString()));
        ((ClientFactoryWithDispatch)this.clientFactory).getDispatch().execute((Action)action, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setNavigationPathDisplay(NavigationPathDisplay navigationPathDisplay) {
        this.navigationPathDisplay = navigationPathDisplay;
    }

    protected NavigationPathDisplay getNavigationPathDisplay() {
        return this.navigationPathDisplay;
    }

    protected abstract void afterEventLoad(C var1, EventViewDTO var2, AbstractEventPlace var3);

    private AbstractEventPlace getRealPlace(boolean isMultiRegatta) {
        if (!isMultiRegatta) {
            return new RegattaOverviewPlace(new EventContext(this.place.getCtx()).withRegattaId(null));
        }
        return new MultiregattaOverviewPlace(this.place.getCtx());
    }

    protected AbstractEventPlace verifyAndAdjustPlace(EventViewDTO event) {
        EventContext contextWithoutRegatta = new EventContext(this.place.getCtx()).withRegattaId(null);
        if (this.place instanceof AbstractMultiregattaEventPlace && !event.isMultiRegatta()) {
            if (this.place instanceof MultiregattaRegattasPlace) {
                return new RegattaRacesPlace(contextWithoutRegatta);
            }
            if (this.place instanceof MultiregattaMediaPlace) {
                return new RegattaMediaPlace(contextWithoutRegatta);
            }
            return new RegattaOverviewPlace(contextWithoutRegatta);
        }
        if (this.place instanceof AbstractEventRegattaPlace) {
            boolean regattaKnown = event.isRegattaIDKnown(this.place.getCtx().getRegattaId());
            if (!event.isMultiRegatta() && this.place.getCtx().getRegattaId() != null && !regattaKnown) {
                this.place.getCtx().withRegattaId(null);
            } else if (event.isMultiRegatta() && !regattaKnown) {
                logger.warning("Regatta ID " + this.place.getCtx().getRegattaId() + " is unknown; displaying event instead");
                return new MultiregattaRegattasPlace(contextWithoutRegatta);
            }
        }
        if (this.place instanceof RegattaMediaPlace && event.isMultiRegatta()) {
            return new MultiregattaMediaPlace(contextWithoutRegatta);
        }
        return this.place;
    }

    static /* synthetic */ AbstractEventPlace access$0(AbstractEventActivityProxy abstractEventActivityProxy) {
        return abstractEventActivityProxy.place;
    }

    static /* synthetic */ AbstractEventPlace access$1(AbstractEventActivityProxy abstractEventActivityProxy, boolean bl) {
        return abstractEventActivityProxy.getRealPlace(bl);
    }

    static /* synthetic */ void access$2(AbstractEventActivityProxy abstractEventActivityProxy, AbstractEventPlace abstractEventPlace) {
        abstractEventActivityProxy.place = abstractEventPlace;
    }

    static /* synthetic */ ClientFactory access$3(AbstractEventActivityProxy abstractEventActivityProxy) {
        return abstractEventActivityProxy.clientFactory;
    }
}

