/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.regattacompetition;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.RaceCompetitionFormatFleetDTO;
import com.sap.sailing.gwt.home.communication.race.FleetMetadataDTO;
import com.sap.sailing.gwt.home.shared.partials.regattacompetition.RegattaCompetitionView;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.RGBColor;

public abstract class AbstractRegattaCompetitionFleet
extends Composite
implements RegattaCompetitionView.RegattaCompetitionFleetView {
    protected AbstractRegattaCompetitionFleet(RaceCompetitionFormatFleetDTO fleet) {
        this.initWidget(this.getMainUiElement());
        this.getFleetNameUiElement().setInnerText(fleet.getFleet().getFleetName());
        this.getFleetCornerUiElement().getStyle().setProperty("borderTopColor", fleet.getFleet().getFleetColor());
        if (fleet.getFleet().isDefaultFleet()) {
            this.onDefaultFleetName();
        } else {
            this.getElement().getStyle().setBackgroundColor(this.getBackgroundColor(fleet.getFleet()));
        }
    }

    private String getBackgroundColor(FleetMetadataDTO fleet) {
        Util.Triple rgbValues = new RGBColor(fleet.getFleetColor()).getAsRGB();
        return "rgba(" + rgbValues.getA() + "," + rgbValues.getB() + "," + rgbValues.getC() + ", 0.1)";
    }

    public void doFilter(boolean filter) {
        this.setVisible(!filter);
    }

    protected abstract void onDefaultFleetName();

    protected abstract Widget getMainUiElement();

    protected abstract Element getFleetNameUiElement();

    protected abstract Element getFleetCornerUiElement();
}

