/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.editable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.shared.partials.editable.EditableResources;
import com.sap.sailing.gwt.home.shared.partials.editable.InlineEditButton;
import com.sap.sailing.gwt.home.shared.partials.editable.InlineEditLabel;
import java.util.ArrayList;
import java.util.List;

public class InlineEditLabel
extends Composite
implements HasText {
    private static InlineEditTextfieldUiBinder uiBinder = (InlineEditTextfieldUiBinder)GWT.create(InlineEditTextfieldUiBinder.class);
    @UiField
    EditableResources res;
    @UiField
    TextBox textBoxUi;
    @UiField
    Label labelUi;
    @UiField
    InlineEditButton editButtonUi;
    private boolean state = false;
    private final List<TextChangeHandler> changeHandlers = new ArrayList();

    public InlineEditLabel() {
        EditableResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.editButtonUi.getElement().getStyle().setBackgroundImage("url('" + this.res.editPencil().getSafeUri().asString() + "')");
        this.textBoxUi.addKeyUpHandler(event -> {
            if (event.getNativeKeyCode() == 13) {
                this.updateState(false);
                this.editButtonUi.updateState(false);
            }
        });
        this.labelUi.addClickHandler(event -> {
            this.updateState(true);
            this.editButtonUi.updateState(true);
        });
        this.updateState(false, true);
    }

    @UiHandler(value={"editButtonUi"})
    void onClick(ClickEvent e) {
        this.updateState(!this.state);
    }

    private void updateState(boolean newState) {
        this.updateState(newState, false);
    }

    private void updateState(boolean newState, boolean suppressEvents) {
        if (newState) {
            this.textBoxUi.setWidth(String.valueOf(this.labelUi.getOffsetWidth() + 7) + "px");
            this.labelUi.setVisible(false);
            this.textBoxUi.setVisible(true);
            this.textBoxUi.setText(this.labelUi.getText());
            this.textBoxUi.setFocus(true);
        } else {
            boolean unchanged = this.textBoxUi.getText().equals(this.labelUi.getText());
            this.labelUi.setVisible(true);
            this.textBoxUi.setVisible(false);
            this.labelUi.setText(this.textBoxUi.getText());
            if (!suppressEvents && !unchanged) {
                this.changeHandlers.forEach(c -> c.onTextChanged(this.labelUi.getText()));
            }
        }
        this.state = newState;
    }

    public void setText(String text) {
        this.labelUi.setText(text);
    }

    public String getText() {
        return this.labelUi.getText();
    }

    public void addTextChangeHandler(TextChangeHandler handler) {
        this.changeHandlers.add(handler);
    }

    public void clearTextChangeHandlers() {
        this.changeHandlers.clear();
    }
}

