/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorWithIdDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.ParticipatedEventDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileNumericStatisticType;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileStatisticDTO;
import com.sap.sailing.gwt.home.desktop.partials.desktopaccordion.DesktopAccordionResources;
import com.sap.sailing.gwt.home.desktop.places.user.profile.sailorprofiletab.SailingProfileOverviewPresenter;
import com.sap.sailing.gwt.home.mobile.partials.sectionHeader.SectionHeaderContent;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.BoatclassElementBuilder;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.SailorProfileMobileResources;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details.SailorProfilesDetailsImpl;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details.events.SailorProfileEventEntry;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details.statistics.SailorProfileStatisticTable;
import com.sap.sailing.gwt.home.shared.partials.editable.EditableSuggestedMultiSelectionCompetitor;
import com.sap.sailing.gwt.home.shared.partials.editable.InlineEditButton;
import com.sap.sailing.gwt.home.shared.partials.editable.InlineEditLabel;
import com.sap.sailing.gwt.home.shared.places.user.profile.sailorprofile.EditSailorProfileDetailsView;
import com.sap.sailing.gwt.home.shared.places.user.profile.sailorprofile.SharedSailorProfileResources;
import com.sap.sailing.gwt.home.shared.places.user.profile.sailorprofile.view.SailorProfileView;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.security.ui.authentication.app.NeedsAuthenticationContext;

public class SailorProfilesDetailsImpl
extends Composite
implements SailorProfileView,
EditSailorProfileDetailsView {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    private static StringMessages stringMessages = (StringMessages)GWT.create(StringMessages.class);
    @UiField
    InlineEditLabel profileTitleUi;
    @UiField
    FlowPanel contentUi;
    @UiField
    SectionHeaderContent competitorsUi;
    @UiField
    HTMLPanel contentContainerCompetitorsUi;
    @UiField
    SectionHeaderContent boatclassesUi;
    @UiField
    HTMLPanel contentContainerBoatclassesUi;
    @UiField
    SectionHeaderContent eventsUi;
    @UiField
    HTMLPanel contentContainerEventsUi;
    @UiField
    SectionHeaderContent statisticsUi;
    @UiField
    HTMLPanel contentContainerStatisticsUi;
    private Label boatclassesEmpty;
    private Label eventsEmpty;
    private Label statisticsEmpty;
    private SailingProfileOverviewPresenter presenter;
    private EditableSuggestedMultiSelectionCompetitor editableSuggestedMultiselect;
    private SailorProfileDTO currentData;

    public SailorProfilesDetailsImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        SharedSailorProfileResources.INSTANCE.css().ensureInjected();
        SailorProfileMobileResources.INSTANCE.css().ensureInjected();
        this.competitorsUi.initCollapsibility((Element)this.contentContainerCompetitorsUi.getElement(), false);
        this.boatclassesUi.initCollapsibility((Element)this.contentContainerBoatclassesUi.getElement(), false);
        this.eventsUi.initCollapsibility((Element)this.contentContainerEventsUi.getElement(), false);
        this.statisticsUi.initCollapsibility((Element)this.contentContainerStatisticsUi.getElement(), false);
        this.statisticsUi.addAccordionListener((SectionHeaderContent.AccordionExpansionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPresenter(SailingProfileOverviewPresenter presenter) {
        this.presenter = presenter;
        presenter.getSharedSailorProfilePresenter().getDataProvider().setView((EditSailorProfileDetailsView)this);
        this.createMultiSelection();
        this.setupTitleChangeHandler();
    }

    public NeedsAuthenticationContext authentificationContextConsumer() {
        return null;
    }

    public void setEntry(SailorProfileDTO entry) {
        this.currentData = entry;
        this.profileTitleUi.setText(entry.getName());
        this.setCompetitors((Iterable)entry.getCompetitors());
        this.setBoatclasses(entry.getBoatclasses());
        this.presenter.getSharedSailorProfilePresenter().getDataProvider().getEvents(entry.getKey(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        if (this.statisticsUi.isExpanded()) {
            this.updateStatistics(entry);
        }
    }

    private void setupTitleChangeHandler() {
        this.profileTitleUi.addTextChangeHandler(text -> this.presenter.getSharedSailorProfilePresenter().getDataProvider().updateTitle(this.currentData.getKey(), text));
    }

    private void createMultiSelection() {
        this.editableSuggestedMultiselect = new EditableSuggestedMultiSelectionCompetitor(this.presenter.getSharedSailorProfilePresenter().getCompetitorPresenter(), this.presenter.getFlagImageResolver(), true);
        this.contentContainerCompetitorsUi.add((Widget)this.editableSuggestedMultiselect);
        InlineEditButton editButton = this.editableSuggestedMultiselect.getEditButton();
        editButton.setVisible(false);
        editButton.addStyleName(SailorProfileMobileResources.INSTANCE.css().editButton());
        this.competitorsUi.setFirstHeaderElement((Widget)editButton);
        this.competitorsUi.addAccordionListener((SectionHeaderContent.AccordionExpansionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setCompetitors(Iterable<SimpleCompetitorWithIdDTO> competitors) {
        this.editableSuggestedMultiselect.setSelectedItems(competitors);
    }

    private void setBoatclasses(Iterable<BoatClassDTO> boatclasses) {
        this.contentContainerBoatclassesUi.clear();
        this.contentContainerBoatclassesUi.getElement().removeAllChildren();
        if (Util.isEmpty(boatclasses)) {
            this.createBoatclassesEmptyLabelIfNecessary();
            this.contentContainerBoatclassesUi.add((Widget)this.boatclassesEmpty);
            this.contentContainerBoatclassesUi.removeStyleName(SailorProfileMobileResources.INSTANCE.css().detailsSectionPanel());
            this.contentContainerBoatclassesUi.removeStyleName(SharedResources.INSTANCE.mainCss().spacermarginbottomsmall());
            this.contentContainerBoatclassesUi.addStyleName(SailorProfileMobileResources.INSTANCE.css().detailsBoatclassesEmptyLabel());
        } else {
            this.contentContainerBoatclassesUi.addStyleName(SailorProfileMobileResources.INSTANCE.css().detailsSectionPanel());
            this.contentContainerBoatclassesUi.addStyleName(SharedResources.INSTANCE.mainCss().spacermarginbottomsmall());
        }
        for (BoatClassDTO boatclass : boatclasses) {
            this.contentContainerBoatclassesUi.getElement().getStyle().clearOverflow();
            this.contentContainerBoatclassesUi.getElement().appendChild((Node)BoatclassElementBuilder.generateBoatclassElementForMobile((BoatClassDTO)boatclass));
        }
    }

    private void createBoatclassesEmptyLabelIfNecessary() {
        if (this.boatclassesEmpty == null) {
            this.boatclassesEmpty = new Label(stringMessages.pleaseSelectCompetitorFirst());
            this.boatclassesEmpty.addStyleName(DesktopAccordionResources.INSTANCE.css().accordionEmptyMessage());
        }
    }

    private void setEvents(Iterable<ParticipatedEventDTO> participatedEvents) {
        this.contentContainerEventsUi.clear();
        if (Util.isEmpty(participatedEvents)) {
            this.createEventsLabelIfNecessary();
            this.contentContainerEventsUi.add((Widget)this.eventsEmpty);
            this.contentContainerEventsUi.removeStyleName(SailorProfileMobileResources.INSTANCE.css().detailsEventsContainer());
        } else {
            this.contentContainerEventsUi.addStyleName(SailorProfileMobileResources.INSTANCE.css().detailsEventsContainer());
        }
        for (ParticipatedEventDTO event : participatedEvents) {
            this.contentContainerEventsUi.add((Widget)new SailorProfileEventEntry(event, this.presenter.getSharedSailorProfilePresenter().getPlaceController(), this.presenter.getFlagImageResolver()));
        }
    }

    private void createEventsLabelIfNecessary() {
        if (this.eventsEmpty == null) {
            this.eventsEmpty = new Label(stringMessages.noEventsFoundForCompetitors());
            this.eventsEmpty.addStyleName(DesktopAccordionResources.INSTANCE.css().accordionEmptyMessage());
        }
    }

    private void clearStatistic() {
        this.contentContainerStatisticsUi.clear();
        if (this.statisticsEmpty == null) {
            this.statisticsEmpty = new Label(stringMessages.noStatisticsFoundForCompetitors());
            this.statisticsEmpty.addStyleName(DesktopAccordionResources.INSTANCE.css().accordionEmptyMessage());
        }
        this.contentContainerStatisticsUi.add((Widget)this.statisticsEmpty);
    }

    private void addStatistic(SailorProfileNumericStatisticType type, SailorProfileStatisticDTO statistic) {
        this.contentContainerStatisticsUi.add((Widget)new SailorProfileStatisticTable(type, statistic, this.presenter.getFlagImageResolver(), stringMessages, this.presenter.getClientFactory().getUserService()));
        if (this.statisticsEmpty != null) {
            this.contentContainerStatisticsUi.remove((Widget)this.statisticsEmpty);
        }
    }

    private void updateStatistics(SailorProfileDTO entry) {
        this.clearStatistic();
        SailorProfileNumericStatisticType[] sailorProfileNumericStatisticTypeArray = SailorProfileNumericStatisticType.values();
        int n = sailorProfileNumericStatisticTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SailorProfileNumericStatisticType type = sailorProfileNumericStatisticTypeArray[n2];
            this.presenter.getSharedSailorProfilePresenter().getDataProvider().getStatisticFor(entry.getKey(), type, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            ++n2;
        }
    }

    static /* synthetic */ SailorProfileDTO access$0(SailorProfilesDetailsImpl sailorProfilesDetailsImpl) {
        return sailorProfilesDetailsImpl.currentData;
    }

    static /* synthetic */ void access$1(SailorProfilesDetailsImpl sailorProfilesDetailsImpl, SailorProfileDTO sailorProfileDTO) {
        sailorProfilesDetailsImpl.updateStatistics(sailorProfileDTO);
    }

    static /* synthetic */ void access$2(SailorProfilesDetailsImpl sailorProfilesDetailsImpl, Iterable iterable) {
        sailorProfilesDetailsImpl.setEvents(iterable);
    }

    static /* synthetic */ void access$3(SailorProfilesDetailsImpl sailorProfilesDetailsImpl, SailorProfileNumericStatisticType sailorProfileNumericStatisticType, SailorProfileStatisticDTO sailorProfileStatisticDTO) {
        sailorProfilesDetailsImpl.addStatistic(sailorProfileNumericStatisticType, sailorProfileStatisticDTO);
    }
}

