/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.eventheader;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.HasLogo;
import com.sap.sailing.gwt.home.communication.event.LabelType;
import com.sap.sailing.gwt.home.communication.eventview.EventViewDTO;
import com.sap.sailing.gwt.home.communication.eventview.HasRegattaMetadata;
import com.sap.sailing.gwt.home.desktop.partials.eventheader.EventHeader;
import com.sap.sailing.gwt.home.desktop.partials.eventheader.EventHeaderResources;
import com.sap.sailing.gwt.home.desktop.partials.sharing.EventHeaderSharingButtons;
import com.sap.sailing.gwt.home.desktop.places.event.EventView;
import com.sap.sailing.gwt.home.shared.partials.shared.SharingMetadataProvider;
import com.sap.sailing.gwt.home.shared.utils.EventDatesFormatterUtil;
import com.sap.sailing.gwt.home.shared.utils.LabelTypeUtil;
import com.sap.sailing.gwt.home.shared.utils.LogoUtil;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.databylogo.DataByLogo;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.controls.dropdown.DropdownResources;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import java.util.Date;

public class EventHeader
extends Composite {
    private static EventHeaderUiBinder uiBinder = (EventHeaderUiBinder)GWT.create(EventHeaderUiBinder.class);
    @UiField
    StringMessages i18n;
    @UiField
    DivElement eventLogo;
    @UiField(provided=true)
    MediaMenuIcon eventLogoMenuButton;
    @UiField
    AnchorElement eventLogoAnchorUi;
    @UiField
    HeadingElement staticTitle;
    @UiField
    SpanElement eventName;
    @UiField
    DivElement eventState;
    @UiField
    DivElement dropdownTitle;
    @UiField
    SpanElement dropdownEventName;
    @UiField
    DivElement dropdownEventState;
    @UiField
    AnchorElement dropdownTrigger;
    @UiField
    DivElement eventDate;
    @UiField
    SpanElement eventVenue;
    @UiField
    DivElement eventVenueContainer;
    @UiField
    AnchorElement eventLink;
    @UiField
    DivElement competitors;
    @UiField
    DivElement races;
    @UiField
    DivElement eventCategory;
    @UiField
    DivElement courseAreaUi;
    @UiField
    FlowPanel dropdownContent;
    @UiField
    EventHeaderSharingButtons sharing;
    @UiField
    DataByLogo dataByLogo;
    @UiField
    EventHeaderResources local_res;
    @UiField
    DropdownResources dropdownitem_res;
    private EventViewDTO event;
    private EventView.Presenter presenter;

    public EventHeader(EventView.Presenter presenter) {
        this.event = presenter.getEventDTO();
        this.presenter = presenter;
        this.eventLogoMenuButton = new MediaMenuIcon((TakedownNoticeService)presenter.getUserService(), "takedownRequestForLogoImage");
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.local_res.css().ensureInjected();
        this.dropdownitem_res.css().ensureInjected();
        this.initFields();
        this.initSharing();
    }

    private void initSharing() {
        this.sharing.setUp((SharingMetadataProvider)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initFields() {
        String nameToShow;
        LogoUtil.setEventLogo((Element)this.eventLogo, (HasLogo)this.event, (MediaMenuIcon)this.eventLogoMenuButton);
        if (this.presenter.showRegattaMetadata()) {
            this.presenter.getCurrentEventNavigation().configureAnchorElement(this.eventLogoAnchorUi);
        }
        String eventDisplayName = this.event.getDisplayName();
        if (this.presenter.showRegattaMetadata()) {
            HasRegattaMetadata regattaMetadata = this.presenter.getRegattaMetadata();
            String regattaDisplayName = regattaMetadata.getDisplayName();
            nameToShow = regattaDisplayName.toLowerCase().contains(eventDisplayName.toLowerCase()) ? regattaDisplayName : String.valueOf(eventDisplayName) + " - " + regattaDisplayName;
            if (regattaMetadata.getCompetitorsCount() > 0) {
                this.competitors.setInnerText(this.i18n.competitorsCount(regattaMetadata.getCompetitorsCount()));
            } else {
                this.hide(new Element[]{this.competitors});
            }
            if (regattaMetadata.getRaceCount() > 0) {
                this.races.setInnerText(this.i18n.racesCount(regattaMetadata.getRaceCount()));
            } else {
                this.hide(new Element[]{this.races});
            }
            if (regattaMetadata.getDefaultCourseAreaName() != null) {
                this.courseAreaUi.setInnerText(this.i18n.courseAreaName(regattaMetadata.getDefaultCourseAreaName()));
            } else {
                this.hide(new Element[]{this.courseAreaUi});
            }
            if (regattaMetadata.getLeaderboardGroupNames() != null) {
                this.eventCategory.setInnerText(Util.joinStrings((String)", ", (Iterable)regattaMetadata.getLeaderboardGroupNames()));
            } else {
                this.hide(new Element[]{this.eventCategory});
            }
            Date startDate = regattaMetadata.getStartDate() != null ? regattaMetadata.getStartDate() : this.event.getStartDate();
            Date endDate = regattaMetadata.getEndDate() != null ? regattaMetadata.getEndDate() : this.event.getEndDate();
            this.eventDate.setInnerHTML(EventDatesFormatterUtil.formatDateRangeWithYear((Date)startDate, (Date)endDate));
            this.hide(new Element[]{this.eventVenueContainer, this.eventLink});
        } else {
            nameToShow = eventDisplayName;
            this.eventDate.setInnerHTML(EventDatesFormatterUtil.formatDateRangeWithYear((Date)this.event.getStartDate(), (Date)this.event.getEndDate()));
            this.eventVenue.setInnerText(this.event.getLocationAndVenueAndCountry());
            if (this.event.getOfficialWebsiteURL() != null) {
                String title = this.withoutPrefix(this.event.getOfficialWebsiteURL(), new String[]{"http://", "https://"});
                if (title.length() > 35) {
                    title = StringMessages.INSTANCE.officalEventWebsite();
                }
                this.eventLink.setInnerText(title);
                this.eventLink.setHref(this.event.getOfficialWebsiteURL());
            } else {
                this.hide(new Element[]{this.eventLink});
            }
            this.hide(new Element[]{this.competitors, this.races, this.courseAreaUi, this.eventCategory});
        }
        this.dataByLogo.setUp(this.event.getTrackingConnectorInfos(), true, false);
        this.initTitleAndSelection(nameToShow);
    }

    private void initTitleAndSelection(String nameToShow) {
        if (!this.presenter.needsSelectionInHeader()) {
            this.eventName.setInnerText(nameToShow);
            LabelTypeUtil.renderLabelType((Element)this.eventState, (LabelType)this.event.getState().getStateMarker());
            UIObject.ensureDebugId((Element)this.eventState, (String)"EventStateLabelDiv");
            this.hide(new Element[]{this.dropdownTitle});
        } else {
            this.dropdownEventName.setInnerText(nameToShow);
            LabelTypeUtil.renderLabelType((Element)this.dropdownEventState, (LabelType)(this.presenter.showRegattaMetadata() ? this.presenter.getRegattaMetadata().getState().getStateMarker() : this.event.getState().getStateMarker()));
            UIObject.ensureDebugId((Element)this.dropdownEventState, (String)"EventStateLabelDiv");
            this.hide(new Element[]{this.staticTitle});
            this.initDropdown();
        }
    }

    private void initDropdown() {
        new /* Unavailable Anonymous Inner Class!! */;
        this.presenter.forPlaceSelection((EventView.PlaceCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String withoutPrefix(String title, String ... prefixes) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (title.startsWith(prefix)) {
                return title.substring(prefix.length(), title.length());
            }
            ++n2;
        }
        return title;
    }

    private void hide(Element ... elementsToHide) {
        Element[] elementArray = elementsToHide;
        int n = elementsToHide.length;
        int n2 = 0;
        while (n2 < n) {
            Element element = elementArray[n2];
            element.removeFromParent();
            ++n2;
        }
    }

    static /* synthetic */ EventViewDTO access$0(EventHeader eventHeader) {
        return eventHeader.event;
    }

    static /* synthetic */ EventView.Presenter access$1(EventHeader eventHeader) {
        return eventHeader.presenter;
    }
}

