/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event.eventoverview;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.event.eventoverview.EventOverviewStageContentDTO;
import com.sap.sailing.gwt.home.communication.event.eventoverview.EventOverviewStageDTO;
import com.sap.sailing.gwt.home.communication.event.eventoverview.EventOverviewTickerStageDTO;
import com.sap.sailing.gwt.home.communication.event.eventoverview.EventOverviewVideoStageDTO;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.gwt.dispatch.shared.commands.ResultWithTTL;
import com.sap.sse.gwt.shared.DTO;
import com.sap.sse.shared.media.VideoDescriptor;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class GetEventOverviewStageAction
implements SailingAction<ResultWithTTL<EventOverviewStageDTO>>,
IsClientCacheable {
    private UUID eventId;
    private boolean useTeaserImage;

    private GetEventOverviewStageAction() {
    }

    public GetEventOverviewStageAction(UUID eventId, boolean useTeaserImage) {
        this.eventId = eventId;
        this.useTeaserImage = useTeaserImage;
    }

    @GwtIncompatible
    public ResultWithTTL<EventOverviewStageDTO> execute(SailingDispatchContext context) {
        TimePoint now = MillisecondsTimePoint.now();
        Event event = context.getRacingEventService().getEvent((Serializable)this.eventId);
        EventState state = HomeServiceUtil.calculateEventState((EventBase)event);
        long ttl = Duration.ONE_MINUTE.times(5L).asMillis();
        if (state == EventState.RUNNING) {
            ttl = Duration.ONE_MINUTE.times(2L).asMillis();
        }
        if (this.isUpcomingOrPlanned(event, state)) {
            ttl = Math.min(ttl, now.until(event.getStartDate()).asMillis());
        }
        EventOverviewStageDTO stage = new EventOverviewStageDTO(null, this.getStageContent(context, event, state, now));
        return new ResultWithTTL((Duration)new MillisecondsDurationImpl(ttl), (DTO)stage);
    }

    @GwtIncompatible
    public EventOverviewStageContentDTO getStageContent(SailingDispatchContext context, Event event, EventState state, TimePoint now) {
        List<String> videoTags = Collections.singletonList(MediaTagConstants.FEATURED.getName());
        VideoDescriptor featuredVideo = HomeServiceUtil.getStageVideo((Event)event, (Locale)context.getClientLocale(), videoTags, (boolean)false);
        if (featuredVideo != null) {
            return new EventOverviewVideoStageDTO(EventOverviewVideoStageDTO.Type.MEDIA, HomeServiceUtil.toVideoDTO((VideoDescriptor)featuredVideo));
        }
        String imageUrl = HomeServiceUtil.getFeaturedImageUrlAsString((EventBase)event);
        if (imageUrl == null) {
            String string = imageUrl = this.useTeaserImage ? HomeServiceUtil.findEventThumbnailImageUrlAsString((EventBase)event) : HomeServiceUtil.getStageImageURLAsString((EventBase)event);
        }
        if (this.isUpcomingOrPlanned(event, state)) {
            return new EventOverviewTickerStageDTO(event.getStartDate().asDate(), event.getName(), imageUrl);
        }
        return new EventOverviewTickerStageDTO(null, event.getName(), imageUrl);
    }

    @GwtIncompatible
    private boolean isUpcomingOrPlanned(Event event, EventState state) {
        TimePoint startDate = event.getStartDate();
        return startDate != null && (state == EventState.UPCOMING || state == EventState.PLANNED);
    }

    public void cacheInstanceKey(StringBuilder key) {
        key.append(this.eventId).append("_").append(this.useTeaserImage);
    }
}

