/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.shared.leaderboard;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.autoplay.client.shared.leaderboard.LeaderboardPerspectiveSettingsDialogComponent;
import com.sap.sailing.gwt.autoplay.client.shared.leaderboard.LeaderboardWithZoomingPerspectiveLifecycle;
import com.sap.sailing.gwt.autoplay.client.shared.leaderboard.LeaderboardWithZoomingPerspectiveSettings;
import com.sap.sailing.gwt.autoplay.client.shared.oldleaderboard.OldLeaderboard;
import com.sap.sailing.gwt.common.client.CSS3Util;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiRaceLeaderboardPanelLifecycle;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiRaceLeaderboardSettings;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.FlagImageResolverImpl;
import com.sap.sailing.gwt.ui.client.LeaderboardUpdateListener;
import com.sap.sailing.gwt.ui.client.LeaderboardUpdateProvider;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.ClassicLeaderboardStyle;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.MultiRaceLeaderboardPanel;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.AbstractPerspectiveComposite;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveLifecycle;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.WithSecurity;
import com.sap.sse.security.ui.settings.ComponentContextWithSettingsStorage;

public class MultiRaceLeaderboardWithZoomingPerspective
extends AbstractPerspectiveComposite<LeaderboardWithZoomingPerspectiveLifecycle, LeaderboardWithZoomingPerspectiveSettings>
implements LeaderboardUpdateProvider {
    private final DockLayoutPanel dockPanel;
    private static final int SAP_HEADER_HEIGHT = 75;
    private final Widget currentContentWidget;
    private final MultiRaceLeaderboardPanel leaderboardPanel;
    private final StringMessages stringMessages;
    private final WithSecurity withSecurity;

    public MultiRaceLeaderboardWithZoomingPerspective(Component<?> parent, ComponentContextWithSettingsStorage<PerspectiveCompositeSettings<LeaderboardWithZoomingPerspectiveSettings>> componentContext, LeaderboardWithZoomingPerspectiveLifecycle lifecycle, PerspectiveCompositeSettings<LeaderboardWithZoomingPerspectiveSettings> settings, SailingServiceAsync sailingService, UserService userService, AsyncActionsExecutor asyncActionsExecutor, CompetitorSelectionProvider competitorSelectionProvider, Timer timer, String leaderboardName, ErrorReporter errorReporter, StringMessages stringMessages, boolean startInFullScreenMode, Iterable<DetailType> availableDetailTypes, WithSecurity withSecurity) {
        super(parent, componentContext, (PerspectiveLifecycle)lifecycle, settings);
        this.stringMessages = stringMessages;
        this.withSecurity = withSecurity;
        Window.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.leaderboardPanel = this.createLeaderboardPanel(lifecycle, settings, sailingService, asyncActionsExecutor, competitorSelectionProvider, timer, leaderboardName, errorReporter, stringMessages, availableDetailTypes);
        this.leaderboardPanel.getContentWidget().getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        this.addChildComponent((Component)this.leaderboardPanel);
        this.dockPanel = new DockLayoutPanel(Style.Unit.PX);
        OldLeaderboard oldLeaderboard = new OldLeaderboard(this.leaderboardPanel, stringMessages);
        this.leaderboardPanel.addLeaderboardUpdateListener((LeaderboardUpdateListener)oldLeaderboard);
        this.currentContentWidget = oldLeaderboard.getContentWidget();
        if (((LeaderboardWithZoomingPerspectiveSettings)this.getPerspectiveSettings()).isLeaderboardAutoZoom()) {
            this.autoZoomContentWidget(75, this.currentContentWidget);
        } else {
            Double zoom = ((LeaderboardWithZoomingPerspectiveSettings)this.getPerspectiveSettings()).getLeaderboardZoomFactor();
            this.zoomContentWidget(75, this.currentContentWidget, zoom.doubleValue());
        }
        this.dockPanel.add((Widget)oldLeaderboard);
        this.initWidget((Widget)this.dockPanel);
    }

    public Widget getEntryWidget() {
        return this;
    }

    public boolean isVisible() {
        return false;
    }

    public void setVisible(boolean visibility) {
    }

    public String getDependentCssClassName() {
        return "";
    }

    private void zoomContentWidget(int headerHeight, Widget contentWidget, double scaleFactor) {
        if (contentWidget != null) {
            Scheduler.get().scheduleFixedPeriod((Scheduler.RepeatingCommand)new /* Unavailable Anonymous Inner Class!! */, 1000);
        }
    }

    private void autoZoomContentWidget(int headerHeight, Widget contentWidget) {
        if (contentWidget != null) {
            Scheduler.get().scheduleFixedPeriod((Scheduler.RepeatingCommand)new /* Unavailable Anonymous Inner Class!! */, 1000);
        }
    }

    private void scaleContentWidget(int headerHeight, Widget contentWidget, double scaleFactor) {
        int clientWidth = Window.getClientWidth();
        int contentWidth = contentWidget.getOffsetWidth();
        double diffX = (double)clientWidth - (double)contentWidth * scaleFactor;
        this.scaleContentWidget(headerHeight, contentWidget, scaleFactor, diffX);
    }

    private void scaleContentWidget(int headerHeight, Widget contentWidget) {
        int contentHeight;
        double scaleFactorY;
        int clientWidth = Window.getClientWidth();
        int clientHeight = Window.getClientHeight() - headerHeight;
        int contentWidth = contentWidget.getOffsetWidth();
        double scaleFactorX = (double)clientWidth / (double)contentWidth;
        Double scaleFactor = scaleFactorX > (scaleFactorY = (double)clientHeight / (double)(contentHeight = contentWidget.getOffsetHeight())) ? scaleFactorY : scaleFactorX;
        if (scaleFactor < 1.0) {
            scaleFactor = 1.0;
        }
        double diffX = (double)clientWidth - (double)contentWidth * scaleFactor;
        this.scaleContentWidget(headerHeight, contentWidget, scaleFactor.doubleValue(), diffX);
    }

    private void scaleContentWidget(int headerHeight, Widget contentWidget, double scaleFactor, double diffX) {
        if (scaleFactor > 0.0) {
            CSS3Util.setProperty((Style)contentWidget.getElement().getStyle(), (String)"transform", (String)("translateX(" + diffX / 2.0 + "px) scale(" + scaleFactor + ")"));
            CSS3Util.setProperty((Style)contentWidget.getElement().getStyle(), (String)"transformOrigin", (String)"0 0");
        }
    }

    public void addLeaderboardUpdateListener(LeaderboardUpdateListener listener) {
        this.leaderboardPanel.addLeaderboardUpdateListener(listener);
    }

    public void removeLeaderboardUpdateListener(LeaderboardUpdateListener listener) {
        this.leaderboardPanel.removeLeaderboardUpdateListener(listener);
    }

    private MultiRaceLeaderboardPanel createLeaderboardPanel(LeaderboardWithZoomingPerspectiveLifecycle lifecycle, PerspectiveCompositeSettings<LeaderboardWithZoomingPerspectiveSettings> settings, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, CompetitorSelectionProvider competitorSelectionProvider, Timer timer, String leaderboardName, ErrorReporter errorReporter, StringMessages stringMessages, Iterable<DetailType> availableDetailTypes) {
        MultiRaceLeaderboardPanelLifecycle leaderboardPanelLifecycle = ((LeaderboardWithZoomingPerspectiveLifecycle)this.getPerspectiveLifecycle()).getLeaderboardPanelLifecycle();
        MultiRaceLeaderboardSettings leaderboardSettings = (MultiRaceLeaderboardSettings)settings.findSettingsByComponentId(leaderboardPanelLifecycle.getComponentId());
        MultiRaceLeaderboardPanel leaderboardPanel = new MultiRaceLeaderboardPanel((Component)this, this.getComponentContext(), sailingService, asyncActionsExecutor, leaderboardSettings, true, competitorSelectionProvider, timer, leaderboardName, errorReporter, stringMessages, false, null, false, null, false, true, false, false, false, (LeaderboardPanel.LeaderBoardStyle)new ClassicLeaderboardStyle(), FlagImageResolverImpl.get(), availableDetailTypes, this.withSecurity);
        return leaderboardPanel;
    }

    public SettingsDialogComponent<LeaderboardWithZoomingPerspectiveSettings> getPerspectiveOwnSettingsDialogComponent() {
        return new LeaderboardPerspectiveSettingsDialogComponent((LeaderboardWithZoomingPerspectiveSettings)this.getPerspectiveSettings(), this.stringMessages);
    }

    public boolean hasPerspectiveOwnSettings() {
        return true;
    }

    public String getId() {
        return "lbwh";
    }

    static /* synthetic */ Settings access$0(MultiRaceLeaderboardWithZoomingPerspective multiRaceLeaderboardWithZoomingPerspective) {
        return multiRaceLeaderboardWithZoomingPerspective.getPerspectiveSettings();
    }

    static /* synthetic */ Widget access$1(MultiRaceLeaderboardWithZoomingPerspective multiRaceLeaderboardWithZoomingPerspective) {
        return multiRaceLeaderboardWithZoomingPerspective.currentContentWidget;
    }

    static /* synthetic */ void access$2(MultiRaceLeaderboardWithZoomingPerspective multiRaceLeaderboardWithZoomingPerspective, int n, Widget widget) {
        multiRaceLeaderboardWithZoomingPerspective.autoZoomContentWidget(n, widget);
    }

    static /* synthetic */ void access$3(MultiRaceLeaderboardWithZoomingPerspective multiRaceLeaderboardWithZoomingPerspective, int n, Widget widget, double d) {
        multiRaceLeaderboardWithZoomingPerspective.scaleContentWidget(n, widget, d);
    }

    static /* synthetic */ void access$4(MultiRaceLeaderboardWithZoomingPerspective multiRaceLeaderboardWithZoomingPerspective, int n, Widget widget) {
        multiRaceLeaderboardWithZoomingPerspective.scaleContentWidget(n, widget);
    }
}

