/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription;

import com.sap.sse.security.SecurityService;
import com.sap.sse.security.subscription.SubscriptionApiService;
import com.sap.sse.security.subscription.SubscriptionPlanUpdateTask;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class SubscriptionPlanBackgroundUpdater {
    private static final Logger logger = Logger.getLogger(SubscriptionPlanBackgroundUpdater.class.getName());
    private final ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
    private final ServiceTracker<SubscriptionApiService, SubscriptionApiService> subscriptionApiServiceTracker;

    public SubscriptionPlanBackgroundUpdater(BundleContext context) {
        this.subscriptionApiServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, SubscriptionApiService.class);
    }

    public void start(CompletableFuture<SecurityService> securityService) {
        logger.info(() -> "Start subscription plan background update task");
        this.executor.schedule(new SubscriptionPlanUpdateTask(securityService, this.subscriptionApiServiceTracker), 1L, TimeUnit.MINUTES);
    }
}

