/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.jaxrs.api;

import com.sap.sse.security.exceptions.OwnershipException;
import com.sap.sse.security.jaxrs.AbstractSecurityResource;
import com.sap.sse.security.model.GeneralResponse;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.QualifiedObjectIdentifierImpl;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

@Path(value="/restsecurity/ownership")
public class OwnershipResource
extends AbstractSecurityResource {
    public static final String RESTSECURITY_OWNERSHIP = "/restsecurity/ownership";
    public static final String KEY_OBJECT_ID = "objectId";
    public static final String KEY_OBJECT_TYPE = "objectType";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_GROUP_ID = "groupId";
    public static final String KEY_ACL = "acl";
    public static final String KEY_ACTIONS = "actions";
    public static final String KEY_DISPLAY_NAME = "displayName";

    @Path(value="{objectType}/{typeRelativeObjectId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response setOwnership(@PathParam(value="objectType") String objectType, @PathParam(value="typeRelativeObjectId") String typeRelativeObjectId, String jsonBody) throws OwnershipException {
        UserGroup userGroup;
        User user;
        JSONObject json = (JSONObject)JSONValue.parse((String)jsonBody);
        QualifiedObjectIdentifierImpl identifier = new QualifiedObjectIdentifierImpl(objectType, new TypeRelativeObjectIdentifier(new String[]{typeRelativeObjectId}));
        try {
            SecurityUtils.getSubject().checkPermission(identifier.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP));
        }
        catch (Exception ex) {
            throw new OwnershipException("Not permitted to change ownership.", Response.Status.FORBIDDEN);
        }
        OwnershipAnnotation existingOwnership = this.getSecurityService().getOwnership((QualifiedObjectIdentifier)identifier);
        if (json.containsKey((Object)KEY_USERNAME)) {
            String username = (String)json.get((Object)KEY_USERNAME);
            if (username == null) {
                user = null;
            } else {
                user = this.getSecurityService().getUserByName(username);
                if (user == null) {
                    throw new OwnershipException("User Not found", Response.Status.BAD_REQUEST);
                }
            }
        } else {
            User user2 = user = existingOwnership == null ? null : (User)((Ownership)existingOwnership.getAnnotation()).getUserOwner();
        }
        if (json.containsKey((Object)KEY_GROUP_ID)) {
            String userGroupIdAsString = (String)json.get((Object)KEY_GROUP_ID);
            if (userGroupIdAsString == null) {
                userGroup = null;
            } else {
                userGroup = this.getSecurityService().getUserGroup(UUID.fromString(userGroupIdAsString));
                if (userGroup == null) {
                    throw new OwnershipException("UserGroup Not found", Response.Status.BAD_REQUEST);
                }
            }
        } else {
            UserGroup userGroup2 = userGroup = existingOwnership == null ? null : (UserGroup)((Ownership)existingOwnership.getAnnotation()).getTenantOwner();
        }
        if (json.containsKey((Object)KEY_DISPLAY_NAME)) {
            this.getSecurityService().setOwnership((QualifiedObjectIdentifier)identifier, user, userGroup, (String)json.get((Object)KEY_DISPLAY_NAME));
        } else {
            this.getSecurityService().setOwnership((QualifiedObjectIdentifier)identifier, user, userGroup);
        }
        return Response.ok((Object)new GeneralResponse(true, "Ownership changed successfully").toString()).build();
    }

    @Path(value="{objectType}/{typeRelativeObjectId}")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getOwnership(@PathParam(value="objectType") String objectType, @PathParam(value="typeRelativeObjectId") String typeRelativeObjectId) throws OwnershipException {
        return this.getOwnership(objectType, new String[]{typeRelativeObjectId});
    }

    @Path(value="{objectType}")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getOwnershipWithMultiId(@PathParam(value="objectType") String objectType, @QueryParam(value="id") List<String> compositeTypeRelativeObjectId) throws OwnershipException {
        return this.getOwnership(objectType, compositeTypeRelativeObjectId.toArray(new String[0]));
    }

    private Response getOwnership(String objectType, String[] typeRelativeObjectIdArray) {
        QualifiedObjectIdentifierImpl identifier = new QualifiedObjectIdentifierImpl(objectType, new TypeRelativeObjectIdentifier(typeRelativeObjectIdArray));
        OwnershipAnnotation existingOwnership = this.getSecurityService().getOwnership((QualifiedObjectIdentifier)identifier);
        JSONObject result = new JSONObject();
        result.put((Object)KEY_OBJECT_TYPE, (Object)objectType);
        result.put((Object)KEY_OBJECT_ID, (Object)identifier.getTypeRelativeObjectIdentifier().toString());
        result.put((Object)KEY_GROUP_ID, existingOwnership == null || ((Ownership)existingOwnership.getAnnotation()).getTenantOwner() == null ? null : ((UserGroup)((Ownership)existingOwnership.getAnnotation()).getTenantOwner()).getId().toString());
        result.put((Object)KEY_USERNAME, existingOwnership == null || ((Ownership)existingOwnership.getAnnotation()).getUserOwner() == null ? null : ((User)((Ownership)existingOwnership.getAnnotation()).getUserOwner()).getName());
        result.put((Object)KEY_DISPLAY_NAME, existingOwnership == null || existingOwnership.getDisplayNameOfAnnotatedObject() == null ? null : existingOwnership.getDisplayNameOfAnnotatedObject());
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @Path(value="{objectType}/{typeRelativeObjectId}/acl")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getAccessControlLists(@PathParam(value="objectType") String objectType, @PathParam(value="typeRelativeObjectId") String typeRelativeObjectId) throws OwnershipException {
        QualifiedObjectIdentifierImpl identifier = new QualifiedObjectIdentifierImpl(objectType, new TypeRelativeObjectIdentifier(new String[]{typeRelativeObjectId}));
        AccessControlListAnnotation acl = this.getSecurityService().getAccessControlList((QualifiedObjectIdentifier)identifier);
        JSONObject result = new JSONObject();
        result.put((Object)KEY_OBJECT_TYPE, (Object)objectType);
        result.put((Object)KEY_OBJECT_ID, (Object)typeRelativeObjectId);
        result.put((Object)KEY_DISPLAY_NAME, acl == null || acl.getDisplayNameOfAnnotatedObject() == null ? null : acl.getDisplayNameOfAnnotatedObject());
        JSONArray actionsByUserGroup = new JSONArray();
        result.put((Object)KEY_ACL, (Object)actionsByUserGroup);
        if (acl != null && acl.getAnnotation() != null) {
            for (Map.Entry e : ((AccessControlList)acl.getAnnotation()).getActionsByUserGroup().entrySet()) {
                JSONObject actionsForGroup = new JSONObject();
                actionsByUserGroup.add((Object)actionsForGroup);
                actionsForGroup.put((Object)KEY_GROUP_ID, e.getKey() == null ? null : ((UserGroup)e.getKey()).getId().toString());
                JSONArray actions = new JSONArray();
                actions.addAll((Collection)e.getValue());
                actionsForGroup.put((Object)KEY_ACTIONS, (Object)actions);
            }
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @Path(value="{objectType}/{typeRelativeObjectId}/acl")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response setAccessControlLists(@PathParam(value="objectType") String objectType, @PathParam(value="typeRelativeObjectId") String typeRelativeObjectId, String jsonBody) throws OwnershipException {
        JSONObject json = (JSONObject)JSONValue.parse((String)jsonBody);
        JSONArray actionsByUserGroupJson = (JSONArray)json.get((Object)KEY_ACL);
        QualifiedObjectIdentifierImpl identifier = new QualifiedObjectIdentifierImpl(objectType, new TypeRelativeObjectIdentifier(new String[]{typeRelativeObjectId}));
        try {
            SecurityUtils.getSubject().checkPermission(identifier.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL));
        }
        catch (Exception ex) {
            throw new OwnershipException("Not permitted to change ownership.", Response.Status.FORBIDDEN);
        }
        HashMap<UserGroup, Set<String>> actionsByUserGroup = new HashMap<UserGroup, Set<String>>();
        for (Object o : actionsByUserGroupJson) {
            UserGroup group;
            JSONObject permissionsForGroup = (JSONObject)o;
            String groupIdAsString = (String)permissionsForGroup.get((Object)KEY_GROUP_ID);
            if (groupIdAsString == null) {
                group = null;
            } else {
                group = this.getSecurityService().getUserGroup(UUID.fromString(groupIdAsString));
                if (group == null) {
                    throw new OwnershipException(String.format("UserGroup with ID %s Not found", groupIdAsString), Response.Status.BAD_REQUEST);
                }
            }
            JSONArray actions = (JSONArray)permissionsForGroup.get((Object)KEY_ACTIONS);
            HashSet<String> actionsForGroup = new HashSet<String>();
            for (Object action : actions) {
                actionsForGroup.add(action.toString());
            }
            actionsByUserGroup.put(group, actionsForGroup);
        }
        if (json.containsKey((Object)KEY_DISPLAY_NAME)) {
            String displayName = (String)json.get((Object)KEY_DISPLAY_NAME);
            this.getSecurityService().overrideAccessControlList((QualifiedObjectIdentifier)identifier, actionsByUserGroup, displayName);
        } else {
            this.getSecurityService().overrideAccessControlList((QualifiedObjectIdentifier)identifier, actionsByUserGroup);
        }
        return Response.ok((Object)new GeneralResponse(true, "ACL changed successfully").toString()).build();
    }
}

