/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.impl;

import com.sap.sse.security.SecurityService;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ext.Provider;
import org.osgi.util.tracker.ServiceTracker;

@Provider
public class DefaultTenantRequestFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(DefaultTenantRequestFilter.class.getName());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        SecurityService securityService = this.getSecurityService(request.getServletContext());
        String defaultTenantGroupId = httpRequest.getHeader("tenantGroupId");
        if (defaultTenantGroupId != null) {
            securityService.setTemporaryDefaultTenant(UUID.fromString(defaultTenantGroupId));
            logger.info("executing request " + httpRequest.getRequestURI() + " with divergent tenant group " + defaultTenantGroupId);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (defaultTenantGroupId != null) {
                securityService.setTemporaryDefaultTenant(null);
            }
        }
    }

    public void destroy() {
    }

    private SecurityService getSecurityService(ServletContext ctx) {
        ServiceTracker tracker = (ServiceTracker)ctx.getAttribute("securityServiceTracker");
        return (SecurityService)tracker.getService();
    }
}

