/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.session.Session;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Token;

public class SessionUtils {
    public static final String SESSION_ID = "GWTOAuthLoginDemo_sessionid";
    public static final String SESSION_REQUEST_TOKEN = "GWTOAuthLoginDemo_request_token";
    public static final String SESSION_NONCE = "GWTOAuthLoginDemo_nonce";
    public static final String SESSION_PROTECTED_URL = "GWTOAuthLoginDemo_protected_url";
    public static final String SESSION_ACCESS_TOKEN = "GWTOAuthLoginDemo_access_token";
    public static final String SESSION_YAHOO_GUID = "GWTOAuthLoginDemo_yahoo_guid";
    public static final String SESSION_AUTH_PROVIDER = "GWTOAuthLoginDemo_auth_provider";
    public static final String SOCIAL_USER = "Social_User";
    public static final String SESSION_EXPIRED_MESSAGE = "Session has expired";

    public static void saveRequestTokenToSession(Token requestToken) throws Exception {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new Exception(SESSION_EXPIRED_MESSAGE);
        }
        session.setAttribute((Object)SESSION_REQUEST_TOKEN, (Object)requestToken);
    }

    public static void saveStateToSession(String state) throws Exception {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new Exception(SESSION_EXPIRED_MESSAGE);
        }
        session.setAttribute((Object)SESSION_NONCE, (Object)state);
    }

    public static String getProtectedResourceUrlFromSession() throws OAuthException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new OAuthException(SESSION_EXPIRED_MESSAGE);
        }
        return (String)session.getAttribute((Object)SESSION_PROTECTED_URL);
    }

    public static String getStateFromSession() throws Exception {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new Exception(SESSION_EXPIRED_MESSAGE);
        }
        return (String)session.getAttribute((Object)SESSION_NONCE);
    }

    public static String getSessionIdFromSession() throws OAuthException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new OAuthException(SESSION_EXPIRED_MESSAGE);
        }
        String sessionId = (String)session.getAttribute((Object)SESSION_ID);
        return sessionId;
    }

    public static Token getAccessTokenFromSession() throws OAuthException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new OAuthException(SESSION_EXPIRED_MESSAGE);
        }
        return (Token)session.getAttribute((Object)SESSION_ACCESS_TOKEN);
    }

    public static int getAuthProviderFromSession() throws OAuthException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new OAuthException(SESSION_EXPIRED_MESSAGE);
        }
        return (Integer)session.getAttribute((Object)SESSION_AUTH_PROVIDER);
    }

    public static void saveUsername(String username) {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            return;
        }
        session.setAttribute((Object)SOCIAL_USER, (Object)username);
    }

    public static void saveSessionIdToSession(String sessionId) throws AuthenticationException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new AuthenticationException(SESSION_EXPIRED_MESSAGE);
        }
        session.setAttribute((Object)SESSION_ID, (Object)sessionId);
    }

    public static void saveProtectedResourceUrlToSession(String url) throws AuthenticationException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new AuthenticationException(SESSION_EXPIRED_MESSAGE);
        }
        session.setAttribute((Object)SESSION_PROTECTED_URL, (Object)url);
    }

    public static void saveAuthProviderToSession(int authProvider) throws AuthenticationException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new AuthenticationException(SESSION_EXPIRED_MESSAGE);
        }
        session.setAttribute((Object)SESSION_AUTH_PROVIDER, (Object)authProvider);
    }

    public static void saveAccessTokenToSession(Token accessToken) throws AuthenticationException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new AuthenticationException(SESSION_EXPIRED_MESSAGE);
        }
        session.setAttribute((Object)SESSION_ACCESS_TOKEN, (Object)accessToken);
    }

    public static void saveYahooGuidToSession(String guid) throws AuthenticationException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new AuthenticationException(SESSION_EXPIRED_MESSAGE);
        }
        session.setAttribute((Object)SESSION_YAHOO_GUID, (Object)guid);
    }

    public static String getYahooGuidFromSession() throws AuthenticationException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new AuthenticationException(SESSION_EXPIRED_MESSAGE);
        }
        return (String)session.getAttribute((Object)SESSION_YAHOO_GUID);
    }

    public static Token getRequestTokenFromSession() throws AuthenticationException {
        Session session = SecurityUtils.getSubject().getSession();
        if (session == null) {
            throw new AuthenticationException(SESSION_EXPIRED_MESSAGE);
        }
        return (Token)session.getAttribute((Object)SESSION_REQUEST_TOKEN);
    }

    public static Object getPrincipal() {
        return SecurityUtils.getSubject().getPrincipal();
    }
}

