/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.tractracadapter.MetadataParser;
import com.sap.sse.common.Color;
import com.sap.sse.common.impl.AbstractColor;
import com.sap.sse.common.impl.NamedImpl;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.model.lib.api.map.IMapItem;
import com.tractrac.model.lib.api.map.IPositionedItem;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class MetadataParserImpl
implements MetadataParser {
    @Override
    public Map<Integer, PassingInstruction> parsePassingInstructionData(String routeMetadataString, int numberOfWaypoints) {
        HashMap<Integer, PassingInstruction> result = new HashMap<Integer, PassingInstruction>();
        if (routeMetadataString != null) {
            int start;
            Map<String, String> routeMetadata = this.parseMetadata(routeMetadataString);
            int i = start = routeMetadata.containsKey("Seq.0") ? 0 : 1;
            while (i < start + numberOfWaypoints) {
                PassingInstruction passingInstructions;
                String seqValue = routeMetadata.get("Seq." + i);
                if (seqValue != null && (passingInstructions = PassingInstruction.valueOfIgnoringCase((String)seqValue)) != null) {
                    result.put(i - start, passingInstructions);
                }
                ++i;
            }
        }
        return result;
    }

    private Map<String, String> parseMetadata(String metadata) {
        HashMap<Object, Object> metadataMap = new HashMap<String, String>();
        try {
            Properties p = new Properties();
            p.load(new StringReader(metadata));
            metadataMap = new HashMap<Object, Object>(p);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return metadataMap;
    }

    @Override
    public MetadataParser.ControlPointMetaData parseControlPointMetadata(IPositionedItem controlPoint) {
        String controlPointMetadataString = controlPoint.getMetadata().getText();
        String controlPointName = controlPoint.getName();
        Map<Object, Object> controlPointMetadata = controlPointMetadataString == null ? Collections.emptyMap() : this.parseMetadata(controlPointMetadataString);
        MarkType type = this.resolveMarkTypeFromMetadata(controlPointMetadata, "Type");
        String colorAsString = controlPointMetadata.get("Color");
        Color color = AbstractColor.getCssColor((String)colorAsString);
        String shape = controlPointMetadata.get("Shape");
        String pattern = controlPointMetadata.get("Pattern");
        ControlPointMetaDataImpl markMetadata = new ControlPointMetaDataImpl(controlPointName, type, color, shape, pattern, controlPoint.getId());
        return markMetadata;
    }

    private MarkType resolveMarkTypeFromMetadata(Map<String, String> controlPointMetadata, String typePropertyName) {
        MarkType result = MarkType.BUOY;
        String markType = controlPointMetadata.get(typePropertyName);
        if (markType != null && !markType.isEmpty()) {
            MarkType[] markTypeArray = MarkType.values();
            int n = markTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MarkType m = markTypeArray[n2];
                if (m.name().equalsIgnoreCase(markType)) {
                    result = m;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public Map<String, Iterable<IPositionedItem>> parseSidelinesFromRaceMetadata(String raceMetadataString, Iterable<? extends IMapItem> allControlPoints) {
        HashMap<String, Iterable<IPositionedItem>> result = new HashMap<String, Iterable<IPositionedItem>>();
        if (raceMetadataString != null) {
            Map<String, String> sidelineMetadata = this.parseMetadata(raceMetadataString);
            for (Map.Entry<String, String> entry : sidelineMetadata.entrySet()) {
                if (!entry.getKey().startsWith("SIDELINE")) continue;
                ArrayList sidelineCPs = new ArrayList();
                result.put(entry.getKey(), sidelineCPs);
                for (IMapItem iMapItem : allControlPoints) {
                    String cpName = iMapItem.getName().trim();
                    if (!cpName.equals(entry.getValue())) continue;
                    sidelineCPs.addAll(iMapItem.getPositionedItems());
                }
            }
        }
        return result;
    }

    @Override
    public MetadataParser.BoatMetaData parseCompetitorBoat(IRaceCompetitor competitor) {
        String raceCompetitorMetadataString;
        BoatMetaDataImpl result = null;
        String parsedBoatName = null;
        String parsedBoatId = null;
        String parsedBoatUuid = null;
        String parsedColor = null;
        String string = raceCompetitorMetadataString = competitor.getMetadata() != null ? competitor.getMetadata().getText() : null;
        if (raceCompetitorMetadataString != null) {
            Map<String, String> competitorMetadata = this.parseMetadata(raceCompetitorMetadataString);
            for (Map.Entry<String, String> entry : competitorMetadata.entrySet()) {
                if (entry.getKey().equals("boatName")) {
                    parsedBoatName = entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("boatId")) {
                    parsedBoatId = entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("boatUuid")) {
                    parsedBoatUuid = entry.getValue();
                    continue;
                }
                if (!entry.getKey().equals("boatColor")) continue;
                parsedColor = entry.getValue();
            }
            if (parsedBoatName != null && (parsedBoatId != null || parsedBoatUuid != null) && parsedColor != null) {
                result = new BoatMetaDataImpl(parsedBoatUuid, parsedBoatId, parsedBoatName, parsedColor);
            }
        }
        return result;
    }

    public class BoatMetaDataImpl
    extends NamedImpl
    implements MetadataParser.BoatMetaData {
        private static final long serialVersionUID = 1L;
        private String id;
        private UUID uuid;
        private final String color;

        public BoatMetaDataImpl(String boatUuid, String boatId, String boatName, String boatColor) {
            block3: {
                super(boatName);
                this.id = boatId;
                this.uuid = null;
                this.color = boatColor;
                if (boatUuid != null) {
                    try {
                        this.uuid = UUID.fromString(boatUuid);
                    }
                    catch (IllegalArgumentException e) {
                        if (this.id != null) break block3;
                        this.id = boatUuid;
                    }
                }
            }
        }

        @Override
        public UUID getUuid() {
            return this.uuid;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getColor() {
            return this.color;
        }
    }

    private class ControlPointMetaDataImpl
    extends NamedImpl
    implements MetadataParser.ControlPointMetaData {
        private static final long serialVersionUID = 1L;
        private final MarkType type;
        private final Color color;
        private final String shape;
        private final String pattern;
        private final Serializable id;

        public ControlPointMetaDataImpl(String name, MarkType type, Color color, String shape, String pattern, Serializable id) {
            super(name);
            this.type = type;
            this.color = color;
            this.shape = shape;
            this.pattern = pattern;
            this.id = id;
        }

        @Override
        public MarkType getType() {
            return this.type;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public String getShape() {
            return this.shape;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public Serializable getId() {
            return this.id;
        }
    }
}

