/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;
import com.sap.sse.common.TimePoint;

public class UpdateLeaderboardScoreCorrectionMetadata
extends AbstractLeaderboardOperation<Void> {
    private static final long serialVersionUID = -977025759476022993L;
    private final TimePoint timePointOfLastCorrectionValidity;
    private final String comment;

    public UpdateLeaderboardScoreCorrectionMetadata(String leaderboardName, TimePoint timePointOfLastCorrectionValidity, String comment) {
        super(leaderboardName);
        this.timePointOfLastCorrectionValidity = timePointOfLastCorrectionValidity;
        this.comment = comment;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    public Void internalApplyTo(RacingEventService toState) {
        SettableScoreCorrection scoreCorrection;
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        if (leaderboard != null) {
            scoreCorrection = leaderboard.getScoreCorrection();
            if (scoreCorrection == null) {
                throw new IllegalArgumentException("Leaderboard " + this.getLeaderboardName() + " has no score corrections to which to apply metadata " + this.timePointOfLastCorrectionValidity + "/" + this.comment);
            }
        } else {
            throw new IllegalArgumentException("Didn't find leaderboard " + this.getLeaderboardName());
        }
        scoreCorrection.setComment(this.comment);
        scoreCorrection.setTimePointOfLastCorrectionsValidity(this.timePointOfLastCorrectionValidity);
        this.updateStoredLeaderboard(toState, leaderboard);
        return null;
    }
}

