/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardScoreCorrectionUpdate;
import com.sap.sse.common.TimePoint;

public class UpdateLeaderboardIncrementalScoreCorrection
extends AbstractLeaderboardScoreCorrectionUpdate {
    private static final long serialVersionUID = 9064307077124881657L;
    private final Double scoreOffsetInPoints;

    public UpdateLeaderboardIncrementalScoreCorrection(String leaderboardName, String columnName, String competitorIdAsString, Double scoreOffsetInPoints, TimePoint timePoint) {
        super(leaderboardName, columnName, competitorIdAsString, timePoint);
        this.scoreOffsetInPoints = scoreOffsetInPoints;
    }

    @Override
    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    @Override
    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    @Override
    protected Double updateScoreCorrection(Leaderboard leaderboard, Competitor competitor, RaceColumn raceColumn) {
        if (this.scoreOffsetInPoints == null) {
            leaderboard.getScoreCorrection().uncorrectScoreIncrementally(competitor, raceColumn);
        } else {
            leaderboard.getScoreCorrection().correctScoreIncrementally(competitor, raceColumn, this.scoreOffsetInPoints.doubleValue());
        }
        Double newTotalPoints = leaderboard.getTotalPoints(competitor, raceColumn, this.getTimePoint());
        return newTotalPoints;
    }
}

