/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRaceOperation;
import java.io.IOException;

public class RemoveAndUntrackRace
extends AbstractRaceOperation<Void> {
    private static final long serialVersionUID = 4260421466093529004L;

    public RemoveAndUntrackRace(RegattaAndRaceIdentifier raceIdentifier) {
        super(raceIdentifier);
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    @Override
    public boolean isRequiresExplicitTransitiveReplication() {
        return true;
    }

    public Void internalApplyTo(RacingEventService toState) {
        RaceDefinition race;
        Regatta regatta = toState.getRegatta((RegattaIdentifier)this.getRaceIdentifier());
        if (regatta != null && (race = regatta.getRaceByName(this.getRaceIdentifier().getRaceName())) != null) {
            try {
                toState.removeRace(regatta, race);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

