/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import com.sap.sse.common.Util;
import java.util.ArrayList;

public class AllowCompetitorResetToDefaults
extends AbstractRacingEventServiceOperation<Void> {
    private static final long serialVersionUID = 5133140671156755328L;
    private final Iterable<String> competitorIdsAsStrings;

    public AllowCompetitorResetToDefaults(Iterable<String> competitorIdsAsStrings) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.competitorIdsAsStrings = arrayList;
        Util.addAll(competitorIdsAsStrings, arrayList);
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        CompetitorAndBoatStore competitorStore = toState.getBaseDomainFactory().getCompetitorAndBoatStore();
        for (String competitorIdAsString : this.competitorIdsAsStrings) {
            DynamicCompetitor competitor = competitorStore.getExistingCompetitorByIdAsString(competitorIdAsString);
            if (competitor == null) continue;
            competitorStore.allowCompetitorResetToDefaults((Competitor)competitor);
            if (!competitor.hasBoat()) continue;
            competitorStore.allowBoatResetToDefaults(((DynamicCompetitorWithBoat)competitor).getBoat());
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

